<?php
/**
*
* @package hjw calendar Extension
* @copyright (c) 2016 calendar
* @license http://opensource.org/licenses/gpl-2.0.php GNU General Public License v2
*
*/

namespace hjw\calendar\event;

/**
* @ignore
*/
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
* Event listener
*/
class main_listener implements EventSubscriberInterface
{
	static public function getSubscribedEvents()
	{
		return array(
			'core.user_setup'								=> 'load_language_on_setup',
			'core.posting_modify_template_vars'   			=> 'calendar',
			'core.page_header'     							=> 'calendar_on_header',
			'core.viewonline_overwrite_location'			=> 'viewonline_page',
			'core.submit_post_end'							=> 'send_data_to_table',
			'core.viewtopic_assign_template_vars_before'	=> 'modify_participants_list',
			'core.viewtopic_modify_post_row'				=> 'display_participants_list',
		);
	}

	/** @var \phpbb\config\config */
	protected $config;

	/** @var \phpbb\db\driver\driver_interface */
	protected $db;

	/** @var \phpbb\controller\helper */
	protected $helper;

	/** @var \phpbb\template\template */
	protected $template;

	/** @var \phpbb\user */
	protected $user;

	/** @var \phpbb\request\request_interface */
	protected $request;
	
	/** @var string php file extension */
	protected $php_ext;

	/** @var string phpbb root path */
	protected $phpbb_root_path;
 
	/** @var \phpbb\event\dispatcher_interface */
    protected $phpbb_dispatcher;	
	
	/**
	* Constructor
	*
	* @param \phpbb\config\config		$config
	* @param \phpbb\controller\helper	$helper
	* @param \phpbb\template\template	$template
	* @param \phpbb\user				$this->user
	*/

	public function __construct(\phpbb\config\config $config, \phpbb\db\driver\driver_interface $db, \phpbb\controller\helper $helper, 
								\phpbb\auth\auth $auth, \phpbb\template\template $template, \phpbb\user $user, \phpbb\request\request $request,
								\phpbb\event\dispatcher_interface $phpbb_dispatcher, $phpbb_root_path, $phpEx )
	{
		$this->config = $config;
		$this->db = $db;
		$this->helper = $helper;
		$this->template = $template;
		$this->user = $user;
		$this->auth = $auth;
		$this->request = $request;
		$this->phpex = $phpEx;
		$this->phpbb_root_path = $phpbb_root_path;
		$this->root_path = $phpbb_root_path . 'ext/hjw/calendar/';
        $this->phpbb_dispatcher = $phpbb_dispatcher;
	}

	public function viewonline_page($event)
	{
		switch ($event['on_page'][1])
		{
			case 'app':
			if (strrpos($event['row']['session_page'], '/calendar'))
			{
				$event['location'] = $this->user->lang('VIEWING_CALENDAR');
				$event['location_url'] = $this->helper->route('hjw_calendar_controller');
			}
			break;
		}
	}

	public function load_language_on_setup($event)
	{
		$lang_set_ext = $event['lang_set_ext'];
		$lang_set_ext[] = array(
			'ext_name' => 'hjw/calendar',
			'lang_set' => 'calendar',
		);
		$event['lang_set_ext'] = $lang_set_ext;
	}

	public function display_participants_list($event)
	{ 
		$post_id = $event['row']['post_id'];
		$forum_id = $event['row']['forum_id'];
		$topic_id = $event['row']['topic_id'];

		$date_format  = $this->user->data['user_dateformat'];

		$number['yes']	= 0;
		$number['no']	= 0;
		$number['mb']	= 0;

		include_once($this->root_path . 'includes/constants' . $this->phpex);

		$p_id = $event['cp_row'];
		$sql = 'SELECT *
			FROM ' . CALENDAR_TABLE . '
			WHERE post_id = "' . $post_id.'"';

		$result = $this->db->sql_query($sql);
		$event_row = $this->db->sql_fetchrow($result);
		$this->db->sql_freeresult($result);
		if ($event_row)
		{
			$e_id	=	$event_row['event_id'];
			$e_n	=	$event_row['event_name'];
			$f		=	explode('-',$event_row['date_from']);
			$t		=	explode('-',$event_row['date_to']);
			$cal_date = $f[2]. '.' . $f[1] . '.' . $f[0];
			if ($t[2] > 0)
			{
				$cal_date .= ' - ' . $t[2]. '.' . $t[1] . '.' . $t[0];
			}
			
			$link = 'calendar/?month=' . $f[1] . '&year=' . $f[0];
			if(!$this->config['enable_mod_rewrite'])
			{
				$link = 'app.php/' . $link;
			}
			$link = append_sid($link);

			$sql = 'SELECT *
				FROM ' . CALENDAR_EVENT_TABLE . '
				WHERE id = "' . $event_row['event_id'].'"';

			$result = $this->db->sql_query($sql);
			$row = $this->db->sql_fetchrow($result);
			$this->db->sql_freeresult($result);

			if ($row['participants'])
			{
				$sql = 'SELECT *
					FROM ' . CALENDAR_FORUMS_TABLE . '
					WHERE forum_id = "' . $forum_id.'"';
				$result = $this->db->sql_query($sql);
				$forum_row = $this->db->sql_fetchrow($result);
				$this->db->sql_freeresult($result);
				if ($forum_row)
				{
					if ($forum_row['allowed'] == 1)
					{
						$p_id['row'] = array(
							'ENTRY'				=>	$this->user->lang('CALENDAR_ENTRY') . ': ' . $cal_date,
							'LINK'				=>	$link,
							'PARTICIPANTS_ID'	=>	true,
							'U_PARTICIPANTS'	=>	append_sid($this->phpbb_root_path . 'viewtopic.php?f='.$forum_id.'&amp;p='.$post_id.'#p'.$post_id),
						);
						$sql = 'SELECT *
							FROM ' . CALENDAR_PARTICIPANTS_TABLE . '
								WHERE post_id = "' . $post_id.'"';
						$result = $this->db->sql_query($sql);
						while($part_row = $this->db->sql_fetchrow($result))
						{
							$sql = 'SELECT user_colour, username, user_timezone, user_id
								FROM ' . USERS_TABLE . '
									WHERE user_id = "' . $part_row['user_id'].'"';
							$user_result = $this->db->sql_query($sql);
							while($user_row = $this->db->sql_fetchrow($user_result))
							{
								$number[''.$part_row['participants'].''] += (int)$part_row['number'];
								$r	= explode('-',$part_row['date'].'-0-0');

								date_default_timezone_set($this->config['board_timezone']);

								$d = mktime($r[3], $r[4], $r[5], $r[1], $r[2], $r[0]);

								$a = date("Y-m-j-H-i-s", $d);					

								date_default_timezone_set($this->user->data['user_timezone']);

								$m = date("Y-m-j-H-i-s", $d);					
								date_default_timezone_set($this->config['board_timezone']);

								$r	= explode('-',$m);

								$p_date = $this->user->create_datetime()
									->setDate($r[0], $r[1], $r[2])
									->setTime($r[3],$r[4],$r[5])
									->format($date_format, true);

								$p_id['row']['LIST'][] = array(
									'PARTICIPANTS_USER'			=> $user_row['username'],
									'PARTICIPANTS_USER_LINK'	=> append_sid($this->phpbb_root_path . 'memberlist.php?mode=viewprofile&u=' . $user_row['user_id']),
									'PARTICIPANTS_COLOUR'		=> $user_row['user_colour'],
									'PARTICIPANTS_NUMBER'		=> $part_row['number'],
									'PARTICIPANTS_PART'			=> $this->user->lang['CALENDAR_'.strtoupper($part_row['participants']).''],
									'PARTICIPANTS_COMMENTS'		=> $part_row['comments'],
									'PARTICIPANTS_DATE'			=> $p_date,
								);
							}
							$this->db->sql_freeresult($user_result);
						}
						$p_id['row']['0'] = array(
							'PARTICIPANTS_COUNT'	=> $number['yes'] . '&nbsp;/&nbsp;' . $number['mb'] . '&nbsp;/&nbsp;' . $number['no'],
						);
					}
				}
			}
			else
			{
				$p_id['row'] = array(
					'ENTRY'				=>	$this->user->lang('CALENDAR_ENTRY') . ': ' . $cal_date,
					'LINK'				=>	$link,
				);
			}
			$event['cp_row'] = $p_id;
		}
	}

	public function calendar_on_header($event)
	{ 
		global $weekday, $wday, $c_event, $c_date;
		$dc = $this->request->variable('dc','');

		$url = $this->request->variable('REQUEST_URI', '', false,\phpbb\request\request_interface::SERVER);

		$url = preg_replace('/\?dc=off/','',$url);
		$url = preg_replace('/\?dc=on/','',$url);
		$url = preg_replace('/&amp;dc=off/','',$url);
		$url = preg_replace('/&amp;dc=on/','',$url);

		$i = strpos($url, 'f');
		if ($i)
		{
			$url	= append_sid($url . '&');
		}
		else
		{
			$url	= append_sid($url . '?');
		}

		if ($dc == 'on' || $this->config['calendar_on_header'] <> date("j"))
		{
			$calendar	= true;
			$d_action	= append_sid($url . 'dc=off');
			$this->config->set('calendar_on_header', 0);
		}

		if ($this->config['calendar_on_header'] == date("j"))
		{
			$calendar	= false;
			$d_action	= append_sid($url . 'dc=on');
		}

		if ($dc == 'off')
		{
			$calendar	= false;
			$d_action	= append_sid($url . 'dc=on');
			$this->config->set('calendar_on_header', date("j"));
		}
		
		$this->template->assign_vars(array(
			'CALENDAR'				=> $calendar,
			'DISPLAY_ACTION'		=> $d_action,
		));

		include($this->root_path . 'includes/constants' . $this->phpex);
		$calendar_link	=	$this->helper->route('hjw_calendar_controller');

		if($this->config['version'] > '3.1')
		{
			$version = '3.1';
		}
		if($this->config['version'] > '3.2')
		{
			$version = '3.2';
		}
		
		$football = 0;
		$sql = 'SELECT *
			FROM ' . EXT_TABLE . '
				ORDER by ext_name';
		$result = $this->db->sql_query($sql);
		while($row = $this->db->sql_fetchrow($result))
		{
			if($row['ext_name'] == 'football/football' &&	$row['ext_active'] == 1)
			{
				$football = $this->config['calendar_football'];
			}
		}
		
		$this->template->assign_vars(array(
				'U_CALENDAR'				=> $calendar_link,	
				'S_WEEK_OR_NEXT'			=> $this->config['week_or_next'],
				'S_WEEK_ON_INDEX'			=> $this->config['week_on_index'],
				'S_BIRTHDAY_ON_CALENDAR'	=> $this->config['birthday_on_calendar'],
				'S_CALENDAR_FOR_GUESTS'		=> $this->config['calendar_for_guests'],
				'VERSION'					=> $version,
			));	
		if ($calendar == true)
		{
		$month_name = array(
			1 => $this->user->lang['datetime']['January'],
			2 => $this->user->lang['datetime']['February'],
			3 => $this->user->lang['datetime']['March'],
			4 => $this->user->lang['datetime']['April'],
			5 => $this->user->lang['datetime']['May'],
			6 => $this->user->lang['datetime']['June'],
			7 => $this->user->lang['datetime']['July'],
			8 => $this->user->lang['datetime']['August'],
			9 => $this->user->lang['datetime']['September'],
		   10 => $this->user->lang['datetime']['October'],
		   11 => $this->user->lang['datetime']['November'],
		   12 => $this->user->lang['datetime']['December'],
			);
		$weekday = array(
			1 => $this->user->lang['datetime']['Monday'],
			2 => $this->user->lang['datetime']['Tuesday'],
			3 => $this->user->lang['datetime']['Wednesday'],
			4 => $this->user->lang['datetime']['Thursday'],
			5 => $this->user->lang['datetime']['Friday'],
			6 => $this->user->lang['datetime']['Saturday'],
			7 => $this->user->lang['datetime']['Sunday'],
		);
		$wday = array(
			1 => $this->user->lang['datetime']['Mon'],
			2 => $this->user->lang['datetime']['Tue'],
			3 => $this->user->lang['datetime']['Wed'],
			4 => $this->user->lang['datetime']['Thu'],
			5 => $this->user->lang['datetime']['Fri'],
			6 => $this->user->lang['datetime']['Sat'],
			7 => $this->user->lang['datetime']['Sun'],
		);
			
		if($this->config['week_or_next'] == 1 || $this->config['week_or_next'] == 3)
		{
			$day = date("j"); 
			$month = date("n"); 
			$year = date("Y"); 

			include($this->root_path . 'includes/special_days' . $this->phpex);

			$c_days = ($this->config['number_of_weeks']*7)-1;
			for ($y=0;$y<=$c_days;$y++)
			{
				$i=$y;
				while ($i > 6)
				{
					$i -= 7;
				}
				$d=date("N")+$y;
				if ($y<7)
				{
					$dd=$d;
					if ($dd>7)
					{
						$dd -= 7;
					}
					$this->template->assign_block_vars('weekday' ,array(
						'DAY'	=> $weekday[$dd],
						'SDAY'	=> $wday[$dd],
					));
				}
				while ($d > 7)
				{
					$d=$d-7;
				}
				$bg = 'bg1';
				if (is_int(($d+1)/7))
				{
					$bg = 'sat';
				}
				if (is_int($d/7))
				{
					$bg = 'sun';
				}
				$td = '';
				if ($i == 0)
				{
					$td = '<tr>';
				}
				$td .= '<td class="'.$bg.'" title="'. $day.'.'.$month_name[$month].'">';

				$tde = '</td>';
				if ($i == 6)
				{
					$tde = '</td></tr>';
				}
				$this->template->assign_block_vars('day', array(
					'INDEX'	=> true,
					'DATE'	=> $day.'.',
					'TD'	=> $td,
					'TDE'	=> $tde,
				));

				include($this->root_path . 'includes/calendar_event' . $this->phpex);

				$day++;
				if ($day > date("t", mktime(0, 0, 0, $month, 1, $year)))
				{
					$day = $day-date("t", mktime(0, 0, 0, $month, 1, $year));
					$month++;
					if ($month > 12)
					{
						$month = $month-12;
						$year = $year+1;
					}
				}
			}
		}

		if($this->config['week_or_next'] == 2 || $this->config['week_or_next'] == 3)
		{
			$year	=	date("Y");
			$month	=	date("n");
			$day	=	date("j");
			$count_event = 0;
			$count_event_max = 10 *  $this->config['number_of_weeks'];
			$sql = 'SELECT *
				FROM ' . CALENDAR_TABLE . ' 
					WHERE date_from >= "' . $year.'-'.str_pad($month, 2, '0', STR_PAD_LEFT).'-'.str_pad($day, 2, '0', STR_PAD_LEFT).'" 
						OR 
							date_to >= "' . $year.'-'.str_pad($month, 2, '0', STR_PAD_LEFT).'-'.str_pad($day, 2, '0', STR_PAD_LEFT).'"
								OR 
									date_from <= "' . $year.'-'.str_pad($month, 2, '0', STR_PAD_LEFT).'-'.str_pad($day, 2, '0', STR_PAD_LEFT).'"
										AND 
											date_to = "0000-00-00" AND calendar_repeat = "1" 
					ORDER by date_from';

			$event_result = $this->db->sql_query($sql);
			while (($event_row = $this->db->sql_fetchrow($event_result)) && ($count_event < $count_event_max))
			{
				$upcoming = $event_row;
				if($event_row['calendar_repeat'])
				{
					if($event_row['repeat_dm'] == 1)
					{
						$f		= explode('-',$event_row['date_from']);
						$start	= mktime(12,0,0,$f[1],$f[2],$f[0]);
						$date	= mktime(12,0,0,$month,$day,$year);
						$count = 0;
						for($i=0;$count<$count_event_max ;$i++)
						{
							$next	= mktime(12,0,0,$f[1],$f[2]+$i*$event_row['repeat_day_number'],$f[0]);
							if (date("Ymd", $next) >= date("Ymd", $date)) 
							{
								$upcoming['date_from'] =  date("Y-m-d", $next);
								upcoming_events($upcoming);
								$count++;
							}
						}
					}
					if($event_row['repeat_dm'] == 0)
					{
						$f		= explode('-',$event_row['date_from']);
				
						$start	= mktime(12,0,0,$f[1],$f[2],$f[0]);
						$date	= mktime(12,0,0,$month,$day,$year);
						$count = 0;
						for($i=0;$count<$count_event_max ;$i++)
						{
							$next	= mktime(12,0,0,$f[1]+$i*$event_row['repeat_month_number'],$f[2],$f[0]);
							if (date("Ymd", $next) >= date("Ymd", $date)) 
							{
								$upcoming['date_from'] =  date("Y-m-d", $next);
								upcoming_events($upcoming);
								$count++;
							}
						}
					}
	
				}
				else
				{		
					upcoming_events($upcoming);
				}
			}
			$sql = 'SELECT *
				FROM ' . CALENDAR_EVENT_LIST_TABLE . '
					WHERE date_from >= "' . $year.'-'.str_pad($month, 2, '0', STR_PAD_LEFT).'-'.str_pad($day, 2, '0', STR_PAD_LEFT).'" 
						OR 
							date_to >= "' . $year.'-'.str_pad($month, 2, '0', STR_PAD_LEFT).'-'.str_pad($day, 2, '0', STR_PAD_LEFT).'" 
								ORDER by date_from';

			$event_result = $this->db->sql_query($sql);
			while (($event_row = $this->db->sql_fetchrow($event_result)) && ($count_event < $count_event_max))
			{
				$appointment	= $event_row['appointment'];
				$link 			= $event_row['link'];
				$color			= $event_row['color'];
				$big			= $event_row['big'];
				$bcolor			= $event_row['bcolor'];
				$anniversary	= $event_row['anniversary'];
				
				$r				= explode('-',$event_row['date_from']);
				$from_year		= $r[0];
				$from_month 	= $r[1];
				$from_day		= $r[2];
				$r				= explode('-',$event_row['date_to']);
				$to_year		= $r[0];
				$to_month 		= $r[1];
				$to_day			= $r[2];

				$wd = date("N", strtotime($from_year . '-' . $from_month . '-' . $from_day));

				$datum = $from_day . '.' . $from_month . '.' . $from_year;
				if ($event_row['date_to'] <> '0000-00-00')
				{
					$datum .= '<br />- ' . $to_day . '.' . $to_month . '.' . $to_year;
				}
				else
				{
					$datum .= '<br />';
				}
				$datum .= '<br />';

				$output = '<div title ="' . $appointment . '"><span class="day">' . $weekday[$wd] . '</span><span class="sday">' . $wday[$wd] . '</span>';
				$output .= '<br />';
				$output .= $datum;
				if($big)
				{
					$appointment	=	'<strong>' . $appointment . '</strong>';
				}
				$output .= '<span style="color:#' . $color . ';background-color:#' . $bcolor . ';border-radius:13px;padding:0 3px;">' . $appointment . '</span>';
				$output .= '</div>';
				if ($link)
				{
					$output = '<a href="' . $link . '" title ="' . $appointment . '"><div>' . $output . '</div></a>';
				}
				$c_event[]	=	$output;
				$c_date[]	=	$from_year . $from_month . $from_day;
			}

			
			$sql = 'SELECT *
				FROM ' . CALENDAR_EVENT_LIST_TABLE . '
					WHERE date_from LIKE "0000-%"
						OR anniversary = "1"';
					
			$event_result = $this->db->sql_query($sql);
			while ($event_row = $this->db->sql_fetchrow($event_result)) 
			{
				$appointment	= $event_row['appointment'];
				$link 			= $event_row['link'];
				$color			= $event_row['color'];
				$big			= $event_row['big'];
				$bcolor			= $event_row['bcolor'];
				$anniversary	= $event_row['anniversary'];

				$r				= explode('-',$event_row['date_from']);
				$from_year		= $r[0];
				$from_month 	= $r[1];
				$from_day		= $r[2];
				$r				= explode('-',$event_row['date_to']);
				$to_year		= $r[0];
				$to_month 		= $r[1];
				$to_day			= $r[2];
				if($from_year =='0000')
				{
					if(str_pad($from_month, 2, '0', STR_PAD_LEFT) . str_pad($from_day, 2, '0', STR_PAD_LEFT) >= str_pad($month, 2, '0', STR_PAD_LEFT) . str_pad($day, 2, '0', STR_PAD_LEFT))
					{
						$from_year = $year;
					}
					else
					{
						$from_year = $year+1;
					}
				}
				if($anniversary)
				{
					$age = $from_year;
					if(str_pad($from_month, 2, '0', STR_PAD_LEFT) . str_pad($from_day, 2, '0', STR_PAD_LEFT) >= str_pad($month, 2, '0', STR_PAD_LEFT) . str_pad($day, 2, '0', STR_PAD_LEFT))
					{
						$from_year = $year;
					}
					else
					{
						$from_year = $year+1;
					}
					$age = $from_year - $age;
					$appointment	=	$appointment . ' (' . $age . ')';
				}
				$wd = date("N", strtotime($from_year . '-' . $from_month . '-' . $from_day));

				$datum = $from_day . '.' . $from_month . '.' . $from_year;
				if ($event_row['date_to'] <> '0000-00-00')
				{
					$datum .= '<br />- ' . $to_day . '.' . $to_month . '.' . $to_year;
				}
				else
				{
					$datum .= '<br />';
				}
				$datum .= '<br />';
				
				$output = '<div title ="' . $appointment . '"><span class="day">' . $weekday[$wd] . '</span><span class="sday">' . $wday[$wd] . '</span>';
				$output .= '<br />';
				$output .= $datum;
				if($big)
				{
					$appointment	=	'<strong>' . $appointment . '</strong>';
				}
				$output .= '<span style="color:#' . $color . ';background-color:#' . $bcolor . ';border-radius:13px;padding:0 3px;">' . $appointment . '</span>';
				$output .= '</div>';
				if ($link)
				{
					$output = '<a href="' . $link . '" title ="' . $appointment . '"><div>' . $output . '</div></a>';
				}
				$c_event[]	=	$output;
				$c_date[]	=	$from_year . $from_month . $from_day;
			}

			if($this->config['birthday_on_calendar'])
			{
				$sql = 'SELECT user_id, username, user_birthday, user_colour
					FROM ' . USERS_TABLE . '
						ORDER by user_birthday';

				$event_result = $this->db->sql_query($sql);
				while (($event_row = $this->db->sql_fetchrow($event_result)) && ($count_event < $count_event_max))
				{
					if($event_row['user_birthday'] && $event_row['user_birthday'] != ' 0- 0-   0')
					{
						$user_id			= $event_row['user_id'];
						$username 			= $event_row['username'];
						$user_colour 		= $event_row['user_colour'];
						$r			= explode('-',$event_row['user_birthday']);
						$from_day	= str_pad(trim($r[0]), 2, '0', STR_PAD_LEFT);
						$from_month = str_pad(trim($r[1]), 2, '0', STR_PAD_LEFT);
						$from_year	= str_pad(trim($r[2]), 4, '0', STR_PAD_LEFT);
						if ( checkdate($from_month, $from_day, $from_year) )
						{
							$age = $from_year;

							if($from_month . $from_day >= str_pad(trim($month), 2, '0', STR_PAD_LEFT) . str_pad(trim($day), 2, '0', STR_PAD_LEFT))
							{
								$from_year = $year;
							}
							else
							{
								$from_year = $year+1;
							}
							$age = $from_year - $age;
							$username	=	$username . ' (' . $age . ')';
							$wd = date("N", strtotime($from_year . '-' . $from_month . '-' . $from_day));
							$datum = $from_day . '.' . $from_month . '.' . $from_year . '<br />';
							$datum .= '<br />';
							$output = '<div title ="' . $username . '"><span class="day">' . $weekday[$wd] . '</span><span class="sday">' . $wday[$wd] . '</span>';
							$output .= '<br />';
							$output .= $datum;
							$output .= '<span style="color:#' . $color . ';background-color:#' . $bcolor . ';border-radius:13px;padding:0 3px;">' . $username . '</span>';
							$output .= '</div>';
							$output = '<a href="memberlist.php?mode=viewprofile&amp;u=' . $user_id . '">' . $output . '</a>';

							$c_event[]=$output;
							$c_date[] =$from_year . $from_month . $from_day;
						}
					}
				}
			}

			if (isset($c_date))
			{
				array_multisort($c_date, $c_event);
			
				$c_count = min(count($c_event),$count_event_max);
				for($i=0;$i<$c_count;$i++)
				{
					$break = false;
					if ((int)(($i+1)/10) == ($i+1)/10)
					{
						$break = true;
					}
					$this->template->assign_block_vars('event', array(
						'EVENT'		=>	$c_event[$i],
						'BREAK'		=>	$break,
					));
				}
			}
		}
	}
	}
	

	public function modify_participants_list()
	{

		$user_id  = $this->user->data['user_id'];
		include($this->root_path . 'includes/constants' . $this->phpex);
		if ($this->request->variable('part', ''))
		{
			if ($user_id)
			{
				$sql_ary = array(
					'POST_ID'		=> $this->request->variable('participants_id', '', true),
					'USER_ID'		=> $user_id,
					'NUMBER'		=> (int)($this->request->variable('group', '', true)),
					'PARTICIPANTS'	=> utf8_normalize_nfc($this->request->variable('part', '', true)),
					'COMMENTS'		=> utf8_normalize_nfc($this->request->variable('comments', '', true)),
					'DATE'			=> date("Y-n-j-H-i"),
				);
				
                /**
				* Perform additional actions when new participants are added or modify the data
				*
				* @event hjw.calendar.viewtopic.modify_participants_list
				* @var array    sql_ary            SQL data to be entered into participants table
				* @since 0.7.6
				*/
				$vars = array(
					'sql_ary',
					'user_id',
				);
				extract($this->phpbb_dispatcher->trigger_event('hjw.calendar.viewtopic.modify_participants_list', compact($vars)));
				
				$sql='SELECT * from ' . CALENDAR_PARTICIPANTS_TABLE . "
					WHERE post_id = '" . $sql_ary['POST_ID'] ."' and user_id = '" . $user_id."'"; 
				$result = $this->db->sql_query($sql);
				$row = $this->db->sql_fetchrow($result);
				if ($row)
				{
					$sql = 'UPDATE ' . CALENDAR_PARTICIPANTS_TABLE . '
						SET ' . $this->db->sql_build_array('UPDATE', $sql_ary) . "
						WHERE post_id = '" . $sql_ary['POST_ID'] ."' and user_id = '" . $user_id."'"; 
				}
				else
				{
					$sql = 'INSERT INTO ' . CALENDAR_PARTICIPANTS_TABLE . ' ' . $this->db->sql_build_array('INSERT', $sql_ary);	
				}
				$result = $this->db->sql_query($sql);
			}
		}
	}

	public function calendar($event)
	{ 
		include($this->root_path . 'includes/constants' . $this->phpex);
		$post_id = $event['post_id'];
		$forum_id = $event['forum_id'];
		
		$quote = false;
		if ((substr($event['post_data']['post_text'],1,5) == 'quote'))
		{
			$quote = true;
		}

		$first_post_id = 0;
		if (isset($event['post_data']['topic_first_post_id']))
		{
			$first_post_id = $event['post_data']['topic_first_post_id'];
		}
		$first_post = false;
		if ($first_post_id == 0)
		{
			$first_post = true;
		}
		else
		{
			if($first_post_id == $event['post_id'] && !$quote)
			{
				$first_post = true;
			}
		}

		if ($this->config['calendar_only_first_post'] && !$first_post)
		{
		}
		else
		{
			$sql = 'SELECT *
				FROM ' . CALENDAR_FORUMS_TABLE . '
				WHERE forum_id = "' . $forum_id.'"';
			$result = $this->db->sql_query($sql);
			$forum_row = $this->db->sql_fetchrow($result);
			$this->db->sql_freeresult($result);
			if ($forum_row)
			{
				if ($forum_row['allowed'] == 1)
				{
					$this->template->assign_vars( array(
						'CALENDAR_ALLOWED'			=> true,
					));	

					$month_name = array(
						1 => $this->user->lang['datetime']['January'],
						2 => $this->user->lang['datetime']['February'],
						3 => $this->user->lang['datetime']['March'],
						4 => $this->user->lang['datetime']['April'],
						5 => $this->user->lang['datetime']['May'],
						6 => $this->user->lang['datetime']['June'],
						7 => $this->user->lang['datetime']['July'],
						8 => $this->user->lang['datetime']['August'],
						9 => $this->user->lang['datetime']['September'],
					   10 => $this->user->lang['datetime']['October'],
					   11 => $this->user->lang['datetime']['November'],
					   12 => $this->user->lang['datetime']['December'],
					);

					$event_id 	= '';
					$event_name	= '';
					$from 		= '';
					$r			= '';
					$from_year	= '';
					$from_month = '';
					$from_day	= '';
					$to 		= '';
					$r			= '';
					$to_year	= '';
					$to_month 	= '';
					$to_day		= '';
					$calendar_repeat				= '';
					$calendar_repeat_dm			= '';
					$calendar_repeat_day_number		= '';
					$calendar_repeat_month_number	= '';
					if ($post_id)
					{
						$sql = 'SELECT *
							FROM ' . CALENDAR_TABLE . '
								WHERE post_id = ' . $post_id;
						$result = $this->db->sql_query($sql);
						$row = $this->db->sql_fetchrow($result);
						if($row)
						{
							$present	= true;
							$event_id 	= $row['event_id'];
							$event_name	= $row['event_name'];
							$from 		= $row['date_from'];
							$r			= explode('-',$from);
							$from_year	= $r[0];
							$from_month = $r[1];
							$from_day	= $r[2];
							$to 		= $row['date_to'];
							$r			= explode('-',$to);
							$to_year	= $r[0];
							$to_month 	= $r[1];
							$to_day		= $r[2];
							
							$calendar_repeat				= $row['calendar_repeat'];
							$calendar_repeat_dm				= $row['repeat_dm'];
							$calendar_repeat_day_number		= $row['repeat_day_number'];
							$calendar_repeat_month_number	= $row['repeat_month_number'];
						}
					}

					$event_id	= $this->request->variable('event', $event_id);
					$event_name	= $this->request->variable('event_name', $event_name);
					
					$from_day	= str_pad($this->request->variable('from_day',	$from_day),		2 ,'0', STR_PAD_LEFT);
					$from_month	= str_pad($this->request->variable('from_month',	$from_month),	2 ,'0', STR_PAD_LEFT);
					$from_year	= str_pad($this->request->variable('from_year',	$from_year),	4 ,'0', STR_PAD_LEFT);
					$to_day		= str_pad($this->request->variable('to_day',		$to_day),		2 ,'0', STR_PAD_LEFT);
					$to_month	= str_pad($this->request->variable('to_month',	$to_month),		2 ,'0', STR_PAD_LEFT);
					$to_year	= str_pad($this->request->variable('to_year',		$to_year),		4 ,'0', STR_PAD_LEFT);
					$from		= $from_year.'-'.$from_month.'-'.$from_day;
					$to			= $to_year.'-'.$to_month.'-'.$to_day;
					
					$calendar_repeat				= $this->request->variable('calendar_repeat', $calendar_repeat);
					$calendar_repeat_dm				= $this->request->variable('calendar_repeat_dm', $calendar_repeat_dm);
					$calendar_repeat_day_number		= $this->request->variable('calendar_repeat_day_number', $calendar_repeat_day_number);
					$calendar_repeat_month_number	= $this->request->variable('calendar_repeat_month_number', $calendar_repeat_month_number);

					$cr0 = '';
					$cr1 = '';
					if(!$calendar_repeat)
					{
						$cr0 = ' checked="checked" ';
					}
					else
					{
						$cr1 = ' checked="checked" ';
					}
					$crd = '';
					$crm = '';
					if($calendar_repeat_dm)
					{
						$crd = ' checked="checked" ';
					}
					else
					{
						$crm = ' checked="checked" ';
					}
					
					
					$this->template->assign_vars(array(
						'EVENT_NAME' 					=> $event_name,
						'CR0'							=> $cr0,
						'CR1'							=> $cr1,
						'CRD'							=> $crd,
						'CALENDAR_REPEAT_DAY_NUMBER'	=> $calendar_repeat_day_number,
						'CRM'							=> $crm,
						'CALENDAR_REPEAT_MONTH_NUMBER'	=> $calendar_repeat_month_number,
					));	

					$this->template->assign_block_vars('from_day', array(
						'SELECT' =>'<option value=" ">'.$this->user->lang['DAY'].'</option>',
					));	

					for ($i=1;$i<=31;$i++)
					{
						$s='';if ($i == $from_day) $s=' selected="selected"';  
						$this->template->assign_block_vars('from_day', array(
							'SELECT' =>'<option'.$s.' value="'.$i.'">'.$i.'</option>',
						));	
					}

					$this->template->assign_block_vars('to_day', array(
						'SELECT' =>'<option value=" ">'.$this->user->lang['DAY'].'</option>',
					));	

					for ($i=1;$i<=31;$i++)
					{
						$s='';if ($i == $to_day) $s=' selected="selected"';  
						$this->template->assign_block_vars('to_day', array(
							'SELECT' =>'<option'.$s.' value="'.$i.'">'.$i.'</option>',
						));	
					}

					$this->template->assign_block_vars('from_month', array(
						'SELECT' =>'<option value=" ">'.$this->user->lang['MONTH'].'</option>',
					));	

					for ($i=1;$i<=12;$i++)
					{
						$s='';if ($i == $from_month) $s=' selected="selected"';  
						$this->template->assign_block_vars('from_month', array(
							'SELECT' =>'<option'.$s.' value="'.$i.'">'.$month_name[$i].'</option>',
						));	
					}

					$this->template->assign_block_vars('to_month', array(
						'SELECT' =>'<option value=" ">'.$this->user->lang['MONTH'].'</option>',
					));	

					for ($i=1;$i<=12;$i++)
					{
						$s='';if ($i == $to_month) $s=' selected="selected"';  
						$this->template->assign_block_vars('to_month', array(
							'SELECT' =>'<option'.$s.' value="'.$i.'">'.$month_name[$i].'</option>',
						));	
					}

					$date = getdate();
					$year=$date['year']*1;
					if ($from_year > 0) $year = $from_year;
					$this->template->assign_block_vars('from_year', array(
						'SELECT' =>'<option value=" ">'.$this->user->lang['YEAR'].'</option>',
					));	

					for ($i=$year;$i<$year+10;$i++)
					{
						$s='';if ($i == $from_year) $s=' selected="selected"';  
						$this->template->assign_block_vars('from_year', array(
							'SELECT' =>'<option'.$s.' value="'.$i.'">'.$i.'</option>',
						));	
					}

					$this->template->assign_block_vars('to_year', array(
						'SELECT' =>'<option value=" ">'.$this->user->lang['YEAR'].'</option>',
					));	

					for ($i=$year;$i<$year+10;$i++)
					{
						$s='';if ($i == $to_year) $s=' selected="selected"';  
						$this->template->assign_block_vars('to_year', array(
							'SELECT' =>'<option'.$s.' value="'.$i.'">'.$i.'</option>',
						));	
					}

					$this->template->assign_block_vars('eventselect', array(
						'SELECT' =>'<option value=" "> </option>',
					));	

					$sql = 'SELECT *
						FROM ' . CALENDAR_EVENT_TABLE;
					$result = $this->db->sql_query($sql);
					while($row = $this->db->sql_fetchrow($result))
					{
						$s='';if ($row['id']*1 == $event_id*1) $s=' selected="selected"';  
						$this->template->assign_block_vars('eventselect', array(
							'SELECT' =>'<option'.$s.' value="'.$row['id'].'">'.$row['event'].'</option>',
						));
					}
				}
			}
		}
	}

	public function send_data_to_table($event)
	{
		include($this->root_path . 'includes/constants' . $this->phpex);

		$post_id = $event['data']['post_id'];
		
		$present 	= false;
		$e_id		=	'';
		$e_n		=	'';
		$f[0]		=	'0000';
		$f[1]		=	'00';
		$f[2]		=	'00';
		$t[0]		=	'0000';
		$t[1]		=	'00';
		$t[2]		=	'00';
		$cr			= 0;
		$crd		= 0;
		$crdn		= 0;
		$crmn		= 0;
	
		$sql = 'SELECT *
			FROM ' . CALENDAR_TABLE . '
				WHERE post_id = ' . $post_id;
		$result = $this->db->sql_query($sql);
		if($row = $this->db->sql_fetchrow($result))
		{
			$present	= true;
			$e_id		= $row['event_id'];
			$e_n		= $row['event_name'];
			$f			= explode('-',$row['date_from']);
			$t			= explode('-',$row['date_to']);
			$cr			= $row['calendar_repeat'];
			$crd		= $row['repeat_dm'];
			$crdn		= $row['repeat_day_number'];
			$crmn		= $row['repeat_month_number'];
		}
//print_r($this->request);		
		$event_id	= $this->request->variable('event', $e_id);
		$event_name	= utf8_normalize_nfc($this->request->variable('event_name', $e_n, true));
		$from_day	= str_pad($this->request->variable('from_day',		$f[2]),	2 ,'0', STR_PAD_LEFT);
		$from_month	= str_pad($this->request->variable('from_month',	$f[1]),	2 ,'0', STR_PAD_LEFT);
		$from_year	= str_pad($this->request->variable('from_year',		$f[0]),	4 ,'0', STR_PAD_LEFT);
		$to_day		= str_pad($this->request->variable('to_day',		$t[2]),	2 ,'0', STR_PAD_LEFT);
		$to_month	= str_pad($this->request->variable('to_month',		$t[1]),	2 ,'0', STR_PAD_LEFT);
		$to_year	= str_pad($this->request->variable('to_year',		$t[0]),	4 ,'0', STR_PAD_LEFT);
		$from		= $from_year.'-'.$from_month.'-'.$from_day;
		$to			= $to_year.'-'.$to_month.'-'.$to_day;

		$calendar_repeat				= $this->request->variable('calendar_repeat', $cr);
		$calendar_repeat_dm				= $this->request->variable('calendar_repeat_dm', $crd);
		$calendar_repeat_day_number		= $this->request->variable('calendar_repeat_day_number', $crdn);
		$calendar_repeat_month_number	= $this->request->variable('calendar_repeat_month_number', $crmn);

		$sql_ary = array(
			'POST_ID'				=>	$post_id,
			'EVENT_ID'				=>	$event_id,
			'EVENT_NAME'			=>	$event_name,
			'DATE_FROM'				=>	$from,
			'DATE_TO'				=>	$to,
			'CALENDAR_REPEAT'		=>	$calendar_repeat,
			'REPEAT_DM'				=>	$calendar_repeat_dm,
			'REPEAT_DAY_NUMBER'		=>	$calendar_repeat_day_number,
			'REPEAT_MONTH_NUMBER'	=>	$calendar_repeat_month_number,
		);

		if ($present & $event_id == '')
			{
			$sql = 'DELETE FROM ' . CALENDAR_TABLE . " 
				WHERE post_id = '" . $post_id."'"; 
			}

		if ($event_id > 0)
		{
			if ($present)
			{
				$sql = 'UPDATE ' . CALENDAR_TABLE . '
					SET ' . $this->db->sql_build_array('UPDATE', $sql_ary) . "
					WHERE post_id = '" . $post_id."'";
			}
			else
			{
				$sql = 'INSERT INTO ' . CALENDAR_TABLE . ' ' . $this->db->sql_build_array('INSERT', $sql_ary);		
			}
		}
		$result = $this->db->sql_query($sql);
	}
}

function upcoming_events($upcoming)
{
	global $db, $user, $auth, $phpbb_root_path, $config, $weekday, $wday, $c_event, $c_date;
		$post_id	= $upcoming['post_id'];
		$event_id 	= $upcoming['event_id'];
		$event_name	= $upcoming['event_name'];
		$r			= explode('-',$upcoming['date_from']);
		$from_year	= $r[0];
		$from_month = $r[1];
		$from_day	= $r[2];
		$r			= explode('-',$upcoming['date_to']);
		$to_year	= $r[0];
		$to_month 	= $r[1];
		$to_day		= $r[2];

		$sql = 'SELECT *
			FROM ' . CALENDAR_EVENT_TABLE . '
				WHERE id = "' . $event_id . '"';
		$result = $db->sql_query($sql);
		$row	= $db->sql_fetchrow($result);
		$color	= $row['color'];
		$big	= $row['big'];
		$bcolor	= $row['bcolor'];
			
		$sql = 'SELECT *
			FROM ' . POSTS_TABLE . '
				WHERE post_id = "' . $post_id . '"'; 
		$post_result = $db->sql_query($sql);
		$post_row = $db->sql_fetchrow($post_result);
		$db->sql_freeresult($post_result);
		if ($post_row)
		{
			if ($post_row['post_visibility'] == 1)
			{
				$user_id = $user->data['user_id'];
				$auth_array = $auth->acl_raw_data($user_id, 'f_read', $post_row['forum_id']);
				if (isset($auth_array[$user_id][$post_row['forum_id']]['f_read']) && $auth_array[$user_id][$post_row['forum_id']]['f_read'])
				{
					$link 	= append_sid($phpbb_root_path . 'viewtopic.php?p=' . $post_row['post_id'] . '#p' . $post_row['post_id']);
					$subject = $post_row['post_subject'];
				
					$wd = date("N", strtotime($from_year . '-' . $from_month . '-' . $from_day));
					$datum = $from_day . '.' . $from_month . '.' . $from_year;
					if ($upcoming['date_to'] <> '0000-00-00')
					{
						$datum .= '<br />- ' . $to_day . '.' . $to_month . '.' . $to_year;
					}
					else
					{
						$datum .= '<br />';
					}
					$datum .= '<br />';
					$number = 0;
					$nr = '';
					$part='';
	
					if($config['calendar_number_participating'])
					{
						$sql = 'SELECT *
							FROM ' . CALENDAR_PARTICIPANTS_TABLE . '
								WHERE post_id = "' . $post_id.'"';
						$result = $db->sql_query($sql);
						while($part_row = $db->sql_fetchrow($result))
						{
							$sql = 'SELECT user_colour, username
								FROM ' . USERS_TABLE . '
									WHERE user_id = "' . $part_row['user_id'].'"';
							$user_result = $db->sql_query($sql);
							$user_row = $db->sql_fetchrow($user_result);
		
							if ($part_row['participants'] == 'yes')
							{
								$number += (int)$part_row['number'];
								if($config['calendar_participants_name'])
								{
									$part .= chr(10) . $user_row['username'] . ' [' . (int)$part_row['number'] . ']';
								}
							}
						}
						if ($number > 0)
						{
							$nr = ' ['.$number.']';
							$part = chr(10).'----------'.$part;
						}
					}
					
					$output = '<div title ="' . $subject . $part . ' "><span class="day">' . $weekday[$wd] . '</span><span class="sday">' . $wday[$wd] . '</span>';
					$output .= '<br />';
					$output .= $datum;
					if($nr)
					{
						$event_name	.=	$nr;
					}
					if($big)
					{
						$event_name	=	'<strong>' . $event_name . '</strong>';
					}
					$output .= '<span style="color:#' . $color . ';background-color:#' . $bcolor . ';border-radius:13px;padding:0 3px;">' . $event_name . '</span>';
					$output .= '</div>';
					if ($link)
					{
						$output = '<a href="' . $link . ' "><div>' . $output . '</div></a>';
					}
					$c_event[]	=	$output;
					$c_date[]	=	$from_year . $from_month . $from_day;
				}
			}
		}
		else
		{
			$sql = 'DELETE FROM ' . CALENDAR_TABLE . " 
				WHERE post_id = '" . $post_id."'"; 
			$result = $db->sql_query($sql);
		}
	}
