<?php


/** 
 * @package 
 * @filename json_test.php 
 * @author Christopher M. Moody, TK-394 
 * @email chris@tk394.com 
 * @version 1.0 
 * @date 4/21/13 
 * @time: 2:05 PM 
 * 
 * 
 */ 

// URL to the Legion's JSON feed.  Change the number to your specific unit. 
// ID numbers can be found by going to http://www.501st.com/members/displayUnits.php#garrisons 
// hovering your mouse over the 'Roster of Unit Member Costumes' link and looking for 
// the number in URL.  Example: In the link for the 70th Explorers Garrison, 
// http://www.501st.com/members/garrisonroster.php?garrisonId=57 , the ID number is 57. 
// 
// $json_url = 'http://www.501st.com/api/garrisons/<your unit ID here>/members'; 
$json_url = 'https://www.501st.com/api/v2/garrisons/56/members'; 

// Read the JSON contents of that page into a variable. 
$json = file_get_contents($json_url); 

// Decode the JSON into an object. 
$legionData = json_decode($json); 



?> 

<link rel="stylesheet" href="../../foundation.css">
<div class="row" style="text-align:center;margin:0 auto;"> 
    <!-- Garrison Officers --> 
    <div class="four columns push-eight"> <!-- Foundation v3: Makes this the right column unless viewing on mobile --> 
        <div class="panel"> 
            <h4><?=$legionData->unit->name?> Officers</h4> 
            <hr /> 
            <?php 
            $officers = $legionData->unit->officers; 
            foreach ($officers as $officer) { 
                // Add a line break to the middle of GMB for better formatting. 
                // May not be needed for your unit's site. Then again, you may 
                // need to add *more* for other offices that don't fit your layout. 
                if ($officer->office == 'Garrison Merchandising & Branding Officer') { 
                    $officer->office = 'Garrison Merchandising<br />& Branding Officer'; 
                } 
                ?> 
                <p><strong><?=$officer->office?> (<?=$officer->officeAcronym?>):</strong><br /> 
                <a href="<?=$officer->profileUrl?>"><?=$officer->fullName?>, <?=$officer->legionId?></a></p> 
                <?php 
            } 
            ?> 
        </div> 
    </div> 

    <!-- Garrison Roster --> 
    <div class="eight columns pull-four">  <!-- Foundation v3: Makes this the left column unless viewing on mobile --> 
        <div class="panel" style="background: #ffffff"> 
            <!-- Display the unit name and number of members --> 
            <h4><?=$legionData->unit->name?> Roster (<?=$legionData->unit->unitSize?> members):</h4> 
            <ul class="block-grid five-up mobile-two-up text-center"> 
            <?php 
                $members = $legionData->unit->members; 
                foreach ($members as $member) { 
                    ?> 
                    <!-- Display a thumbnail and TK ID with link to profile, for each member --> 
 <!--                    <li class="small"><?=$member->fullName?><br/> <!-- Full name currently not offered in the API --> --> 
                        <a href="<?=$member->link?>" target="_blank"><img src="<?=$member->thumbnail?>" border="0" width="75" height="101" class="member-thumb" /></a><br/> 
                        <?=$member->legionId?><br/><br/> 
                    </li> 
                    <?php 
                    } 
                ?> 
            </ul> 
        </div> 
    </div> 
</div> test