<?php

/*
* @package   s9e\TextFormatter
* @copyright Copyright (c) 2010-2017 The s9e Authors
* @license   http://www.opensource.org/licenses/mit-license.php The MIT License
*/
namespace s9e\TextFormatter;
abstract class Bundle
{
	public static function getCachedParser()
	{
		if (!isset(static::$parser))
			static::$parser = static::getParser();
		return static::$parser;
	}
	public static function getCachedRenderer()
	{
		if (!isset(static::$renderer))
			static::$renderer = static::getRenderer();
		return static::$renderer;
	}
	public static function parse($text)
	{
		if (isset(static::$beforeParse))
			$text = \call_user_func(static::$beforeParse, $text);
		$xml = static::getCachedParser()->parse($text);
		if (isset(static::$afterParse))
			$xml = \call_user_func(static::$afterParse, $xml);
		return $xml;
	}
	public static function render($xml, array $params = array())
	{
		$renderer = static::getCachedRenderer();
		if (!empty($params))
			$renderer->setParameters($params);
		if (isset(static::$beforeRender))
			$xml = \call_user_func(static::$beforeRender, $xml);
		$output = $renderer->render($xml);
		if (isset(static::$afterRender))
			$output = \call_user_func(static::$afterRender, $output);
		return $output;
	}
	public static function reset()
	{
		static::$parser   = \null;
		static::$renderer = \null;
	}
	public static function unparse($xml)
	{
		if (isset(static::$beforeUnparse))
			$xml = \call_user_func(static::$beforeUnparse, $xml);
		$text = Unparser::unparse($xml);
		if (isset(static::$afterUnparse))
			$text = \call_user_func(static::$afterUnparse, $text);
		return $text;
	}
}

/*
* @package   s9e\TextFormatter
* @copyright Copyright (c) 2010-2017 The s9e Authors
* @license   http://www.opensource.org/licenses/mit-license.php The MIT License
*/
namespace s9e\TextFormatter\Bundles;
abstract class MediaPack extends \s9e\TextFormatter\Bundle
{
	protected static $parser;
	protected static $renderer;
	public static function getParser()
	{
		return \unserialize('O:24:"s9e\\TextFormatter\\Parser":4:{s:16:"' . "\0" . '*' . "\0" . 'pluginsConfig";a:1:{s:10:"MediaEmbed";a:4:{s:10:"quickMatch";s:1:":";s:6:"regexp";s:39:"/\\b(?>spotify:|https?:\\/\\/)[^["\'\\s]+/Si";s:7:"tagName";s:5:"MEDIA";s:11:"regexpLimit";i:10000;}}s:14:"registeredVars";a:2:{s:9:"urlConfig";a:1:{s:14:"allowedSchemes";s:12:"/^https?$/Di";}s:10:"mediasites";a:153:{s:14:"abcnews.go.com";s:7:"abcnews";s:9:"amazon.ca";s:6:"amazon";s:12:"amazon.co.uk";s:6:"amazon";s:12:"amazon.co.jp";s:6:"amazon";s:10:"amazon.com";s:6:"amazon";s:9:"amazon.de";s:6:"amazon";s:9:"amazon.es";s:6:"amazon";s:9:"amazon.fr";s:6:"amazon";s:9:"amazon.it";s:6:"amazon";s:11:"audioboo.fm";s:9:"audioboom";s:13:"audioboom.com";s:9:"audioboom";s:13:"audiomack.com";s:9:"audiomack";s:12:"bandcamp.com";s:8:"bandcamp";s:7:"bbc.com";s:7:"bbcnews";s:7:"blab.im";s:4:"blab";s:18:"bleacherreport.com";s:14:"bleacherreport";s:9:"break.com";s:5:"break";s:8:"bcove.me";s:10:"brightcove";s:19:"link.brightcove.com";s:10:"brightcove";s:11:"cbsnews.com";s:7:"cbsnews";s:14:"video.cnbc.com";s:4:"cnbc";s:7:"cnn.com";s:3:"cnn";s:13:"money.cnn.com";s:8:"cnnmoney";s:16:"collegehumor.com";s:12:"collegehumor";s:6:"cc.com";s:13:"comedycentral";s:17:"comedycentral.com";s:13:"comedycentral";s:8:"coub.com";s:4:"coub";s:15:"dailymotion.com";s:11:"dailymotion";s:16:"democracynow.org";s:12:"democracynow";s:10:"dumpert.nl";s:7:"dumpert";s:11:"8tracks.com";s:11:"eighttracks";s:8:"espn.com";s:4:"espn";s:11:"espn.go.com";s:4:"espn";s:12:"facebook.com";s:8:"facebook";s:10:"flickr.com";s:6:"flickr";s:7:"fora.tv";s:6:"foratv";s:17:"video.foxnews.com";s:7:"foxnews";s:14:"funnyordie.com";s:10:"funnyordie";s:12:"gamespot.com";s:8:"gamespot";s:16:"gametrailers.com";s:12:"gametrailers";s:14:"gettyimages.be";s:5:"getty";s:14:"gettyimages.cn";s:5:"getty";s:17:"gettyimages.co.jp";s:5:"getty";s:17:"gettyimages.co.uk";s:5:"getty";s:15:"gettyimages.com";s:5:"getty";s:18:"gettyimages.com.au";s:5:"getty";s:14:"gettyimages.de";s:5:"getty";s:14:"gettyimages.dk";s:5:"getty";s:14:"gettyimages.es";s:5:"getty";s:14:"gettyimages.fr";s:5:"getty";s:14:"gettyimages.ie";s:5:"getty";s:14:"gettyimages.it";s:5:"getty";s:14:"gettyimages.nl";s:5:"getty";s:14:"gettyimages.pt";s:5:"getty";s:14:"gettyimages.se";s:5:"getty";s:6:"gty.im";s:5:"getty";s:10:"gfycat.com";s:6:"gfycat";s:8:"gifs.com";s:4:"gifs";s:10:"github.com";s:4:"gist";s:13:"globalnews.ca";s:10:"globalnews";s:12:"gofundme.com";s:8:"gofundme";s:16:"drive.google.com";s:11:"googledrive";s:15:"plus.google.com";s:10:"googleplus";s:15:"docs.google.com";s:12:"googlesheets";s:14:"healthguru.com";s:10:"healthguru";s:8:"hudl.com";s:4:"hudl";s:8:"hulu.com";s:4:"hulu";s:15:"humortv.vara.nl";s:9:"humortvnl";s:7:"ign.com";s:3:"ign";s:8:"imdb.com";s:4:"imdb";s:9:"imgur.com";s:5:"imgur";s:13:"indiegogo.com";s:9:"indiegogo";s:13:"instagram.com";s:9:"instagram";s:11:"archive.org";s:15:"internetarchive";s:12:"izlesene.com";s:8:"izlesene";s:14:"jwplatform.com";s:10:"jwplatform";s:12:"video.khl.ru";s:3:"khl";s:15:"kickstarter.com";s:11:"kickstarter";s:15:"kissvideo.click";s:9:"kissvideo";s:10:"libsyn.com";s:6:"libsyn";s:10:"livecap.tv";s:7:"livecap";s:12:"liveleak.com";s:8:"liveleak";s:11:"livestre.am";s:10:"livestream";s:14:"livestream.com";s:10:"livestream";s:10:"my.mail.ru";s:6:"mailru";s:10:"medium.com";s:6:"medium";s:12:"metacafe.com";s:8:"metacafe";s:12:"mixcloud.com";s:8:"mixcloud";s:7:"mlb.com";s:3:"mlb";s:9:"mrctv.org";s:5:"mrctv";s:9:"msnbc.com";s:5:"msnbc";s:30:"channel.nationalgeographic.com";s:13:"natgeochannel";s:28:"video.nationalgeographic.com";s:11:"natgeovideo";s:11:"nbcnews.com";s:7:"nbcnews";s:13:"nbcsports.com";s:9:"nbcsports";s:7:"nhl.com";s:3:"nhl";s:7:"npr.org";s:3:"npr";s:4:"n.pr";s:3:"npr";s:11:"nytimes.com";s:7:"nytimes";s:10:"oddshot.tv";s:7:"oddshot";s:12:"pastebin.com";s:8:"pastebin";s:13:"pinterest.com";s:9:"pinterest";s:8:"plays.tv";s:7:"playstv";s:11:"podbean.com";s:7:"podbean";s:9:"prezi.com";s:5:"prezi";s:10:"reddit.com";s:6:"reddit";s:9:"rutube.ru";s:6:"rutube";s:10:"scribd.com";s:6:"scribd";s:14:"slideshare.net";s:10:"slideshare";s:14:"soundcloud.com";s:10:"soundcloud";s:12:"sportsnet.ca";s:9:"sportsnet";s:16:"open.spotify.com";s:7:"spotify";s:16:"play.spotify.com";s:7:"spotify";s:8:"spotify:";s:7:"spotify";s:22:"store.steampowered.com";s:10:"steamstore";s:12:"stitcher.com";s:8:"stitcher";s:12:"strawpoll.me";s:9:"strawpoll";s:14:"streamable.com";s:10:"streamable";s:12:"teamcoco.com";s:8:"teamcoco";s:7:"ted.com";s:3:"ted";s:15:"theatlantic.com";s:11:"theatlantic";s:15:"theguardian.com";s:11:"theguardian";s:12:"theonion.com";s:8:"theonion";s:11:"tinypic.com";s:7:"tinypic";s:7:"tmz.com";s:3:"tmz";s:17:"traileraddict.com";s:13:"traileraddict";s:10:"tumblr.com";s:6:"tumblr";s:9:"twitch.tv";s:6:"twitch";s:11:"twitter.com";s:7:"twitter";s:10:"ustream.tv";s:7:"ustream";s:9:"vbox7.com";s:5:"vbox7";s:8:"veoh.com";s:4:"veoh";s:8:"vevo.com";s:4:"vevo";s:11:"viagame.com";s:7:"viagame";s:18:"videodetective.com";s:14:"videodetective";s:12:"videomega.tv";s:9:"videomega";s:6:"vid.me";s:5:"vidme";s:9:"vimeo.com";s:5:"vimeo";s:7:"vine.co";s:4:"vine";s:6:"vk.com";s:2:"vk";s:12:"vkontakte.ru";s:2:"vk";s:11:"vocaroo.com";s:7:"vocaroo";s:7:"vox.com";s:3:"vox";s:18:"washingtonpost.com";s:14:"washingtonpost";s:19:"worldstarhiphop.com";s:4:"wshh";s:7:"wsj.com";s:3:"wsj";s:13:"xboxclips.com";s:9:"xboxclips";s:11:"xboxdvr.com";s:7:"xboxdvr";s:16:"screen.yahoo.com";s:11:"yahooscreen";s:9:"youku.com";s:5:"youku";s:11:"youtube.com";s:7:"youtube";s:8:"youtu.be";s:7:"youtube";s:14:"zippyshare.com";s:10:"zippyshare";}}s:14:"' . "\0" . '*' . "\0" . 'rootContext";a:2:{s:7:"allowed";a:3:{i:0;i:65535;i:1;i:65535;i:2;i:65535;}s:5:"flags";i:0;}s:13:"' . "\0" . '*' . "\0" . 'tagsConfig";a:122:{s:7:"ABCNEWS";a:8:{s:10:"attributes";a:2:{s:2:"id";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:53:"s9e\\TextFormatter\\Parser\\BuiltInFilters::filterRegexp";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:8:"!^\\d+$!D";}}}s:8:"required";b:1;}s:3:"url";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:50:"s9e\\TextFormatter\\Parser\\BuiltInFilters::filterUrl";s:6:"params";a:3:{s:9:"attrValue";N;s:9:"urlConfig";N;s:6:"logger";N;}}}s:8:"required";b:0;}}s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:47:"!abcnews\\.go\\.com/[^/]+/video/[^/]+-(?\'id\'\\d+)!";i:2;a:2:{i:0;s:0:"";i:1;s:2:"id";}}i:1;a:3:{i:0;s:3:"url";i:1;s:15:"!^(?\'id\'\\d+)$!D";i:2;R:195;}}s:11:"filterChain";a:2:{i:0;a:2:{s:8:"callback";s:55:"s9e\\TextFormatter\\Parser::executeAttributePreprocessors";s:6:"params";a:2:{s:3:"tag";N;s:9:"tagConfig";N;}}i:1;a:2:{s:8:"callback";s:42:"s9e\\TextFormatter\\Parser::filterAttributes";s:6:"params";a:4:{s:3:"tag";N;s:9:"tagConfig";N;s:14:"registeredVars";N;s:6:"logger";N;}}}s:12:"nestingLimit";i:10;s:5:"rules";a:1:{s:5:"flags";i:3089;}s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";a:3:{i:0;i:65532;i:1;i:65535;i:2;i:65535;}}s:6:"AMAZON";a:8:{s:10:"attributes";a:3:{s:2:"id";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:53:"s9e\\TextFormatter\\Parser\\BuiltInFilters::filterRegexp";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:14:"#^[A-Z0-9]+$#D";}}}s:8:"required";b:1;}s:3:"tld";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:53:"s9e\\TextFormatter\\Parser\\BuiltInFilters::filterRegexp";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:29:"#^(?:ca|de|es|fr|it|jp|uk)$#D";}}}s:8:"required";b:0;}s:3:"url";R:182;}s:22:"attributePreprocessors";a:3:{i:0;a:3:{i:0;s:3:"url";i:1;s:37:"#/(?:dp|gp/product)/(?\'id\'[A-Z0-9]+)#";i:2;R:195;}i:1;a:3:{i:0;s:3:"url";i:1;s:47:"#amazon\\.(?:co\\.)?(?\'tld\'ca|de|es|fr|it|jp|uk)#";i:2;a:2:{i:0;s:0:"";i:1;s:3:"tld";}}i:2;a:3:{i:0;s:3:"url";i:1;s:21:"#^(?\'id\'[A-Z0-9]+)$#D";i:2;R:195;}}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:9:"AUDIOBOOM";a:8:{s:10:"attributes";R:173;s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:40:"!audioboo(?:\\.f|m\\.co)m/boos/(?\'id\'\\d+)!";i:2;R:195;}i:1;R:198;}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:2;s:7:"allowed";a:3:{i:0;i:65528;i:1;i:65535;i:2;i:65535;}}s:9:"AUDIOMACK";a:8:{s:10:"attributes";a:3:{s:2:"id";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:53:"s9e\\TextFormatter\\Parser\\BuiltInFilters::filterRegexp";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:18:"!^[-\\w]+/[-\\w]+$!D";}}}s:8:"required";b:1;}s:4:"mode";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:53:"s9e\\TextFormatter\\Parser\\BuiltInFilters::filterRegexp";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:19:"!^(?:album|song)$!D";}}}s:8:"required";b:0;}s:3:"url";R:182;}s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:57:"!audiomack\\.com/(?\'mode\'album|song)/(?\'id\'[-\\w]+/[-\\w]+)!";i:2;a:3:{i:0;s:0:"";i:1;s:4:"mode";i:2;s:2:"id";}}i:1;a:3:{i:0;s:3:"url";i:1;s:25:"!^(?\'id\'[-\\w]+/[-\\w]+)$!D";i:2;R:195;}}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:3;s:7:"allowed";a:3:{i:0;i:65524;i:1;i:65535;i:2;i:65535;}}s:8:"BANDCAMP";a:7:{s:10:"attributes";a:4:{s:8:"album_id";a:2:{s:11:"filterChain";R:175;s:8:"required";b:0;}s:8:"track_id";R:307;s:9:"track_num";R:307;s:3:"url";R:182;}s:11:"filterChain";a:3:{i:0;a:2:{s:8:"callback";s:51:"s9e\\TextFormatter\\Plugins\\MediaEmbed\\Parser::scrape";s:6:"params";a:3:{s:3:"tag";N;i:0;a:2:{i:0;a:3:{i:0;s:23:"!bandcamp\\.com/album/.!";i:1;s:25:"!/album=(?\'album_id\'\\d+)!";i:2;a:1:{i:0;s:8:"album_id";}}i:1;a:3:{i:0;s:23:"!bandcamp\\.com/track/.!";i:1;a:3:{i:0;s:29:"!"album_id":(?\'album_id\'\\d+)!";i:1;s:31:"!"track_num":(?\'track_num\'\\d+)!";i:2;s:25:"!/track=(?\'track_id\'\\d+)!";}i:2;a:3:{i:0;s:8:"album_id";i:1;s:8:"track_id";i:2;s:9:"track_num";}}}s:8:"cacheDir";N;}}i:1;R:207;i:2;a:2:{s:8:"callback";s:67:"s9e\\TextFormatter\\Plugins\\MediaEmbed\\Parser::hasNonDefaultAttribute";s:6:"params";a:1:{s:3:"tag";N;}}}s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:7:"BBCNEWS";a:8:{s:10:"attributes";a:2:{s:2:"id";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:53:"s9e\\TextFormatter\\Parser\\BuiltInFilters::filterRegexp";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:11:"!^[-\\w]+$!D";}}}s:8:"required";b:1;}s:3:"url";R:182;}s:22:"attributePreprocessors";a:1:{i:0;a:3:{i:0;s:3:"url";i:1;s:18:"!^(?\'id\'[-\\w]+)$!D";i:2;R:195;}}s:11:"filterChain";a:3:{i:0;R:202;i:1;a:2:{s:8:"callback";s:51:"s9e\\TextFormatter\\Plugins\\MediaEmbed\\Parser::scrape";s:6:"params";a:3:{s:3:"tag";N;i:0;a:1:{i:0;a:3:{i:0;s:19:"!bbc\\.com/news/\\w+!";i:1;s:41:"!bbc\\.com\\\\/news\\\\/(?\'id\'[-\\w]+)\\\\/embed!";i:2;a:1:{i:0;s:2:"id";}}}s:8:"cacheDir";N;}}i:2;R:207;}s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:4:"BLAB";a:8:{s:10:"attributes";a:2:{s:2:"id";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:53:"s9e\\TextFormatter\\Parser\\BuiltInFilters::filterRegexp";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:11:"#^[-\\w]+$#D";}}}s:8:"required";b:1;}s:3:"url";R:182;}s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:68:"#blab\\.im/(?!about$|live$|replay$|scheduled$|search\\?)(?\'id\'[-\\w]+)#";i:2;R:195;}i:1;a:3:{i:0;s:3:"url";i:1;s:18:"#^(?\'id\'[-\\w]+)$#D";i:2;R:195;}}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:14:"BLEACHERREPORT";a:8:{s:10:"attributes";R:339;s:22:"attributePreprocessors";R:348;s:11:"filterChain";a:3:{i:0;R:202;i:1;a:2:{s:8:"callback";s:51:"s9e\\TextFormatter\\Plugins\\MediaEmbed\\Parser::scrape";s:6:"params";a:3:{s:3:"tag";N;i:0;a:1:{i:0;a:3:{i:0;s:13:"!/articles/.!";i:1;s:25:"!id="video-(?\'id\'[-\\w]+)!";i:2;R:361;}}s:8:"cacheDir";N;}}i:2;R:207;}s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:5:"BREAK";a:8:{s:10:"attributes";R:173;s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:33:"!break\\.com/video/.*-(?\'id\'\\d+)$!";i:2;R:195;}i:1;R:198;}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:10:"BRIGHTCOVE";a:7:{s:10:"attributes";a:4:{s:5:"bckey";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:53:"s9e\\TextFormatter\\Parser\\BuiltInFilters::filterRegexp";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:13:"!^[-,~\\w]+$!D";}}}s:8:"required";b:0;}s:5:"bcpid";R:307;s:5:"bctid";R:307;s:3:"url";R:182;}s:11:"filterChain";a:3:{i:0;a:2:{s:8:"callback";s:51:"s9e\\TextFormatter\\Plugins\\MediaEmbed\\Parser::scrape";s:6:"params";a:3:{s:3:"tag";N;i:0;a:1:{i:0;a:3:{i:0;a:2:{i:0;s:13:"!bcove\\.me/.!";i:1;s:40:"!link\\.brightcove\\.com/services/player/!";}i:1;s:108:"!meta name="twitter:player" content=".*?bcpid(?\'bcpid\'\\d+).*?bckey=(?\'bckey\'[-,~\\w]+).*?bctid=(?\'bctid\'\\d+)!";i:2;a:3:{i:0;s:5:"bckey";i:1;s:5:"bcpid";i:2;s:5:"bctid";}}}s:8:"cacheDir";N;}}i:1;R:207;i:2;R:331;}s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:7:"CBSNEWS";a:8:{s:10:"attributes";a:3:{s:2:"id";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:53:"s9e\\TextFormatter\\Parser\\BuiltInFilters::filterRegexp";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:8:"#^\\d+$#D";}}}s:8:"required";b:0;}s:3:"pid";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:53:"s9e\\TextFormatter\\Parser\\BuiltInFilters::filterRegexp";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:8:"#^\\w+$#D";}}}s:8:"required";b:0;}s:3:"url";R:182;}s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:42:"#cbsnews\\.com/video/watch/\\?id=(?\'id\'\\d+)#";i:2;R:195;}i:1;a:3:{i:0;s:3:"url";i:1;s:15:"#^(?\'id\'\\d+)$#D";i:2;R:195;}}s:11:"filterChain";a:4:{i:0;R:202;i:1;a:2:{s:8:"callback";s:51:"s9e\\TextFormatter\\Plugins\\MediaEmbed\\Parser::scrape";s:6:"params";a:3:{s:3:"tag";N;i:0;a:1:{i:0;a:3:{i:0;s:32:"#cbsnews\\.com/videos/(?!watch/)#";i:1;s:21:"#"pid":"(?\'pid\'\\w+)"#";i:2;a:1:{i:0;s:3:"pid";}}}s:8:"cacheDir";N;}}i:2;R:207;i:3;R:331;}s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:4:"CNBC";a:8:{s:10:"attributes";R:173;s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:38:"!cnbc\\.com/gallery/\\?video=(?\'id\'\\d+)!";i:2;R:195;}i:1;R:198;}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:3:"CNN";a:8:{s:10:"attributes";a:2:{s:2:"id";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:53:"s9e\\TextFormatter\\Parser\\BuiltInFilters::filterRegexp";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:12:"!^.*\\.cnn$!D";}}}s:8:"required";b:1;}s:3:"url";R:182;}s:22:"attributePreprocessors";a:3:{i:0;a:3:{i:0;s:3:"url";i:1;s:31:"!cnn.com/videos/(?\'id\'.*\\.cnn)!";i:2;R:195;}i:1;a:3:{i:0;s:3:"url";i:1;s:47:"!cnn\\.com/video/data/2\\.0/video/(?\'id\'.*\\.cnn)!";i:2;R:195;}i:2;a:3:{i:0;s:3:"url";i:1;s:19:"!^(?\'id\'.*\\.cnn)$!D";i:2;R:195;}}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:8:"CNNMONEY";a:8:{s:10:"attributes";a:2:{s:2:"id";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:53:"s9e\\TextFormatter\\Parser\\BuiltInFilters::filterRegexp";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:17:"!^.*\\.cnnmoney$!D";}}}s:8:"required";b:1;}s:3:"url";R:182;}s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:43:"!money\\.cnn\\.com/video/(?\'id\'.*\\.cnnmoney)!";i:2;R:195;}i:1;a:3:{i:0;s:3:"url";i:1;s:24:"!^(?\'id\'.*\\.cnnmoney)$!D";i:2;R:195;}}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:12:"COLLEGEHUMOR";a:8:{s:10:"attributes";R:173;s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:46:"!collegehumor\\.com/(?:video|embed)/(?\'id\'\\d+)!";i:2;R:195;}i:1;R:198;}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:13:"COMEDYCENTRAL";a:8:{s:10:"attributes";a:2:{s:2:"id";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:53:"s9e\\TextFormatter\\Parser\\BuiltInFilters::filterRegexp";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:49:"!^(?:mgid:arc:(?:episode|video):[.\\w]+:[-\\w]+)$!D";}}}s:8:"required";b:1;}s:3:"url";R:182;}s:22:"attributePreprocessors";a:1:{i:0;a:3:{i:0;s:3:"url";i:1;s:56:"!^(?\'id\'(?:mgid:arc:(?:episode|video):[.\\w]+:[-\\w]+))$!D";i:2;R:195;}}s:11:"filterChain";a:3:{i:0;R:202;i:1;a:2:{s:8:"callback";s:51:"s9e\\TextFormatter\\Plugins\\MediaEmbed\\Parser::scrape";s:6:"params";a:3:{s:3:"tag";N;i:0;a:1:{i:0;a:3:{i:0;s:56:"!c(?:c|omedycentral)\\.com/(?:full-episode|video-clip)s/!";i:1;s:49:"!(?\'id\'mgid:arc:(?:episode|video):[.\\w]+:[-\\w]+)!";i:2;R:361;}}s:8:"cacheDir";N;}}i:2;R:207;}s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:4:"COUB";a:8:{s:10:"attributes";a:2:{s:2:"id";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:53:"s9e\\TextFormatter\\Parser\\BuiltInFilters::filterRegexp";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:8:"!^\\w+$!D";}}}s:8:"required";b:1;}s:3:"url";R:182;}s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:27:"!coub\\.com/view/(?\'id\'\\w+)!";i:2;R:195;}i:1;a:3:{i:0;s:3:"url";i:1;s:15:"!^(?\'id\'\\w+)$!D";i:2;R:195;}}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:11:"DAILYMOTION";a:8:{s:10:"attributes";a:2:{s:2:"id";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:53:"s9e\\TextFormatter\\Parser\\BuiltInFilters::filterRegexp";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:17:"!^[A-Za-z0-9]+$!D";}}}s:8:"required";b:1;}s:3:"url";R:182;}s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:94:"!dailymotion\\.com/(?:live/|swf/|user/[^#]+#video=|(?:related/\\d+/)?video/)(?\'id\'[A-Za-z0-9]+)!";i:2;R:195;}i:1;a:3:{i:0;s:3:"url";i:1;s:24:"!^(?\'id\'[A-Za-z0-9]+)$!D";i:2;R:195;}}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:12:"DEMOCRACYNOW";a:8:{s:10:"attributes";a:2:{s:2:"id";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:53:"s9e\\TextFormatter\\Parser\\BuiltInFilters::filterRegexp";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:34:"!^(?:\\w+/)?\\d+/\\d+/\\d+(?:/\\w+)?$!D";}}}s:8:"required";b:1;}s:3:"url";R:182;}s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:66:"!democracynow.org/(?:embed/)?(?\'id\'(?:\\w+/)?\\d+/\\d+/\\d+(?:/\\w+)?)!";i:2;R:195;}i:1;a:3:{i:0;s:3:"url";i:1;s:41:"!^(?\'id\'(?:\\w+/)?\\d+/\\d+/\\d+(?:/\\w+)?)$!D";i:2;R:195;}}s:11:"filterChain";a:3:{i:0;R:202;i:1;a:2:{s:8:"callback";s:51:"s9e\\TextFormatter\\Plugins\\MediaEmbed\\Parser::scrape";s:6:"params";a:3:{s:3:"tag";N;i:0;a:1:{i:0;a:3:{i:0;s:33:"!m\\.democracynow\\.org/stories/\\d!";i:1;s:72:"!democracynow\\.org/(?\'id\'(?:\\w+/)?\\d+/\\d+/\\d+(?:/\\w+)?)\' rel=\'canonical!";i:2;R:361;}}s:8:"cacheDir";N;}}i:2;R:207;}s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:7:"DUMPERT";a:8:{s:10:"attributes";a:2:{s:2:"id";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:53:"s9e\\TextFormatter\\Parser\\BuiltInFilters::filterRegexp";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:15:"!^\\d+[/_]\\w+$!D";}}}s:8:"required";b:1;}s:3:"url";R:182;}s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:41:"!dumpert\\.nl/mediabase/(?\'id\'\\d+[/_]\\w+)!";i:2;R:195;}i:1;a:3:{i:0;s:3:"url";i:1;s:22:"!^(?\'id\'\\d+[/_]\\w+)$!D";i:2;R:195;}}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:11:"EIGHTTRACKS";a:8:{s:10:"attributes";R:173;s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:39:"!8tracks\\.com/[-\\w]+/(?\'id\'\\d+)(?=#|$)!";i:2;R:195;}i:1;R:198;}s:11:"filterChain";a:3:{i:0;R:202;i:1;a:2:{s:8:"callback";s:51:"s9e\\TextFormatter\\Plugins\\MediaEmbed\\Parser::scrape";s:6:"params";a:3:{s:3:"tag";N;i:0;a:1:{i:0;a:3:{i:0;s:28:"!8tracks\\.com/[-\\w]+/[-\\w]+!";i:1;s:30:"!eighttracks://mix/(?\'id\'\\d+)!";i:2;R:361;}}s:8:"cacheDir";N;}}i:2;R:207;}s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:4:"ESPN";a:8:{s:10:"attributes";a:2:{s:2:"id";a:2:{s:11:"filterChain";R:441;s:8:"required";b:1;}s:3:"url";R:182;}s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:43:"#video/(?:clip(?:\\?id=|/_/id/))?(?\'id\'\\d+)#";i:2;R:195;}i:1;R:460;}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:8:"FACEBOOK";a:8:{s:10:"attributes";a:3:{s:2:"id";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:53:"s9e\\TextFormatter\\Parser\\BuiltInFilters::filterRegexp";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:8:"@^\\d+$@D";}}}s:8:"required";b:1;}s:4:"type";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:53:"s9e\\TextFormatter\\Parser\\BuiltInFilters::filterRegexp";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:10:"#^video$#D";}}}s:8:"required";b:0;}s:3:"url";R:182;}s:22:"attributePreprocessors";a:3:{i:0;a:3:{i:0;s:3:"url";i:1;s:135:"@/(?!(?:apps|developers|graph)\\.)[-\\w.]*facebook\\.com/(?:[/\\w]+/permalink|(?!pages/|groups/).*?)(?:/|fbid=|\\?v=)(?\'id\'\\d+)(?=$|[/?&#])@";i:2;R:195;}i:1;a:3:{i:0;s:3:"url";i:1;s:20:"#/(?\'type\'video)s?/#";i:2;a:2:{i:0;s:0:"";i:1;s:4:"type";}}i:2;a:3:{i:0;s:3:"url";i:1;s:15:"@^(?\'id\'\\d+)$@D";i:2;R:195;}}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:4;s:7:"allowed";a:3:{i:0;i:65516;i:1;i:65535;i:2;i:65535;}}s:6:"FLICKR";a:8:{s:10:"attributes";R:173;s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:37:"!flickr\\.com/photos/[^/]+/(?\'id\'\\d+)!";i:2;R:195;}i:1;R:198;}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:6:"FORATV";a:8:{s:10:"attributes";R:173;s:22:"attributePreprocessors";a:1:{i:0;R:198;}s:11:"filterChain";a:3:{i:0;R:202;i:1;a:2:{s:8:"callback";s:51:"s9e\\TextFormatter\\Plugins\\MediaEmbed\\Parser::scrape";s:6:"params";a:3:{s:3:"tag";N;i:0;a:1:{i:0;a:3:{i:0;s:24:"!fora\\.tv/\\d+/\\d+/\\d+/.!";i:1;s:22:"!embed\\?id=(?\'id\'\\d+)!";i:2;R:361;}}s:8:"cacheDir";N;}}i:2;R:207;}s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:7:"FOXNEWS";a:8:{s:10:"attributes";R:173;s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:34:"!video\\.foxnews\\.com/v/(?\'id\'\\d+)!";i:2;R:195;}i:1;R:198;}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:10:"FUNNYORDIE";a:8:{s:10:"attributes";a:2:{s:2:"id";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:53:"s9e\\TextFormatter\\Parser\\BuiltInFilters::filterRegexp";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:14:"!^[0-9a-f]+$!D";}}}s:8:"required";b:1;}s:3:"url";R:182;}s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:41:"!funnyordie\\.com/videos/(?\'id\'[0-9a-f]+)!";i:2;R:195;}i:1;a:3:{i:0;s:3:"url";i:1;s:21:"!^(?\'id\'[0-9a-f]+)$!D";i:2;R:195;}}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:8:"GAMESPOT";a:8:{s:10:"attributes";R:173;s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:64:"!gamespot\\.com.*?/(?:events|videos)/.*?-(?\'id\'\\d+)/(?:[#?].*)?$!";i:2;R:195;}i:1;R:198;}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:12:"GAMETRAILERS";a:8:{s:10:"attributes";R:173;s:22:"attributePreprocessors";R:730;s:11:"filterChain";a:3:{i:0;R:202;i:1;a:2:{s:8:"callback";s:51:"s9e\\TextFormatter\\Plugins\\MediaEmbed\\Parser::scrape";s:6:"params";a:3:{s:3:"tag";N;i:0;a:1:{i:0;a:3:{i:0;s:51:"!gametrailers\\.com/(?:full-episode|review|video)s/!";i:1;s:18:"!embed/(?\'id\'\\d+)!";i:2;R:361;}}s:8:"cacheDir";N;}}i:2;R:207;}s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:5:"GETTY";a:8:{s:10:"attributes";a:6:{s:2:"et";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:53:"s9e\\TextFormatter\\Parser\\BuiltInFilters::filterRegexp";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:12:"!^[-=\\w]+$!D";}}}s:8:"required";b:0;}s:6:"height";a:3:{s:12:"defaultValue";s:3:"360";s:11:"filterChain";R:175;s:8:"required";b:0;}s:2:"id";R:174;s:3:"sig";R:796;s:3:"url";R:182;s:5:"width";a:3:{s:12:"defaultValue";s:3:"640";s:11:"filterChain";R:175;s:8:"required";b:0;}}s:22:"attributePreprocessors";a:4:{i:0;a:3:{i:0;s:3:"url";i:1;s:20:"!gty\\.im/(?\'id\'\\d+)!";i:2;R:195;}i:1;a:3:{i:0;s:3:"url";i:1;s:47:"!gettyimages\\.[.\\w]+/detail(?=/).*?/(?\'id\'\\d+)!";i:2;R:195;}i:2;a:3:{i:0;s:3:"url";i:1;s:30:"!#[-\\w]*picture-id(?\'id\'\\d+)$!";i:2;R:195;}i:3;R:198;}s:11:"filterChain";a:3:{i:0;R:202;i:1;a:2:{s:8:"callback";s:51:"s9e\\TextFormatter\\Plugins\\MediaEmbed\\Parser::scrape";s:6:"params";a:3:{s:3:"tag";N;i:0;a:1:{i:0;a:4:{i:0;s:2:"//";i:1;a:4:{i:0;s:30:"!"height":[ "]*(?\'height\'\\d+)!";i:1;s:28:"!"width":[ "]*(?\'width\'\\d+)!";i:2;s:19:"!et=(?\'et\'[-=\\w]+)!";i:3;s:21:"!sig=(?\'sig\'[-=\\w]+)!";}i:2;a:4:{i:0;s:2:"et";i:1;s:6:"height";i:2;s:3:"sig";i:3;s:5:"width";}i:3;s:42:"http://embed.gettyimages.com/preview/{@id}";}}s:8:"cacheDir";N;}}i:2;R:207;}s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:6:"GFYCAT";a:8:{s:10:"attributes";a:4:{s:6:"height";a:3:{s:12:"defaultValue";s:3:"315";s:11:"filterChain";R:175;s:8:"required";b:0;}s:2:"id";R:566;s:3:"url";R:182;s:5:"width";a:3:{s:12:"defaultValue";s:3:"560";s:11:"filterChain";R:175;s:8:"required";b:0;}}s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:24:"!gfycat\\.com/(?\'id\'\\w+)!";i:2;R:195;}i:1;R:578;}s:11:"filterChain";a:3:{i:0;R:202;i:1;a:2:{s:8:"callback";s:51:"s9e\\TextFormatter\\Plugins\\MediaEmbed\\Parser::scrape";s:6:"params";a:3:{s:3:"tag";N;i:0;a:1:{i:0;a:4:{i:0;s:2:"//";i:1;a:2:{i:0;s:39:"!video:height" content="(?\'height\'\\d+)!";i:1;s:37:"!video:width" content="(?\'width\'\\d+)!";}i:2;a:2:{i:0;s:6:"height";i:1;s:5:"width";}i:3;s:23:"http://gfycat.com/{@id}";}}s:8:"cacheDir";N;}}i:2;R:207;}s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:4:"GIFS";a:8:{s:10:"attributes";a:4:{s:6:"height";R:804;s:2:"id";R:566;s:3:"url";R:182;s:5:"width";R:807;}s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:31:"!gifs\\.com/(?:gif/)?(?\'id\'\\w+)!";i:2;R:195;}i:1;R:578;}s:11:"filterChain";a:3:{i:0;R:202;i:1;a:2:{s:8:"callback";s:51:"s9e\\TextFormatter\\Plugins\\MediaEmbed\\Parser::scrape";s:6:"params";a:3:{s:3:"tag";N;i:0;a:1:{i:0;a:4:{i:0;s:2:"//";i:1;a:2:{i:0;s:55:"!meta property="og:image:width" content="(?\'width\'\\d+)!";i:1;s:57:"!meta property="og:image:height" content="(?\'height\'\\d+)!";}i:2;R:866;i:3;s:26:"https://gifs.com/gif/{@id}";}}s:8:"cacheDir";N;}}i:2;R:207;}s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:4:"GIST";a:8:{s:10:"attributes";a:2:{s:2:"id";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:53:"s9e\\TextFormatter\\Parser\\BuiltInFilters::filterRegexp";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:36:"!^(?:\\w+/)?[\\da-f]+(?:/[\\da-f]+)?$!D";}}}s:8:"required";b:1;}s:3:"url";R:182;}s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:58:"!gist\\.github\\.com/(?\'id\'(?:\\w+/)?[\\da-f]+(?:/[\\da-f]+)?)!";i:2;R:195;}i:1;a:3:{i:0;s:3:"url";i:1;s:43:"!^(?\'id\'(?:\\w+/)?[\\da-f]+(?:/[\\da-f]+)?)$!D";i:2;R:195;}}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:5;s:7:"allowed";a:3:{i:0;i:65500;i:1;i:65535;i:2;i:65535;}}s:10:"GLOBALNEWS";a:8:{s:10:"attributes";R:173;s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:33:"!globalnews\\.ca/video/(?\'id\'\\d+)!";i:2;R:195;}i:1;R:198;}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:8:"GOFUNDME";a:8:{s:10:"attributes";a:2:{s:2:"id";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:53:"s9e\\TextFormatter\\Parser\\BuiltInFilters::filterRegexp";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:8:"@^\\w+$@D";}}}s:8:"required";b:1;}s:3:"url";R:182;}s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:35:"@gofundme\\.com/(?\'id\'\\w+)(?![^#?])@";i:2;R:195;}i:1;a:3:{i:0;s:3:"url";i:1;s:15:"@^(?\'id\'\\w+)$@D";i:2;R:195;}}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:11:"GOOGLEDRIVE";a:8:{s:10:"attributes";R:339;s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:44:"!drive\\.google\\.com/.*?file/d/(?\'id\'[-\\w]+)!";i:2;R:195;}i:1;R:349;}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:10:"GOOGLEPLUS";a:8:{s:10:"attributes";a:4:{s:4:"name";a:2:{s:11:"filterChain";a:2:{i:0;a:2:{s:8:"callback";s:53:"s9e\\TextFormatter\\Parser\\BuiltInFilters::filterRegexp";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:10:"!^[^/]+$!D";}}i:1;a:2:{s:8:"callback";s:9:"urldecode";s:6:"params";a:1:{s:9:"attrValue";N;}}}s:8:"required";b:0;}s:3:"oid";R:307;s:3:"pid";a:2:{s:11:"filterChain";R:567;s:8:"required";b:0;}s:3:"url";R:182;}s:22:"attributePreprocessors";a:1:{i:0;a:3:{i:0;s:3:"url";i:1;s:83:"!//plus\\.google\\.com/(?:u/\\d+/)?(?:\\+(?\'name\'[^/]+)|(?\'oid\'\\d+))/posts/(?\'pid\'\\w+)!";i:2;a:4:{i:0;s:0:"";i:1;s:4:"name";i:2;s:3:"oid";i:3;s:3:"pid";}}}s:11:"filterChain";a:3:{i:0;R:202;i:1;R:207;i:2;R:331;}s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:6;s:7:"allowed";a:3:{i:0;i:65468;i:1;i:65535;i:2;i:65535;}}s:12:"GOOGLESHEETS";a:8:{s:10:"attributes";a:3:{s:3:"gid";R:307;s:2:"id";R:340;s:3:"url";R:182;}s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:89:"!docs\\.google\\.com/spreadsheet(?:/ccc\\?key=|s/d/)(?\'id\'[-\\w]+)[^#]*(?:#gid=(?\'gid\'\\d+))?!";i:2;a:3:{i:0;s:0:"";i:1;s:2:"id";i:2;s:3:"gid";}}i:1;R:349;}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:7;s:7:"allowed";a:3:{i:0;i:65404;i:1;i:65535;i:2;i:65535;}}s:10:"HEALTHGURU";a:8:{s:10:"attributes";R:565;s:22:"attributePreprocessors";a:1:{i:0;R:578;}s:11:"filterChain";a:3:{i:0;R:202;i:1;a:2:{s:8:"callback";s:51:"s9e\\TextFormatter\\Plugins\\MediaEmbed\\Parser::scrape";s:6:"params";a:3:{s:3:"tag";N;i:0;a:1:{i:0;a:3:{i:0;s:38:"!healthguru\\.com/(?:content/)?video/.!";i:1;s:34:"!healthguru\\.com/embed/(?\'id\'\\w+)!";i:2;R:361;}}s:8:"cacheDir";N;}}i:2;R:207;}s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:4:"HUDL";a:8:{s:10:"attributes";a:3:{s:7:"athlete";R:307;s:9:"highlight";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:53:"s9e\\TextFormatter\\Parser\\BuiltInFilters::filterRegexp";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:13:"!^[\\da-f]+$!D";}}}s:8:"required";b:0;}s:3:"url";R:182;}s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:69:"!hudl\\.com/athlete/(?\'athlete\'\\d+)/highlights/(?\'highlight\'[\\da-f]+)!";i:2;a:3:{i:0;s:0:"";i:1;s:7:"athlete";i:2;s:9:"highlight";}}i:1;a:3:{i:0;s:3:"url";i:1;s:60:"!hudl\\.com/video/\\d+/(?\'athlete\'\\d+)/(?\'highlight\'[\\da-f]+)!";i:2;R:1035;}}s:11:"filterChain";a:4:{i:0;R:202;i:1;a:2:{s:8:"callback";s:51:"s9e\\TextFormatter\\Plugins\\MediaEmbed\\Parser::scrape";s:6:"params";a:3:{s:3:"tag";N;i:0;a:1:{i:0;a:3:{i:0;s:14:"!hudl\\.com/v/!";i:1;s:60:"!hudl\\.com/video/\\d+/(?\'athlete\'\\d+)/(?\'highlight\'[\\da-f]+)!";i:2;a:2:{i:0;s:7:"athlete";i:1;s:9:"highlight";}}}s:8:"cacheDir";N;}}i:2;R:207;i:3;R:331;}s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:4:"HULU";a:8:{s:10:"attributes";R:339;s:22:"attributePreprocessors";R:348;s:11:"filterChain";a:3:{i:0;R:202;i:1;a:2:{s:8:"callback";s:51:"s9e\\TextFormatter\\Plugins\\MediaEmbed\\Parser::scrape";s:6:"params";a:3:{s:3:"tag";N;i:0;a:1:{i:0;a:3:{i:0;s:18:"!hulu\\.com/watch/!";i:1;s:19:"!eid=(?\'id\'[-\\w]+)!";i:2;R:361;}}s:8:"cacheDir";N;}}i:2;R:207;}s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:9:"HUMORTVNL";a:8:{s:10:"attributes";a:2:{s:2:"id";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:53:"s9e\\TextFormatter\\Parser\\BuiltInFilters::filterRegexp";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:12:"!^[-.\\w]+$!D";}}}s:8:"required";b:1;}s:3:"url";R:182;}s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:45:"!humortv\\.vara\\.nl/\\w+\\.(?\'id\'[-.\\w]+)\\.html!";i:2;R:195;}i:1;a:3:{i:0;s:3:"url";i:1;s:19:"!^(?\'id\'[-.\\w]+)$!D";i:2;R:195;}}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:3:"IGN";a:8:{s:10:"attributes";a:2:{s:2:"id";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:53:"s9e\\TextFormatter\\Parser\\BuiltInFilters::filterRegexp";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:35:"!^https?://.*?ign\\.com/videos/.+$!D";}}}s:8:"required";b:1;}s:3:"url";R:182;}s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:39:"!(?\'id\'https?://.*?ign\\.com/videos/.+)!";i:2;R:195;}i:1;a:3:{i:0;s:3:"url";i:1;s:42:"!^(?\'id\'https?://.*?ign\\.com/videos/.+)$!D";i:2;R:195;}}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:4:"IMDB";a:8:{s:10:"attributes";R:173;s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:31:"!imdb\\.com/[/\\w]+/vi(?\'id\'\\d+)!";i:2;R:195;}i:1;R:198;}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:5:"IMGUR";a:8:{s:10:"attributes";a:3:{s:2:"id";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:53:"s9e\\TextFormatter\\Parser\\BuiltInFilters::filterRegexp";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:15:"@^(?:a/)?\\w+$@D";}}}s:8:"required";b:1;}s:4:"type";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:52:"s9e\\TextFormatter\\Parser\\BuiltInFilters::filterAlnum";s:6:"params";R:967;}}s:8:"required";b:0;}s:3:"url";R:182;}s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:74:"@imgur\\.com/(?!r/|user/)(?:gallery/)?(?\'id\'(?:a/)?\\w+)(?!\\w|\\.(?:pn|jp)g)@";i:2;R:195;}i:1;a:3:{i:0;s:3:"url";i:1;s:22:"@^(?\'id\'(?:a/)?\\w+)$@D";i:2;R:195;}}s:11:"filterChain";a:3:{i:0;R:202;i:1;a:2:{s:8:"callback";s:51:"s9e\\TextFormatter\\Plugins\\MediaEmbed\\Parser::scrape";s:6:"params";a:3:{s:3:"tag";N;i:0;a:1:{i:0;a:3:{i:0;s:23:"@imgur\\.com/gallery/\\w@";i:1;a:3:{i:0;s:41:"!image\\s*:\\s*.*?"is_(?\'type\'album)":true!";i:1;s:26:"!<div id="(?\'type\'album)-!";i:2;s:29:"!class="(?\'type\'album)-image!";}i:2;a:1:{i:0;s:4:"type";}}}s:8:"cacheDir";N;}}i:2;R:207;}s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:8;s:7:"allowed";a:3:{i:0;i:65532;i:1;i:65534;i:2;i:65535;}}s:9:"INDIEGOGO";a:8:{s:10:"attributes";R:339;s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:39:"!indiegogo\\.com/projects/(?\'id\'[-\\w]+)!";i:2;R:195;}i:1;R:349;}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:9:"INSTAGRAM";a:8:{s:10:"attributes";R:339;s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:32:"!instagram\\.com/p/(?\'id\'[-\\w]+)!";i:2;R:195;}i:1;R:349;}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:9;s:7:"allowed";a:3:{i:0;i:65532;i:1;i:65533;i:2;i:65535;}}s:15:"INTERNETARCHIVE";a:8:{s:10:"attributes";a:4:{s:6:"height";R:804;s:2:"id";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:53:"s9e\\TextFormatter\\Parser\\BuiltInFilters::filterRegexp";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:11:"!^[^/"]+$!D";}}}s:8:"required";b:1;}s:3:"url";R:182;s:5:"width";R:807;}s:22:"attributePreprocessors";a:1:{i:0;a:3:{i:0;s:3:"url";i:1;s:18:"!^(?\'id\'[^/"]+)$!D";i:2;R:195;}}s:11:"filterChain";a:3:{i:0;R:202;i:1;a:2:{s:8:"callback";s:51:"s9e\\TextFormatter\\Plugins\\MediaEmbed\\Parser::scrape";s:6:"params";a:3:{s:3:"tag";N;i:0;a:1:{i:0;a:3:{i:0;s:23:"!archive\\.org/details/!";i:1;a:3:{i:0;s:81:"!meta property="twitter:player" content="https://archive.org/embed/(?\'id\'[^/"]+)!";i:1;s:55:"!meta property="og:video:width" content="(?\'width\'\\d+)!";i:2;s:57:"!meta property="og:video:height" content="(?\'height\'\\d+)!";}i:2;a:3:{i:0;s:6:"height";i:1;s:2:"id";i:2;s:5:"width";}}}s:8:"cacheDir";N;}}i:2;R:207;}s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:8:"IZLESENE";a:8:{s:10:"attributes";R:173;s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:39:"!izlesene\\.com/video/[-\\w]+/(?\'id\'\\d+)!";i:2;R:195;}i:1;R:198;}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:10:"JWPLATFORM";a:8:{s:10:"attributes";R:339;s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:35:"!jwplatform\\.com/\\w+/(?\'id\'[-\\w]+)!";i:2;R:195;}i:1;R:349;}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:3:"KHL";a:8:{s:10:"attributes";a:2:{s:2:"id";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:53:"s9e\\TextFormatter\\Parser\\BuiltInFilters::filterRegexp";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:11:"!^[/\\w]+$!D";}}}s:8:"required";b:1;}s:3:"url";R:182;}s:22:"attributePreprocessors";a:1:{i:0;a:3:{i:0;s:3:"url";i:1;s:18:"!^(?\'id\'[/\\w]+)$!D";i:2;R:195;}}s:11:"filterChain";a:3:{i:0;R:202;i:1;a:2:{s:8:"callback";s:51:"s9e\\TextFormatter\\Plugins\\MediaEmbed\\Parser::scrape";s:6:"params";a:3:{s:3:"tag";N;i:0;a:1:{i:0;a:3:{i:0;s:36:"!video\\.khl\\.ru/(?:event|quote)s/\\d!";i:1;s:27:"!/feed/start/(?\'id\'[/\\w]+)!";i:2;R:361;}}s:8:"cacheDir";N;}}i:2;R:207;}s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:11:"KICKSTARTER";a:8:{s:10:"attributes";a:4:{s:4:"card";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:53:"s9e\\TextFormatter\\Parser\\BuiltInFilters::filterRegexp";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:9:"!^card$!D";}}}s:8:"required";b:0;}s:2:"id";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:53:"s9e\\TextFormatter\\Parser\\BuiltInFilters::filterRegexp";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:17:"!^[^/]+/[^/?]+$!D";}}}s:8:"required";b:1;}s:3:"url";R:182;s:5:"video";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:53:"s9e\\TextFormatter\\Parser\\BuiltInFilters::filterRegexp";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:10:"!^video$!D";}}}s:8:"required";b:0;}}s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:93:"!kickstarter\\.com/projects/(?\'id\'[^/]+/[^/?]+)(?:/widget/(?:(?\'card\'card)|(?\'video\'video)))?!";i:2;a:4:{i:0;s:0:"";i:1;s:2:"id";i:2;s:4:"card";i:3;s:5:"video";}}i:1;a:3:{i:0;s:3:"url";i:1;s:24:"!^(?\'id\'[^/]+/[^/?]+)$!D";i:2;R:195;}}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:9:"KISSVIDEO";a:8:{s:10:"attributes";R:753;s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:41:"!kissvideo\\.click/[^_]*_(?\'id\'[0-9a-f]+)!";i:2;R:195;}i:1;R:766;}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:6:"LIBSYN";a:8:{s:10:"attributes";R:173;s:22:"attributePreprocessors";R:730;s:11:"filterChain";a:3:{i:0;R:202;i:1;a:2:{s:8:"callback";s:51:"s9e\\TextFormatter\\Plugins\\MediaEmbed\\Parser::scrape";s:6:"params";a:3:{s:3:"tag";N;i:0;a:1:{i:0;a:3:{i:0;s:16:"@(?!\\.mp3)....$@";i:1;s:29:"!embed/episode/id/(?\'id\'\\d+)!";i:2;R:361;}}s:8:"cacheDir";N;}}i:2;R:207;}s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:10;s:7:"allowed";a:3:{i:0;i:65532;i:1;i:65531;i:2;i:65535;}}s:7:"LIVECAP";a:8:{s:10:"attributes";a:3:{s:7:"channel";R:970;s:2:"id";R:566;s:3:"url";R:182;}s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:44:"!livecap.tv/[st]/(?\'channel\'\\w+)/(?\'id\'\\w+)!";i:2;a:3:{i:0;s:0:"";i:1;s:7:"channel";i:2;s:2:"id";}}i:1;R:578;}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:8:"LIVELEAK";a:8:{s:10:"attributes";a:2:{s:2:"id";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:53:"s9e\\TextFormatter\\Parser\\BuiltInFilters::filterRegexp";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:15:"!^[a-f_0-9]+$!D";}}}s:8:"required";b:1;}s:3:"url";R:182;}s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:41:"!liveleak\\.com/view\\?i=(?\'id\'[a-f_0-9]+)!";i:2;R:195;}i:1;a:3:{i:0;s:3:"url";i:1;s:22:"!^(?\'id\'[a-f_0-9]+)$!D";i:2;R:195;}}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:10:"LIVESTREAM";a:8:{s:10:"attributes";a:6:{s:10:"account_id";R:307;s:7:"channel";R:970;s:7:"clip_id";a:2:{s:11:"filterChain";R:341;s:8:"required";b:0;}s:8:"event_id";R:307;s:3:"url";R:182;s:8:"video_id";R:307;}s:22:"attributePreprocessors";a:3:{i:0;a:3:{i:0;s:3:"url";i:1;s:69:"!livestream\\.com/accounts/(?\'account_id\'\\d+)/events/(?\'event_id\'\\d+)!";i:2;a:3:{i:0;s:0:"";i:1;s:10:"account_id";i:2;s:8:"event_id";}}i:1;a:3:{i:0;s:3:"url";i:1;s:26:"!/videos/(?\'video_id\'\\d+)!";i:2;a:2:{i:0;s:0:"";i:1;s:8:"video_id";}}i:2;a:3:{i:0;s:3:"url";i:1;s:76:"!original\\.livestream\\.com/(?\'channel\'\\w+)/video\\?clipId=(?\'clip_id\'[-\\w]+)!";i:2;a:3:{i:0;s:0:"";i:1;s:7:"channel";i:2;s:7:"clip_id";}}}s:11:"filterChain";a:4:{i:0;R:202;i:1;a:2:{s:8:"callback";s:51:"s9e\\TextFormatter\\Plugins\\MediaEmbed\\Parser::scrape";s:6:"params";a:3:{s:3:"tag";N;i:0;a:2:{i:0;a:3:{i:0;s:2:"//";i:1;s:53:"!accounts/(?\'account_id\'\\d+)/events/(?\'event_id\'\\d+)!";i:2;a:2:{i:0;s:10:"account_id";i:1;s:8:"event_id";}}i:1;a:3:{i:0;s:13:"!livestre.am!";i:1;s:70:"!//original\\.livestream\\.com/(?\'channel\'\\w+)/video/(?\'clip_id\'[-\\w]+)!";i:2;a:2:{i:0;s:7:"channel";i:1;s:7:"clip_id";}}}s:8:"cacheDir";N;}}i:2;R:207;i:3;R:331;}s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:6:"MAILRU";a:8:{s:10:"attributes";R:1235;s:22:"attributePreprocessors";R:1244;s:11:"filterChain";a:3:{i:0;R:202;i:1;a:2:{s:8:"callback";s:51:"s9e\\TextFormatter\\Plugins\\MediaEmbed\\Parser::scrape";s:6:"params";a:3:{s:3:"tag";N;i:0;a:1:{i:0;a:3:{i:0;s:35:"!my\\.mail\\.ru/\\w+/\\w+/video/\\w+/\\d!";i:1;s:36:"!mail\\.ru/video/(?\'id\'[/\\w]+)\\.html!";i:2;R:361;}}s:8:"cacheDir";N;}}i:2;R:207;}s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:5:"MEDIA";a:6:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:54:"s9e\\TextFormatter\\Plugins\\MediaEmbed\\Parser::filterTag";s:6:"params";a:3:{s:3:"tag";N;s:6:"parser";N;s:10:"mediasites";N;}}}s:12:"nestingLimit";i:10;s:5:"rules";a:1:{s:5:"flags";i:513;}s:8:"tagLimit";i:1000;s:9:"bitNumber";i:0;s:7:"allowed";a:3:{i:0;i:65534;i:1;i:65535;i:2;i:65535;}}s:6:"MEDIUM";a:8:{s:10:"attributes";a:2:{s:2:"id";a:2:{s:11:"filterChain";R:1024;s:8:"required";b:1;}s:3:"url";R:182;}s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:47:"!medium\\.com/[^/]*/(?:[-\\w]+-)?(?\'id\'[\\da-f]+)!";i:2;R:195;}i:1;a:3:{i:0;s:3:"url";i:1;s:20:"!^(?\'id\'[\\da-f]+)$!D";i:2;R:195;}}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:11;s:7:"allowed";a:3:{i:0;i:65532;i:1;i:65527;i:2;i:65535;}}s:8:"METACAFE";a:8:{s:10:"attributes";R:173;s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:32:"!metacafe\\.com/watch/(?\'id\'\\d+)!";i:2;R:195;}i:1;R:198;}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:8:"MIXCLOUD";a:8:{s:10:"attributes";a:2:{s:2:"id";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:53:"s9e\\TextFormatter\\Parser\\BuiltInFilters::filterRegexp";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:18:"@^[-\\w]+/[^/&]+$@D";}}}s:8:"required";b:1;}s:3:"url";R:182;}s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:55:"@mixcloud\\.com/(?!categories|tag)(?\'id\'[-\\w]+/[^/&]+)/@";i:2;R:195;}i:1;a:3:{i:0;s:3:"url";i:1;s:25:"@^(?\'id\'[-\\w]+/[^/&]+)$@D";i:2;R:195;}}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:3:"MLB";a:8:{s:10:"attributes";R:673;s:22:"attributePreprocessors";a:3:{i:0;a:3:{i:0;s:3:"url";i:1;s:29:"#mlb\\.com/[\\w/]*/v(?\'id\'\\d+)#";i:2;R:195;}i:1;a:3:{i:0;s:3:"url";i:1;s:41:"#mlb\\.com/r/video\\?content_id=(?\'id\'\\d+)#";i:2;R:195;}i:2;R:460;}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:5:"MRCTV";a:8:{s:10:"attributes";R:173;s:22:"attributePreprocessors";R:730;s:11:"filterChain";a:3:{i:0;R:202;i:1;a:2:{s:8:"callback";s:51:"s9e\\TextFormatter\\Plugins\\MediaEmbed\\Parser::scrape";s:6:"params";a:3:{s:3:"tag";N;i:0;a:1:{i:0;a:3:{i:0;s:21:"!mrctv\\.org/videos/.!";i:1;s:29:"!mrctv\\.org/embed/(?\'id\'\\d+)!";i:2;R:361;}}s:8:"cacheDir";N;}}i:2;R:207;}s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:5:"MSNBC";a:8:{s:10:"attributes";R:929;s:22:"attributePreprocessors";a:1:{i:0;R:942;}s:11:"filterChain";a:3:{i:0;R:202;i:1;a:2:{s:8:"callback";s:51:"s9e\\TextFormatter\\Plugins\\MediaEmbed\\Parser::scrape";s:6:"params";a:3:{s:3:"tag";N;i:0;a:1:{i:0;a:3:{i:0;a:2:{i:0;s:26:"@msnbc\\.com/[-\\w]+/watch/@";i:1;s:18:"@on\\.msnbc\\.com/.@";}i:1;s:19:"@guid="?(?\'id\'\\w+)@";i:2;R:361;}}s:8:"cacheDir";N;}}i:2;R:207;}s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:13:"NATGEOCHANNEL";a:8:{s:10:"attributes";a:2:{s:2:"id";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:53:"s9e\\TextFormatter\\Parser\\BuiltInFilters::filterRegexp";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:26:"@^[-/\\w]+/videos/[-\\w]+$@D";}}}s:8:"required";b:1;}s:3:"url";R:182;}s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:63:"@channel\\.nationalgeographic\\.com/(?\'id\'[-/\\w]+/videos/[-\\w]+)@";i:2;R:195;}i:1;a:3:{i:0;s:3:"url";i:1;s:33:"@^(?\'id\'[-/\\w]+/videos/[-\\w]+)$@D";i:2;R:195;}}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:11:"NATGEOVIDEO";a:8:{s:10:"attributes";a:2:{s:2:"id";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:53:"s9e\\TextFormatter\\Parser\\BuiltInFilters::filterRegexp";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:11:"@^[-\\w]+$@D";}}}s:8:"required";b:1;}s:3:"url";R:182;}s:22:"attributePreprocessors";a:1:{i:0;a:3:{i:0;s:3:"url";i:1;s:18:"@^(?\'id\'[-\\w]+)$@D";i:2;R:195;}}s:11:"filterChain";a:3:{i:0;R:202;i:1;a:2:{s:8:"callback";s:51:"s9e\\TextFormatter\\Plugins\\MediaEmbed\\Parser::scrape";s:6:"params";a:3:{s:3:"tag";N;i:0;a:1:{i:0;a:3:{i:0;s:48:"@video\\.nationalgeographic\\.com/(?:tv|video)/\\w@";i:1;s:22:"@guid="(?\'id\'[-\\w]+)"@";i:2;R:361;}}s:8:"cacheDir";N;}}i:2;R:207;}s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:7:"NBCNEWS";a:8:{s:10:"attributes";R:173;s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:63:"!nbcnews\\.com/(?:widget/video-embed/|video/[-\\w]+?-)(?\'id\'\\d+)!";i:2;R:195;}i:1;R:198;}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:9:"NBCSPORTS";a:8:{s:10:"attributes";R:565;s:22:"attributePreprocessors";R:1007;s:11:"filterChain";a:3:{i:0;R:202;i:1;a:2:{s:8:"callback";s:51:"s9e\\TextFormatter\\Plugins\\MediaEmbed\\Parser::scrape";s:6:"params";a:3:{s:3:"tag";N;i:0;a:1:{i:0;a:3:{i:0;s:24:"!nbcsports\\.com/video/.!";i:1;s:25:"!select/media/(?\'id\'\\w+)!";i:2;R:361;}}s:8:"cacheDir";N;}}i:2;R:207;}s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:3:"NHL";a:8:{s:10:"attributes";a:4:{s:1:"c";R:440;s:2:"id";a:2:{s:11:"filterChain";R:370;s:8:"required";b:0;}s:1:"t";R:440;s:3:"url";R:182;}s:22:"attributePreprocessors";a:3:{i:0;a:3:{i:0;s:3:"url";i:1;s:44:"#nhl\\.com/videocenter/.*?\\Wid=(?\'id\'[-\\w]+)#";i:2;R:195;}i:1;a:3:{i:0;s:3:"url";i:1;s:80:"#nhl\\.com/(?:\\w+/)?video(?:/(?![ct]-)[-\\w]+)?(?:/t-(?\'t\'\\d+))?(?:/c-(?\'c\'\\d+))?#";i:2;a:3:{i:0;s:0:"";i:1;s:1:"t";i:2;s:1:"c";}}i:2;R:381;}s:11:"filterChain";R:981;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:3:"NPR";a:7:{s:10:"attributes";a:3:{s:1:"i";R:307;s:1:"m";R:307;s:3:"url";R:182;}s:11:"filterChain";a:3:{i:0;a:2:{s:8:"callback";s:51:"s9e\\TextFormatter\\Plugins\\MediaEmbed\\Parser::scrape";s:6:"params";a:3:{s:3:"tag";N;i:0;a:1:{i:0;a:3:{i:0;a:2:{i:0;s:21:"!npr\\.org/[/\\w]+/\\d+!";i:1;s:10:"!n\\.pr/\\w!";}i:1;s:34:"!player/embed/(?\'i\'\\d+)/(?\'m\'\\d+)!";i:2;a:2:{i:0;s:1:"i";i:1;s:1:"m";}}}s:8:"cacheDir";N;}}i:1;R:207;i:2;R:331;}s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:12;s:7:"allowed";a:3:{i:0;i:65532;i:1;i:65519;i:2;i:65535;}}s:7:"NYTIMES";a:8:{s:10:"attributes";R:173;s:22:"attributePreprocessors";a:3:{i:0;a:3:{i:0;s:3:"url";i:1;s:50:"!nytimes\\.com/video/[a-z]+/(?:[a-z]+/)?(?\'id\'\\d+)!";i:2;R:195;}i:1;a:3:{i:0;s:3:"url";i:1;s:50:"!nytimes\\.com/video/\\d+/\\d+/\\d+/[a-z]+/(?\'id\'\\d+)!";i:2;R:195;}i:2;R:198;}s:11:"filterChain";a:3:{i:0;R:202;i:1;a:2:{s:8:"callback";s:51:"s9e\\TextFormatter\\Plugins\\MediaEmbed\\Parser::scrape";s:6:"params";a:3:{s:3:"tag";N;i:0;a:1:{i:0;a:4:{i:0;s:65:"!nytimes\\.com/movie(?:s/movie)?/(?\'playlist\'\\d+)/[-\\w]+/trailers!";i:1;s:26:"!/video/movies/(?\'id\'\\d+)!";i:2;R:361;i:3;s:73:"http://www.nytimes.com/svc/video/api/playlist/{@playlist}?externalId=true";}}s:8:"cacheDir";N;}}i:2;R:207;}s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:7:"ODDSHOT";a:8:{s:10:"attributes";R:339;s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:31:"!oddshot.tv/shot/(?\'id\'[-\\w]+)!";i:2;R:195;}i:1;R:349;}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:8:"PASTEBIN";a:8:{s:10:"attributes";R:929;s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:55:"@pastebin\\.com/(?!u/)(?:\\w+(?:\\.php\\?i=|/))?(?\'id\'\\w+)@";i:2;R:195;}i:1;R:942;}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:13;s:7:"allowed";a:3:{i:0;i:65532;i:1;i:65503;i:2;i:65535;}}s:9:"PINTEREST";a:8:{s:10:"attributes";a:2:{s:2:"id";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:53:"s9e\\TextFormatter\\Parser\\BuiltInFilters::filterRegexp";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:25:"@^(?:\\d+|[-\\w]+/[-\\w]+)$@";}}}s:8:"required";b:1;}s:3:"url";R:182;}s:22:"attributePreprocessors";a:3:{i:0;a:3:{i:0;s:3:"url";i:1;s:30:"@pinterest.com/pin/(?\'id\'\\d+)@";i:2;R:195;}i:1;a:3:{i:0;s:3:"url";i:1;s:44:"@pinterest.com/(?!pin/)(?\'id\'[-\\w]+/[-\\w]+)@";i:2;R:195;}i:2;a:3:{i:0;s:3:"url";i:1;s:32:"@^(?\'id\'(?:\\d+|[-\\w]+/[-\\w]+))$@";i:2;R:195;}}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:14;s:7:"allowed";a:3:{i:0;i:65532;i:1;i:65471;i:2;i:65535;}}s:7:"PLAYSTV";a:8:{s:10:"attributes";R:565;s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:28:"!plays\\.tv/video/(?\'id\'\\w+)!";i:2;R:195;}i:1;R:578;}s:11:"filterChain";a:3:{i:0;R:202;i:1;a:2:{s:8:"callback";s:51:"s9e\\TextFormatter\\Plugins\\MediaEmbed\\Parser::scrape";s:6:"params";a:3:{s:3:"tag";N;i:0;a:1:{i:0;a:3:{i:0;s:14:"!plays\\.tv/s/!";i:1;s:28:"!plays\\.tv/video/(?\'id\'\\w+)!";i:2;R:361;}}s:8:"cacheDir";N;}}i:2;R:207;}s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:7:"PODBEAN";a:8:{s:10:"attributes";R:339;s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:55:"!podbean\\.com/media/(?:player/|share/pb-)(?\'id\'[-\\w]+)!";i:2;R:195;}i:1;R:349;}s:11:"filterChain";a:3:{i:0;R:202;i:1;a:2:{s:8:"callback";s:51:"s9e\\TextFormatter\\Plugins\\MediaEmbed\\Parser::scrape";s:6:"params";a:3:{s:3:"tag";N;i:0;a:1:{i:0;a:3:{i:0;s:17:"!podbean\\.com/e/!";i:1;s:40:"!podbean.com/media/player/(?\'id\'[-\\w]+)!";i:2;R:361;}}s:8:"cacheDir";N;}}i:2;R:207;}s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:15;s:7:"allowed";a:3:{i:0;i:65532;i:1;i:65407;i:2;i:65535;}}s:5:"PREZI";a:8:{s:10:"attributes";a:2:{s:2:"id";a:2:{s:11:"filterChain";R:449;s:8:"required";b:1;}s:3:"url";R:182;}s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:221:"#//prezi\\.com/(?!(?:a(?:bout|mbassadors)|c(?:o(?:llaborate|mmunity|ntact)|reate)|exp(?:erts|lore)|ip(?:ad|hone)|jobs|l(?:ear|ogi)n|m(?:ac|obility)|pr(?:es(?:s|ent)|icing)|recommend|support|user|windows|your)/)(?\'id\'\\w+)/#";i:2;R:195;}i:1;a:3:{i:0;s:3:"url";i:1;s:15:"#^(?\'id\'\\w+)$#D";i:2;R:195;}}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:6:"REDDIT";a:8:{s:10:"attributes";a:2:{s:4:"path";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:53:"s9e\\TextFormatter\\Parser\\BuiltInFilters::filterRegexp";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:37:"!^/r/\\w+/comments/\\w+/(?:\\w+/\\w+)?$!D";}}}s:8:"required";b:0;}s:3:"url";R:182;}s:22:"attributePreprocessors";a:1:{i:0;a:3:{i:0;s:3:"url";i:1;s:43:"!(?\'path\'/r/\\w+/comments/\\w+/(?:\\w+/\\w+)?)!";i:2;a:2:{i:0;s:0:"";i:1;s:4:"path";}}}s:11:"filterChain";R:981;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:16;s:7:"allowed";a:3:{i:0;i:65532;i:1;i:65535;i:2;i:65534;}}s:6:"RUTUBE";a:8:{s:10:"attributes";R:173;s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:30:"!rutube\\.ru/tracks/(?\'id\'\\d+)!";i:2;R:195;}i:1;R:198;}s:11:"filterChain";a:3:{i:0;R:202;i:1;a:2:{s:8:"callback";s:51:"s9e\\TextFormatter\\Plugins\\MediaEmbed\\Parser::scrape";s:6:"params";a:3:{s:3:"tag";N;i:0;a:1:{i:0;a:3:{i:0;s:31:"!rutube\\.ru/video/[0-9a-f]{32}!";i:1;s:34:"!rutube\\.ru/play/embed/(?\'id\'\\d+)!";i:2;R:361;}}s:8:"cacheDir";N;}}i:2;R:207;}s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:6:"SCRIBD";a:8:{s:10:"attributes";R:173;s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:50:"!scribd\\.com/(?:mobile/)?doc(?:ument)?/(?\'id\'\\d+)!";i:2;R:195;}i:1;R:198;}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:17;s:7:"allowed";a:3:{i:0;i:65532;i:1;i:65535;i:2;i:65533;}}s:10:"SLIDESHARE";a:8:{s:10:"attributes";a:2:{s:2:"id";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:53:"s9e\\TextFormatter\\Parser\\BuiltInFilters::filterRegexp";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:11:"!^\\d{6,}$!D";}}}s:8:"required";b:1;}s:3:"url";R:182;}s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:45:"!slideshare\\.net/[^/]+/[-\\w]+-(?\'id\'\\d{6,})$!";i:2;R:195;}i:1;a:3:{i:0;s:3:"url";i:1;s:18:"!^(?\'id\'\\d{6,})$!D";i:2;R:195;}}s:11:"filterChain";a:3:{i:0;R:202;i:1;a:2:{s:8:"callback";s:51:"s9e\\TextFormatter\\Plugins\\MediaEmbed\\Parser::scrape";s:6:"params";a:3:{s:3:"tag";N;i:0;a:1:{i:0;a:3:{i:0;s:26:"!slideshare\\.net/[^/]+/\\w!";i:1;s:29:"!"presentationId":(?\'id\'\\d+)!";i:2;R:361;}}s:8:"cacheDir";N;}}i:2;R:207;}s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:10:"SOUNDCLOUD";a:8:{s:10:"attributes";a:5:{s:2:"id";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:53:"s9e\\TextFormatter\\Parser\\BuiltInFilters::filterRegexp";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:83:"@^(?:https?://(?:api\\.)?soundcloud\\.com/(?!pages/)[-/\\w]+/[-/\\w]+|^[^/]+/[^/]+$)$@D";}}}s:8:"required";b:1;}s:11:"playlist_id";a:2:{s:11:"filterChain";R:686;s:8:"required";b:0;}s:12:"secret_token";a:2:{s:11:"filterChain";R:1550;s:8:"required";b:0;}s:8:"track_id";R:1855;s:3:"url";R:182;}s:22:"attributePreprocessors";a:5:{i:0;a:3:{i:0;s:3:"url";i:1;s:83:"@(?\'id\'https?://(?:api\\.)?soundcloud\\.com/(?!pages/)[-/\\w]+/[-/\\w]+|^[^/]+/[^/]+$)@";i:2;R:195;}i:1;a:3:{i:0;s:3:"url";i:1;s:52:"@api\\.soundcloud\\.com/playlists/(?\'playlist_id\'\\d+)@";i:2;a:2:{i:0;s:0:"";i:1;s:11:"playlist_id";}}i:2;a:3:{i:0;s:3:"url";i:1;s:89:"@api\\.soundcloud\\.com/tracks/(?\'track_id\'\\d+)(?:\\?secret_token=(?\'secret_token\'[-\\w]+))?@";i:2;a:3:{i:0;s:0:"";i:1;s:8:"track_id";i:2;s:12:"secret_token";}}i:3;a:3:{i:0;s:3:"url";i:1;s:81:"@soundcloud\\.com/(?!playlists|tracks)[-\\w]+/[-\\w]+/(?=s-)(?\'secret_token\'[-\\w]+)@";i:2;a:2:{i:0;s:0:"";i:1;s:12:"secret_token";}}i:4;a:3:{i:0;s:3:"url";i:1;s:90:"@^(?\'id\'(?:https?://(?:api\\.)?soundcloud\\.com/(?!pages/)[-/\\w]+/[-/\\w]+|^[^/]+/[^/]+$))$@D";i:2;R:195;}}s:11:"filterChain";a:3:{i:0;R:202;i:1;a:2:{s:8:"callback";s:51:"s9e\\TextFormatter\\Plugins\\MediaEmbed\\Parser::scrape";s:6:"params";a:3:{s:3:"tag";N;i:0;a:2:{i:0;a:3:{i:0;s:54:"@soundcloud\\.com/(?!playlists|tracks)[-\\w]+/[-\\w]+/s-@";i:1;s:36:"@soundcloud:tracks:(?\'track_id\'\\d+)@";i:2;a:1:{i:0;s:8:"track_id";}}i:1;a:3:{i:0;s:27:"@soundcloud\\.com/\\w+/sets/@";i:1;s:44:"@soundcloud://playlists:(?\'playlist_id\'\\d+)@";i:2;a:1:{i:0;s:11:"playlist_id";}}}s:8:"cacheDir";N;}}i:2;R:207;}s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:18;s:7:"allowed";a:3:{i:0;i:65532;i:1;i:65535;i:2;i:65531;}}s:9:"SPORTSNET";a:8:{s:10:"attributes";a:2:{s:2:"id";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:53:"s9e\\TextFormatter\\Parser\\BuiltInFilters::filterRegexp";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:8:"/^\\d+$/D";}}}s:8:"required";b:1;}s:3:"url";R:182;}s:22:"attributePreprocessors";a:1:{i:0;a:3:{i:0;s:3:"url";i:1;s:15:"/^(?\'id\'\\d+)$/D";i:2;R:195;}}s:11:"filterChain";a:3:{i:0;R:202;i:1;a:2:{s:8:"callback";s:51:"s9e\\TextFormatter\\Plugins\\MediaEmbed\\Parser::scrape";s:6:"params";a:3:{s:3:"tag";N;i:0;a:1:{i:0;a:3:{i:0;s:2:"//";i:1;a:2:{i:0;s:25:"/vid(?:eoId)?=(?\'id\'\\d+)/";i:1;s:46:"/param name="@videoPlayer" value="(?\'id\'\\d+)"/";}i:2;R:361;}}s:8:"cacheDir";N;}}i:2;R:207;}s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:7:"SPOTIFY";a:8:{s:10:"attributes";a:3:{s:4:"path";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:53:"s9e\\TextFormatter\\Parser\\BuiltInFilters::filterRegexp";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:44:"!^(?:(?:album|artist|track|user)/[-/\\w]+)$!D";}}}s:8:"required";b:0;}s:3:"uri";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:53:"s9e\\TextFormatter\\Parser\\BuiltInFilters::filterRegexp";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:61:"!^(?:spotify:(?:album|artist|user|track(?:set)?):[-,:\\w]+)$!D";}}}s:8:"required";b:0;}s:3:"url";R:182;}s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:62:"!(?\'uri\'spotify:(?:album|artist|user|track(?:set)?):[-,:\\w]+)!";i:2;a:2:{i:0;s:0:"";i:1;s:3:"uri";}}i:1;a:3:{i:0;s:3:"url";i:1;s:74:"!(?:open|play)\\.spotify\\.com/(?\'path\'(?:album|artist|track|user)/[-/\\w]+)!";i:2;R:1775;}}s:11:"filterChain";R:981;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:10:"STEAMSTORE";a:8:{s:10:"attributes";R:173;s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:39:"!store.steampowered.com/app/(?\'id\'\\d+)!";i:2;R:195;}i:1;R:198;}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:19;s:7:"allowed";a:3:{i:0;i:65532;i:1;i:65535;i:2;i:65527;}}s:8:"STITCHER";a:7:{s:10:"attributes";a:3:{s:3:"eid";R:307;s:3:"fid";R:307;s:3:"url";R:182;}s:11:"filterChain";a:3:{i:0;a:2:{s:8:"callback";s:51:"s9e\\TextFormatter\\Plugins\\MediaEmbed\\Parser::scrape";s:6:"params";a:3:{s:3:"tag";N;i:0;a:1:{i:0;a:3:{i:0;s:11:"!/podcast/!";i:1;a:2:{i:0;s:23:"!data-eid="(?\'eid\'\\d+)!";i:1;s:23:"!data-fid="(?\'fid\'\\d+)!";}i:2;a:2:{i:0;s:3:"eid";i:1;s:3:"fid";}}}s:8:"cacheDir";N;}}i:1;R:207;i:2;R:331;}s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:20;s:7:"allowed";a:3:{i:0;i:65532;i:1;i:65535;i:2;i:65519;}}s:9:"STRAWPOLL";a:8:{s:10:"attributes";R:173;s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:26:"!strawpoll\\.me/(?\'id\'\\d+)!";i:2;R:195;}i:1;R:198;}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:10:"STREAMABLE";a:8:{s:10:"attributes";R:565;s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:28:"!streamable\\.com/(?\'id\'\\w+)!";i:2;R:195;}i:1;R:578;}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:8:"TEAMCOCO";a:8:{s:10:"attributes";R:173;s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:32:"!teamcoco\\.com/video/(?\'id\'\\d+)!";i:2;R:195;}i:1;R:198;}s:11:"filterChain";a:3:{i:0;R:202;i:1;a:2:{s:8:"callback";s:51:"s9e\\TextFormatter\\Plugins\\MediaEmbed\\Parser::scrape";s:6:"params";a:3:{s:3:"tag";N;i:0;a:1:{i:0;a:3:{i:0;s:23:"!teamcoco\\.com/video/.!";i:1;s:17:"!"id":(?\'id\'\\d+)!";i:2;R:361;}}s:8:"cacheDir";N;}}i:2;R:207;}s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:3:"TED";a:8:{s:10:"attributes";a:2:{s:2:"id";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:53:"s9e\\TextFormatter\\Parser\\BuiltInFilters::filterRegexp";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:46:"#^(?:(?:talk|playlist)s/[-\\w]+(?:\\.html)?)$#iD";}}}s:8:"required";b:1;}s:3:"url";R:182;}s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:76:"#ted\\.com/(?\'id\'(?:talk|playlist)s/[-\\w]+(?:\\.html)?)(?![-\\w]|/transcript)#i";i:2;R:195;}i:1;a:3:{i:0;s:3:"url";i:1;s:53:"#^(?\'id\'(?:(?:talk|playlist)s/[-\\w]+(?:\\.html)?))$#iD";i:2;R:195;}}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:11:"THEATLANTIC";a:8:{s:10:"attributes";R:173;s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:41:"!theatlantic\\.com/video/index/(?\'id\'\\d+)!";i:2;R:195;}i:1;R:198;}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:11:"THEGUARDIAN";a:8:{s:10:"attributes";a:2:{s:2:"id";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:53:"s9e\\TextFormatter\\Parser\\BuiltInFilters::filterRegexp";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:22:"!^\\w+/video/[-/\\w]+$!D";}}}s:8:"required";b:1;}s:3:"url";R:182;}s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:43:"!theguardian\\.com/(?\'id\'\\w+/video/[-/\\w]+)!";i:2;R:195;}i:1;a:3:{i:0;s:3:"url";i:1;s:29:"!^(?\'id\'\\w+/video/[-/\\w]+)$!D";i:2;R:195;}}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:8:"THEONION";a:8:{s:10:"attributes";R:173;s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:42:"!theonion\\.com/video/[-\\w]+[-,](?\'id\'\\d+)!";i:2;R:195;}i:1;R:198;}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:7:"TINYPIC";a:8:{s:10:"attributes";a:3:{s:2:"id";R:566;s:1:"s";R:307;s:3:"url";R:182;}s:22:"attributePreprocessors";a:3:{i:0;a:3:{i:0;s:3:"url";i:1;s:52:"!tinypic\\.com/player\\.php\\?v=(?\'id\'\\w+)&s=(?\'s\'\\d+)!";i:2;a:3:{i:0;s:0:"";i:1;s:2:"id";i:2;s:1:"s";}}i:1;a:3:{i:0;s:3:"url";i:1;s:37:"!tinypic\\.com/r/(?\'id\'\\w+)/(?\'s\'\\d+)!";i:2;R:2101;}i:2;R:578;}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:3:"TMZ";a:8:{s:10:"attributes";R:929;s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:28:"@tmz\\.com/videos/(?\'id\'\\w+)@";i:2;R:195;}i:1;R:942;}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:13:"TRAILERADDICT";a:8:{s:10:"attributes";a:2:{s:2:"id";R:685;s:3:"url";R:182;}s:22:"attributePreprocessors";a:1:{i:0;R:711;}s:11:"filterChain";a:3:{i:0;R:202;i:1;a:2:{s:8:"callback";s:51:"s9e\\TextFormatter\\Plugins\\MediaEmbed\\Parser::scrape";s:6:"params";a:3:{s:3:"tag";N;i:0;a:1:{i:0;a:3:{i:0;s:37:"@traileraddict\\.com/(?!tags/)[^/]+/.@";i:1;s:34:"@v\\.traileraddict\\.com/(?\'id\'\\d+)@";i:2;R:361;}}s:8:"cacheDir";N;}}i:2;R:207;}s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:6:"TUMBLR";a:8:{s:10:"attributes";a:5:{s:3:"did";R:1363;s:2:"id";R:174;s:3:"key";R:1363;s:4:"name";R:1363;s:3:"url";R:182;}s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:46:"!(?\'name\'[-\\w]+)\\.tumblr\\.com/post/(?\'id\'\\d+)!";i:2;a:3:{i:0;s:0:"";i:1;s:4:"name";i:2;s:2:"id";}}i:1;R:198;}s:11:"filterChain";a:3:{i:0;R:202;i:1;a:2:{s:8:"callback";s:51:"s9e\\TextFormatter\\Plugins\\MediaEmbed\\Parser::scrape";s:6:"params";a:3:{s:3:"tag";N;i:0;a:1:{i:0;a:4:{i:0;s:25:"!\\w\\.tumblr\\.com/post/\\d!";i:1;a:2:{i:0;s:27:"!did=\\\\u0022(?\'did\'[-\\w]+)!";i:1;s:31:"!embed\\\\/post\\\\/(?\'key\'[-\\w]+)!";}i:2;a:2:{i:0;s:3:"did";i:1;s:3:"key";}i:3;s:73:"http://www.tumblr.com/oembed/1.0?url=http://{@name}.tumblr.com/post/{@id}";}}s:8:"cacheDir";N;}}i:2;R:207;}s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:21;s:7:"allowed";a:3:{i:0;i:65532;i:1;i:65535;i:2;i:65503;}}s:6:"TWITCH";a:8:{s:10:"attributes";a:7:{s:10:"archive_id";R:440;s:7:"channel";R:448;s:10:"chapter_id";R:440;s:7:"clip_id";R:448;s:1:"t";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:53:"s9e\\TextFormatter\\Parser\\BuiltInFilters::filterRegexp";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:27:"#^(?:(?:\\d+h)?\\d+m)?\\d+s$#D";}}}s:8:"required";b:0;}s:3:"url";R:182;s:8:"video_id";R:440;}s:22:"attributePreprocessors";a:3:{i:0;a:3:{i:0;s:3:"url";i:1;s:96:"#twitch\\.tv/(?\'channel\'\\w+)(?:/b/(?\'archive_id\'\\d+)|/c/(?\'chapter_id\'\\d+)|/v/(?\'video_id\'\\d+))?#";i:2;a:5:{i:0;s:0:"";i:1;s:7:"channel";i:2;s:10:"archive_id";i:3;s:10:"chapter_id";i:4;s:8:"video_id";}}i:1;a:3:{i:0;s:3:"url";i:1;s:32:"#t=(?\'t\'(?:(?:\\d+h)?\\d+m)?\\d+s)#";i:2;a:2:{i:0;s:0:"";i:1;s:1:"t";}}i:2;a:3:{i:0;s:3:"url";i:1;s:51:"#clips\\.twitch\\.tv/(?\'channel\'\\w+)/(?\'clip_id\'\\w+)#";i:2;R:1382;}}s:11:"filterChain";R:981;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:7:"TWITTER";a:8:{s:10:"attributes";R:2120;s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:51:"@twitter\\.com/(?:#!/)?\\w+/status(?:es)?/(?\'id\'\\d+)@";i:2;R:195;}i:1;R:711;}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:22;s:7:"allowed";a:3:{i:0;i:65532;i:1;i:65535;i:2;i:65471;}}s:7:"USTREAM";a:8:{s:10:"attributes";a:3:{s:3:"cid";R:307;s:3:"url";R:182;s:3:"vid";R:307;}s:22:"attributePreprocessors";a:1:{i:0;a:3:{i:0;s:3:"url";i:1;s:34:"!ustream\\.tv/recorded/(?\'vid\'\\d+)!";i:2;a:2:{i:0;s:0:"";i:1;s:3:"vid";}}}s:11:"filterChain";a:4:{i:0;R:202;i:1;a:2:{s:8:"callback";s:51:"s9e\\TextFormatter\\Plugins\\MediaEmbed\\Parser::scrape";s:6:"params";a:3:{s:3:"tag";N;i:0;a:1:{i:0;a:3:{i:0;s:90:"#ustream\\.tv/(?!explore/|platform/|recorded/|search\\?|upcoming$|user/)(?:channel/)?[-\\w]+#";i:1;s:19:"!embed/(?\'cid\'\\d+)!";i:2;a:1:{i:0;s:3:"cid";}}}s:8:"cacheDir";N;}}i:2;R:207;i:3;R:331;}s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:5:"VBOX7";a:8:{s:10:"attributes";R:1440;s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:33:"!vbox7\\.com/play:(?\'id\'[\\da-f]+)!";i:2;R:195;}i:1;R:1447;}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:4:"VEOH";a:8:{s:10:"attributes";R:565;s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:50:"!veoh\\.com/(?:m/watch\\.php\\?v=|watch/)v(?\'id\'\\w+)!";i:2;R:195;}i:1;R:578;}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:4:"VEVO";a:8:{s:10:"attributes";a:2:{s:2:"id";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:53:"s9e\\TextFormatter\\Parser\\BuiltInFilters::filterRegexp";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:14:"!^[A-Z0-9]+$!D";}}}s:8:"required";b:1;}s:3:"url";R:182;}s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:45:"!vevo\\.com/watch/([-/\\w]+/)?(?\'id\'[A-Z0-9]+)!";i:2;a:3:{i:0;s:0:"";i:1;s:0:"";i:2;s:2:"id";}}i:1;a:3:{i:0;s:3:"url";i:1;s:21:"!^(?\'id\'[A-Z0-9]+)$!D";i:2;R:195;}}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:7:"VIAGAME";a:8:{s:10:"attributes";R:173;s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:40:"!viagame\\.com/channels/[^/]+/(?\'id\'\\d+)!";i:2;R:195;}i:1;R:198;}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:14:"VIDEODETECTIVE";a:8:{s:10:"attributes";R:173;s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:59:"!videodetective\\.com/\\w+/[-\\w]+/(?:trailer/P0*)?(?\'id\'\\d+)!";i:2;R:195;}i:1;R:198;}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:9:"VIDEOMEGA";a:8:{s:10:"attributes";R:565;s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:32:"!videomega\\.tv/\\?ref=(?\'id\'\\w+)!";i:2;R:195;}i:1;R:578;}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:5:"VIDME";a:8:{s:10:"attributes";R:875;s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:20:"!vid\\.me/(?\'id\'\\w+)!";i:2;R:195;}i:1;R:578;}s:11:"filterChain";a:3:{i:0;R:202;i:1;a:2:{s:8:"callback";s:51:"s9e\\TextFormatter\\Plugins\\MediaEmbed\\Parser::scrape";s:6:"params";a:3:{s:3:"tag";N;i:0;a:1:{i:0;a:3:{i:0;s:2:"//";i:1;s:170:"!meta property="og:video:type" content="video/\\w+">\\s*<meta property="og:video:height" content="(?\'height\'\\d+)">\\s*<meta property="og:video:width" content="(?\'width\'\\d+)!";i:2;R:866;}}s:8:"cacheDir";N;}}i:2;R:207;}s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:5:"VIMEO";a:8:{s:10:"attributes";R:173;s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:50:"!vimeo\\.com/(?:channels/[^/]+/|video/)?(?\'id\'\\d+)!";i:2;R:195;}i:1;R:198;}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:4:"VINE";a:8:{s:10:"attributes";a:2:{s:2:"id";a:2:{s:11:"filterChain";a:1:{i:0;R:960;}s:8:"required";b:1;}s:3:"url";R:182;}s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:25:"!vine\\.co/v/(?\'id\'[^/]+)!";i:2;R:195;}i:1;a:3:{i:0;s:3:"url";i:1;s:17:"!^(?\'id\'[^/]+)$!D";i:2;R:195;}}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:2:"VK";a:8:{s:10:"attributes";a:4:{s:4:"hash";a:2:{s:11:"filterChain";R:755;s:8:"required";b:0;}s:3:"oid";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:53:"s9e\\TextFormatter\\Parser\\BuiltInFilters::filterRegexp";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:10:"!^-?\\d+$!D";}}}s:8:"required";b:0;}s:3:"url";R:182;s:3:"vid";R:307;}s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:71:"!vk(?:\\.com|ontakte\\.ru)/(?:[\\w.]+\\?z=)?video(?\'oid\'-?\\d+)_(?\'vid\'\\d+)!";i:2;a:3:{i:0;s:0:"";i:1;s:3:"oid";i:2;s:3:"vid";}}i:1;a:3:{i:0;s:3:"url";i:1;s:98:"!vk(?:\\.com|ontakte\\.ru)/video_ext\\.php\\?oid=(?\'oid\'-?\\d+)&id=(?\'vid\'\\d+)&hash=(?\'hash\'[0-9a-f]+)!";i:2;a:4:{i:0;s:0:"";i:1;s:3:"oid";i:2;s:3:"vid";i:3;s:4:"hash";}}}s:11:"filterChain";a:4:{i:0;R:202;i:1;a:2:{s:8:"callback";s:51:"s9e\\TextFormatter\\Plugins\\MediaEmbed\\Parser::scrape";s:6:"params";a:3:{s:3:"tag";N;i:0;a:1:{i:0;a:4:{i:0;s:21:"!vk.*?video-?\\d+_\\d+!";i:1;s:31:"!embed_hash=(?\'hash\'[0-9a-f]+)!";i:2;a:1:{i:0;s:4:"hash";}i:3;s:32:"http://vk.com/video{@oid}_{@vid}";}}s:8:"cacheDir";N;}}i:2;R:207;i:3;R:331;}s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:7:"VOCAROO";a:8:{s:10:"attributes";R:565;s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:27:"!vocaroo\\.com/i/(?\'id\'\\w+)!";i:2;R:195;}i:1;R:578;}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:3:"VOX";a:8:{s:10:"attributes";R:339;s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:31:"!vox.com/.*#ooid=(?\'id\'[-\\w]+)!";i:2;R:195;}i:1;R:349;}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:14:"WASHINGTONPOST";a:8:{s:10:"attributes";a:2:{s:2:"id";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:53:"s9e\\TextFormatter\\Parser\\BuiltInFilters::filterRegexp";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:15:"#^[-0-9a-f]+$#D";}}}s:8:"required";b:1;}s:3:"url";R:182;}s:22:"attributePreprocessors";a:3:{i:0;a:3:{i:0;s:3:"url";i:1;s:51:"#washingtonpost\\.com/video/c/\\w+/(?\'id\'[-0-9a-f]+)#";i:2;R:195;}i:1;a:3:{i:0;s:3:"url";i:1;s:65:"#washingtonpost\\.com/video/[-/\\w]+/(?\'id\'[-0-9a-f]+)_video\\.html#";i:2;R:195;}i:2;a:3:{i:0;s:3:"url";i:1;s:22:"#^(?\'id\'[-0-9a-f]+)$#D";i:2;R:195;}}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:4:"WSHH";a:8:{s:10:"attributes";R:173;s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:42:"!worldstarhiphop\\.com/featured/(?\'id\'\\d+)!";i:2;R:195;}i:1;R:198;}s:11:"filterChain";a:3:{i:0;R:202;i:1;a:2:{s:8:"callback";s:51:"s9e\\TextFormatter\\Plugins\\MediaEmbed\\Parser::scrape";s:6:"params";a:3:{s:3:"tag";N;i:0;a:1:{i:0;a:3:{i:0;s:49:"!worldstarhiphop\\.com/(?:\\w+/)?video\\.php\\?v=\\w+!";i:1;s:18:"!v: ?"?(?\'id\'\\d+)!";i:2;R:361;}}s:8:"cacheDir";N;}}i:2;R:207;}s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:3:"WSJ";a:8:{s:10:"attributes";a:2:{s:2:"id";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:53:"s9e\\TextFormatter\\Parser\\BuiltInFilters::filterRegexp";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:18:"@^[-0-9A-F]{36}$@D";}}}s:8:"required";b:1;}s:3:"url";R:182;}s:22:"attributePreprocessors";a:3:{i:0;a:3:{i:0;s:3:"url";i:1;s:38:"@wsj\\.com/[^#]*#!(?\'id\'[-0-9A-F]{36})@";i:2;R:195;}i:1;a:3:{i:0;s:3:"url";i:1;s:43:"@wsj\\.com/video/[^/]+/(?\'id\'[-0-9A-F]{36})@";i:2;R:195;}i:2;a:3:{i:0;s:3:"url";i:1;s:25:"@^(?\'id\'[-0-9A-F]{36})$@D";i:2;R:195;}}s:11:"filterChain";a:3:{i:0;R:202;i:1;a:2:{s:8:"callback";s:51:"s9e\\TextFormatter\\Plugins\\MediaEmbed\\Parser::scrape";s:6:"params";a:3:{s:3:"tag";N;i:0;a:1:{i:0;a:3:{i:0;s:17:"@on\\.wsj\\.com/\\w@";i:1;s:27:"@guid=(?\'id\'[-0-9A-F]{36})@";i:2;R:361;}}s:8:"cacheDir";N;}}i:2;R:207;}s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:9:"XBOXCLIPS";a:8:{s:10:"attributes";a:3:{s:2:"id";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:53:"s9e\\TextFormatter\\Parser\\BuiltInFilters::filterRegexp";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:15:"@^[-0-9a-f]+$@D";}}}s:8:"required";b:1;}s:3:"url";R:182;s:4:"user";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:53:"s9e\\TextFormatter\\Parser\\BuiltInFilters::filterRegexp";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:10:"@^[^/]+$@D";}}}s:8:"required";b:0;}}s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:65:"@xboxclips\\.com/(?\'user\'[^/]+)/(?!screenshots/)(?\'id\'[-0-9a-f]+)@";i:2;a:3:{i:0;s:0:"";i:1;s:4:"user";i:2;s:2:"id";}}i:1;a:3:{i:0;s:3:"url";i:1;s:22:"@^(?\'id\'[-0-9a-f]+)$@D";i:2;R:195;}}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:7:"XBOXDVR";a:8:{s:10:"attributes";a:3:{s:2:"id";R:174;s:3:"url";R:182;s:4:"user";a:2:{s:11:"filterChain";R:2329;s:8:"required";b:0;}}s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:52:"!xboxdvr\\.com/gamer/(?\'user\'[^/]+)/video/(?\'id\'\\d+)!";i:2;R:2497;}i:1;R:198;}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:11:"YAHOOSCREEN";a:8:{s:10:"attributes";R:339;s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:52:"!screen\\.yahoo\\.com/(?:[-\\w]+/)?(?\'id\'[-\\w]+)\\.html!";i:2;R:195;}i:1;R:349;}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:5:"YOUKU";a:8:{s:10:"attributes";R:565;s:22:"attributePreprocessors";a:2:{i:0;a:3:{i:0;s:3:"url";i:1;s:33:"!youku\\.com/v_show/id_(?\'id\'\\w+)!";i:2;R:195;}i:1;R:578;}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:7:"YOUTUBE";a:8:{s:10:"attributes";a:7:{s:1:"h";R:307;s:2:"id";R:340;s:4:"list";R:1363;s:1:"m";R:307;s:1:"s";R:307;s:1:"t";R:307;s:3:"url";R:182;}s:22:"attributePreprocessors";a:5:{i:0;a:3:{i:0;s:3:"url";i:1;s:45:"!youtube\\.com/(?:watch.*?v=|v/)(?\'id\'[-\\w]+)!";i:2;R:195;}i:1;a:3:{i:0;s:3:"url";i:1;s:25:"!youtu\\.be/(?\'id\'[-\\w]+)!";i:2;R:195;}i:2;a:3:{i:0;s:3:"url";i:1;s:57:"![#&?]t=(?:(?:(?\'h\'\\d+)h)?(?\'m\'\\d+)m(?\'s\'\\d+)|(?\'t\'\\d+))!";i:2;a:5:{i:0;s:0:"";i:1;s:1:"h";i:2;s:1:"m";i:3;s:1:"s";i:4;s:1:"t";}}i:3;a:3:{i:0;s:3:"url";i:1;s:23:"!&list=(?\'list\'[-\\w]+)!";i:2;a:2:{i:0;s:0:"";i:1;s:4:"list";}}i:4;R:349;}s:11:"filterChain";R:201;s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:1;s:7:"allowed";R:219;}s:10:"ZIPPYSHARE";a:7:{s:10:"attributes";a:3:{s:4:"file";R:970;s:6:"server";R:307;s:3:"url";R:182;}s:11:"filterChain";a:3:{i:0;a:2:{s:8:"callback";s:51:"s9e\\TextFormatter\\Plugins\\MediaEmbed\\Parser::scrape";s:6:"params";a:3:{s:3:"tag";N;i:0;a:1:{i:0;a:3:{i:0;s:5:"!/v/!";i:1;s:45:"!file=(?\'file\'\\w+)&amp;server=(?\'server\'\\d+)!";i:2;a:2:{i:0;s:4:"file";i:1;s:6:"server";}}}s:8:"cacheDir";N;}}i:1;R:207;i:2;R:331;}s:12:"nestingLimit";i:10;s:5:"rules";R:215;s:8:"tagLimit";i:1000;s:9:"bitNumber";i:23;s:7:"allowed";a:3:{i:0;i:65532;i:1;i:65535;i:2;i:65407;}}}}');
	}
	public static function getRenderer()
	{
		return \unserialize('O:44:"s9e\\TextFormatter\\Bundles\\MediaPack\\Renderer":2:{s:9:"' . "\0" . '*' . "\0" . 'params";a:8:{s:20:"AMAZON_ASSOCIATE_TAG";s:0:"";s:23:"AMAZON_ASSOCIATE_TAG_CA";s:0:"";s:23:"AMAZON_ASSOCIATE_TAG_DE";s:0:"";s:23:"AMAZON_ASSOCIATE_TAG_ES";s:0:"";s:23:"AMAZON_ASSOCIATE_TAG_FR";s:0:"";s:23:"AMAZON_ASSOCIATE_TAG_IT";s:0:"";s:23:"AMAZON_ASSOCIATE_TAG_JP";s:0:"";s:23:"AMAZON_ASSOCIATE_TAG_UK";s:0:"";}s:18:"metaElementsRegexp";s:22:"(<[eis]>[^<]*</[eis]>)";}');
	}
}

/*
* @package   s9e\TextFormatter
* @copyright Copyright (c) 2010-2017 The s9e Authors
* @license   http://www.opensource.org/licenses/mit-license.php The MIT License
*/
namespace s9e\TextFormatter;
use DOMDocument;
use DOMXPath;
abstract class Utils
{
	public static function getAttributeValues($xml, $tagName, $attrName)
	{
		$values = array();
		if (\strpos($xml, '<' . $tagName) !== \false)
		{
			$regexp = '(<' . \preg_quote($tagName) . '(?= )[^>]*? ' . \preg_quote($attrName) . '="([^"]*+))';
			\preg_match_all($regexp, $xml, $matches);
			foreach ($matches[1] as $value)
				$values[] = \html_entity_decode($value, \ENT_QUOTES, 'UTF-8');
		}
		return $values;
	}
	public static function encodeUnicodeSupplementaryCharacters($str)
	{
		return \preg_replace_callback(
			'([\\xF0-\\xF4]...)S',
			__CLASS__ . '::encodeUnicodeSupplementaryCharactersCallback',
			$str
		);
	}
	public static function removeFormatting($xml)
	{
		$dom   = self::loadXML($xml);
		$xpath = new DOMXPath($dom);
		foreach ($xpath->query('//e | //s') as $node)
			$node->parentNode->removeChild($node);
		return $dom->documentElement->textContent;
	}
	public static function removeTag($xml, $tagName, $nestingLevel = 0)
	{
		if (\strpos($xml, '<' . $tagName) === \false)
			return $xml;
		$dom   = self::loadXML($xml);
		$xpath = new DOMXPath($dom);
		$nodes = $xpath->query(\str_repeat('//' . $tagName, 1 + $nestingLevel));
		foreach ($nodes as $node)
			$node->parentNode->removeChild($node);
		return self::saveXML($dom);
	}
	public static function replaceAttributes($xml, $tagName, $callback)
	{
		$_self = __CLASS__;
		if (\strpos($xml, '<' . $tagName) === \false)
			return $xml;
		return \preg_replace_callback(
			'((<' . \preg_quote($tagName) . ')(?=[ />])[^>]*?(/?>))',
			function ($m) use ($callback, $_self)
			{
				return $m[1] . $_self::serializeAttributes($callback($_self::parseAttributes($m[0]))) . $m[2];
			},
			$xml
		);
	}
	protected static function encodeUnicodeSupplementaryCharactersCallback(array $m)
	{
		$utf8 = $m[0];
		$cp   = (\ord($utf8[0]) << 18) + (\ord($utf8[1]) << 12) + (\ord($utf8[2]) << 6) + \ord($utf8[3]) - 0x3C82080;
		return '&#' . $cp . ';';
	}
	protected static function loadXML($xml)
	{
		$flags = (\LIBXML_VERSION >= 20700) ? \LIBXML_COMPACT | \LIBXML_PARSEHUGE : 0;
		$dom = new DOMDocument;
		$dom->loadXML($xml, $flags);
		return $dom;
	}
	public static function parseAttributes($xml)
	{
		$attributes = array();
		if (\strpos($xml, '="') !== \false)
		{
			\preg_match_all('(([^ =]++)="([^"]*))S', $xml, $matches);
			foreach ($matches[1] as $i => $attrName)
				$attributes[$attrName] = \html_entity_decode($matches[2][$i], \ENT_QUOTES, 'UTF-8');
		}
		return $attributes;
	}
	protected static function saveXML(DOMDocument $dom)
	{
		return self::encodeUnicodeSupplementaryCharacters($dom->saveXML($dom->documentElement));
	}
	public static function serializeAttributes(array $attributes)
	{
		$xml = '';
		\ksort($attributes);
		foreach ($attributes as $attrName => $attrValue)
			$xml .= ' ' . \htmlspecialchars($attrName, \ENT_QUOTES) . '="' . \htmlspecialchars($attrValue, \ENT_COMPAT) . '"';
		$xml = \preg_replace('/\\r\\n?/', "\n", $xml);
		$xml = \preg_replace('/[\\x00-\\x08\\x0B\\x0C\\x0E-\\x1F]+/S', '', $xml);
		$xml = \str_replace("\n", '&#10;', $xml);
		return self::encodeUnicodeSupplementaryCharacters($xml);
	}
}