<?php

/*
* @package   s9e\TextFormatter
* @copyright Copyright (c) 2010-2017 The s9e Authors
* @license   http://www.opensource.org/licenses/mit-license.php The MIT License
*/
namespace s9e\TextFormatter;
use DOMDocument;
use InvalidArgumentException;
abstract class Renderer
{
	public $metaElementsRegexp = '(<[eis]>[^<]*</[eis]>)';
	protected $params = array();
	protected function loadXML($xml)
	{
		$this->checkUnsupported($xml);
		$flags = (\LIBXML_VERSION >= 20700) ? \LIBXML_COMPACT | \LIBXML_PARSEHUGE : 0;
		$dom = new DOMDocument;
		$dom->loadXML($xml, $flags);
		return $dom;
	}
	public function render($xml)
	{
		if (\substr($xml, 0, 3) === '<t>')
			return $this->renderPlainText($xml);
		else
			return $this->renderRichText(\preg_replace($this->metaElementsRegexp, '', $xml));
	}
	protected function renderPlainText($xml)
	{
		$html = \substr($xml, 3, -4);
		$html = \str_replace('<br/>', '<br>', $html);
		$html = $this->decodeSMP($html);
		return $html;
	}
	abstract protected function renderRichText($xml);
	public function getParameter($paramName)
	{
		return (isset($this->params[$paramName])) ? $this->params[$paramName] : '';
	}
	public function getParameters()
	{
		return $this->params;
	}
	public function setParameter($paramName, $paramValue)
	{
		$this->params[$paramName] = (string) $paramValue;
	}
	public function setParameters(array $params)
	{
		foreach ($params as $paramName => $paramValue)
			$this->setParameter($paramName, $paramValue);
	}
	protected function checkUnsupported($xml)
	{
		if (\strpos($xml, '<!') !== \false)
			throw new InvalidArgumentException('DTDs, CDATA nodes and comments are not allowed');
		if (\strpos($xml, '<?') !== \false)
			throw new InvalidArgumentException('Processing instructions are not allowed');
	}
	protected function decodeSMP($str)
	{
		if (\strpos($str, '&#') === \false)
			return $str;
		return \preg_replace_callback('(&#(?:x[0-9A-Fa-f]+|[0-9]+);)', __CLASS__ . '::decodeEntity', $str);
	}
	protected static function decodeEntity(array $m)
	{
		return \htmlspecialchars(\html_entity_decode($m[0], \ENT_QUOTES, 'UTF-8'), \ENT_COMPAT);
	}
}

/*
* @package   s9e\TextFormatter
* @copyright Copyright (c) 2010-2017 The s9e Authors
* @license   http://www.opensource.org/licenses/mit-license.php The MIT License
*/
namespace s9e\TextFormatter\Bundles\MediaPack;
class Renderer extends \s9e\TextFormatter\Renderer
{
	protected $params=array('AMAZON_ASSOCIATE_TAG'=>'','AMAZON_ASSOCIATE_TAG_CA'=>'','AMAZON_ASSOCIATE_TAG_DE'=>'','AMAZON_ASSOCIATE_TAG_ES'=>'','AMAZON_ASSOCIATE_TAG_FR'=>'','AMAZON_ASSOCIATE_TAG_IT'=>'','AMAZON_ASSOCIATE_TAG_JP'=>'','AMAZON_ASSOCIATE_TAG_UK'=>'');
	protected static $tagBranches=array('ABCNEWS'=>0,'AMAZON'=>1,'AUDIOBOOM'=>2,'AUDIOMACK'=>3,'BANDCAMP'=>4,'BBCNEWS'=>5,'BLAB'=>6,'BLEACHERREPORT'=>7,'BREAK'=>8,'BRIGHTCOVE'=>9,'CBSNEWS'=>10,'CNBC'=>11,'CNN'=>12,'CNNMONEY'=>13,'COLLEGEHUMOR'=>14,'COMEDYCENTRAL'=>15,'COUB'=>16,'DAILYMOTION'=>17,'DEMOCRACYNOW'=>18,'DUMPERT'=>19,'EIGHTTRACKS'=>20,'ESPN'=>21,'FACEBOOK'=>22,'FLICKR'=>23,'FORATV'=>24,'FOXNEWS'=>25,'FUNNYORDIE'=>26,'GAMESPOT'=>27,'GAMETRAILERS'=>28,'GETTY'=>29,'GFYCAT'=>30,'GIFS'=>31,'GIST'=>32,'GLOBALNEWS'=>33,'GOFUNDME'=>34,'GOOGLEDRIVE'=>35,'GOOGLEPLUS'=>36,'GOOGLESHEETS'=>37,'HEALTHGURU'=>38,'HUDL'=>39,'HULU'=>40,'HUMORTVNL'=>41,'IGN'=>42,'IMDB'=>43,'IMGUR'=>44,'INDIEGOGO'=>45,'INSTAGRAM'=>46,'INTERNETARCHIVE'=>47,'IZLESENE'=>48,'JWPLATFORM'=>49,'KHL'=>50,'KICKSTARTER'=>51,'KISSVIDEO'=>52,'LIBSYN'=>53,'LIVECAP'=>54,'LIVELEAK'=>55,'LIVESTREAM'=>56,'MAILRU'=>57,'MEDIUM'=>58,'METACAFE'=>59,'MIXCLOUD'=>60,'MLB'=>61,'MRCTV'=>62,'MSNBC'=>63,'NATGEOCHANNEL'=>64,'NATGEOVIDEO'=>65,'NBCNEWS'=>66,'NBCSPORTS'=>67,'NHL'=>68,'NPR'=>69,'NYTIMES'=>70,'ODDSHOT'=>71,'PASTEBIN'=>72,'PINTEREST'=>73,'PLAYSTV'=>74,'PODBEAN'=>75,'PREZI'=>76,'REDDIT'=>77,'RUTUBE'=>78,'SCRIBD'=>79,'SLIDESHARE'=>80,'SOUNDCLOUD'=>81,'SPORTSNET'=>82,'SPOTIFY'=>83,'STEAMSTORE'=>84,'STITCHER'=>85,'STRAWPOLL'=>86,'STREAMABLE'=>87,'TEAMCOCO'=>88,'TED'=>89,'THEATLANTIC'=>90,'THEGUARDIAN'=>91,'THEONION'=>92,'TINYPIC'=>93,'TMZ'=>94,'TRAILERADDICT'=>95,'TUMBLR'=>96,'TWITCH'=>97,'TWITTER'=>98,'USTREAM'=>99,'VBOX7'=>100,'VEOH'=>101,'VEVO'=>102,'VIAGAME'=>103,'VIDEODETECTIVE'=>104,'VIDEOMEGA'=>105,'VIDME'=>106,'VIMEO'=>107,'VINE'=>108,'VK'=>109,'VOCAROO'=>110,'VOX'=>111,'WASHINGTONPOST'=>112,'WSHH'=>113,'WSJ'=>114,'XBOXCLIPS'=>115,'XBOXDVR'=>116,'YAHOOSCREEN'=>117,'YOUKU'=>118,'YOUTUBE'=>119,'ZIPPYSHARE'=>120,'br'=>121,'e'=>122,'i'=>122,'s'=>122,'p'=>123);
	public function __sleep()
	{
		$props = \get_object_vars($this);
		unset($props['out'], $props['proc'], $props['source']);
		return \array_keys($props);
	}
	public function renderRichText($xml)
	{
		if (!isset($this->quickRenderingTest) || !\preg_match($this->quickRenderingTest, $xml))
			try
			{
				return $this->renderQuick($xml);
			}
			catch (\Exception $e)
			{
			}
		$dom = $this->loadXML($xml);
		$this->out = '';
		$this->at($dom->documentElement);
		return $this->out;
	}
	protected function at(\DOMNode $root)
	{
		if ($root->nodeType === 3)
			$this->out .= \htmlspecialchars($root->textContent,0);
		else
			foreach ($root->childNodes as $node)
				if (!isset(self::$tagBranches[$node->nodeName]))
					$this->at($node);
				else
				{
					$tb = self::$tagBranches[$node->nodeName];
					if($tb<62)if($tb<31){if($tb<16)if($tb<8)if($tb<4)if($tb===0)$this->out.='<div data-s9e-mediaembed="abcnews" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//abcnews.go.com/video/embed?id='.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';elseif($tb===1){$this->out.='<div data-s9e-mediaembed="amazon" style="display:inline-block;width:100%;max-width:120px"><div style="overflow:hidden;position:relative;padding-bottom:200%"><iframe allowfullscreen="" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//';if($node->getAttribute('tld')==='es'||$node->getAttribute('tld')==='it'){$this->out.='rcm-eu.amazon-adsystem.com/e/cm?lt1=_blank&amp;bc1=FFFFFF&amp;bg1=FFFFFF&amp;fc1=000000&amp;lc1=0000FF&amp;p=8&amp;l=as1&amp;f=ifr&amp;asins='.\htmlspecialchars($node->getAttribute('id'),2).'&amp;o=';if($node->getAttribute('tld')==='es')$this->out.='30';else$this->out.='29';$this->out.='&amp;t=';if($node->getAttribute('tld')==='es'&&!empty($this->params['AMAZON_ASSOCIATE_TAG_ES']))$this->out.=\htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG_ES'],2);elseif($node->getAttribute('tld')==='it'&&!empty($this->params['AMAZON_ASSOCIATE_TAG_IT']))$this->out.=\htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG_IT'],2);else$this->out.='_';}else{$this->out.='ws-';if($node->getAttribute('tld')==='jp')$this->out.='fe';elseif($node->hasAttribute('tld')&&(\strpos('desfrituk',$node->getAttribute('tld'))!==\false))$this->out.='eu';else$this->out.='na';$this->out.='.amazon-adsystem.com/widgets/q?ServiceVersion=20070822&amp;OneJS=1&amp;Operation=GetAdHtml&amp;MarketPlace=';if($node->hasAttribute('tld'))$this->out.=\htmlspecialchars(\strtr($node->getAttribute('tld'),'acdefijkprstu','ACDEFIJBPRSTG'),2);else$this->out.='US';$this->out.='&amp;ad_type=product_link&amp;tracking_id=';if($node->getAttribute('tld')==='ca'&&!empty($this->params['AMAZON_ASSOCIATE_TAG_CA']))$this->out.=\htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG_CA'],2);elseif($node->getAttribute('tld')==='de'&&!empty($this->params['AMAZON_ASSOCIATE_TAG_DE']))$this->out.=\htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG_DE'],2);elseif($node->getAttribute('tld')==='fr'&&!empty($this->params['AMAZON_ASSOCIATE_TAG_FR']))$this->out.=\htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG_FR'],2);elseif($node->getAttribute('tld')==='jp'&&!empty($this->params['AMAZON_ASSOCIATE_TAG_JP']))$this->out.=\htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG_JP'],2);elseif($node->getAttribute('tld')==='uk'&&!empty($this->params['AMAZON_ASSOCIATE_TAG_UK']))$this->out.=\htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG_UK'],2);elseif(!empty($this->params['AMAZON_ASSOCIATE_TAG']))$this->out.=\htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG'],2);else$this->out.='_';$this->out.='&amp;marketplace=amazon&amp;region=';if($node->hasAttribute('tld'))$this->out.=\htmlspecialchars(\strtr($node->getAttribute('tld'),'acdefijkprstu','ACDEFIJBPRSTG'),2);else$this->out.='US';$this->out.='&amp;asins='.\htmlspecialchars($node->getAttribute('id'),2).'&amp;show_border=true&amp;link_opens_in_new_window=true';}$this->out.='"></iframe></div></div>';}elseif($tb===2)$this->out.='<iframe data-s9e-mediaembed="audioboom" allowfullscreen="" scrolling="no" src="//audioboom.com/boos/'.\htmlspecialchars($node->getAttribute('id'),2).'/embed/v3" style="border:0;height:150px;max-width:700px;width:100%"></iframe>';elseif($node->getAttribute('mode')==='album')$this->out.='<iframe data-s9e-mediaembed="audiomack" allowfullscreen="" scrolling="no" src="//www.audiomack.com/embed4-album/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:340px;max-width:900px;width:100%"></iframe>';else$this->out.='<iframe data-s9e-mediaembed="audiomack" allowfullscreen="" scrolling="no" src="//www.audiomack.com/embed4/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:110px;max-width:900px;width:100%"></iframe>';elseif($tb===4){$this->out.='<div data-s9e-mediaembed="bandcamp" style="display:inline-block;width:100%;max-width:400px"><div style="overflow:hidden;position:relative;padding-bottom:100%"><iframe allowfullscreen="" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//bandcamp.com/EmbeddedPlayer/size=large/minimal=true/';if($node->hasAttribute('album_id')){$this->out.='album='.\htmlspecialchars($node->getAttribute('album_id'),2);if($node->hasAttribute('track_num'))$this->out.='/t='.\htmlspecialchars($node->getAttribute('track_num'),2);}else$this->out.='track='.\htmlspecialchars($node->getAttribute('track_id'),2);$this->out.='"></iframe></div></div>';}elseif($tb===5){$this->out.='<div data-s9e-mediaembed="bbcnews" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//www.bbc.com';if((\strpos($node->getAttribute('playlist'),'/news/')===0)&&(\strpos($node->getAttribute('playlist'),'A')!==\false))$this->out.=\htmlspecialchars(\strstr($node->getAttribute('playlist'),'A',\true),2);else$this->out.='/news/'.\htmlspecialchars($node->getAttribute('id'),2);$this->out.='/embed"></iframe></div></div>';}elseif($tb===6)$this->out.='<div data-s9e-mediaembed="blab" style="display:inline-block;width:100%;max-width:400px"><div style="overflow:hidden;position:relative;padding-bottom:100%"><iframe allowfullscreen="" scrolling="no" src="https://blab.im/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';else$this->out.='<div data-s9e-mediaembed="bleacherreport" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//bleacherreport.com/video_embed?id='.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';elseif($tb<12)if($tb===8)$this->out.='<div data-s9e-mediaembed="break" style="display:inline-block;width:100%;max-width:464px"><div style="overflow:hidden;position:relative;padding-bottom:60.344827586207%"><iframe allowfullscreen="" scrolling="no" src="//break.com/embed/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';elseif($tb===9)$this->out.='<div data-s9e-mediaembed="brightcove" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="https://link.brightcove.com/services/player/bcpid'.\htmlspecialchars($node->getAttribute('bcpid'),2).'?bckey='.\htmlspecialchars($node->getAttribute('bckey'),2).'&amp;bctid='.\htmlspecialchars($node->getAttribute('bctid'),2).'&amp;secureConnections=true&amp;secureHTMLConnections=true&amp;autoStart=false&amp;height=100%25&amp;width=100%25" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';elseif($tb===10){$this->out.='<div data-s9e-mediaembed="cbsnews" style="display:inline-block;width:100%;max-width:640px">';if($node->hasAttribute('pid'))$this->out.='<div style="overflow:hidden;position:relative;padding-bottom:62.1875%;padding-bottom:calc(56.25% + 38px)"><object data="//www.cbsnews.com/common/video/cbsnews_player.swf" style="height:100%;left:0;position:absolute;width:100%" type="application/x-shockwave-flash" typemustmatch=""><param name="allowfullscreen" value="true"><param name="flashvars" value="pType=embed&amp;si=254&amp;pid='.\htmlspecialchars($node->getAttribute('pid'),2);else$this->out.='<div style="overflow:hidden;position:relative;padding-bottom:62.5%;padding-bottom:calc(56.25% + 40px)"><object data="//i.i.cbsi.com/cnwk.1d/av/video/cbsnews/atlantis2/cbsnews_player_embed.swf" style="height:100%;left:0;position:absolute;width:100%" type="application/x-shockwave-flash" typemustmatch=""><param name="allowfullscreen" value="true"><param name="flashvars" value="si=254&amp;contentValue='.\htmlspecialchars($node->getAttribute('id'),2);$this->out.='"></object></div>';$this->out.='</div>';}else$this->out.='<div data-s9e-mediaembed="cnbc" style="display:inline-block;width:100%;max-width:400px"><div style="overflow:hidden;position:relative;padding-bottom:95%"><object data="//plus.cnbc.com/rssvideosearch/action/player/id/'.\htmlspecialchars($node->getAttribute('id'),2).'/code/cnbcplayershare" style="height:100%;left:0;position:absolute;width:100%" type="application/x-shockwave-flash" typemustmatch=""><param name="allowfullscreen" value="true"></object></div></div>';elseif($tb===12)$this->out.='<div data-s9e-mediaembed="cnn" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//edition.cnn.com/video/api/embed.html#/video/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';elseif($tb===13)$this->out.='<div data-s9e-mediaembed="cnnmoney" style="display:inline-block;width:100%;max-width:560px"><div style="overflow:hidden;position:relative;padding-bottom:64.285714285714%"><iframe allowfullscreen="" scrolling="no" src="//money.cnn.com/.element/ssi/video/7.0/players/embed.player.html?videoid=video/'.\htmlspecialchars($node->getAttribute('id'),2).'&amp;width=560&amp;height=360" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';elseif($tb===14)$this->out.='<div data-s9e-mediaembed="collegehumor" style="display:inline-block;width:100%;max-width:600px"><div style="overflow:hidden;position:relative;padding-bottom:61.5%"><iframe allowfullscreen="" scrolling="no" src="//www.collegehumor.com/e/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';else$this->out.='<div data-s9e-mediaembed="comedycentral" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//media.mtvnservices.com/embed/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';elseif($tb<24)if($tb<20)if($tb===16)$this->out.='<div data-s9e-mediaembed="coub" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//coub.com/embed/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';elseif($tb===17)$this->out.='<div data-s9e-mediaembed="dailymotion" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.dailymotion.com/embed/video/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';elseif($tb===18){$this->out.='<div data-s9e-mediaembed="democracynow" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//www.democracynow.org/embed/';if((\strpos($node->getAttribute('id'),'/headlines')!==\false))$this->out.='headlines/'.\htmlspecialchars(\strstr($node->getAttribute('id'),'/headlines',\true),2);elseif((\strpos($node->getAttribute('id'),'2')===0))$this->out.='story/'.\htmlspecialchars($node->getAttribute('id'),2);elseif((\strpos($node->getAttribute('id'),'shows/')===0))$this->out.='show/'.\htmlspecialchars(\substr(\strstr($node->getAttribute('id'),'/'),1),2);else$this->out.=\htmlspecialchars($node->getAttribute('id'),2);$this->out.='"></iframe></div></div>';}else$this->out.='<div data-s9e-mediaembed="dumpert" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.dumpert.nl/embed/'.\htmlspecialchars(\strtr($node->getAttribute('id'),'_','/'),2).'/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';elseif($tb===20)$this->out.='<div data-s9e-mediaembed="eighttracks" style="display:inline-block;width:100%;max-width:400px"><div style="overflow:hidden;position:relative;padding-bottom:100%"><iframe allowfullscreen="" scrolling="no" src="//8tracks.com/mixes/'.\htmlspecialchars($node->getAttribute('id'),2).'/player_v3_universal" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';elseif($tb===21)$this->out.='<div data-s9e-mediaembed="espn" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.espn.com/core/video/iframe?id='.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';elseif($tb===22)$this->out.='<iframe data-s9e-mediaembed="facebook" allowfullscreen="" onload="var a=Math.random();window.addEventListener(\'message\',function(b){if(b.data.id==a)style.height=b.data.height+\'px\'});contentWindow.postMessage(\'s9e:\'+a,\'https://s9e.github.io\')" scrolling="no" src="https://s9e.github.io/iframe/facebook.min.html#'.\htmlspecialchars($node->getAttribute('type').$node->getAttribute('id'),2).'" style="border:0;height:360px;max-width:640px;width:100%"></iframe>';else$this->out.='<div data-s9e-mediaembed="flickr" style="display:inline-block;width:100%;max-width:500px"><div style="overflow:hidden;position:relative;padding-bottom:100%"><iframe allowfullscreen="" scrolling="no" src="https://www.flickr.com/photos/_/'.\htmlspecialchars($node->getAttribute('id'),2).'/player/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';elseif($tb<28)if($tb===24)$this->out.='<div data-s9e-mediaembed="foratv" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//library.fora.tv/embed?id='.\htmlspecialchars($node->getAttribute('id'),2).'&amp;type=c" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';elseif($tb===25)$this->out.='<div data-s9e-mediaembed="foxnews" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//video.foxnews.com/v/video-embed.html?video_id='.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';elseif($tb===26)$this->out.='<div data-s9e-mediaembed="funnyordie" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.funnyordie.com/embed/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';else$this->out.='<div data-s9e-mediaembed="gamespot" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:62.5%"><iframe allowfullscreen="" scrolling="no" src="//www.gamespot.com/videos/embed/'.\htmlspecialchars($node->getAttribute('id'),2).'/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';elseif($tb===28){$this->out.='<div data-s9e-mediaembed="gametrailers" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="';if((\strpos($node->getAttribute('id'),'mgid:')===0))$this->out.='//media.mtvnservices.com/embed/'.\htmlspecialchars($node->getAttribute('id'),2);else$this->out.='//embed.gametrailers.com/embed/'.\htmlspecialchars($node->getAttribute('id'),2).'?embed=1&amp;suppressBumper=1';$this->out.='"></iframe></div></div>';}elseif($tb===29){$this->out.='<div data-s9e-mediaembed="getty" style="display:inline-block;width:100%;max-width:'.\htmlspecialchars($node->getAttribute('width'),2).'px"><div style="overflow:hidden;position:relative;';if($node->getAttribute('width')>0)$this->out.='padding-bottom:'.\htmlspecialchars(100*($node->getAttribute('height')+49)/$node->getAttribute('width'),2).'%;padding-bottom:calc('.\htmlspecialchars(100*$node->getAttribute('height')/$node->getAttribute('width'),2).'% + 49px)';$this->out.='"><iframe allowfullscreen="" scrolling="no" src="//embed.gettyimages.com/embed/'.\htmlspecialchars($node->getAttribute('id'),2).'?et='.\htmlspecialchars($node->getAttribute('et'),2).'&amp;sig='.\htmlspecialchars($node->getAttribute('sig'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';}else{$this->out.='<div data-s9e-mediaembed="gfycat" style="display:inline-block;width:100%;max-width:'.\htmlspecialchars($node->getAttribute('width'),2).'px"><div style="overflow:hidden;position:relative;';if($node->getAttribute('width')>0)$this->out.='padding-bottom:'.\htmlspecialchars(100*$node->getAttribute('height')/$node->getAttribute('width'),2).'%';$this->out.='"><iframe allowfullscreen="" scrolling="no" src="//gfycat.com/iframe/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';}}elseif($tb<47)if($tb<39)if($tb<35)if($tb===31){$this->out.='<div data-s9e-mediaembed="gifs" style="display:inline-block;width:100%;max-width:'.\htmlspecialchars($node->getAttribute('width'),2).'px"><div style="overflow:hidden;position:relative;';if($node->getAttribute('width')>0)$this->out.='padding-bottom:'.\htmlspecialchars(100*$node->getAttribute('height')/$node->getAttribute('width'),2).'%';$this->out.='"><iframe allowfullscreen="" scrolling="no" src="//gifs.com/embed/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';}elseif($tb===32)$this->out.='<iframe data-s9e-mediaembed="gist" allowfullscreen="" onload="var a=Math.random();window.addEventListener(\'message\',function(b){if(b.data.id==a)style.height=b.data.height+\'px\'});contentWindow.postMessage(\'s9e:\'+a,\'https://s9e.github.io\')" scrolling="" src="https://s9e.github.io/iframe/gist.min.html#'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:180px;width:100%"></iframe>';elseif($tb===33)$this->out.='<div data-s9e-mediaembed="globalnews" style="display:inline-block;width:100%;max-width:560px"><div style="overflow:hidden;position:relative;padding-bottom:67.321428571429%"><iframe allowfullscreen="" scrolling="no" src="//globalnews.ca/video/embed/'.\htmlspecialchars($node->getAttribute('id'),2).'/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';else$this->out.='<div data-s9e-mediaembed="gofundme" style="display:inline-block;width:100%;max-width:258px"><div style="overflow:hidden;position:relative;padding-bottom:131.00775193798%"><object data="//funds.gofundme.com/Widgetflex.swf" style="height:100%;left:0;position:absolute;width:100%" type="application/x-shockwave-flash" typemustmatch=""><param name="allowfullscreen" value="true"><param name="flashvars" value="page='.\htmlspecialchars($node->getAttribute('id'),2).'"></object></div></div>';elseif($tb===35)$this->out.='<div data-s9e-mediaembed="googledrive" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:75%"><iframe allowfullscreen="" scrolling="no" src="//drive.google.com/file/d/'.\htmlspecialchars($node->getAttribute('id'),2).'/preview" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';elseif($tb===36){$this->out.='<iframe data-s9e-mediaembed="googleplus" allowfullscreen="" onload="var a=Math.random();window.addEventListener(\'message\',function(b){if(b.data.id==a)style.height=b.data.height+\'px\'});contentWindow.postMessage(\'s9e:\'+a,\'https://s9e.github.io\')" scrolling="no" style="border:0;height:240px;max-width:450px;width:100%" src="https://s9e.github.io/iframe/googleplus.min.html#';if($node->hasAttribute('oid'))$this->out.=\htmlspecialchars($node->getAttribute('oid'),2);else$this->out.='+'.\htmlspecialchars($node->getAttribute('name'),2);$this->out.='/posts/'.\htmlspecialchars($node->getAttribute('pid'),2).'"></iframe>';}elseif($tb===37)$this->out.='<iframe data-s9e-mediaembed="googlesheets" allowfullscreen="" scrolling="no" src="https://docs.google.com/spreadsheet/ccc?key='.\htmlspecialchars($node->getAttribute('id'),2).'&amp;widget=true&amp;headers=false&amp;rm=minimal#gid='.\htmlspecialchars($node->getAttribute('gid'),2).'" style="border:0;height:500px;resize:vertical;width:100%"></iframe>';else$this->out.='<div data-s9e-mediaembed="healthguru" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.healthguru.com/embed/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';elseif($tb<43)if($tb===39)$this->out.='<div data-s9e-mediaembed="hudl" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.hudl.com/embed/athlete/'.\htmlspecialchars($node->getAttribute('athlete'),2).'/highlights/'.\htmlspecialchars($node->getAttribute('highlight'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';elseif($tb===40)$this->out.='<div data-s9e-mediaembed="hulu" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="https://secure.hulu.com/embed/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';elseif($tb===41)$this->out.='<div data-s9e-mediaembed="humortvnl" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//humortv.vara.nl/embed.'.\htmlspecialchars($node->getAttribute('id'),2).'.html" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';else$this->out.='<div data-s9e-mediaembed="ign" style="display:inline-block;width:100%;max-width:468px"><div style="overflow:hidden;position:relative;padding-bottom:56.196581196581%"><iframe allowfullscreen="" scrolling="no" src="//widgets.ign.com/video/embed/content.html?url='.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';elseif($tb===43)$this->out.='<div data-s9e-mediaembed="imdb" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.imdb.com/video/imdb/vi'.\htmlspecialchars($node->getAttribute('id'),2).'/imdb/embed?autoplay=false&amp;width=640" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';elseif($tb===44){$this->out.='<iframe data-s9e-mediaembed="imgur" allowfullscreen="" onload="var b=Math.random();window.addEventListener(\'message\',function(a){a.data.id==b&amp;&amp;(style.height=a.data.height+\'px\',style.width=a.data.width+\'px\')});contentWindow.postMessage(\'s9e:\'+b,\'https://s9e.github.io\')" scrolling="no" style="border:0;height:450px;width:568px" src="https://s9e.github.io/iframe/imgur.min.html#';if($node->getAttribute('type')==='album'&&!((\strpos($node->getAttribute('id'),'a/')===0)))$this->out.='a/';$this->out.=\htmlspecialchars($node->getAttribute('id'),2).'"></iframe>';}elseif($tb===45)$this->out.='<div data-s9e-mediaembed="indiegogo" style="display:inline-block;width:100%;max-width:222px"><div style="overflow:hidden;position:relative;padding-bottom:200.45045045045%"><iframe allowfullscreen="" scrolling="no" src="//www.indiegogo.com/project/'.\htmlspecialchars($node->getAttribute('id'),2).'/embedded" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';else$this->out.='<iframe data-s9e-mediaembed="instagram" allowfullscreen="" onload="var a=Math.random();window.addEventListener(\'message\',function(b){if(b.data.id==a)style.height=b.data.height+\'px\'});contentWindow.postMessage(\'s9e:\'+a,\'https://s9e.github.io\')" scrolling="no" src="https://s9e.github.io/iframe/instagram.min.html#'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:640px;max-width:640px;width:100%"></iframe>';elseif($tb<55)if($tb<51)if($tb===47){$this->out.='<div data-s9e-mediaembed="internetarchive" style="display:inline-block;width:100%;max-width:'.\htmlspecialchars($node->getAttribute('width'),2).'px"><div style="overflow:hidden;position:relative;';if($node->getAttribute('width')>0)$this->out.='padding-bottom:'.\htmlspecialchars(100*$node->getAttribute('height')/$node->getAttribute('width'),2).'%';$this->out.='"><iframe allowfullscreen="" scrolling="no" src="https://archive.org/embed/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';}elseif($tb===48)$this->out.='<div data-s9e-mediaembed="izlesene" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.izlesene.com/embedplayer/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';elseif($tb===49)$this->out.='<div data-s9e-mediaembed="jwplatform" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//content.jwplatform.com/players/'.\htmlspecialchars($node->getAttribute('id'),2).'.html" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';else$this->out.='<div data-s9e-mediaembed="khl" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//video.khl.ru/iframe/feed/start/'.\htmlspecialchars($node->getAttribute('id'),2).'?type_id=18&amp;width=560&amp;height=315" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';elseif($tb===51)if($node->hasAttribute('video'))$this->out.='<div data-s9e-mediaembed="kickstarter" style="display:inline-block;width:100%;max-width:480px"><div style="overflow:hidden;position:relative;padding-bottom:75%"><iframe allowfullscreen="" scrolling="no" src="//www.kickstarter.com/projects/'.\htmlspecialchars($node->getAttribute('id'),2).'/widget/video.html" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';else$this->out.='<div data-s9e-mediaembed="kickstarter" style="display:inline-block;width:100%;max-width:220px"><div style="overflow:hidden;position:relative;padding-bottom:190.90909090909%"><iframe allowfullscreen="" scrolling="no" src="//www.kickstarter.com/projects/'.\htmlspecialchars($node->getAttribute('id'),2).'/widget/card.html" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';elseif($tb===52)$this->out.='<div data-s9e-mediaembed="kissvideo" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.kissvideo.click/embed.php?vid='.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';elseif($tb===53)$this->out.='<iframe data-s9e-mediaembed="libsyn" allowfullscreen="" scrolling="no" src="//html5-player.libsyn.com/embed/episode/id/'.\htmlspecialchars($node->getAttribute('id'),2).'/height/45/width/900/theme/standard/direction/no/autoplay/no/autonext/no/thumbnail/no/preload/no/no_addthis/no/" style="border:0;height:45px;max-width:900px;width:100%"></iframe>';else$this->out.='<div data-s9e-mediaembed="livecap" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="https://www.livecap.tv/s/embed/'.\htmlspecialchars($node->getAttribute('channel'),2).'/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';elseif($tb<59)if($tb===55)$this->out.='<div data-s9e-mediaembed="liveleak" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.liveleak.com/ll_embed?i='.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';elseif($tb===56){$this->out.='<div data-s9e-mediaembed="livestream" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="';if($node->hasAttribute('clip_id'))$this->out.='//cdn.livestream.com/embed/'.\htmlspecialchars($node->getAttribute('channel'),2).'?layout=4&amp;autoplay=false&amp;clip='.\htmlspecialchars($node->getAttribute('clip_id'),2);else{$this->out.='//livestream.com/accounts/'.\htmlspecialchars($node->getAttribute('account_id'),2).'/events/'.\htmlspecialchars($node->getAttribute('event_id'),2);if($node->hasAttribute('video_id'))$this->out.='/videos/'.\htmlspecialchars($node->getAttribute('video_id'),2);$this->out.='/player?autoPlay=false';}$this->out.='"></iframe></div></div>';}elseif($tb===57)$this->out.='<div data-s9e-mediaembed="mailru" style="display:inline-block;width:100%;max-width:560px"><div style="overflow:hidden;position:relative;padding-bottom:61.071428571429%"><iframe allowfullscreen="" scrolling="no" src="//videoapi.my.mail.ru/videos/embed/'.\htmlspecialchars($node->getAttribute('id'),2).'.html" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';else$this->out.='<iframe data-s9e-mediaembed="medium" allowfullscreen="" onload="window.addEventListener(\'message\',function(a){a=a.data.split(\'::\');\'m\'===a[0]&amp;&amp;0&lt;src.indexOf(a[1])&amp;&amp;a[2]&amp;&amp;(style.height=a[2]+\'px\')})" scrolling="no" src="https://api.medium.com/embed?type=story&amp;path=%2F%2F'.\htmlspecialchars($node->getAttribute('id'),2).'&amp;id='.\htmlspecialchars(\strtr($node->getAttribute('id'),'abcdef','111111'),2).'" style="border:1px solid;border-color:#eee #ddd #bbb;border-radius:5px;box-shadow:rgba(0,0,0,.15) 0 1px 3px;height:400px;max-width:400px;width:100%"></iframe>';elseif($tb===59)$this->out.='<div data-s9e-mediaembed="metacafe" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.metacafe.com/embed/'.\htmlspecialchars($node->getAttribute('id'),2).'/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';elseif($tb===60)$this->out.='<div data-s9e-mediaembed="mixcloud" style="display:inline-block;width:100%;max-width:400px"><div style="overflow:hidden;position:relative;padding-bottom:100%"><iframe allowfullscreen="" scrolling="no" src="//www.mixcloud.com/widget/iframe/?feed=http%3A%2F%2Fwww.mixcloud.com%2F'.\htmlspecialchars($node->getAttribute('id'),2).'%2F&amp;embed_type=widget_standard" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';else$this->out.='<div data-s9e-mediaembed="mlb" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//m.mlb.com/shared/video/embed/embed.html?content_id='.\htmlspecialchars($node->getAttribute('id'),2).'&amp;width=640&amp;height=360" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';elseif($tb<93)if($tb<78)if($tb<70)if($tb<66)if($tb===62)$this->out.='<div data-s9e-mediaembed="mrctv" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="https://www.mrctv.org/embed/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';elseif($tb===63)$this->out.='<div data-s9e-mediaembed="msnbc" style="display:inline-block;width:100%;max-width:635px"><div style="overflow:hidden;position:relative;padding-bottom:69.291338582677%"><iframe allowfullscreen="" scrolling="no" src="//player.theplatform.com/p/2E2eJC/EmbeddedOffSite?guid='.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';elseif($tb===64)$this->out.='<div data-s9e-mediaembed="natgeochannel" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//channel.nationalgeographic.com/'.\htmlspecialchars($node->getAttribute('id'),2).'/embed/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';else$this->out.='<div data-s9e-mediaembed="natgeovideo" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//player.d.nationalgeographic.com/players/ngsvideo/share/?guid='.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';elseif($tb===66)$this->out.='<div data-s9e-mediaembed="nbcnews" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.nbcnews.com/widget/video-embed/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';elseif($tb===67)$this->out.='<div data-s9e-mediaembed="nbcsports" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//vplayer.nbcsports.com/p/BxmELC/nbcsports_embed/select/media/'.\htmlspecialchars($node->getAttribute('id'),2).'?parentUrl=" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';elseif($tb===68){$this->out.='<div data-s9e-mediaembed="nhl" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="';if($node->hasAttribute('c')||$node->hasAttribute('t')){$this->out.='//www.nhl.com/video/embed';if($node->hasAttribute('t'))$this->out.='/t-'.\htmlspecialchars($node->getAttribute('t'),2);if($node->hasAttribute('c'))$this->out.='/c-'.\htmlspecialchars($node->getAttribute('c'),2);$this->out.='?autostart=false';}else$this->out.='//video.nhl.com/videocenter/embed?playlist='.\htmlspecialchars($node->getAttribute('id'),2);$this->out.='"></iframe></div></div>';}else$this->out.='<iframe data-s9e-mediaembed="npr" allowfullscreen="" scrolling="no" src="//www.npr.org/player/embed/'.\htmlspecialchars($node->getAttribute('i'),2).'/'.\htmlspecialchars($node->getAttribute('m'),2).'" style="border:0;height:228px;max-width:800px;width:100%"></iframe>';elseif($tb<74)if($tb===70)$this->out.='<div data-s9e-mediaembed="nytimes" style="display:inline-block;width:100%;max-width:585px"><div style="overflow:hidden;position:relative;padding-bottom:68.376068376068%"><iframe allowfullscreen="" scrolling="no" src="//graphics8.nytimes.com/video/players/offsite/index.html?videoId='.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';elseif($tb===71)$this->out.='<div data-s9e-mediaembed="oddshot" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//oddshot.tv/shot/'.\htmlspecialchars($node->getAttribute('id'),2).'/embed" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';elseif($tb===72)$this->out.='<iframe data-s9e-mediaembed="pastebin" allowfullscreen="" scrolling="" src="//pastebin.com/embed_iframe.php?i='.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:300px;resize:vertical;width:100%"></iframe>';else{$this->out.='<iframe data-s9e-mediaembed="pinterest" allowfullscreen="" onload="var a=Math.random();window.addEventListener(\'message\',function(b){if(b.data.id==a)style.height=b.data.height+\'px\'});contentWindow.postMessage(\'s9e:\'+a,\'https://s9e.github.io\')" scrolling="no" src="https://s9e.github.io/iframe/pinterest.min.html#'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:360px;max-width:';if((\strpos($node->getAttribute('id'),'/')!==\false))$this->out.='730';else$this->out.='345';$this->out.='px;width:100%"></iframe>';}elseif($tb===74)$this->out.='<div data-s9e-mediaembed="playstv" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//plays.tv/embeds/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';elseif($tb===75)$this->out.='<iframe data-s9e-mediaembed="podbean" allowfullscreen="" scrolling="no" src="//www.podbean.com/media/player/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100px;max-width:900px;width:100%"></iframe>';elseif($tb===76)$this->out.='<div data-s9e-mediaembed="prezi" style="display:inline-block;width:100%;max-width:550px"><div style="overflow:hidden;position:relative;padding-bottom:72.727272727273%"><iframe allowfullscreen="" scrolling="no" src="//prezi.com/embed/'.\htmlspecialchars($node->getAttribute('id'),2).'/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';else$this->out.='<iframe data-s9e-mediaembed="reddit" allowfullscreen="" onload="var a=Math.random();window.addEventListener(\'message\',function(b){if(b.data.id==a)style.height=b.data.height+\'px\'});contentWindow.postMessage(\'s9e:\'+a,\'https://s9e.github.io\')" scrolling="no" src="https://s9e.github.io/iframe/reddit.min.html#'.\htmlspecialchars($node->getAttribute('path'),2).'" style="border:0;height:165px;max-width:800px;width:100%"></iframe>';elseif($tb<86)if($tb<82)if($tb===78)$this->out.='<div data-s9e-mediaembed="rutube" style="display:inline-block;width:100%;max-width:720px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//rutube.ru/play/embed/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';elseif($tb===79)$this->out.='<iframe data-s9e-mediaembed="scribd" allowfullscreen="" scrolling="no" src="https://www.scribd.com/embeds/'.\htmlspecialchars($node->getAttribute('id'),2).'/content?view_mode=scroll&amp;show_recommendations=false" style="border:0;height:500px;resize:vertical;width:100%"></iframe>';elseif($tb===80)$this->out.='<div data-s9e-mediaembed="slideshare" style="display:inline-block;width:100%;max-width:427px"><div style="overflow:hidden;position:relative;padding-bottom:83.372365339578%"><iframe allowfullscreen="" scrolling="no" src="//www.slideshare.net/slideshow/embed_code/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';else{$this->out.='<iframe data-s9e-mediaembed="soundcloud" allowfullscreen="" scrolling="no" src="https://w.soundcloud.com/player/?url=';if($node->hasAttribute('playlist_id'))$this->out.='https%3A//api.soundcloud.com/playlists/'.\htmlspecialchars($node->getAttribute('playlist_id'),2);elseif($node->hasAttribute('track_id'))$this->out.='https%3A//api.soundcloud.com/tracks/'.\htmlspecialchars($node->getAttribute('track_id'),2).'&amp;secret_token='.\htmlspecialchars($node->getAttribute('secret_token'),2);else{if((\strpos($node->getAttribute('id'),'://')===\false))$this->out.='https%3A//soundcloud.com/';$this->out.=\htmlspecialchars($node->getAttribute('id'),2);}$this->out.='" style="border:0;height:';if($node->hasAttribute('playlist_id')||(\strpos($node->getAttribute('id'),'/sets/')!==\false))$this->out.='450';else$this->out.='166';$this->out.='px;max-width:900px;width:100%"></iframe>';}elseif($tb===82)$this->out.='<div data-s9e-mediaembed="sportsnet" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="https://images.rogersdigitalmedia.com/video_service.php?videoId='.\htmlspecialchars($node->getAttribute('id'),2).'&amp;playerKey=AQ~~,AAAAAGWRwLc~,cRCmKE8Utf7OFWP38XQcokFZ80fR-u_y&amp;autoStart=false&amp;width=100%25&amp;height=100%25" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';elseif($tb===83){$this->out.='<div data-s9e-mediaembed="spotify" style="display:inline-block;width:100%;max-width:400px"><div style="overflow:hidden;position:relative;padding-bottom:120%"><iframe allowfullscreen="" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="https://embed.spotify.com/?view=coverart&amp;uri=';if($node->hasAttribute('uri'))$this->out.=\htmlspecialchars($node->getAttribute('uri'),2);else$this->out.='spotify:'.\htmlspecialchars(\strtr($node->getAttribute('path'),'/',':'),2);$this->out.='"></iframe></div></div>';}elseif($tb===84)$this->out.='<iframe data-s9e-mediaembed="steamstore" allowfullscreen="" scrolling="no" src="//store.steampowered.com/widget/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:190px;max-width:900px;width:100%"></iframe>';else$this->out.='<iframe data-s9e-mediaembed="stitcher" allowfullscreen="" scrolling="no" src="//app.stitcher.com/splayer/f/'.\htmlspecialchars($node->getAttribute('fid'),2).'/'.\htmlspecialchars($node->getAttribute('eid'),2).'" style="border:0;height:150px;max-width:900px;width:100%"></iframe>';elseif($tb<90){if($tb===86)$this->out.='<div data-s9e-mediaembed="strawpoll" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="" src="//www.strawpoll.me/embed_1/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';elseif($tb===87)$this->out.='<div data-s9e-mediaembed="streamable" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//streamable.com/e/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';elseif($tb===88)$this->out.='<div data-s9e-mediaembed="teamcoco" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:64.84375%"><iframe allowfullscreen="" scrolling="no" src="//teamcoco.com/embed/v/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';else{$this->out.='<div data-s9e-mediaembed="ted" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//embed.ted.com/'.\htmlspecialchars($node->getAttribute('id'),2);if((\strpos($node->getAttribute('id'),'.html')===\false))$this->out.='.html';$this->out.='"></iframe></div></div>';}}elseif($tb===90)$this->out.='<div data-s9e-mediaembed="theatlantic" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.theatlantic.com/video/iframe/'.\htmlspecialchars($node->getAttribute('id'),2).'/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';elseif($tb===91)$this->out.='<div data-s9e-mediaembed="theguardian" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//embed.theguardian.com/embed/video/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';else$this->out.='<div data-s9e-mediaembed="theonion" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.theonion.com/video_embed/?id='.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';elseif($tb<109)if($tb<101)if($tb<97)if($tb===93)$this->out.='<div data-s9e-mediaembed="tinypic" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:60.9375%;padding-bottom:calc(56.25% + 30px)"><object data="//tinypic.com/player.swf?file='.\htmlspecialchars($node->getAttribute('id'),2).'&amp;s='.\htmlspecialchars($node->getAttribute('s'),2).'" style="height:100%;left:0;position:absolute;width:100%" type="application/x-shockwave-flash" typemustmatch=""><param name="allowfullscreen" value="true"></object></div></div>';elseif($tb===94)$this->out.='<div data-s9e-mediaembed="tmz" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.kaltura.com/index.php/kwidget/cache_st/133592691/wid/_591531/partner_id/591531/uiconf_id/9071262/entry_id/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';elseif($tb===95)$this->out.='<div data-s9e-mediaembed="traileraddict" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//v.traileraddict.com/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';else$this->out.='<iframe data-s9e-mediaembed="tumblr" allowfullscreen="" onload="var a=Math.random();window.addEventListener(\'message\',function(b){if(b.data.id==a)style.height=b.data.height+\'px\'});contentWindow.postMessage(\'s9e:\'+a,\'https://s9e.github.io\')" scrolling="no" src="https://s9e.github.io/iframe/tumblr.min.html#'.\htmlspecialchars($node->getAttribute('key'),2).'/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:180px;max-width:520px;width:100%"></iframe>';elseif($tb===97){$this->out.='<div data-s9e-mediaembed="twitch" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="';if($node->hasAttribute('clip_id'))$this->out.='//clips.twitch.tv/embed?autoplay=false&amp;clip='.\htmlspecialchars($node->getAttribute('channel'),2).'/'.\htmlspecialchars($node->getAttribute('clip_id'),2);else{$this->out.='//player.twitch.tv/?autoplay=false&amp;';if($node->hasAttribute('archive_id'))$this->out.='video=a'.\htmlspecialchars($node->getAttribute('archive_id'),2);elseif($node->hasAttribute('chapter_id'))$this->out.='video=c'.\htmlspecialchars($node->getAttribute('chapter_id'),2);elseif($node->hasAttribute('video_id'))$this->out.='video=v'.\htmlspecialchars($node->getAttribute('video_id'),2);else$this->out.='channel='.\htmlspecialchars($node->getAttribute('channel'),2);if($node->hasAttribute('t'))$this->out.='&amp;time='.\htmlspecialchars($node->getAttribute('t'),2);}$this->out.='"></iframe></div></div>';}elseif($tb===98)$this->out.='<iframe data-s9e-mediaembed="twitter" allowfullscreen="" onload="var a=Math.random();window.addEventListener(\'message\',function(b){if(b.data.id==a)style.height=b.data.height+\'px\'});contentWindow.postMessage(\'s9e:\'+a,\'https://s9e.github.io\')" scrolling="no" src="https://s9e.github.io/iframe/twitter.min.html#'.\htmlspecialchars($node->getAttribute('id'),2).'" style="background:url(https://abs.twimg.com/favicons/favicon.ico) no-repeat 50% 50%;border:0;height:186px;max-width:500px;width:100%"></iframe>';elseif($tb===99){$this->out.='<div data-s9e-mediaembed="ustream" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%">';if($node->hasAttribute('vid'))$this->out.='<iframe allowfullscreen="" scrolling="no" src="//www.ustream.tv/embed/recorded/'.\htmlspecialchars($node->getAttribute('vid'),2);else$this->out.='<iframe allowfullscreen="" scrolling="no" src="//www.ustream.tv/embed/'.\htmlspecialchars($node->getAttribute('cid'),2);$this->out.='?html5ui" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe>';$this->out.='</div></div>';}else$this->out.='<div data-s9e-mediaembed="vbox7" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//vbox7.com/emb/external.php?vid='.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';elseif($tb<105)if($tb===101)$this->out.='<div data-s9e-mediaembed="veoh" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:62.5%;padding-bottom:calc(56.25% + 40px)"><object data="//www.veoh.com/swf/webplayer/WebPlayer.swf?version=AFrontend.5.7.0.1509&amp;permalinkId=v'.\htmlspecialchars($node->getAttribute('id'),2).'&amp;player=videodetailsembedded&amp;videoAutoPlay=0&amp;id=anonymous" style="height:100%;left:0;position:absolute;width:100%" type="application/x-shockwave-flash" typemustmatch=""><param name="allowfullscreen" value="true"></object></div></div>';elseif($tb===102)$this->out.='<div data-s9e-mediaembed="vevo" style="display:inline-block;width:100%;max-width:575px"><div style="overflow:hidden;position:relative;padding-bottom:56.347826086957%"><iframe allowfullscreen="" scrolling="no" src="//cache.vevo.com/m/html/embed.html?video='.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';elseif($tb===103)$this->out.='<div data-s9e-mediaembed="viagame" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:61.25%"><iframe allowfullscreen="" scrolling="no" src="//www.viagame.com/embed/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';else$this->out.='<div data-s9e-mediaembed="videodetective" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.videodetective.com/embed/video/?options=false&amp;autostart=false&amp;playlist=none&amp;publishedid='.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';elseif($tb===105)$this->out.='<div data-s9e-mediaembed="videomega" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//videomega.tv/iframe.php?ref='.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';elseif($tb===106){$this->out.='<div data-s9e-mediaembed="vidme" style="display:inline-block;width:100%;max-width:'.\htmlspecialchars($node->getAttribute('width'),2).'px"><div style="overflow:hidden;position:relative;';if($node->getAttribute('width')>0)$this->out.='padding-bottom:'.\htmlspecialchars(100*$node->getAttribute('height')/$node->getAttribute('width'),2).'%';$this->out.='"><iframe allowfullscreen="" scrolling="no" src="https://vid.me/e/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';}elseif($tb===107)$this->out.='<div data-s9e-mediaembed="vimeo" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//player.vimeo.com/video/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';else$this->out.='<div data-s9e-mediaembed="vine" style="display:inline-block;width:100%;max-width:480px"><div style="overflow:hidden;position:relative;padding-bottom:100%"><iframe allowfullscreen="" scrolling="no" src="https://vine.co/v/'.\htmlspecialchars($node->getAttribute('id'),2).'/embed/simple?audio=1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';elseif($tb<117)if($tb<113)if($tb===109)$this->out.='<div data-s9e-mediaembed="vk" style="display:inline-block;width:100%;max-width:607px"><div style="overflow:hidden;position:relative;padding-bottom:59.308072487644%"><iframe allowfullscreen="" scrolling="no" src="//vk.com/video_ext.php?oid='.\htmlspecialchars($node->getAttribute('oid'),2).'&amp;id='.\htmlspecialchars($node->getAttribute('vid'),2).'&amp;hash='.\htmlspecialchars($node->getAttribute('hash'),2).'&amp;hd=1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';elseif($tb===110)$this->out.='<div data-s9e-mediaembed="vocaroo" style="display:inline-block;width:100%;max-width:148px"><div style="overflow:hidden;position:relative;padding-bottom:29.72972972973%"><object data="//vocaroo.com/player.swf?playMediaID='.\htmlspecialchars($node->getAttribute('id'),2).'&amp;autoplay=0" style="height:100%;left:0;position:absolute;width:100%" type="application/x-shockwave-flash" typemustmatch=""><param name="allowfullscreen" value="true"></object></div></div>';elseif($tb===111)$this->out.='<div data-s9e-mediaembed="vox" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//player.ooyala.com/iframe.html#pbid=a637d53c5c0a43c7bf4e342886b9d8b0&amp;ec='.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';else$this->out.='<div data-s9e-mediaembed="washingtonpost" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.washingtonpost.com/video/c/embed/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';elseif($tb===113)$this->out.='<div data-s9e-mediaembed="wshh" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.worldstarhiphop.com/embed/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';elseif($tb===114)$this->out.='<div data-s9e-mediaembed="wsj" style="display:inline-block;width:100%;max-width:512px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//video-api.wsj.com/api-video/player/iframe.html?guid='.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';elseif($tb===115)$this->out.='<div data-s9e-mediaembed="xboxclips" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//xboxclips.com/'.\htmlspecialchars($node->getAttribute('user'),2).'/'.\htmlspecialchars($node->getAttribute('id'),2).'/embed" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';else$this->out.='<div data-s9e-mediaembed="xboxdvr" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//xboxdvr.com/gamer/'.\htmlspecialchars($node->getAttribute('user'),2).'/video/'.\htmlspecialchars($node->getAttribute('id'),2).'/embed" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';elseif($tb<121)if($tb===117)$this->out.='<div data-s9e-mediaembed="yahooscreen" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="https://screen.yahoo.com/'.\htmlspecialchars($node->getAttribute('id'),2).'.html?format=embed" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';elseif($tb===118)$this->out.='<div data-s9e-mediaembed="youku" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:62.5%;padding-bottom:calc(56.25% + 40px)"><object data="https://players.youku.com/player.php/sid/'.\htmlspecialchars($node->getAttribute('id'),2).'/v.swf" style="height:100%;left:0;position:absolute;width:100%" type="application/x-shockwave-flash" typemustmatch=""><param name="allowfullscreen" value="true"></object></div></div>';elseif($tb===119){$this->out.='<div data-s9e-mediaembed="youtube" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" style="background:url(https://i.ytimg.com/vi/'.\htmlspecialchars($node->getAttribute('id'),2).'/hqdefault.jpg) 50% 50% / cover;border:0;height:100%;left:0;position:absolute;width:100%" src="https://www.youtube.com/embed/'.\htmlspecialchars($node->getAttribute('id'),2);if($node->hasAttribute('list'))$this->out.='?list='.\htmlspecialchars($node->getAttribute('list'),2);if($node->hasAttribute('t')||$node->hasAttribute('m')){if($node->hasAttribute('list'))$this->out.='&amp;';else$this->out.='?';$this->out.='start=';if($node->hasAttribute('t'))$this->out.=\htmlspecialchars($node->getAttribute('t'),2);elseif($node->hasAttribute('h'))$this->out.=\htmlspecialchars($node->getAttribute('h')*3600+$node->getAttribute('m')*60+$node->getAttribute('s'),2);else$this->out.=\htmlspecialchars($node->getAttribute('m')*60+$node->getAttribute('s'),2);}$this->out.='"></iframe></div></div>';}else$this->out.='<object data-s9e-mediaembed="zippyshare" data="//api.zippyshare.com/api/player.swf" style="height:80px;max-width:900px;width:100%" type="application/x-shockwave-flash" typemustmatch=""><param name="allowfullscreen" value="true"><param name="flashvars" value="file='.\htmlspecialchars($node->getAttribute('file'),2).'&amp;server='.\htmlspecialchars($node->getAttribute('server'),2).'&amp;autostart=false"></object>';elseif($tb===121)$this->out.='<br>';elseif($tb===122);else{$this->out.='<p>';$this->at($node);$this->out.='</p>';}
				}
	}
	private static $dynamic=array('ABCNEWS'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="abcnews" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//abcnews.go.com/video/embed?id=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'AUDIOBOOM'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="audioboom" allowfullscreen="" scrolling="no" src="//audioboom.com/boos/$1/embed/v3" style="border:0;height:150px;max-width:700px;width:100%"></iframe>'),'BLAB'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="blab" style="display:inline-block;width:100%;max-width:400px"><div style="overflow:hidden;position:relative;padding-bottom:100%"><iframe allowfullscreen="" scrolling="no" src="https://blab.im/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'BLEACHERREPORT'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="bleacherreport" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//bleacherreport.com/video_embed?id=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'BREAK'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="break" style="display:inline-block;width:100%;max-width:464px"><div style="overflow:hidden;position:relative;padding-bottom:60.344827586207%"><iframe allowfullscreen="" scrolling="no" src="//break.com/embed/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'BRIGHTCOVE'=>array('(^[^ ]+(?> (?!bc(?>key|pid|tid)=)[^=]+="[^"]*")*(?> bckey="([^"]*)")?(?> (?!bc[pt]id=)[^=]+="[^"]*")*(?> bcpid="([^"]*)")?(?> (?!bctid=)[^=]+="[^"]*")*(?> bctid="([^"]*)")?.*)s','<div data-s9e-mediaembed="brightcove" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="https://link.brightcove.com/services/player/bcpid$2?bckey=$1&amp;bctid=$3&amp;secureConnections=true&amp;secureHTMLConnections=true&amp;autoStart=false&amp;height=100%25&amp;width=100%25" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'CNBC'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="cnbc" style="display:inline-block;width:100%;max-width:400px"><div style="overflow:hidden;position:relative;padding-bottom:95%"><object data="//plus.cnbc.com/rssvideosearch/action/player/id/$1/code/cnbcplayershare" style="height:100%;left:0;position:absolute;width:100%" type="application/x-shockwave-flash" typemustmatch=""><param name="allowfullscreen" value="true"></object></div></div>'),'CNN'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="cnn" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//edition.cnn.com/video/api/embed.html#/video/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'CNNMONEY'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="cnnmoney" style="display:inline-block;width:100%;max-width:560px"><div style="overflow:hidden;position:relative;padding-bottom:64.285714285714%"><iframe allowfullscreen="" scrolling="no" src="//money.cnn.com/.element/ssi/video/7.0/players/embed.player.html?videoid=video/$1&amp;width=560&amp;height=360" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'COLLEGEHUMOR'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="collegehumor" style="display:inline-block;width:100%;max-width:600px"><div style="overflow:hidden;position:relative;padding-bottom:61.5%"><iframe allowfullscreen="" scrolling="no" src="//www.collegehumor.com/e/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'COMEDYCENTRAL'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="comedycentral" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//media.mtvnservices.com/embed/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'COUB'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="coub" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//coub.com/embed/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'DAILYMOTION'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="dailymotion" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.dailymotion.com/embed/video/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'EIGHTTRACKS'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="eighttracks" style="display:inline-block;width:100%;max-width:400px"><div style="overflow:hidden;position:relative;padding-bottom:100%"><iframe allowfullscreen="" scrolling="no" src="//8tracks.com/mixes/$1/player_v3_universal" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'ESPN'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="espn" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.espn.com/core/video/iframe?id=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'FLICKR'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="flickr" style="display:inline-block;width:100%;max-width:500px"><div style="overflow:hidden;position:relative;padding-bottom:100%"><iframe allowfullscreen="" scrolling="no" src="https://www.flickr.com/photos/_/$1/player/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'FORATV'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="foratv" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//library.fora.tv/embed?id=$1&amp;type=c" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'FOXNEWS'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="foxnews" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//video.foxnews.com/v/video-embed.html?video_id=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'FUNNYORDIE'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="funnyordie" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.funnyordie.com/embed/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'GAMESPOT'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="gamespot" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:62.5%"><iframe allowfullscreen="" scrolling="no" src="//www.gamespot.com/videos/embed/$1/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'GIST'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="gist" allowfullscreen="" onload="var a=Math.random();window.addEventListener(\'message\',function(b){if(b.data.id==a)style.height=b.data.height+\'px\'});contentWindow.postMessage(\'s9e:\'+a,\'https://s9e.github.io\')" scrolling="" src="https://s9e.github.io/iframe/gist.min.html#$1" style="border:0;height:180px;width:100%"></iframe>'),'GLOBALNEWS'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="globalnews" style="display:inline-block;width:100%;max-width:560px"><div style="overflow:hidden;position:relative;padding-bottom:67.321428571429%"><iframe allowfullscreen="" scrolling="no" src="//globalnews.ca/video/embed/$1/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'GOFUNDME'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="gofundme" style="display:inline-block;width:100%;max-width:258px"><div style="overflow:hidden;position:relative;padding-bottom:131.00775193798%"><object data="//funds.gofundme.com/Widgetflex.swf" style="height:100%;left:0;position:absolute;width:100%" type="application/x-shockwave-flash" typemustmatch=""><param name="allowfullscreen" value="true"><param name="flashvars" value="page=$1"></object></div></div>'),'GOOGLEDRIVE'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="googledrive" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:75%"><iframe allowfullscreen="" scrolling="no" src="//drive.google.com/file/d/$1/preview" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'GOOGLESHEETS'=>array('(^[^ ]+(?> (?!g?id=)[^=]+="[^"]*")*(?> gid="([^"]*)")?(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="googlesheets" allowfullscreen="" scrolling="no" src="https://docs.google.com/spreadsheet/ccc?key=$2&amp;widget=true&amp;headers=false&amp;rm=minimal#gid=$1" style="border:0;height:500px;resize:vertical;width:100%"></iframe>'),'HEALTHGURU'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="healthguru" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.healthguru.com/embed/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'HUDL'=>array('(^[^ ]+(?> (?!(?>athlete|highlight)=)[^=]+="[^"]*")*(?> athlete="([^"]*)")?(?> (?!highlight=)[^=]+="[^"]*")*(?> highlight="([^"]*)")?.*)s','<div data-s9e-mediaembed="hudl" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.hudl.com/embed/athlete/$1/highlights/$2" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'HULU'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="hulu" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="https://secure.hulu.com/embed/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'HUMORTVNL'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="humortvnl" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//humortv.vara.nl/embed.$1.html" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'IGN'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="ign" style="display:inline-block;width:100%;max-width:468px"><div style="overflow:hidden;position:relative;padding-bottom:56.196581196581%"><iframe allowfullscreen="" scrolling="no" src="//widgets.ign.com/video/embed/content.html?url=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'IMDB'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="imdb" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.imdb.com/video/imdb/vi$1/imdb/embed?autoplay=false&amp;width=640" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'INDIEGOGO'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="indiegogo" style="display:inline-block;width:100%;max-width:222px"><div style="overflow:hidden;position:relative;padding-bottom:200.45045045045%"><iframe allowfullscreen="" scrolling="no" src="//www.indiegogo.com/project/$1/embedded" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'INSTAGRAM'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="instagram" allowfullscreen="" onload="var a=Math.random();window.addEventListener(\'message\',function(b){if(b.data.id==a)style.height=b.data.height+\'px\'});contentWindow.postMessage(\'s9e:\'+a,\'https://s9e.github.io\')" scrolling="no" src="https://s9e.github.io/iframe/instagram.min.html#$1" style="border:0;height:640px;max-width:640px;width:100%"></iframe>'),'IZLESENE'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="izlesene" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.izlesene.com/embedplayer/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'JWPLATFORM'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="jwplatform" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//content.jwplatform.com/players/$1.html" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'KHL'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="khl" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//video.khl.ru/iframe/feed/start/$1?type_id=18&amp;width=560&amp;height=315" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'KISSVIDEO'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="kissvideo" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.kissvideo.click/embed.php?vid=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'LIBSYN'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="libsyn" allowfullscreen="" scrolling="no" src="//html5-player.libsyn.com/embed/episode/id/$1/height/45/width/900/theme/standard/direction/no/autoplay/no/autonext/no/thumbnail/no/preload/no/no_addthis/no/" style="border:0;height:45px;max-width:900px;width:100%"></iframe>'),'LIVECAP'=>array('(^[^ ]+(?> (?!(?>channel|id)=)[^=]+="[^"]*")*(?> channel="([^"]*)")?(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="livecap" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="https://www.livecap.tv/s/embed/$1/$2" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'LIVELEAK'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="liveleak" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.liveleak.com/ll_embed?i=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'MAILRU'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="mailru" style="display:inline-block;width:100%;max-width:560px"><div style="overflow:hidden;position:relative;padding-bottom:61.071428571429%"><iframe allowfullscreen="" scrolling="no" src="//videoapi.my.mail.ru/videos/embed/$1.html" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'METACAFE'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="metacafe" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.metacafe.com/embed/$1/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'MIXCLOUD'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="mixcloud" style="display:inline-block;width:100%;max-width:400px"><div style="overflow:hidden;position:relative;padding-bottom:100%"><iframe allowfullscreen="" scrolling="no" src="//www.mixcloud.com/widget/iframe/?feed=http%3A%2F%2Fwww.mixcloud.com%2F$1%2F&amp;embed_type=widget_standard" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'MLB'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="mlb" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//m.mlb.com/shared/video/embed/embed.html?content_id=$1&amp;width=640&amp;height=360" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'MRCTV'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="mrctv" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="https://www.mrctv.org/embed/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'MSNBC'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="msnbc" style="display:inline-block;width:100%;max-width:635px"><div style="overflow:hidden;position:relative;padding-bottom:69.291338582677%"><iframe allowfullscreen="" scrolling="no" src="//player.theplatform.com/p/2E2eJC/EmbeddedOffSite?guid=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'NATGEOCHANNEL'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="natgeochannel" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//channel.nationalgeographic.com/$1/embed/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'NATGEOVIDEO'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="natgeovideo" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//player.d.nationalgeographic.com/players/ngsvideo/share/?guid=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'NBCNEWS'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="nbcnews" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.nbcnews.com/widget/video-embed/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'NBCSPORTS'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="nbcsports" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//vplayer.nbcsports.com/p/BxmELC/nbcsports_embed/select/media/$1?parentUrl=" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'NPR'=>array('(^[^ ]+(?> (?![im]=)[^=]+="[^"]*")*(?> i="([^"]*)")?(?> (?!m=)[^=]+="[^"]*")*(?> m="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="npr" allowfullscreen="" scrolling="no" src="//www.npr.org/player/embed/$1/$2" style="border:0;height:228px;max-width:800px;width:100%"></iframe>'),'NYTIMES'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="nytimes" style="display:inline-block;width:100%;max-width:585px"><div style="overflow:hidden;position:relative;padding-bottom:68.376068376068%"><iframe allowfullscreen="" scrolling="no" src="//graphics8.nytimes.com/video/players/offsite/index.html?videoId=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'ODDSHOT'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="oddshot" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//oddshot.tv/shot/$1/embed" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'PASTEBIN'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="pastebin" allowfullscreen="" scrolling="" src="//pastebin.com/embed_iframe.php?i=$1" style="border:0;height:300px;resize:vertical;width:100%"></iframe>'),'PLAYSTV'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="playstv" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//plays.tv/embeds/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'PODBEAN'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="podbean" allowfullscreen="" scrolling="no" src="//www.podbean.com/media/player/$1" style="border:0;height:100px;max-width:900px;width:100%"></iframe>'),'PREZI'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="prezi" style="display:inline-block;width:100%;max-width:550px"><div style="overflow:hidden;position:relative;padding-bottom:72.727272727273%"><iframe allowfullscreen="" scrolling="no" src="//prezi.com/embed/$1/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'REDDIT'=>array('(^[^ ]+(?> (?!path=)[^=]+="[^"]*")*(?> path="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="reddit" allowfullscreen="" onload="var a=Math.random();window.addEventListener(\'message\',function(b){if(b.data.id==a)style.height=b.data.height+\'px\'});contentWindow.postMessage(\'s9e:\'+a,\'https://s9e.github.io\')" scrolling="no" src="https://s9e.github.io/iframe/reddit.min.html#$1" style="border:0;height:165px;max-width:800px;width:100%"></iframe>'),'RUTUBE'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="rutube" style="display:inline-block;width:100%;max-width:720px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//rutube.ru/play/embed/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'SCRIBD'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="scribd" allowfullscreen="" scrolling="no" src="https://www.scribd.com/embeds/$1/content?view_mode=scroll&amp;show_recommendations=false" style="border:0;height:500px;resize:vertical;width:100%"></iframe>'),'SLIDESHARE'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="slideshare" style="display:inline-block;width:100%;max-width:427px"><div style="overflow:hidden;position:relative;padding-bottom:83.372365339578%"><iframe allowfullscreen="" scrolling="no" src="//www.slideshare.net/slideshow/embed_code/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'SPORTSNET'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="sportsnet" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="https://images.rogersdigitalmedia.com/video_service.php?videoId=$1&amp;playerKey=AQ~~,AAAAAGWRwLc~,cRCmKE8Utf7OFWP38XQcokFZ80fR-u_y&amp;autoStart=false&amp;width=100%25&amp;height=100%25" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'STEAMSTORE'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="steamstore" allowfullscreen="" scrolling="no" src="//store.steampowered.com/widget/$1" style="border:0;height:190px;max-width:900px;width:100%"></iframe>'),'STITCHER'=>array('(^[^ ]+(?> (?![ef]id=)[^=]+="[^"]*")*(?> eid="([^"]*)")?(?> (?!fid=)[^=]+="[^"]*")*(?> fid="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="stitcher" allowfullscreen="" scrolling="no" src="//app.stitcher.com/splayer/f/$2/$1" style="border:0;height:150px;max-width:900px;width:100%"></iframe>'),'STRAWPOLL'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="strawpoll" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="" src="//www.strawpoll.me/embed_1/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'STREAMABLE'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="streamable" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//streamable.com/e/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'TEAMCOCO'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="teamcoco" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:64.84375%"><iframe allowfullscreen="" scrolling="no" src="//teamcoco.com/embed/v/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'THEATLANTIC'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="theatlantic" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.theatlantic.com/video/iframe/$1/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'THEGUARDIAN'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="theguardian" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//embed.theguardian.com/embed/video/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'THEONION'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="theonion" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.theonion.com/video_embed/?id=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'TINYPIC'=>array('(^[^ ]+(?> (?!(?>s|id)=)[^=]+="[^"]*")*(?> id="([^"]*)")?(?> (?!s=)[^=]+="[^"]*")*(?> s="([^"]*)")?.*)s','<div data-s9e-mediaembed="tinypic" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:60.9375%;padding-bottom:calc(56.25% + 30px)"><object data="//tinypic.com/player.swf?file=$1&amp;s=$2" style="height:100%;left:0;position:absolute;width:100%" type="application/x-shockwave-flash" typemustmatch=""><param name="allowfullscreen" value="true"></object></div></div>'),'TMZ'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="tmz" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.kaltura.com/index.php/kwidget/cache_st/133592691/wid/_591531/partner_id/591531/uiconf_id/9071262/entry_id/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'TRAILERADDICT'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="traileraddict" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//v.traileraddict.com/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'TUMBLR'=>array('(^[^ ]+(?> (?!(?>id|key)=)[^=]+="[^"]*")*(?> id="([^"]*)")?(?> (?!key=)[^=]+="[^"]*")*(?> key="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="tumblr" allowfullscreen="" onload="var a=Math.random();window.addEventListener(\'message\',function(b){if(b.data.id==a)style.height=b.data.height+\'px\'});contentWindow.postMessage(\'s9e:\'+a,\'https://s9e.github.io\')" scrolling="no" src="https://s9e.github.io/iframe/tumblr.min.html#$2/$1" style="border:0;height:180px;max-width:520px;width:100%"></iframe>'),'TWITTER'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="twitter" allowfullscreen="" onload="var a=Math.random();window.addEventListener(\'message\',function(b){if(b.data.id==a)style.height=b.data.height+\'px\'});contentWindow.postMessage(\'s9e:\'+a,\'https://s9e.github.io\')" scrolling="no" src="https://s9e.github.io/iframe/twitter.min.html#$1" style="background:url(https://abs.twimg.com/favicons/favicon.ico) no-repeat 50% 50%;border:0;height:186px;max-width:500px;width:100%"></iframe>'),'VBOX7'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="vbox7" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//vbox7.com/emb/external.php?vid=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'VEOH'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="veoh" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:62.5%;padding-bottom:calc(56.25% + 40px)"><object data="//www.veoh.com/swf/webplayer/WebPlayer.swf?version=AFrontend.5.7.0.1509&amp;permalinkId=v$1&amp;player=videodetailsembedded&amp;videoAutoPlay=0&amp;id=anonymous" style="height:100%;left:0;position:absolute;width:100%" type="application/x-shockwave-flash" typemustmatch=""><param name="allowfullscreen" value="true"></object></div></div>'),'VEVO'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="vevo" style="display:inline-block;width:100%;max-width:575px"><div style="overflow:hidden;position:relative;padding-bottom:56.347826086957%"><iframe allowfullscreen="" scrolling="no" src="//cache.vevo.com/m/html/embed.html?video=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'VIAGAME'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="viagame" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:61.25%"><iframe allowfullscreen="" scrolling="no" src="//www.viagame.com/embed/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'VIDEODETECTIVE'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="videodetective" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.videodetective.com/embed/video/?options=false&amp;autostart=false&amp;playlist=none&amp;publishedid=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'VIDEOMEGA'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="videomega" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//videomega.tv/iframe.php?ref=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'VIMEO'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="vimeo" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//player.vimeo.com/video/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'VINE'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="vine" style="display:inline-block;width:100%;max-width:480px"><div style="overflow:hidden;position:relative;padding-bottom:100%"><iframe allowfullscreen="" scrolling="no" src="https://vine.co/v/$1/embed/simple?audio=1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'VK'=>array('(^[^ ]+(?> (?!(?>hash|oid|vid)=)[^=]+="[^"]*")*(?> hash="([^"]*)")?(?> (?![ov]id=)[^=]+="[^"]*")*(?> oid="([^"]*)")?(?> (?!vid=)[^=]+="[^"]*")*(?> vid="([^"]*)")?.*)s','<div data-s9e-mediaembed="vk" style="display:inline-block;width:100%;max-width:607px"><div style="overflow:hidden;position:relative;padding-bottom:59.308072487644%"><iframe allowfullscreen="" scrolling="no" src="//vk.com/video_ext.php?oid=$2&amp;id=$3&amp;hash=$1&amp;hd=1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'VOCAROO'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="vocaroo" style="display:inline-block;width:100%;max-width:148px"><div style="overflow:hidden;position:relative;padding-bottom:29.72972972973%"><object data="//vocaroo.com/player.swf?playMediaID=$1&amp;autoplay=0" style="height:100%;left:0;position:absolute;width:100%" type="application/x-shockwave-flash" typemustmatch=""><param name="allowfullscreen" value="true"></object></div></div>'),'VOX'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="vox" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//player.ooyala.com/iframe.html#pbid=a637d53c5c0a43c7bf4e342886b9d8b0&amp;ec=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'WASHINGTONPOST'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="washingtonpost" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.washingtonpost.com/video/c/embed/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'WSHH'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="wshh" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.worldstarhiphop.com/embed/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'WSJ'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="wsj" style="display:inline-block;width:100%;max-width:512px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//video-api.wsj.com/api-video/player/iframe.html?guid=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'XBOXCLIPS'=>array('(^[^ ]+(?> (?!(?>id|user)=)[^=]+="[^"]*")*(?> id="([^"]*)")?(?> (?!user=)[^=]+="[^"]*")*(?> user="([^"]*)")?.*)s','<div data-s9e-mediaembed="xboxclips" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//xboxclips.com/$2/$1/embed" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'XBOXDVR'=>array('(^[^ ]+(?> (?!(?>id|user)=)[^=]+="[^"]*")*(?> id="([^"]*)")?(?> (?!user=)[^=]+="[^"]*")*(?> user="([^"]*)")?.*)s','<div data-s9e-mediaembed="xboxdvr" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//xboxdvr.com/gamer/$2/video/$1/embed" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'YAHOOSCREEN'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="yahooscreen" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="https://screen.yahoo.com/$1.html?format=embed" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>'),'YOUKU'=>array('(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<div data-s9e-mediaembed="youku" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:62.5%;padding-bottom:calc(56.25% + 40px)"><object data="https://players.youku.com/player.php/sid/$1/v.swf" style="height:100%;left:0;position:absolute;width:100%" type="application/x-shockwave-flash" typemustmatch=""><param name="allowfullscreen" value="true"></object></div></div>'),'ZIPPYSHARE'=>array('(^[^ ]+(?> (?!(?>file|server)=)[^=]+="[^"]*")*(?> file="([^"]*)")?(?> (?!server=)[^=]+="[^"]*")*(?> server="([^"]*)")?.*)s','<object data-s9e-mediaembed="zippyshare" data="//api.zippyshare.com/api/player.swf" style="height:80px;max-width:900px;width:100%" type="application/x-shockwave-flash" typemustmatch=""><param name="allowfullscreen" value="true"><param name="flashvars" value="file=$1&amp;server=$2&amp;autostart=false"></object>'));
	private static $attributes;
	private static $quickBranches=array('AMAZON'=>0,'AUDIOMACK'=>1,'BANDCAMP'=>2,'BBCNEWS'=>3,'CBSNEWS'=>4,'DEMOCRACYNOW'=>5,'DUMPERT'=>6,'FACEBOOK'=>7,'GAMETRAILERS'=>8,'GETTY'=>9,'GFYCAT'=>10,'GIFS'=>11,'GOOGLEPLUS'=>12,'IMGUR'=>13,'INTERNETARCHIVE'=>14,'KICKSTARTER'=>15,'LIVESTREAM'=>16,'MEDIUM'=>17,'NHL'=>18,'PINTEREST'=>19,'SOUNDCLOUD'=>20,'SPOTIFY'=>21,'TED'=>22,'TWITCH'=>23,'USTREAM'=>24,'VIDME'=>25,'YOUTUBE'=>26);
	protected function renderQuick($xml)
	{
		$xml = $this->decodeSMP($xml);
		self::$attributes = array();
		$html = \preg_replace_callback(
			'(<(?:(?!/)((?:A(?>BCNEWS|MAZON|UDIO(?>BOOM|MACK))|B(?>ANDCAMP|BCNEWS|L(?>AB|EACHERREPORT)|R(?>EAK|IGHTCOVE))|C(?:BSNEWS|N(?:BC|N(?>MONEY)?)|O(?>LLEGEHUMOR|MEDYCENTRAL|UB))|D(?>AILYMOTION|EMOCRACYNOW|UMPERT)|E(?>IGHTTRACKS|SPN)|F(?>ACEBOOK|LICKR|O(?>RATV|XNEWS)|UNNYORDIE)|G(?>AME(?>SPOT|TRAILERS)|ETTY|FYCAT|I(?>FS|ST)|LOBALNEWS|O(?>FUNDME|OGLE(?>DRIVE|PLUS|SHEETS)))|H(?>EALTHGURU|U(?>DL|LU|MORTVNL))|I(?>GN|M(?>DB|GUR)|N(?>DIEGOGO|STAGRAM|TERNETARCHIVE)|ZLESENE)|JWPLATFORM|K(?>HL|I(?>CKSTARTER|SSVIDEO))|LI(?>BSYN|VE(?>CAP|LEAK|STREAM))|M(?>AILRU|E(?>DIUM|TACAFE)|IXCLOUD|LB|RCTV|SNBC)|N(?>ATGEO(?>CHANNEL|VIDEO)|BC(?>NEW|SPORT)S|HL|PR|YTIMES)|ODDSHOT|P(?>ASTEBIN|INTEREST|LAYSTV|ODBEAN|REZI)|R(?>EDDIT|UTUBE)|S(?>CRIBD|LIDESHARE|OUNDCLOUD|PO(?>RTSNET|TIFY)|T(?>EAMSTORE|ITCHER|R(?>AWPOLL|EAMABLE)))|T(?>E(?>D|AMCOCO)|HE(?>ATLANTIC|GUARDIAN|ONION)|INYPIC|MZ|RAILERADDICT|UMBLR|WIT(?>CH|TER))|USTREAM|V(?>K|BOX7|E(?>OH|VO)|I(?>AGAME|D(?>EO(?>DETECTIVE|MEGA)|ME)|MEO|NE)|O(?>X|CAROO))|W(?>ASHINGTONPOST|S(?>J|HH))|XBOX(?>CLIPS|DVR)|Y(?>AHOOSCREEN|OU(?>KU|TUBE))|ZIPPYSHARE))(?: [^>]*)?>.*?</\\1|(/?(?!br/|p>)[^ />]+)[^>]*?(/)?)>)s',
			array($this, 'quick'),
			\preg_replace(
				'(<[eis]>[^<]*</[eis]>)',
				'',
				\substr($xml, 1 + \strpos($xml, '>'), -4)
			)
		);
		return \str_replace('<br/>', '<br>', $html);
	}
	protected function quick($m)
	{
		if (isset($m[2]))
		{
			$id = $m[2];
			if (isset($m[3]))
			{
				unset($m[3]);
				$m[0] = \substr($m[0], 0, -2) . '>';
				$html = $this->quick($m);
				$m[0] = '</' . $id . '>';
				$m[2] = '/' . $id;
				$html .= $this->quick($m);
				return $html;
			}
		}
		else
		{
			$id = $m[1];
			$lpos = 1 + \strpos($m[0], '>');
			$rpos = \strrpos($m[0], '<');
			$textContent = \substr($m[0], $lpos, $rpos - $lpos);
			if (\strpos($textContent, '<') !== \false)
				throw new \RuntimeException;
			$textContent = \htmlspecialchars_decode($textContent);
		}
		if (isset(self::$dynamic[$id]))
		{
			list($match, $replace) = self::$dynamic[$id];
			return \preg_replace($match, $replace, $m[0], 1);
		}
		if (!isset(self::$quickBranches[$id]))
		{
			if ($id[0] === '!' || $id[0] === '?')
				throw new \RuntimeException;
			return '';
		}
		$attributes = array();
		if (\strpos($m[0], '="') !== \false)
		{
			\preg_match_all('(([^ =]++)="([^"]*))S', \substr($m[0], 0, \strpos($m[0], '>')), $matches);
			foreach ($matches[1] as $i => $attrName)
				$attributes[$attrName] = $matches[2][$i];
		}
		$qb = self::$quickBranches[$id];
		if($qb<14){if($qb<7)if($qb<4)if($qb===0){$attributes+=array('tld'=>\null,'id'=>\null);$html='<div data-s9e-mediaembed="amazon" style="display:inline-block;width:100%;max-width:120px"><div style="overflow:hidden;position:relative;padding-bottom:200%"><iframe allowfullscreen="" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//';if($attributes['tld']==='es'||$attributes['tld']==='it'){$html.='rcm-eu.amazon-adsystem.com/e/cm?lt1=_blank&amp;bc1=FFFFFF&amp;bg1=FFFFFF&amp;fc1=000000&amp;lc1=0000FF&amp;p=8&amp;l=as1&amp;f=ifr&amp;asins='.$attributes['id'].'&amp;o=';if($attributes['tld']==='es')$html.='30';else$html.='29';$html.='&amp;t=';if($attributes['tld']==='es'&&!empty($this->params['AMAZON_ASSOCIATE_TAG_ES']))$html.=\htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG_ES'],2);elseif($attributes['tld']==='it'&&!empty($this->params['AMAZON_ASSOCIATE_TAG_IT']))$html.=\htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG_IT'],2);else$html.='_';}else{$html.='ws-';if($attributes['tld']==='jp')$html.='fe';elseif(isset($attributes['tld'])&&(\strpos('desfrituk',$attributes['tld'])!==\false))$html.='eu';else$html.='na';$html.='.amazon-adsystem.com/widgets/q?ServiceVersion=20070822&amp;OneJS=1&amp;Operation=GetAdHtml&amp;MarketPlace=';if(isset($attributes['tld']))$html.=\htmlspecialchars(\strtr(\htmlspecialchars_decode($attributes['tld']),'acdefijkprstu','ACDEFIJBPRSTG'),2);else$html.='US';$html.='&amp;ad_type=product_link&amp;tracking_id=';if($attributes['tld']==='ca'&&!empty($this->params['AMAZON_ASSOCIATE_TAG_CA']))$html.=\htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG_CA'],2);elseif($attributes['tld']==='de'&&!empty($this->params['AMAZON_ASSOCIATE_TAG_DE']))$html.=\htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG_DE'],2);elseif($attributes['tld']==='fr'&&!empty($this->params['AMAZON_ASSOCIATE_TAG_FR']))$html.=\htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG_FR'],2);elseif($attributes['tld']==='jp'&&!empty($this->params['AMAZON_ASSOCIATE_TAG_JP']))$html.=\htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG_JP'],2);elseif($attributes['tld']==='uk'&&!empty($this->params['AMAZON_ASSOCIATE_TAG_UK']))$html.=\htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG_UK'],2);elseif(!empty($this->params['AMAZON_ASSOCIATE_TAG']))$html.=\htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG'],2);else$html.='_';$html.='&amp;marketplace=amazon&amp;region=';if(isset($attributes['tld']))$html.=\htmlspecialchars(\strtr(\htmlspecialchars_decode($attributes['tld']),'acdefijkprstu','ACDEFIJBPRSTG'),2);else$html.='US';$html.='&amp;asins='.$attributes['id'].'&amp;show_border=true&amp;link_opens_in_new_window=true';}$html.='"></iframe></div></div>';}elseif($qb===1){$attributes+=array('mode'=>\null,'id'=>\null);$html='';if($attributes['mode']==='album')$html.='<iframe data-s9e-mediaembed="audiomack" allowfullscreen="" scrolling="no" src="//www.audiomack.com/embed4-album/'.$attributes['id'].'" style="border:0;height:340px;max-width:900px;width:100%"></iframe>';else$html.='<iframe data-s9e-mediaembed="audiomack" allowfullscreen="" scrolling="no" src="//www.audiomack.com/embed4/'.$attributes['id'].'" style="border:0;height:110px;max-width:900px;width:100%"></iframe>';}elseif($qb===2){$attributes+=array('track_num'=>\null,'track_id'=>\null);$html='<div data-s9e-mediaembed="bandcamp" style="display:inline-block;width:100%;max-width:400px"><div style="overflow:hidden;position:relative;padding-bottom:100%"><iframe allowfullscreen="" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//bandcamp.com/EmbeddedPlayer/size=large/minimal=true/';if(isset($attributes['album_id'])){$html.='album='.$attributes['album_id'];if(isset($attributes['track_num']))$html.='/t='.$attributes['track_num'];}else$html.='track='.$attributes['track_id'];$html.='"></iframe></div></div>';}else{$attributes+=array('playlist'=>\null,'id'=>\null);$html='<div data-s9e-mediaembed="bbcnews" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//www.bbc.com';if((\strpos($attributes['playlist'],'/news/')===0)&&(\strpos($attributes['playlist'],'A')!==\false))$html.=\htmlspecialchars(\strstr(\htmlspecialchars_decode($attributes['playlist']),'A',\true),2);else$html.='/news/'.$attributes['id'];$html.='/embed"></iframe></div></div>';}elseif($qb===4){$attributes+=array('id'=>\null);$html='<div data-s9e-mediaembed="cbsnews" style="display:inline-block;width:100%;max-width:640px">';if(isset($attributes['pid']))$html.='<div style="overflow:hidden;position:relative;padding-bottom:62.1875%;padding-bottom:calc(56.25% + 38px)"><object data="//www.cbsnews.com/common/video/cbsnews_player.swf" style="height:100%;left:0;position:absolute;width:100%" type="application/x-shockwave-flash" typemustmatch=""><param name="allowfullscreen" value="true"><param name="flashvars" value="pType=embed&amp;si=254&amp;pid='.$attributes['pid'];else$html.='<div style="overflow:hidden;position:relative;padding-bottom:62.5%;padding-bottom:calc(56.25% + 40px)"><object data="//i.i.cbsi.com/cnwk.1d/av/video/cbsnews/atlantis2/cbsnews_player_embed.swf" style="height:100%;left:0;position:absolute;width:100%" type="application/x-shockwave-flash" typemustmatch=""><param name="allowfullscreen" value="true"><param name="flashvars" value="si=254&amp;contentValue='.$attributes['id'];$html.='"></object></div>';$html.='</div>';}elseif($qb===5){$attributes+=array('id'=>\null);$html='<div data-s9e-mediaembed="democracynow" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//www.democracynow.org/embed/';if((\strpos($attributes['id'],'/headlines')!==\false))$html.='headlines/'.\htmlspecialchars(\strstr(\htmlspecialchars_decode($attributes['id']),'/headlines',\true),2);elseif((\strpos($attributes['id'],'2')===0))$html.='story/'.$attributes['id'];elseif((\strpos($attributes['id'],'shows/')===0))$html.='show/'.\htmlspecialchars(\substr(\strstr(\htmlspecialchars_decode($attributes['id']),'/'),1),2);else$html.=$attributes['id'];$html.='"></iframe></div></div>';}else{$attributes+=array('id'=>\null);$html='<div data-s9e-mediaembed="dumpert" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.dumpert.nl/embed/'.\strtr($attributes['id'],'_','/').'/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';}elseif($qb<11)if($qb===7){$attributes+=array('type'=>\null,'id'=>\null);$html='<iframe data-s9e-mediaembed="facebook" allowfullscreen="" onload="var a=Math.random();window.addEventListener(\'message\',function(b){if(b.data.id==a)style.height=b.data.height+\'px\'});contentWindow.postMessage(\'s9e:\'+a,\'https://s9e.github.io\')" scrolling="no" src="https://s9e.github.io/iframe/facebook.min.html#'.\htmlspecialchars(\htmlspecialchars_decode($attributes['type']).\htmlspecialchars_decode($attributes['id']),2).'" style="border:0;height:360px;max-width:640px;width:100%"></iframe>';}elseif($qb===8){$attributes+=array('id'=>\null);$html='<div data-s9e-mediaembed="gametrailers" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="';if((\strpos($attributes['id'],'mgid:')===0))$html.='//media.mtvnservices.com/embed/'.$attributes['id'];else$html.='//embed.gametrailers.com/embed/'.$attributes['id'].'?embed=1&amp;suppressBumper=1';$html.='"></iframe></div></div>';}elseif($qb===9){$attributes+=array('width'=>\null,'height'=>\null,'id'=>\null,'et'=>\null,'sig'=>\null);$html='<div data-s9e-mediaembed="getty" style="display:inline-block;width:100%;max-width:'.$attributes['width'].'px"><div style="overflow:hidden;position:relative;';if(\htmlspecialchars_decode($attributes['width'])>0)$html.='padding-bottom:'.\htmlspecialchars(100*($attributes['height']+49)/\htmlspecialchars_decode($attributes['width']),2).'%;padding-bottom:calc('.\htmlspecialchars(100*$attributes['height']/\htmlspecialchars_decode($attributes['width']),2).'% + 49px)';$html.='"><iframe allowfullscreen="" scrolling="no" src="//embed.gettyimages.com/embed/'.$attributes['id'].'?et='.$attributes['et'].'&amp;sig='.$attributes['sig'].'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';}else{$attributes+=array('width'=>\null,'height'=>\null,'id'=>\null);$html='<div data-s9e-mediaembed="gfycat" style="display:inline-block;width:100%;max-width:'.$attributes['width'].'px"><div style="overflow:hidden;position:relative;';if(\htmlspecialchars_decode($attributes['width'])>0)$html.='padding-bottom:'.\htmlspecialchars(100*$attributes['height']/\htmlspecialchars_decode($attributes['width']),2).'%';$html.='"><iframe allowfullscreen="" scrolling="no" src="//gfycat.com/iframe/'.$attributes['id'].'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';}elseif($qb===11){$attributes+=array('width'=>\null,'height'=>\null,'id'=>\null);$html='<div data-s9e-mediaembed="gifs" style="display:inline-block;width:100%;max-width:'.$attributes['width'].'px"><div style="overflow:hidden;position:relative;';if(\htmlspecialchars_decode($attributes['width'])>0)$html.='padding-bottom:'.\htmlspecialchars(100*$attributes['height']/\htmlspecialchars_decode($attributes['width']),2).'%';$html.='"><iframe allowfullscreen="" scrolling="no" src="//gifs.com/embed/'.$attributes['id'].'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';}elseif($qb===12){$attributes+=array('name'=>\null,'pid'=>\null);$html='<iframe data-s9e-mediaembed="googleplus" allowfullscreen="" onload="var a=Math.random();window.addEventListener(\'message\',function(b){if(b.data.id==a)style.height=b.data.height+\'px\'});contentWindow.postMessage(\'s9e:\'+a,\'https://s9e.github.io\')" scrolling="no" style="border:0;height:240px;max-width:450px;width:100%" src="https://s9e.github.io/iframe/googleplus.min.html#';if(isset($attributes['oid']))$html.=$attributes['oid'];else$html.='+'.$attributes['name'];$html.='/posts/'.$attributes['pid'].'"></iframe>';}else{$attributes+=array('type'=>\null,'id'=>\null);$html='<iframe data-s9e-mediaembed="imgur" allowfullscreen="" onload="var b=Math.random();window.addEventListener(\'message\',function(a){a.data.id==b&amp;&amp;(style.height=a.data.height+\'px\',style.width=a.data.width+\'px\')});contentWindow.postMessage(\'s9e:\'+b,\'https://s9e.github.io\')" scrolling="no" style="border:0;height:450px;width:568px" src="https://s9e.github.io/iframe/imgur.min.html#';if($attributes['type']==='album'&&!((\strpos($attributes['id'],'a/')===0)))$html.='a/';$html.=$attributes['id'].'"></iframe>';}}elseif($qb<21)if($qb<18)if($qb===14){$attributes+=array('width'=>\null,'height'=>\null,'id'=>\null);$html='<div data-s9e-mediaembed="internetarchive" style="display:inline-block;width:100%;max-width:'.$attributes['width'].'px"><div style="overflow:hidden;position:relative;';if(\htmlspecialchars_decode($attributes['width'])>0)$html.='padding-bottom:'.\htmlspecialchars(100*$attributes['height']/\htmlspecialchars_decode($attributes['width']),2).'%';$html.='"><iframe allowfullscreen="" scrolling="no" src="https://archive.org/embed/'.$attributes['id'].'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';}elseif($qb===15){$attributes+=array('id'=>\null);$html='';if(isset($attributes['video']))$html.='<div data-s9e-mediaembed="kickstarter" style="display:inline-block;width:100%;max-width:480px"><div style="overflow:hidden;position:relative;padding-bottom:75%"><iframe allowfullscreen="" scrolling="no" src="//www.kickstarter.com/projects/'.$attributes['id'].'/widget/video.html" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';else$html.='<div data-s9e-mediaembed="kickstarter" style="display:inline-block;width:100%;max-width:220px"><div style="overflow:hidden;position:relative;padding-bottom:190.90909090909%"><iframe allowfullscreen="" scrolling="no" src="//www.kickstarter.com/projects/'.$attributes['id'].'/widget/card.html" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';}elseif($qb===16){$attributes+=array('channel'=>\null,'account_id'=>\null,'event_id'=>\null);$html='<div data-s9e-mediaembed="livestream" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="';if(isset($attributes['clip_id']))$html.='//cdn.livestream.com/embed/'.$attributes['channel'].'?layout=4&amp;autoplay=false&amp;clip='.$attributes['clip_id'];else{$html.='//livestream.com/accounts/'.$attributes['account_id'].'/events/'.$attributes['event_id'];if(isset($attributes['video_id']))$html.='/videos/'.$attributes['video_id'];$html.='/player?autoPlay=false';}$html.='"></iframe></div></div>';}else{$attributes+=array('id'=>\null);$html='<iframe data-s9e-mediaembed="medium" allowfullscreen="" onload="window.addEventListener(\'message\',function(a){a=a.data.split(\'::\');\'m\'===a[0]&amp;&amp;0&lt;src.indexOf(a[1])&amp;&amp;a[2]&amp;&amp;(style.height=a[2]+\'px\')})" scrolling="no" src="https://api.medium.com/embed?type=story&amp;path=%2F%2F'.$attributes['id'].'&amp;id='.\htmlspecialchars(\strtr(\htmlspecialchars_decode($attributes['id']),'abcdef','111111'),2).'" style="border:1px solid;border-color:#eee #ddd #bbb;border-radius:5px;box-shadow:rgba(0,0,0,.15) 0 1px 3px;height:400px;max-width:400px;width:100%"></iframe>';}elseif($qb===18){$attributes+=array('t'=>\null,'id'=>\null);$html='<div data-s9e-mediaembed="nhl" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="';if(isset($attributes['c'])||isset($attributes['t'])){$html.='//www.nhl.com/video/embed';if(isset($attributes['t']))$html.='/t-'.$attributes['t'];if(isset($attributes['c']))$html.='/c-'.$attributes['c'];$html.='?autostart=false';}else$html.='//video.nhl.com/videocenter/embed?playlist='.$attributes['id'];$html.='"></iframe></div></div>';}elseif($qb===19){$attributes+=array('id'=>\null);$html='<iframe data-s9e-mediaembed="pinterest" allowfullscreen="" onload="var a=Math.random();window.addEventListener(\'message\',function(b){if(b.data.id==a)style.height=b.data.height+\'px\'});contentWindow.postMessage(\'s9e:\'+a,\'https://s9e.github.io\')" scrolling="no" src="https://s9e.github.io/iframe/pinterest.min.html#'.$attributes['id'].'" style="border:0;height:360px;max-width:';if((\strpos($attributes['id'],'/')!==\false))$html.='730';else$html.='345';$html.='px;width:100%"></iframe>';}else{$attributes+=array('secret_token'=>\null,'id'=>\null);$html='<iframe data-s9e-mediaembed="soundcloud" allowfullscreen="" scrolling="no" src="https://w.soundcloud.com/player/?url=';if(isset($attributes['playlist_id']))$html.='https%3A//api.soundcloud.com/playlists/'.$attributes['playlist_id'];elseif(isset($attributes['track_id']))$html.='https%3A//api.soundcloud.com/tracks/'.$attributes['track_id'].'&amp;secret_token='.$attributes['secret_token'];else{if((\strpos($attributes['id'],'://')===\false))$html.='https%3A//soundcloud.com/';$html.=$attributes['id'];}$html.='" style="border:0;height:';if(isset($attributes['playlist_id'])||(\strpos($attributes['id'],'/sets/')!==\false))$html.='450';else$html.='166';$html.='px;max-width:900px;width:100%"></iframe>';}elseif($qb<24)if($qb===21){$attributes+=array('path'=>\null);$html='<div data-s9e-mediaembed="spotify" style="display:inline-block;width:100%;max-width:400px"><div style="overflow:hidden;position:relative;padding-bottom:120%"><iframe allowfullscreen="" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="https://embed.spotify.com/?view=coverart&amp;uri=';if(isset($attributes['uri']))$html.=$attributes['uri'];else$html.='spotify:'.\strtr($attributes['path'],'/',':');$html.='"></iframe></div></div>';}elseif($qb===22){$attributes+=array('id'=>\null);$html='<div data-s9e-mediaembed="ted" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//embed.ted.com/'.$attributes['id'];if((\strpos($attributes['id'],'.html')===\false))$html.='.html';$html.='"></iframe></div></div>';}else{$attributes+=array('channel'=>\null);$html='<div data-s9e-mediaembed="twitch" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="';if(isset($attributes['clip_id']))$html.='//clips.twitch.tv/embed?autoplay=false&amp;clip='.$attributes['channel'].'/'.$attributes['clip_id'];else{$html.='//player.twitch.tv/?autoplay=false&amp;';if(isset($attributes['archive_id']))$html.='video=a'.$attributes['archive_id'];elseif(isset($attributes['chapter_id']))$html.='video=c'.$attributes['chapter_id'];elseif(isset($attributes['video_id']))$html.='video=v'.$attributes['video_id'];else$html.='channel='.$attributes['channel'];if(isset($attributes['t']))$html.='&amp;time='.$attributes['t'];}$html.='"></iframe></div></div>';}elseif($qb===24){$attributes+=array('cid'=>\null);$html='<div data-s9e-mediaembed="ustream" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%">';if(isset($attributes['vid']))$html.='<iframe allowfullscreen="" scrolling="no" src="//www.ustream.tv/embed/recorded/'.$attributes['vid'];else$html.='<iframe allowfullscreen="" scrolling="no" src="//www.ustream.tv/embed/'.$attributes['cid'];$html.='?html5ui" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe>';$html.='</div></div>';}elseif($qb===25){$attributes+=array('width'=>\null,'height'=>\null,'id'=>\null);$html='<div data-s9e-mediaembed="vidme" style="display:inline-block;width:100%;max-width:'.$attributes['width'].'px"><div style="overflow:hidden;position:relative;';if(\htmlspecialchars_decode($attributes['width'])>0)$html.='padding-bottom:'.\htmlspecialchars(100*$attributes['height']/\htmlspecialchars_decode($attributes['width']),2).'%';$html.='"><iframe allowfullscreen="" scrolling="no" src="https://vid.me/e/'.$attributes['id'].'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></div></div>';}else{$attributes+=array('id'=>\null,'m'=>\null,'s'=>\null);$html='<div data-s9e-mediaembed="youtube" style="display:inline-block;width:100%;max-width:640px"><div style="overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" style="background:url(https://i.ytimg.com/vi/'.$attributes['id'].'/hqdefault.jpg) 50% 50% / cover;border:0;height:100%;left:0;position:absolute;width:100%" src="https://www.youtube.com/embed/'.$attributes['id'];if(isset($attributes['list']))$html.='?list='.$attributes['list'];if(isset($attributes['t'])||isset($attributes['m'])){if(isset($attributes['list']))$html.='&amp;';else$html.='?';$html.='start=';if(isset($attributes['t']))$html.=$attributes['t'];elseif(isset($attributes['h']))$html.=\htmlspecialchars($attributes['h']*3600+$attributes['m']*60+$attributes['s'],2);else$html.=\htmlspecialchars($attributes['m']*60+$attributes['s'],2);}$html.='"></iframe></div></div>';}
		return $html;
	}
}