<?php

/**
* @package   s9e\TextFormatter
* @copyright Copyright (c) 2010-2019 The s9e Authors
* @license   http://www.opensource.org/licenses/mit-license.php The MIT License
*/
class s9e_renderer_522c71daea0b2726b0c699e9b3a11a0a2622d01b extends \s9e\TextFormatter\Renderers\PHP
{
	protected $params=['L_CODE'=>'','L_COLON'=>'','L_IMAGE'=>'','L_SELECT_ALL_CODE'=>'','L_WROTE'=>'','S_VIEWFLASH'=>'','S_VIEWIMG'=>'','S_VIEWSMILIES'=>'','T_SMILIES_PATH'=>''];
	protected function renderNode(\DOMNode $node)
	{
		switch($node->nodeName){case'ALBUM':$this->out.='<a href="http://www.badlands.ca/forum/gallery/image.php?image_id='.htmlspecialchars($node->getAttribute('content'),2).'"><img src="http://www.badlands.ca/forum/gallery/image.php?mode=thumbnail&amp;image_id='.htmlspecialchars($node->getAttribute('content'),2).'" alt="'.htmlspecialchars($node->getAttribute('content'),2).'"></a>';break;case'ATTACHMENT':$this->out.='<div class="inline-attachment"><!-- ia'.htmlspecialchars($node->getAttribute('index'),0).' -->'.htmlspecialchars($node->getAttribute('filename'),0).'<!-- ia'.htmlspecialchars($node->getAttribute('index'),0).' --></div>';break;case'B':$this->out.='<strong class="text-strong">';$this->at($node);$this->out.='</strong>';break;case'CENTER':$this->out.='<div align="center">';$this->at($node);$this->out.='</div>';break;case'CODE':$this->out.='<div class="codebox"><p>'.htmlspecialchars($this->params['L_CODE'].$this->params['L_COLON'],0).' <a href="#" onclick="selectCode(this); return false;">'.htmlspecialchars($this->params['L_SELECT_ALL_CODE'],0).'</a></p><pre><code>';$this->at($node);$this->out.='</code></pre></div>';break;case'COLOR':$this->out.='<span style="color:'.htmlspecialchars($node->getAttribute('color'),2).'">';$this->at($node);$this->out.='</span>';break;case'E':if($this->params['S_VIEWSMILIES']==='')$this->out.=htmlspecialchars($node->textContent,0);else{switch($node->textContent){case'-/-(':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/tr_rip.gif" width="15" height="15" alt="-/-(" title="R.I.P.">';break;case'8)':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_cool.gif" width="15" height="15" alt="8)" title="Cool">';break;case'8-)':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_cool.gif" width="15" height="15" alt="8-)" title="Cool">';break;case'8-O':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_eek.gif" width="15" height="15" alt="8-O" title="Shocked">';break;case'8O':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_eek.gif" width="15" height="15" alt="8O" title="Shocked">';break;case':!:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_exclaim.gif" width="15" height="15" alt=":!:" title="Exclamation">';break;case':(':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_sad.gif" width="15" height="15" alt=":(" title="Sad">';break;case':)':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_smile.gif" width="15" height="15" alt=":)" title="Smile">';break;case':-(':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_sad.gif" width="15" height="15" alt=":-(" title="Sad">';break;case':-)':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_smile.gif" width="15" height="15" alt=":-)" title="Smile">';break;case':-?':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_confused.gif" width="15" height="15" alt=":-?" title="Confused">';break;case':-D':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_biggrin.gif" width="15" height="15" alt=":-D" title="Very Happy">';break;case':-P':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_razz.gif" width="15" height="15" alt=":-P" title="Razz">';break;case':-o':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_surprised.gif" width="15" height="15" alt=":-o" title="Surprised">';break;case':-x':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_mad.gif" width="15" height="15" alt=":-x" title="Mad">';break;case':-|':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_neutral.gif" width="15" height="15" alt=":-|" title="Neutral">';break;case':2guns:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/gun_2guns.gif" width="15" height="15" alt=":2guns:" title="2guns">';break;case'::::||':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_glare.gif" width="15" height="15" alt="::::||" title="Glare">';break;case':::=|':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_drool.gif" width="15" height="15" alt=":::=|" title="Drool">';break;case':?':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_confused.gif" width="15" height="15" alt=":?" title="Confused">';break;case':?:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_question.gif" width="15" height="15" alt=":?:" title="Question">';break;case':???:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_confused.gif" width="15" height="15" alt=":???:" title="Confused">';break;case':D':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_biggrin.gif" width="15" height="15" alt=":D" title="Very Happy">';break;case':M<':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/Icon_mexican.gif" width="30" height="30" alt=":M&lt;" title="Taco">';break;case':Nooooo!:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/novader_icon.gif" width="15" height="15" alt=":Nooooo!:" title="Vader_Nooooo">';break;case':P':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_razz.gif" width="15" height="15" alt=":P" title="Razz">';break;case':RTFM:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/tr_rtfm.gif" width="15" height="15" alt=":RTFM:" title="RTFM!">';break;case':alien:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/non_alien.gif" width="15" height="15" alt=":alien:" title="Alien">';break;case':alright:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/alright.gif" width="15" height="15" alt=":alright:" title="Alright">';break;case':angel:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/big_angel.gif" width="15" height="15" alt=":angel:" title="Angel">';break;case':angery:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/angry.gif" width="15" height="15" alt=":angery:" title="Angery">';break;case':angry:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_angry.gif" width="15" height="15" alt=":angry:" title="Angry">';break;case':annihilate:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/gun_annihilate.gif" width="15" height="15" alt=":annihilate:" title="Annihilate">';break;case':argue:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ext_argue.gif" width="15" height="15" alt=":argue:" title="Argue">';break;case':arrow2:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_arrow2.gif" width="15" height="15" alt=":arrow2:" title="Left Arrow">';break;case':arrow:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_arrow.gif" width="15" height="15" alt=":arrow:" title="Right Arrow">';break;case':artist:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ext_artist.gif" width="15" height="15" alt=":artist:" title="Artist">';break;case':axe:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/gun_axe.gif" width="15" height="15" alt=":axe:" title="Axe">';break;case':baby:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ext_baby.gif" width="15" height="15" alt=":baby:" title="Baby">';break;case':ban:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/tr_ban.gif" width="15" height="15" alt=":ban:" title="Ban">';break;case':bananadance2:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/non_banana2.gif" width="15" height="15" alt=":bananadance2:" title="Bananadance 2">';break;case':bananadance:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/non_banana1.gif" width="15" height="15" alt=":bananadance:" title="Bananadance">';break;case':band:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/big_band.gif" width="15" height="15" alt=":band:" title="Band">';break;case':bangwall:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/banging.gif" width="15" height="15" alt=":bangwall:" title="Banging Head On Wall">';break;case':bash:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/gun_bash.gif" width="15" height="15" alt=":bash:" title="Bash">';break;case':beer2:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ext_beer2.gif" width="15" height="15" alt=":beer2:" title="Beer 2">';break;case':beer:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ext_beer.gif" width="15" height="15" alt=":beer:" title="Beer">';break;case':bigups:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/bigups.gif" width="15" height="15" alt=":bigups:" title="Big Ups">';break;case':biker:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ppl_biker.gif" width="15" height="15" alt=":biker:" title="Biker">';break;case':book:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ext_book.gif" width="15" height="15" alt=":book:" title="Book">';break;case':bounce:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ext_bounce.gif" width="15" height="15" alt=":bounce:" title="Bounce">';break;case':bow:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ges_bow.gif" width="15" height="15" alt=":bow:" title="Bow">';break;case':box:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ext_box.gif" width="15" height="15" alt=":box:" title="Box">';break;case':boxed:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_boxed.gif" width="15" height="15" alt=":boxed:" title="Boxed">';break;case':bshelp:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/bs_help.gif" width="15" height="15" alt=":bshelp:" title="bshelp">';break;case':bsiloveu:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/bs_iloveyou.gif" width="15" height="15" alt=":bsiloveu:" title="bsiloveu">';break;case':bslame:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/bs_lame.gif" width="15" height="15" alt=":bslame:" title="bslame">';break;case':bsnostealing:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/bs_nostealinganything.gif" width="15" height="15" alt=":bsnostealing:" title="bsnostealing">';break;case':bsofftopic:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/bs_offtopic.gif" width="15" height="15" alt=":bsofftopic:" title="bsofftopic">';break;case':bsspam:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/bs_spam.gif" width="15" height="15" alt=":bsspam:" title="bsspam">';break;case':bsstopspam:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/bs_stopspamnlamor.gif" width="15" height="15" alt=":bsstopspam:" title="bsstopspam">';break;case':bswhat:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/bs_quesexclaim.gif" width="15" height="15" alt=":bswhat:" title="bswhat">';break;case':cat:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/non_cat.gif" width="15" height="15" alt=":cat:" title="Cat">';break;case':chair:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/gun_chair.gif" width="15" height="15" alt=":chair:" title="Chair">';break;case':chef:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ppl_chef.gif" width="15" height="15" alt=":chef:" title="Chef">';break;case':cigar:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ext_cigar.gif" width="15" height="15" alt=":cigar:" title="Cigar">';break;case':clap2:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ges_clap2.gif" width="15" height="15" alt=":clap2:" title="Clap 2">';break;case':clap:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ges_clap.gif" width="15" height="15" alt=":clap:" title="Clap">';break;case':clover:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/non_clover.gif" width="15" height="15" alt=":clover:" title="Clover">';break;case':clown:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ext_clown.gif" width="15" height="15" alt=":clown:" title="Clown">';break;case':comehereyou:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/bs_comehereyou.gif" width="15" height="15" alt=":comehereyou:" title="comehereyou">';break;case':cool:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_cool.gif" width="15" height="15" alt=":cool:" title="Cool">';break;case':crutch:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ext_crutch.gif" width="15" height="15" alt=":crutch:" title="Crutch">';break;case':cry2:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/cry.gif" width="15" height="15" alt=":cry2:" title="Cry">';break;case':cry:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_cry.gif" width="15" height="15" alt=":cry:" title="Crying or Very sad">';break;case':cry_baby:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ext_crybaby.gif" width="15" height="15" alt=":cry_baby:" title="Cry Baby">';break;case':cylon:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ppl_cylon.gif" width="15" height="15" alt=":cylon:" title="Cylon">';break;case':discuss:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/discussion.gif" width="15" height="15" alt=":discuss:" title="Discussion">';break;case':disgusted:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/disgusted.gif" width="15" height="15" alt=":disgusted:" title="Disgusted">';break;case':doc:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ext_doc.gif" width="15" height="15" alt=":doc:" title="Doc">';break;case':dontgetit:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/dontgetit.gif" width="15" height="15" alt=":dontgetit:" title="Dont Get It">';break;case':down:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ges_down.gif" width="15" height="15" alt=":down:" title="Down">';break;case':drunk:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ext_drunk.gif" width="15" height="15" alt=":drunk:" title="Drunk">';break;case':eek:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_surprised.gif" width="15" height="15" alt=":eek:" title="Surprised">';break;case':evil:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_evil.gif" width="15" height="15" alt=":evil:" title="Evil or Very Mad">';break;case':explode:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/big_explode.gif" width="15" height="15" alt=":explode:" title="Explode">';break;case':flex:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ext_flex.gif" width="15" height="15" alt=":flex:" title="Flex">';break;case':furious:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_furious.gif" width="15" height="15" alt=":furious:" title="Furious">';break;case':ghey:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/sign_ghey.gif" width="15" height="15" alt=":ghey:" title="ghey">';break;case':greedy:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_greedy.gif" width="15" height="15" alt=":greedy:" title="Greedy">';break;case':grin:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_biggrin.gif" width="15" height="15" alt=":grin:" title="Very Happy">';break;case':gun:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/gun_gun.gif" width="15" height="15" alt=":gun:" title="Gun">';break;case':haha2:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/haha2.gif" width="15" height="15" alt=":haha2:" title="HAHAHA 2">';break;case':haha:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/haha.gif" width="15" height="15" alt=":haha:" title="HAHA">';break;case':hang:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/big_hang.gif" width="15" height="15" alt=":hang:" title="Hang">';break;case':hannibal:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ppl_hannibal.gif" width="15" height="15" alt=":hannibal:" title="Hannibal">';break;case':happy2:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ext_happy.gif" width="15" height="15" alt=":happy2:" title="Happy">';break;case':hbd:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/big_hbd.gif" width="15" height="15" alt=":hbd:" title="HBD">';break;case':help:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ges_help.gif" width="15" height="15" alt=":help:" title="Help">';break;case':hi:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/tr_hi.gif" width="15" height="15" alt=":hi:" title="Hi">';break;case':hitler:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ppl_hitler.gif" width="15" height="15" alt=":hitler:" title="Hitler">';break;case':hmm:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ges_hmm.gif" width="15" height="15" alt=":hmm:" title="Hmm">';break;case':homestar:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/non_homestar.gif" width="15" height="15" alt=":homestar:" title="Homestar">';break;case':hooray:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ext_hooray.gif" width="15" height="15" alt=":hooray:" title="Hooray">';break;case':huh:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/huh.gif" width="15" height="15" alt=":huh:" title="Huh">';break;case':hump:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ext_hump.gif" width="15" height="15" alt=":hump:" title="Hump">';break;case':icecream:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ext_icecream.gif" width="15" height="15" alt=":icecream:" title="Icecream">';break;case':idea:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_idea.gif" width="15" height="15" alt=":idea:" title="Idea">';break;case':in_love:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_in_love.gif" width="15" height="15" alt=":in_love:" title="In Love">';break;case':indian:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ppl_indian.gif" width="15" height="15" alt=":indian:" title="Indian">';break;case':jedai:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/gun_jedai.gif" width="15" height="15" alt=":jedai:" title="Jedai Saber">';break;case':jump2:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ext_jump2.gif" width="15" height="15" alt=":jump2:" title="Jump 2">';break;case':king:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ppl_king.gif" width="15" height="15" alt=":king:" title="King">';break;case':kiss:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ext_kiss.gif" width="15" height="15" alt=":kiss:" title="Kiss">';break;case':komp_cr:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ext_komp_cr.gif" width="15" height="15" alt=":komp_cr:" title="Comp Crash">';break;case':lamo:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ext_lame.gif" width="15" height="15" alt=":lamo:" title="Lamo">';break;case':lol2:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_laugh.gif" width="15" height="15" alt=":lol2:" title="LOL">';break;case':lol:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_lol.gif" width="15" height="15" alt=":lol:" title="Laughing">';break;case':love:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/non_love.gif" width="15" height="15" alt=":love:" title="Love">';break;case':lovers:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ext_lovers.gif" width="15" height="15" alt=":lovers:" title="Lovers">';break;case':mad:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_mad.gif" width="15" height="15" alt=":mad:" title="Mad">';break;case':madman:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/madman.gif" width="15" height="15" alt=":madman:" title="Mad Man">';break;case':mario:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ppl_mario.gif" width="15" height="15" alt=":mario:" title="Mario">';break;case':mbounce:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/big_mbounce.gif" width="15" height="15" alt=":mbounce:" title="Multibounce">';break;case':mobile:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ext_mobile.gif" width="15" height="15" alt=":mobile:" title="Mobile">';break;case':moon:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/moon.gif" width="15" height="15" alt=":moon:" title="Moon">';break;case':moonwalker:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_moonwlk.gif" width="15" height="15" alt=":moonwalker:" title="Moonwalker">';break;case':mrgreen:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_mrgreen.gif" width="15" height="15" alt=":mrgreen:" title="Mr. Green">';break;case':music:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ext_music.gif" width="15" height="15" alt=":music:" title="Music">';break;case':neutral:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_neutral.gif" width="15" height="15" alt=":neutral:" title="Neutral">';break;case':ninja:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ppl_ninja.gif" width="15" height="15" alt=":ninja:" title="Ninja">';break;case':ninjafist:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ppl_ninjafist.gif" width="15" height="15" alt=":ninjafist:" title="Ninja Fist">';break;case':ninjajig:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ppl_ninjajig.gif" width="15" height="15" alt=":ninjajig:" title="Ninja Jig">';break;case':no:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ges_no.gif" width="15" height="15" alt=":no:" title="No">';break;case':nuke:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/non_nuke.gif" width="15" height="15" alt=":nuke:" title="Nuke">';break;case':o':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_surprised.gif" width="15" height="15" alt=":o" title="Surprised">';break;case':oldtimer:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ppl_oldtimer.gif" width="15" height="15" alt=":oldtimer:" title="Oldtimer">';break;case':oops:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_redface.gif" width="15" height="15" alt=":oops:" title="Embarassed">';break;case':osama:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ppl_osama.gif" width="15" height="15" alt=":osama:" title="Osama">';break;case':pimp:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ppl_pimp.gif" width="15" height="15" alt=":pimp:" title="Pimp">';break;case':pirat:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ppl_pirat.gif" width="15" height="15" alt=":pirat:" title="Pirate">';break;case':pirate:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ppl_pirate.gif" width="15" height="15" alt=":pirate:" title="Pirate 2">';break;case':poked:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/poked.gif" width="15" height="15" alt=":poked:" title="Poked">';break;case':police:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ppl_police.gif" width="15" height="15" alt=":police:" title="Police">';break;case':pop:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ppl_pop.gif" width="15" height="15" alt=":pop:" title="Pop">';break;case':priest:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ppl_priest.gif" width="15" height="15" alt=":priest:" title="Priest">';break;case':protest:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/protest.gif" width="15" height="15" alt=":protest:" title="Protest">';break;case':punk:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ppl_punk.gif" width="15" height="15" alt=":punk:" title="Punk">';break;case':rambo:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ppl_rambo.gif" width="15" height="15" alt=":rambo:" title="Rambo">';break;case':rant:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_rant.gif" width="15" height="15" alt=":rant:" title="Rant">';break;case':razz2:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_razz2.gif" width="15" height="15" alt=":razz2:" title="Razz 2">';break;case':razz:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_razz.gif" width="15" height="15" alt=":razz:" title="Razz">';break;case':respect:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/tr_respect.gif" width="15" height="15" alt=":respect:" title="Respect">';break;case':rip:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/tr_rip.gif" width="15" height="15" alt=":rip:" title="R.I.P.">';break;case':rock:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ppl_rock.gif" width="15" height="15" alt=":rock:" title="Rocker">';break;case':rockout:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/rockout3.gif" width="15" height="15" alt=":rockout:" title="Rock Out">';break;case':roll:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_rolleyes.gif" width="15" height="15" alt=":roll:" title="Rolling Eyes">';break;case':sad:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_sad.gif" width="15" height="15" alt=":sad:" title="Sad">';break;case':saddam:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ppl_saddam.gif" width="15" height="15" alt=":saddam:" title="Saddam">';break;case':secret:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ext_secret.gif" width="15" height="15" alt=":secret:" title="Secret">';break;case':shaun:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/non_shaun.gif" width="15" height="15" alt=":shaun:" title="Shaun">';break;case':shock:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_eek.gif" width="15" height="15" alt=":shock:" title="Shocked">';break;case':shuriken:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ppl_shuriken.gif" width="15" height="15" alt=":shuriken:" title="Ninja Shuriken">';break;case':shutup:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ext_shutup.gif" width="15" height="15" alt=":shutup:" title="Shut Up">';break;case':sick:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_sick.gif" width="15" height="15" alt=":sick:" title="Sick">';break;case':signbye:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/sign_bye.gif" width="15" height="15" alt=":signbye:" title="signbye">';break;case':signduh:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/sign_duh.gif" width="15" height="15" alt=":signduh:" title="signduh">';break;case':signeek:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/sign_eek.gif" width="15" height="15" alt=":signeek:" title="signeek">';break;case':signfss:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/sign_ffs.gif" width="15" height="15" alt=":signfss:" title="signfss">';break;case':signhelp:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/sign_help.gif" width="15" height="15" alt=":signhelp:" title="signhelp">';break;case':signheya:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/sign_heya.gif" width="15" height="15" alt=":signheya:" title="signheya">';break;case':signl33t:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/sign_l33t.gif" width="15" height="15" alt=":signl33t:" title="signl33t">';break;case':signlame:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/sign_lame.gif" width="15" height="15" alt=":signlame:" title="signlame">';break;case':signspam:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/sign_spam.gif" width="15" height="15" alt=":signspam:" title="signspam">';break;case':signstfu:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/sign_stfu.gif" width="15" height="15" alt=":signstfu:" title="signstfu">';break;case':slap:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ges_slap.gif" width="15" height="15" alt=":slap:" title="Slap">';break;case':sleep:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ext_sleep.gif" width="15" height="15" alt=":sleep:" title="Sleep">';break;case':smile:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_smile.gif" width="15" height="15" alt=":smile:" title="Smile">';break;case':smurf:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ppl_smurf.gif" width="15" height="15" alt=":smurf:" title="Smurf">';break;case':sorry:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/tr_sorry.gif" width="15" height="15" alt=":sorry:" title="I\'m Sorry">';break;case':spam:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/tr_spam.gif" width="15" height="15" alt=":spam:" title="Spam">';break;case':spank:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/smackbottom.gif" width="15" height="15" alt=":spank:" title="Spanking">';break;case':spider:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ext_spider.gif" width="15" height="15" alt=":spider:" title="Spider">';break;case':spidey:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ppl_spidey.gif" width="15" height="15" alt=":spidey:" title="Spidey">';break;case':t_oops:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/tr_oops.gif" width="15" height="15" alt=":t_oops:" title="Oops">';break;case':tease:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ext_tease.gif" width="15" height="15" alt=":tease:" title="Tease">';break;case':thankyou:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/tr_thankyou.gif" width="15" height="15" alt=":thankyou:" title="Thank You">';break;case':tomato:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ext_tomato.gif" width="15" height="15" alt=":tomato:" title="Tomato">';break;case':twisted:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_twisted.gif" width="15" height="15" alt=":twisted:" title="Twisted Evil">';break;case':up:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ges_up.gif" width="15" height="15" alt=":up:" title="Up">';break;case':wall:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_wall.gif" width="15" height="15" alt=":wall:" title="Wall">';break;case':wbounce:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/big_wbounce.gif" width="15" height="15" alt=":wbounce:" title="Wave Bounce">';break;case':weep:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_weep.gif" width="15" height="15" alt=":weep:" title="Weep">';break;case':wheelcha:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ext_wheelcha.gif" width="15" height="15" alt=":wheelcha:" title="Wheel Chair">';break;case':whistle:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ges_whistle.gif" width="15" height="15" alt=":whistle:" title="Whistling">';break;case':wink:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_wink.gif" width="15" height="15" alt=":wink:" title="Wink">';break;case':wolverine:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ppl_wolverine.gif" width="15" height="15" alt=":wolverine:" title="Wolverine">';break;case':x':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_mad.gif" width="15" height="15" alt=":x" title="Mad">';break;case':yawn:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_yawn.gif" width="15" height="15" alt=":yawn:" title="Yawn">';break;case':yes:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ges_yes.gif" width="15" height="15" alt=":yes:" title="Yes">';break;case':zorro:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ppl_zorro.gif" width="15" height="15" alt=":zorro:" title="Zorro">';break;case':|':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_neutral.gif" width="15" height="15" alt=":|" title="Neutral">';break;case':|<':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_redeem.gif" width="15" height="15" alt=":|&lt;" title="Redeeming">';break;case';)':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_wink.gif" width="15" height="15" alt=";)" title="Wink">';break;case';-)':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_wink.gif" width="15" height="15" alt=";-)" title="Wink">';break;case';;~)':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/5.gif" width="15" height="15" alt=";;~)" title="Eye bat">';break;case'<:)>':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/suitup.gif" width="15" height="15" alt="&lt;:)&gt;" title="Lock and Load">';break;case'<sith:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/lsabre.gif" width="15" height="15" alt="&lt;sith:" title="Lightup">';break;case'=8-|':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/22.gif" width="15" height="15" alt="=8-|" title="Nerd">';break;case'{{email}}':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_wink.gif" width="15" height="15" alt="{{email}}" title="blocked Email">';break;case'|-(o':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/33.gif" width="15" height="15" alt="|-(o" title="Thinking">';break;default:$this->out.=htmlspecialchars($node->textContent,0);}}break;case'EMAIL':$this->out.='<a href="mailto:'.htmlspecialchars($node->getAttribute('email'),2).'">';$this->at($node);$this->out.='</a>';break;case'EMOJI':if($this->params['S_VIEWSMILIES']!==''){$this->out.='<img alt="'.htmlspecialchars($node->textContent,2).'" class="emoji smilies" draggable="false" src="';if($node->hasAttribute('tseq'))$this->out.='//twemoji.maxcdn.com/2/svg/'.htmlspecialchars($node->getAttribute('tseq'),2).'.svg';else$this->out.='https://cdn.jsdelivr.net/gh/s9e/emoji-assets-twemoji@11.2/dist/svgz/'.htmlspecialchars($node->getAttribute('seq'),2).'.svgz';$this->out.='">';}else$this->out.=htmlspecialchars($node->textContent,0);break;case'FACEBOOK':$this->out.='<iframe data-s9e-mediaembed="facebook" allowfullscreen="" onload="var c=new MessageChannel;c.port1.onmessage=function(e){style.height=e.data+\'px\'};contentWindow.postMessage(\'s9e:init\',\'https://s9e.github.io\',[c.port2])" scrolling="no" src="https://s9e.github.io/iframe/2/facebook.min.html#'.htmlspecialchars($node->getAttribute('type').$node->getAttribute('id'),2).'" style="border:0;height:360px;max-width:640px;width:100%"></iframe>';break;case'FEED':$this->out.='<!-- start feedwind code --><script type="text/javascript">document.write(\'\\x3Cscript type="text/javascript" src="\' + (\'https:\' == document.location.protocol ? \'https://\' : \'http://\') + \'feed.mikle.com/js/rssmikle.js">\\x3C/script>\');</script><script type="text/javascript">(function() {var params = {rssmikle_url: "http://www.badlands.ca/forum/feed.php?f=91",rssmikle_frame_width: "800",rssmikle_frame_height: "400",frame_height_by_article: "5",rssmikle_target: "_blank",rssmikle_font: "Arial, Helvetica, sans-serif",rssmikle_font_size: "12",rssmikle_border: "off",responsive: "off",rssmikle_css_url: "",text_align: "left",text_align2: "left",corner: "off",scrollbar: "off",autoscroll: "off",scrolldirection: "down",scrollstep: "3",mcspeed: "20",sort: "New",rssmikle_title: "off",rssmikle_title_sentence: "",rssmikle_title_link: "",rssmikle_title_bgcolor: "#0066FF",rssmikle_title_color: "#FFFFFF",rssmikle_title_bgimage: "",rssmikle_item_bgcolor: "#FFFFFF",rssmikle_item_bgimage: "",rssmikle_item_title_length: "55",rssmikle_item_title_color: "#0066FF",rssmikle_item_border_bottom: "on",rssmikle_item_description: "on",item_link: "on",rssmikle_item_description_length: "150",rssmikle_item_description_color: "#666666",rssmikle_item_date: "gl1",rssmikle_timezone: "Etc/GMT",datetime_format: "%b %e, %Y %l:%M:%S %p",item_description_style: "text+tn",item_thumbnail: "full",article_num: "15",rssmikle_item_podcast: "off",keyword_inc: "",keyword_exc: ""};feedwind_show_widget_iframe(params);})();</script><div style="font-size:10px;text-align:center;width:800px"><a href="http://feed.mikle.com/" target="_blank" style="color:#ccc" rel="noreferrer">RSS Feed Widget</a><!--Please display the above link in your web page according to Terms of Service.--></div><!-- end feedwind code -->';break;case'FEED2':$this->out.='<!-- start feedwind code --><script type="text/javascript">document.write(\'\\x3Cscript type="text/javascript" src="\' + (\'https:\' == document.location.protocol ? \'https://\' : \'http://\') + \'www.badlands.ca/feed.js">\\x3C/script>\');</script><script type="text/javascript">(function() {var params = {rssmikle_url: "http://www.badlands.ca/forum/feed.php?f=91",rssmikle_frame_width: "800",rssmikle_frame_height: "400",frame_height_by_article: "5",rssmikle_target: "_blank",rssmikle_font: "Arial, Helvetica, sans-serif",rssmikle_font_size: "12",rssmikle_border: "off",responsive: "off",rssmikle_css_url: "",text_align: "left",text_align2: "left",corner: "off",scrollbar: "off",autoscroll: "off",scrolldirection: "down",scrollstep: "3",mcspeed: "20",sort: "New",rssmikle_title: "off",rssmikle_title_sentence: "",rssmikle_title_link: "",rssmikle_title_bgcolor: "#0066FF",rssmikle_title_color: "#FFFFFF",rssmikle_title_bgimage: "",rssmikle_item_bgcolor: "#FFFFFF",rssmikle_item_bgimage: "",rssmikle_item_title_length: "55",rssmikle_item_title_color: "#0066FF",rssmikle_item_border_bottom: "on",rssmikle_item_description: "on",item_link: "on",rssmikle_item_description_length: "150",rssmikle_item_description_color: "#666666",rssmikle_item_date: "gl1",rssmikle_timezone: "Etc/GMT",datetime_format: "%b %e, %Y %l:%M:%S %p",item_description_style: "text+tn",item_thumbnail: "full",article_num: "15",rssmikle_item_podcast: "off",keyword_inc: "",keyword_exc: ""};feedwind_show_widget_iframe(params);})();</script><div style="font-size:10px;text-align:center;width:800px"><a href="http://www.badlands.ca/" target="_blank" style="color:#ccc" rel="noreferrer">RSS Feed Widget</a><!--Please display the above link in your web page according to Terms of Service.--></div><!-- end feedwind code -->';break;case'FLASH':if($this->params['S_VIEWFLASH']!=='')$this->out.='<object classid="clsid:D27CDB6E-AE6D-11CF-96B8-444553540000" codebase="http://active.macromedia.com/flash2/cabs/swflash.cab#version=5,0,0,0" width="'.htmlspecialchars($node->getAttribute('width'),2).'" height="'.htmlspecialchars($node->getAttribute('height'),2).'"><param name="movie" value="'.htmlspecialchars($node->getAttribute('url'),2).'"><param name="play" value="false"><param name="loop" value="false"><param name="quality" value="high"><param name="allowScriptAccess" value="never"><param name="allowNetworking" value="internal"><embed src="'.htmlspecialchars($node->getAttribute('url'),2).'" type="application/x-shockwave-flash" pluginspage="http://www.macromedia.com/shockwave/download/index.cgi?P1_Prod_Version=ShockwaveFlash" width="'.htmlspecialchars($node->getAttribute('width'),2).'" height="'.htmlspecialchars($node->getAttribute('height'),2).'" play="false" loop="false" quality="high" allowscriptaccess="never" allownetworking="internal"></object>';else$this->at($node);break;case'I':$this->out.='<em class="text-italics">';$this->at($node);$this->out.='</em>';break;case'IMAGE':$this->out.='<a href="'.htmlspecialchars($node->getAttribute('content'),2).'"><img style="max-width:800px;max-height;800px" src="'.htmlspecialchars($node->getAttribute('content'),2).'" alt="Image"></a>';break;case'IMG':if($this->params['S_VIEWIMG']!=='')$this->out.='<img src="'.htmlspecialchars($node->getAttribute('src'),2).'" class="postimage" alt="'.htmlspecialchars($this->params['L_IMAGE'],2).'">';else$this->at($node);break;case'INVTABLE':$this->out.='<table border="0">';$this->at($node);$this->out.='</table>';break;case'LI':$this->out.='<li>';$this->at($node);$this->out.='</li>';break;case'LINK_TEXT':$this->out.=htmlspecialchars($node->getAttribute('text'),0);break;case'LIST':if(!$node->hasAttribute('type')){$this->out.='<ul>';$this->at($node);$this->out.='</ul>';}elseif((strpos('upperlowerdecim',mb_substr($node->getAttribute('type'),0,5,'utf-8'))!==false)){$this->out.='<ol style="list-style-type:'.htmlspecialchars($node->getAttribute('type'),2).'">';$this->at($node);$this->out.='</ol>';}else{$this->out.='<ul style="list-style-type:'.htmlspecialchars($node->getAttribute('type'),2).'">';$this->at($node);$this->out.='</ul>';}break;case'MENTION':$this->out.='<span class="mention">@';$this->at($node);$this->out.='</span>';break;case'QUOTE':$this->out.='<blockquote';if(!$node->hasAttribute('author'))$this->out.=' class="uncited"';$this->out.='><div>';if($node->hasAttribute('author')){$this->out.='<cite>';if($node->hasAttribute('url'))$this->out.='<a href="'.htmlspecialchars($node->getAttribute('url'),2).'" class="postlink">'.htmlspecialchars($node->getAttribute('author'),0).'</a>';elseif($node->hasAttribute('profile_url'))$this->out.='<a href="'.htmlspecialchars($node->getAttribute('profile_url'),2).'">'.htmlspecialchars($node->getAttribute('author'),0).'</a>';else$this->out.=htmlspecialchars($node->getAttribute('author'),0);$this->out.=' '.htmlspecialchars($this->params['L_WROTE'].$this->params['L_COLON'],0);if($node->hasAttribute('post_url'))$this->out.=' <a href="'.htmlspecialchars($node->getAttribute('post_url'),2).'" data-post-id="'.htmlspecialchars($node->getAttribute('post_id'),2).'" onclick="if(document.getElementById(hash.substr(1)))href=hash">↑</a>';if($node->hasAttribute('date'))$this->out.='<div class="responsive-hide">'.htmlspecialchars($node->getAttribute('date'),0).'</div>';$this->out.='</cite>';}$this->at($node);$this->out.='</div></blockquote>';break;case'SIZE':$this->out.='<span style="font-size:'.htmlspecialchars($node->getAttribute('size'),2).'%;line-height:116%">';$this->at($node);$this->out.='</span>';break;case'SPREADSHEET':$this->out.='<iframe src="https://docs.google.com/spreadsheet/ccc?key='.htmlspecialchars($node->getAttribute('content'),2).'&amp;rm=minimal" width="675" height="675" border="0"></iframe>';break;case'TABLE':$this->out.='<table border="1">';$this->at($node);$this->out.='</table>';break;case'TD':$this->out.='<td style="padding:10px 10px 0 10px">';$this->at($node);$this->out.='</td>';break;case'TD25':$this->out.='<td style="padding:10px;width:25%">';$this->at($node);$this->out.='</td>';break;case'TR':$this->out.='<tr>';$this->at($node);$this->out.='</tr>';break;case'TWITTER':$this->out.='<iframe data-s9e-mediaembed="twitter" allow="autoplay *" allowfullscreen="" onload="var c=new MessageChannel;c.port1.onmessage=function(e){style.height=e.data+\'px\'};contentWindow.postMessage(\'s9e:init\',\'https://s9e.github.io\',[c.port2])" scrolling="no" src="https://s9e.github.io/iframe/2/twitter.min.html#'.htmlspecialchars($node->getAttribute('id'),2).'" style="background:url(https://abs.twimg.com/favicons/favicon.ico) no-repeat 50% 50%;border:0;height:250px;max-width:500px;width:100%"></iframe>';break;case'U':$this->out.='<span style="text-decoration:underline">';$this->at($node);$this->out.='</span>';break;case'UID':$this->out.='<a href="http://www.501st.com/members/displaymemberdetails.php?userID='.htmlspecialchars($node->getAttribute('content'),2).'" target="_blank" rel="noreferrer">501st Profile</a>';break;case'URL':$this->out.='<a href="'.htmlspecialchars($node->getAttribute('url'),2).'" class="postlink">';$this->at($node);$this->out.='</a>';break;case'VIDEOMP4':$this->out.='<video width="640" height="360" preload="auto" controls="" controlslist="nodownload"><source src="'.htmlspecialchars($node->getAttribute('content'),2).'" type="video/mp4"></video>';break;case'XURL':$this->out.='<a href="'.htmlspecialchars($node->getAttribute('xurl'),2).'" title="'.htmlspecialchars($node->getAttribute('content'),2).'" style="text-decoration:underline" onclick="window.open(this.href);return false;">'.htmlspecialchars($node->getAttribute('content'),0).'</a>';break;case'YOUTUBE':$this->out.='<object width="425" height="344"><param name="movie" value="'.htmlspecialchars($node->getAttribute('content0'),2).'v/'.htmlspecialchars($node->getAttribute('content1'),2).'&amp;rel=en&amp;fs=1&amp;color1=0x234900&amp;color2=0xd4d4d4"><param name="allowFullScreen" value="true"><param name="allowscriptaccess" value="always"><embed src="'.htmlspecialchars($node->getAttribute('content0'),2).'v/'.htmlspecialchars($node->getAttribute('content1'),2).'&amp;rel=en&amp;fs=1&amp;color1=0x234900&amp;color2=0xd4d4d4" type="application/x-shockwave-flash" allowscriptaccess="always" allowfullscreen="true" width="425" height="344"></object>';break;case'br':$this->out.='<br>';break;case'e':case'i':case's':break;case'p':$this->out.='<p>';$this->at($node);$this->out.='</p>';break;default:$this->at($node);}
	}
	/** {@inheritdoc} */
	public $enableQuickRenderer=true;
	/** {@inheritdoc} */
	protected $static=['/B'=>'</strong>','/CENTER'=>'</div>','/CODE'=>'</code></pre></div>','/COLOR'=>'</span>','/EMAIL'=>'</a>','/I'=>'</em>','/INVTABLE'=>'</table>','/LI'=>'</li>','/MENTION'=>'</span>','/QUOTE'=>'</div></blockquote>','/SIZE'=>'</span>','/TABLE'=>'</table>','/TD'=>'</td>','/TD25'=>'</td>','/TR'=>'</tr>','/U'=>'</span>','/URL'=>'</a>','B'=>'<strong class="text-strong">','CENTER'=>'<div align="center">','FEED'=>'<!-- start feedwind code --><script type="text/javascript">document.write(\'\\x3Cscript type="text/javascript" src="\' + (\'https:\' == document.location.protocol ? \'https://\' : \'http://\') + \'feed.mikle.com/js/rssmikle.js">\\x3C/script>\');</script><script type="text/javascript">(function() {var params = {rssmikle_url: "http://www.badlands.ca/forum/feed.php?f=91",rssmikle_frame_width: "800",rssmikle_frame_height: "400",frame_height_by_article: "5",rssmikle_target: "_blank",rssmikle_font: "Arial, Helvetica, sans-serif",rssmikle_font_size: "12",rssmikle_border: "off",responsive: "off",rssmikle_css_url: "",text_align: "left",text_align2: "left",corner: "off",scrollbar: "off",autoscroll: "off",scrolldirection: "down",scrollstep: "3",mcspeed: "20",sort: "New",rssmikle_title: "off",rssmikle_title_sentence: "",rssmikle_title_link: "",rssmikle_title_bgcolor: "#0066FF",rssmikle_title_color: "#FFFFFF",rssmikle_title_bgimage: "",rssmikle_item_bgcolor: "#FFFFFF",rssmikle_item_bgimage: "",rssmikle_item_title_length: "55",rssmikle_item_title_color: "#0066FF",rssmikle_item_border_bottom: "on",rssmikle_item_description: "on",item_link: "on",rssmikle_item_description_length: "150",rssmikle_item_description_color: "#666666",rssmikle_item_date: "gl1",rssmikle_timezone: "Etc/GMT",datetime_format: "%b %e, %Y %l:%M:%S %p",item_description_style: "text+tn",item_thumbnail: "full",article_num: "15",rssmikle_item_podcast: "off",keyword_inc: "",keyword_exc: ""};feedwind_show_widget_iframe(params);})();</script><div style="font-size:10px;text-align:center;width:800px"><a href="http://feed.mikle.com/" target="_blank" style="color:#ccc" rel="noreferrer">RSS Feed Widget</a><!--Please display the above link in your web page according to Terms of Service.--></div><!-- end feedwind code -->','FEED2'=>'<!-- start feedwind code --><script type="text/javascript">document.write(\'\\x3Cscript type="text/javascript" src="\' + (\'https:\' == document.location.protocol ? \'https://\' : \'http://\') + \'www.badlands.ca/feed.js">\\x3C/script>\');</script><script type="text/javascript">(function() {var params = {rssmikle_url: "http://www.badlands.ca/forum/feed.php?f=91",rssmikle_frame_width: "800",rssmikle_frame_height: "400",frame_height_by_article: "5",rssmikle_target: "_blank",rssmikle_font: "Arial, Helvetica, sans-serif",rssmikle_font_size: "12",rssmikle_border: "off",responsive: "off",rssmikle_css_url: "",text_align: "left",text_align2: "left",corner: "off",scrollbar: "off",autoscroll: "off",scrolldirection: "down",scrollstep: "3",mcspeed: "20",sort: "New",rssmikle_title: "off",rssmikle_title_sentence: "",rssmikle_title_link: "",rssmikle_title_bgcolor: "#0066FF",rssmikle_title_color: "#FFFFFF",rssmikle_title_bgimage: "",rssmikle_item_bgcolor: "#FFFFFF",rssmikle_item_bgimage: "",rssmikle_item_title_length: "55",rssmikle_item_title_color: "#0066FF",rssmikle_item_border_bottom: "on",rssmikle_item_description: "on",item_link: "on",rssmikle_item_description_length: "150",rssmikle_item_description_color: "#666666",rssmikle_item_date: "gl1",rssmikle_timezone: "Etc/GMT",datetime_format: "%b %e, %Y %l:%M:%S %p",item_description_style: "text+tn",item_thumbnail: "full",article_num: "15",rssmikle_item_podcast: "off",keyword_inc: "",keyword_exc: ""};feedwind_show_widget_iframe(params);})();</script><div style="font-size:10px;text-align:center;width:800px"><a href="http://www.badlands.ca/" target="_blank" style="color:#ccc" rel="noreferrer">RSS Feed Widget</a><!--Please display the above link in your web page according to Terms of Service.--></div><!-- end feedwind code -->','I'=>'<em class="text-italics">','INVTABLE'=>'<table border="0">','LI'=>'<li>','MENTION'=>'<span class="mention">@','TABLE'=>'<table border="1">','TD'=>'<td style="padding:10px 10px 0 10px">','TD25'=>'<td style="padding:10px;width:25%">','TR'=>'<tr>','U'=>'<span style="text-decoration:underline">'];
	/** {@inheritdoc} */
	protected $dynamic=['ALBUM'=>['(^[^ ]+(?> (?!content=)[^=]+="[^"]*")*(?> content="([^"]*)")?.*)s','<a href="http://www.badlands.ca/forum/gallery/image.php?image_id=$1"><img src="http://www.badlands.ca/forum/gallery/image.php?mode=thumbnail&amp;image_id=$1" alt="$1"></a>'],'COLOR'=>['(^[^ ]+(?> (?!color=)[^=]+="[^"]*")*(?> color="([^"]*)")?.*)s','<span style="color:$1">'],'EMAIL'=>['(^[^ ]+(?> (?!email=)[^=]+="[^"]*")*(?> email="([^"]*)")?.*)s','<a href="mailto:$1">'],'IMAGE'=>['(^[^ ]+(?> (?!content=)[^=]+="[^"]*")*(?> content="([^"]*)")?.*)s','<a href="$1"><img style="max-width:800px;max-height;800px" src="$1" alt="Image"></a>'],'SIZE'=>['(^[^ ]+(?> (?!size=)[^=]+="[^"]*")*(?> size="([^"]*)")?.*)s','<span style="font-size:$1%;line-height:116%">'],'SPREADSHEET'=>['(^[^ ]+(?> (?!content=)[^=]+="[^"]*")*(?> content="([^"]*)")?.*)s','<iframe src="https://docs.google.com/spreadsheet/ccc?key=$1&amp;rm=minimal" width="675" height="675" border="0"></iframe>'],'TWITTER'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="twitter" allow="autoplay *" allowfullscreen="" onload="var c=new MessageChannel;c.port1.onmessage=function(e){style.height=e.data+\'px\'};contentWindow.postMessage(\'s9e:init\',\'https://s9e.github.io\',[c.port2])" scrolling="no" src="https://s9e.github.io/iframe/2/twitter.min.html#$1" style="background:url(https://abs.twimg.com/favicons/favicon.ico) no-repeat 50% 50%;border:0;height:250px;max-width:500px;width:100%"></iframe>'],'UID'=>['(^[^ ]+(?> (?!content=)[^=]+="[^"]*")*(?> content="([^"]*)")?.*)s','<a href="http://www.501st.com/members/displaymemberdetails.php?userID=$1" target="_blank" rel="noreferrer">501st Profile</a>'],'URL'=>['(^[^ ]+(?> (?!url=)[^=]+="[^"]*")*(?> url="([^"]*)")?.*)s','<a href="$1" class="postlink">'],'VIDEOMP4'=>['(^[^ ]+(?> (?!content=)[^=]+="[^"]*")*(?> content="([^"]*)")?.*)s','<video width="640" height="360" preload="auto" controls="" controlslist="nodownload"><source src="$1" type="video/mp4"></video>'],'YOUTUBE'=>['(^[^ ]+(?> (?!content[01]=)[^=]+="[^"]*")*(?> content0="([^"]*)")?(?> (?!content1=)[^=]+="[^"]*")*(?> content1="([^"]*)")?.*)s','<object width="425" height="344"><param name="movie" value="$1v/$2&amp;rel=en&amp;fs=1&amp;color1=0x234900&amp;color2=0xd4d4d4"><param name="allowFullScreen" value="true"><param name="allowscriptaccess" value="always"><embed src="$1v/$2&amp;rel=en&amp;fs=1&amp;color1=0x234900&amp;color2=0xd4d4d4" type="application/x-shockwave-flash" allowscriptaccess="always" allowfullscreen="true" width="425" height="344"></object>']];
	/** {@inheritdoc} */
	protected $quickRegexp='(<(?:(?!/)((?:A(?>LBUM|TTACHMENT)|E(?>MOJI)?|F(?:ACEBOOK|EED2?)|IMAGE|LINK_TEXT|SPREADSHEET|TWITTER|UID|VIDEOMP4|XURL|YOUTUBE))(?: [^>]*)?>.*?</\\1|(/?(?!br/|p>)[^ />]+)[^>]*?(/)?)>)s';
	/** {@inheritdoc} */
	protected $quickRenderingTest='(<(?:[!?]|(?>FLASH|IMG)[ />]))';
	/** {@inheritdoc} */
	protected function renderQuickTemplate($id, $xml)
	{
		$attributes=$this->matchAttributes($xml);
		$html='';switch($id){case'/LIST':$attributes=array_pop($this->attributes);if(!isset($attributes['type']))$html.='</ul>';elseif((strpos('upperlowerdecim',mb_substr(htmlspecialchars_decode($attributes['type']),0,5,'utf-8'))!==false))$html.='</ol>';else$html.='</ul>';break;case'ATTACHMENT':$attributes+=['index'=>null,'filename'=>null];$html.='<div class="inline-attachment"><!-- ia'.str_replace('&quot;','"',$attributes['index']).' -->'.str_replace('&quot;','"',$attributes['filename']).'<!-- ia'.str_replace('&quot;','"',$attributes['index']).' --></div>';break;case'CODE':$html.='<div class="codebox"><p>'.htmlspecialchars($this->params['L_CODE'].$this->params['L_COLON'],0).' <a href="#" onclick="selectCode(this); return false;">'.htmlspecialchars($this->params['L_SELECT_ALL_CODE'],0).'</a></p><pre><code>';break;case'E':$textContent=$this->getQuickTextContent($xml);if($this->params['S_VIEWSMILIES']==='')$html.=htmlspecialchars($textContent,0);else{switch($textContent){case'-/-(':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/tr_rip.gif" width="15" height="15" alt="-/-(" title="R.I.P.">';break;case'8)':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_cool.gif" width="15" height="15" alt="8)" title="Cool">';break;case'8-)':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_cool.gif" width="15" height="15" alt="8-)" title="Cool">';break;case'8-O':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_eek.gif" width="15" height="15" alt="8-O" title="Shocked">';break;case'8O':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_eek.gif" width="15" height="15" alt="8O" title="Shocked">';break;case':!:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_exclaim.gif" width="15" height="15" alt=":!:" title="Exclamation">';break;case':(':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_sad.gif" width="15" height="15" alt=":(" title="Sad">';break;case':)':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_smile.gif" width="15" height="15" alt=":)" title="Smile">';break;case':-(':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_sad.gif" width="15" height="15" alt=":-(" title="Sad">';break;case':-)':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_smile.gif" width="15" height="15" alt=":-)" title="Smile">';break;case':-?':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_confused.gif" width="15" height="15" alt=":-?" title="Confused">';break;case':-D':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_biggrin.gif" width="15" height="15" alt=":-D" title="Very Happy">';break;case':-P':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_razz.gif" width="15" height="15" alt=":-P" title="Razz">';break;case':-o':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_surprised.gif" width="15" height="15" alt=":-o" title="Surprised">';break;case':-x':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_mad.gif" width="15" height="15" alt=":-x" title="Mad">';break;case':-|':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_neutral.gif" width="15" height="15" alt=":-|" title="Neutral">';break;case':2guns:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/gun_2guns.gif" width="15" height="15" alt=":2guns:" title="2guns">';break;case'::::||':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_glare.gif" width="15" height="15" alt="::::||" title="Glare">';break;case':::=|':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_drool.gif" width="15" height="15" alt=":::=|" title="Drool">';break;case':?':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_confused.gif" width="15" height="15" alt=":?" title="Confused">';break;case':?:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_question.gif" width="15" height="15" alt=":?:" title="Question">';break;case':???:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_confused.gif" width="15" height="15" alt=":???:" title="Confused">';break;case':D':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_biggrin.gif" width="15" height="15" alt=":D" title="Very Happy">';break;case':M<':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/Icon_mexican.gif" width="30" height="30" alt=":M&lt;" title="Taco">';break;case':Nooooo!:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/novader_icon.gif" width="15" height="15" alt=":Nooooo!:" title="Vader_Nooooo">';break;case':P':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_razz.gif" width="15" height="15" alt=":P" title="Razz">';break;case':RTFM:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/tr_rtfm.gif" width="15" height="15" alt=":RTFM:" title="RTFM!">';break;case':alien:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/non_alien.gif" width="15" height="15" alt=":alien:" title="Alien">';break;case':alright:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/alright.gif" width="15" height="15" alt=":alright:" title="Alright">';break;case':angel:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/big_angel.gif" width="15" height="15" alt=":angel:" title="Angel">';break;case':angery:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/angry.gif" width="15" height="15" alt=":angery:" title="Angery">';break;case':angry:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_angry.gif" width="15" height="15" alt=":angry:" title="Angry">';break;case':annihilate:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/gun_annihilate.gif" width="15" height="15" alt=":annihilate:" title="Annihilate">';break;case':argue:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ext_argue.gif" width="15" height="15" alt=":argue:" title="Argue">';break;case':arrow2:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_arrow2.gif" width="15" height="15" alt=":arrow2:" title="Left Arrow">';break;case':arrow:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_arrow.gif" width="15" height="15" alt=":arrow:" title="Right Arrow">';break;case':artist:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ext_artist.gif" width="15" height="15" alt=":artist:" title="Artist">';break;case':axe:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/gun_axe.gif" width="15" height="15" alt=":axe:" title="Axe">';break;case':baby:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ext_baby.gif" width="15" height="15" alt=":baby:" title="Baby">';break;case':ban:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/tr_ban.gif" width="15" height="15" alt=":ban:" title="Ban">';break;case':bananadance2:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/non_banana2.gif" width="15" height="15" alt=":bananadance2:" title="Bananadance 2">';break;case':bananadance:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/non_banana1.gif" width="15" height="15" alt=":bananadance:" title="Bananadance">';break;case':band:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/big_band.gif" width="15" height="15" alt=":band:" title="Band">';break;case':bangwall:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/banging.gif" width="15" height="15" alt=":bangwall:" title="Banging Head On Wall">';break;case':bash:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/gun_bash.gif" width="15" height="15" alt=":bash:" title="Bash">';break;case':beer2:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ext_beer2.gif" width="15" height="15" alt=":beer2:" title="Beer 2">';break;case':beer:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ext_beer.gif" width="15" height="15" alt=":beer:" title="Beer">';break;case':bigups:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/bigups.gif" width="15" height="15" alt=":bigups:" title="Big Ups">';break;case':biker:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ppl_biker.gif" width="15" height="15" alt=":biker:" title="Biker">';break;case':book:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ext_book.gif" width="15" height="15" alt=":book:" title="Book">';break;case':bounce:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ext_bounce.gif" width="15" height="15" alt=":bounce:" title="Bounce">';break;case':bow:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ges_bow.gif" width="15" height="15" alt=":bow:" title="Bow">';break;case':box:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ext_box.gif" width="15" height="15" alt=":box:" title="Box">';break;case':boxed:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_boxed.gif" width="15" height="15" alt=":boxed:" title="Boxed">';break;case':bshelp:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/bs_help.gif" width="15" height="15" alt=":bshelp:" title="bshelp">';break;case':bsiloveu:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/bs_iloveyou.gif" width="15" height="15" alt=":bsiloveu:" title="bsiloveu">';break;case':bslame:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/bs_lame.gif" width="15" height="15" alt=":bslame:" title="bslame">';break;case':bsnostealing:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/bs_nostealinganything.gif" width="15" height="15" alt=":bsnostealing:" title="bsnostealing">';break;case':bsofftopic:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/bs_offtopic.gif" width="15" height="15" alt=":bsofftopic:" title="bsofftopic">';break;case':bsspam:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/bs_spam.gif" width="15" height="15" alt=":bsspam:" title="bsspam">';break;case':bsstopspam:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/bs_stopspamnlamor.gif" width="15" height="15" alt=":bsstopspam:" title="bsstopspam">';break;case':bswhat:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/bs_quesexclaim.gif" width="15" height="15" alt=":bswhat:" title="bswhat">';break;case':cat:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/non_cat.gif" width="15" height="15" alt=":cat:" title="Cat">';break;case':chair:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/gun_chair.gif" width="15" height="15" alt=":chair:" title="Chair">';break;case':chef:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ppl_chef.gif" width="15" height="15" alt=":chef:" title="Chef">';break;case':cigar:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ext_cigar.gif" width="15" height="15" alt=":cigar:" title="Cigar">';break;case':clap2:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ges_clap2.gif" width="15" height="15" alt=":clap2:" title="Clap 2">';break;case':clap:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ges_clap.gif" width="15" height="15" alt=":clap:" title="Clap">';break;case':clover:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/non_clover.gif" width="15" height="15" alt=":clover:" title="Clover">';break;case':clown:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ext_clown.gif" width="15" height="15" alt=":clown:" title="Clown">';break;case':comehereyou:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/bs_comehereyou.gif" width="15" height="15" alt=":comehereyou:" title="comehereyou">';break;case':cool:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_cool.gif" width="15" height="15" alt=":cool:" title="Cool">';break;case':crutch:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ext_crutch.gif" width="15" height="15" alt=":crutch:" title="Crutch">';break;case':cry2:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/cry.gif" width="15" height="15" alt=":cry2:" title="Cry">';break;case':cry:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_cry.gif" width="15" height="15" alt=":cry:" title="Crying or Very sad">';break;case':cry_baby:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ext_crybaby.gif" width="15" height="15" alt=":cry_baby:" title="Cry Baby">';break;case':cylon:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ppl_cylon.gif" width="15" height="15" alt=":cylon:" title="Cylon">';break;case':discuss:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/discussion.gif" width="15" height="15" alt=":discuss:" title="Discussion">';break;case':disgusted:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/disgusted.gif" width="15" height="15" alt=":disgusted:" title="Disgusted">';break;case':doc:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ext_doc.gif" width="15" height="15" alt=":doc:" title="Doc">';break;case':dontgetit:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/dontgetit.gif" width="15" height="15" alt=":dontgetit:" title="Dont Get It">';break;case':down:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ges_down.gif" width="15" height="15" alt=":down:" title="Down">';break;case':drunk:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ext_drunk.gif" width="15" height="15" alt=":drunk:" title="Drunk">';break;case':eek:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_surprised.gif" width="15" height="15" alt=":eek:" title="Surprised">';break;case':evil:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_evil.gif" width="15" height="15" alt=":evil:" title="Evil or Very Mad">';break;case':explode:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/big_explode.gif" width="15" height="15" alt=":explode:" title="Explode">';break;case':flex:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ext_flex.gif" width="15" height="15" alt=":flex:" title="Flex">';break;case':furious:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_furious.gif" width="15" height="15" alt=":furious:" title="Furious">';break;case':ghey:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/sign_ghey.gif" width="15" height="15" alt=":ghey:" title="ghey">';break;case':greedy:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_greedy.gif" width="15" height="15" alt=":greedy:" title="Greedy">';break;case':grin:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_biggrin.gif" width="15" height="15" alt=":grin:" title="Very Happy">';break;case':gun:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/gun_gun.gif" width="15" height="15" alt=":gun:" title="Gun">';break;case':haha2:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/haha2.gif" width="15" height="15" alt=":haha2:" title="HAHAHA 2">';break;case':haha:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/haha.gif" width="15" height="15" alt=":haha:" title="HAHA">';break;case':hang:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/big_hang.gif" width="15" height="15" alt=":hang:" title="Hang">';break;case':hannibal:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ppl_hannibal.gif" width="15" height="15" alt=":hannibal:" title="Hannibal">';break;case':happy2:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ext_happy.gif" width="15" height="15" alt=":happy2:" title="Happy">';break;case':hbd:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/big_hbd.gif" width="15" height="15" alt=":hbd:" title="HBD">';break;case':help:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ges_help.gif" width="15" height="15" alt=":help:" title="Help">';break;case':hi:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/tr_hi.gif" width="15" height="15" alt=":hi:" title="Hi">';break;case':hitler:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ppl_hitler.gif" width="15" height="15" alt=":hitler:" title="Hitler">';break;case':hmm:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ges_hmm.gif" width="15" height="15" alt=":hmm:" title="Hmm">';break;case':homestar:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/non_homestar.gif" width="15" height="15" alt=":homestar:" title="Homestar">';break;case':hooray:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ext_hooray.gif" width="15" height="15" alt=":hooray:" title="Hooray">';break;case':huh:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/huh.gif" width="15" height="15" alt=":huh:" title="Huh">';break;case':hump:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ext_hump.gif" width="15" height="15" alt=":hump:" title="Hump">';break;case':icecream:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ext_icecream.gif" width="15" height="15" alt=":icecream:" title="Icecream">';break;case':idea:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_idea.gif" width="15" height="15" alt=":idea:" title="Idea">';break;case':in_love:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_in_love.gif" width="15" height="15" alt=":in_love:" title="In Love">';break;case':indian:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ppl_indian.gif" width="15" height="15" alt=":indian:" title="Indian">';break;case':jedai:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/gun_jedai.gif" width="15" height="15" alt=":jedai:" title="Jedai Saber">';break;case':jump2:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ext_jump2.gif" width="15" height="15" alt=":jump2:" title="Jump 2">';break;case':king:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ppl_king.gif" width="15" height="15" alt=":king:" title="King">';break;case':kiss:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ext_kiss.gif" width="15" height="15" alt=":kiss:" title="Kiss">';break;case':komp_cr:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ext_komp_cr.gif" width="15" height="15" alt=":komp_cr:" title="Comp Crash">';break;case':lamo:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ext_lame.gif" width="15" height="15" alt=":lamo:" title="Lamo">';break;case':lol2:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_laugh.gif" width="15" height="15" alt=":lol2:" title="LOL">';break;case':lol:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_lol.gif" width="15" height="15" alt=":lol:" title="Laughing">';break;case':love:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/non_love.gif" width="15" height="15" alt=":love:" title="Love">';break;case':lovers:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ext_lovers.gif" width="15" height="15" alt=":lovers:" title="Lovers">';break;case':mad:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_mad.gif" width="15" height="15" alt=":mad:" title="Mad">';break;case':madman:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/madman.gif" width="15" height="15" alt=":madman:" title="Mad Man">';break;case':mario:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ppl_mario.gif" width="15" height="15" alt=":mario:" title="Mario">';break;case':mbounce:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/big_mbounce.gif" width="15" height="15" alt=":mbounce:" title="Multibounce">';break;case':mobile:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ext_mobile.gif" width="15" height="15" alt=":mobile:" title="Mobile">';break;case':moon:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/moon.gif" width="15" height="15" alt=":moon:" title="Moon">';break;case':moonwalker:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_moonwlk.gif" width="15" height="15" alt=":moonwalker:" title="Moonwalker">';break;case':mrgreen:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_mrgreen.gif" width="15" height="15" alt=":mrgreen:" title="Mr. Green">';break;case':music:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ext_music.gif" width="15" height="15" alt=":music:" title="Music">';break;case':neutral:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_neutral.gif" width="15" height="15" alt=":neutral:" title="Neutral">';break;case':ninja:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ppl_ninja.gif" width="15" height="15" alt=":ninja:" title="Ninja">';break;case':ninjafist:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ppl_ninjafist.gif" width="15" height="15" alt=":ninjafist:" title="Ninja Fist">';break;case':ninjajig:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ppl_ninjajig.gif" width="15" height="15" alt=":ninjajig:" title="Ninja Jig">';break;case':no:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ges_no.gif" width="15" height="15" alt=":no:" title="No">';break;case':nuke:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/non_nuke.gif" width="15" height="15" alt=":nuke:" title="Nuke">';break;case':o':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_surprised.gif" width="15" height="15" alt=":o" title="Surprised">';break;case':oldtimer:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ppl_oldtimer.gif" width="15" height="15" alt=":oldtimer:" title="Oldtimer">';break;case':oops:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_redface.gif" width="15" height="15" alt=":oops:" title="Embarassed">';break;case':osama:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ppl_osama.gif" width="15" height="15" alt=":osama:" title="Osama">';break;case':pimp:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ppl_pimp.gif" width="15" height="15" alt=":pimp:" title="Pimp">';break;case':pirat:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ppl_pirat.gif" width="15" height="15" alt=":pirat:" title="Pirate">';break;case':pirate:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ppl_pirate.gif" width="15" height="15" alt=":pirate:" title="Pirate 2">';break;case':poked:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/poked.gif" width="15" height="15" alt=":poked:" title="Poked">';break;case':police:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ppl_police.gif" width="15" height="15" alt=":police:" title="Police">';break;case':pop:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ppl_pop.gif" width="15" height="15" alt=":pop:" title="Pop">';break;case':priest:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ppl_priest.gif" width="15" height="15" alt=":priest:" title="Priest">';break;case':protest:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/protest.gif" width="15" height="15" alt=":protest:" title="Protest">';break;case':punk:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ppl_punk.gif" width="15" height="15" alt=":punk:" title="Punk">';break;case':rambo:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ppl_rambo.gif" width="15" height="15" alt=":rambo:" title="Rambo">';break;case':rant:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_rant.gif" width="15" height="15" alt=":rant:" title="Rant">';break;case':razz2:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_razz2.gif" width="15" height="15" alt=":razz2:" title="Razz 2">';break;case':razz:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_razz.gif" width="15" height="15" alt=":razz:" title="Razz">';break;case':respect:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/tr_respect.gif" width="15" height="15" alt=":respect:" title="Respect">';break;case':rip:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/tr_rip.gif" width="15" height="15" alt=":rip:" title="R.I.P.">';break;case':rock:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ppl_rock.gif" width="15" height="15" alt=":rock:" title="Rocker">';break;case':rockout:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/rockout3.gif" width="15" height="15" alt=":rockout:" title="Rock Out">';break;case':roll:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_rolleyes.gif" width="15" height="15" alt=":roll:" title="Rolling Eyes">';break;case':sad:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_sad.gif" width="15" height="15" alt=":sad:" title="Sad">';break;case':saddam:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ppl_saddam.gif" width="15" height="15" alt=":saddam:" title="Saddam">';break;case':secret:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ext_secret.gif" width="15" height="15" alt=":secret:" title="Secret">';break;case':shaun:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/non_shaun.gif" width="15" height="15" alt=":shaun:" title="Shaun">';break;case':shock:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_eek.gif" width="15" height="15" alt=":shock:" title="Shocked">';break;case':shuriken:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ppl_shuriken.gif" width="15" height="15" alt=":shuriken:" title="Ninja Shuriken">';break;case':shutup:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ext_shutup.gif" width="15" height="15" alt=":shutup:" title="Shut Up">';break;case':sick:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_sick.gif" width="15" height="15" alt=":sick:" title="Sick">';break;case':signbye:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/sign_bye.gif" width="15" height="15" alt=":signbye:" title="signbye">';break;case':signduh:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/sign_duh.gif" width="15" height="15" alt=":signduh:" title="signduh">';break;case':signeek:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/sign_eek.gif" width="15" height="15" alt=":signeek:" title="signeek">';break;case':signfss:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/sign_ffs.gif" width="15" height="15" alt=":signfss:" title="signfss">';break;case':signhelp:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/sign_help.gif" width="15" height="15" alt=":signhelp:" title="signhelp">';break;case':signheya:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/sign_heya.gif" width="15" height="15" alt=":signheya:" title="signheya">';break;case':signl33t:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/sign_l33t.gif" width="15" height="15" alt=":signl33t:" title="signl33t">';break;case':signlame:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/sign_lame.gif" width="15" height="15" alt=":signlame:" title="signlame">';break;case':signspam:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/sign_spam.gif" width="15" height="15" alt=":signspam:" title="signspam">';break;case':signstfu:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/sign_stfu.gif" width="15" height="15" alt=":signstfu:" title="signstfu">';break;case':slap:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ges_slap.gif" width="15" height="15" alt=":slap:" title="Slap">';break;case':sleep:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ext_sleep.gif" width="15" height="15" alt=":sleep:" title="Sleep">';break;case':smile:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_smile.gif" width="15" height="15" alt=":smile:" title="Smile">';break;case':smurf:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ppl_smurf.gif" width="15" height="15" alt=":smurf:" title="Smurf">';break;case':sorry:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/tr_sorry.gif" width="15" height="15" alt=":sorry:" title="I\'m Sorry">';break;case':spam:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/tr_spam.gif" width="15" height="15" alt=":spam:" title="Spam">';break;case':spank:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/smackbottom.gif" width="15" height="15" alt=":spank:" title="Spanking">';break;case':spider:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ext_spider.gif" width="15" height="15" alt=":spider:" title="Spider">';break;case':spidey:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ppl_spidey.gif" width="15" height="15" alt=":spidey:" title="Spidey">';break;case':t_oops:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/tr_oops.gif" width="15" height="15" alt=":t_oops:" title="Oops">';break;case':tease:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ext_tease.gif" width="15" height="15" alt=":tease:" title="Tease">';break;case':thankyou:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/tr_thankyou.gif" width="15" height="15" alt=":thankyou:" title="Thank You">';break;case':tomato:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ext_tomato.gif" width="15" height="15" alt=":tomato:" title="Tomato">';break;case':twisted:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_twisted.gif" width="15" height="15" alt=":twisted:" title="Twisted Evil">';break;case':up:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ges_up.gif" width="15" height="15" alt=":up:" title="Up">';break;case':wall:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_wall.gif" width="15" height="15" alt=":wall:" title="Wall">';break;case':wbounce:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/big_wbounce.gif" width="15" height="15" alt=":wbounce:" title="Wave Bounce">';break;case':weep:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_weep.gif" width="15" height="15" alt=":weep:" title="Weep">';break;case':wheelcha:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ext_wheelcha.gif" width="15" height="15" alt=":wheelcha:" title="Wheel Chair">';break;case':whistle:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ges_whistle.gif" width="15" height="15" alt=":whistle:" title="Whistling">';break;case':wink:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_wink.gif" width="15" height="15" alt=":wink:" title="Wink">';break;case':wolverine:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ppl_wolverine.gif" width="15" height="15" alt=":wolverine:" title="Wolverine">';break;case':x':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_mad.gif" width="15" height="15" alt=":x" title="Mad">';break;case':yawn:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_yawn.gif" width="15" height="15" alt=":yawn:" title="Yawn">';break;case':yes:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ges_yes.gif" width="15" height="15" alt=":yes:" title="Yes">';break;case':zorro:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/ppl_zorro.gif" width="15" height="15" alt=":zorro:" title="Zorro">';break;case':|':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_neutral.gif" width="15" height="15" alt=":|" title="Neutral">';break;case':|<':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_redeem.gif" width="15" height="15" alt=":|&lt;" title="Redeeming">';break;case';)':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_wink.gif" width="15" height="15" alt=";)" title="Wink">';break;case';-)':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_wink.gif" width="15" height="15" alt=";-)" title="Wink">';break;case';;~)':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/5.gif" width="15" height="15" alt=";;~)" title="Eye bat">';break;case'<:)>':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/suitup.gif" width="15" height="15" alt="&lt;:)&gt;" title="Lock and Load">';break;case'<sith:':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/lsabre.gif" width="15" height="15" alt="&lt;sith:" title="Lightup">';break;case'=8-|':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/22.gif" width="15" height="15" alt="=8-|" title="Nerd">';break;case'{{email}}':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_wink.gif" width="15" height="15" alt="{{email}}" title="blocked Email">';break;case'|-(o':$html.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/33.gif" width="15" height="15" alt="|-(o" title="Thinking">';break;default:$html.=htmlspecialchars($textContent,0);}}break;case'EMOJI':$attributes+=['seq'=>null];$textContent=$this->getQuickTextContent($xml);if($this->params['S_VIEWSMILIES']!==''){$html.='<img alt="'.htmlspecialchars($textContent,2).'" class="emoji smilies" draggable="false" src="';if(isset($attributes['tseq']))$html.='//twemoji.maxcdn.com/2/svg/'.$attributes['tseq'].'.svg';else$html.='https://cdn.jsdelivr.net/gh/s9e/emoji-assets-twemoji@11.2/dist/svgz/'.$attributes['seq'].'.svgz';$html.='">';}else$html.=htmlspecialchars($textContent,0);break;case'FACEBOOK':$attributes+=['type'=>null,'id'=>null];$html.='<iframe data-s9e-mediaembed="facebook" allowfullscreen="" onload="var c=new MessageChannel;c.port1.onmessage=function(e){style.height=e.data+\'px\'};contentWindow.postMessage(\'s9e:init\',\'https://s9e.github.io\',[c.port2])" scrolling="no" src="https://s9e.github.io/iframe/2/facebook.min.html#'.$attributes['type'].$attributes['id'].'" style="border:0;height:360px;max-width:640px;width:100%"></iframe>';break;case'LINK_TEXT':$attributes+=['text'=>null];$html.=str_replace('&quot;','"',$attributes['text']);break;case'LIST':$attributes+=['type'=>null];if(!isset($attributes['type']))$html.='<ul>';elseif((strpos('upperlowerdecim',mb_substr(htmlspecialchars_decode($attributes['type']),0,5,'utf-8'))!==false))$html.='<ol style="list-style-type:'.$attributes['type'].'">';else$html.='<ul style="list-style-type:'.$attributes['type'].'">';$this->attributes[]=$attributes;break;case'QUOTE':$attributes+=['url'=>null,'author'=>null,'post_id'=>null];$html.='<blockquote';if(!isset($attributes['author']))$html.=' class="uncited"';$html.='><div>';if(isset($attributes['author'])){$html.='<cite>';if(isset($attributes['url']))$html.='<a href="'.$attributes['url'].'" class="postlink">'.str_replace('&quot;','"',$attributes['author']).'</a>';elseif(isset($attributes['profile_url']))$html.='<a href="'.$attributes['profile_url'].'">'.str_replace('&quot;','"',$attributes['author']).'</a>';else$html.=str_replace('&quot;','"',$attributes['author']);$html.=' '.htmlspecialchars($this->params['L_WROTE'].$this->params['L_COLON'],0);if(isset($attributes['post_url']))$html.=' <a href="'.$attributes['post_url'].'" data-post-id="'.$attributes['post_id'].'" onclick="if(document.getElementById(hash.substr(1)))href=hash">↑</a>';if(isset($attributes['date']))$html.='<div class="responsive-hide">'.str_replace('&quot;','"',$attributes['date']).'</div>';$html.='</cite>';}break;case'XURL':$attributes+=['xurl'=>null,'content'=>null];$html.='<a href="'.$attributes['xurl'].'" title="'.$attributes['content'].'" style="text-decoration:underline" onclick="window.open(this.href);return false;">'.str_replace('&quot;','"',$attributes['content']).'</a>';}

		return $html;
	}
}