<?php
/**
*
* @package phpBB Extension - Obscure Contact Us
* @copyright (c) 2015 - HiFiKabin
* @license http://opensource.org/licenses/gpl-2.0.php GNU General Public License v2
*
*/

namespace hifikabin\obscurecontactus\acp;

class obscurecontactus_module
{
var $u_action;

    function main($id, $mode)
    {
        global $user, $template, $request;
        global $config;

        $this->tpl_name = 'acp_obscurecontactus_config';
        $this->page_title = $user->lang('OBSCURECONTACTUS_CONFIG');
        $form_name = 'acp_obscurecontactus_config';
		add_form_key($form_name);

        $submit = $request->is_set_post('submit');
        if ($submit)
        {
            if (!check_form_key('acp_obscurecontactus_config'))
        {
            trigger_error('FORM_INVALID');
        }
        $config->set('contact_admin_form_enable', $request->variable('contact_admin_form_enable', false));
        $config->set('obscurecontactus_mouseover', ($request->variable('obscurecontactus_mouseover', '', true)));
        $config->set('obscurecontactus_prefix', ($request->variable('obscurecontactus_prefix', '', true)));
        $config->set('obscurecontactus_subject', ($request->variable('obscurecontactus_subject', '', true)));
        $config->set('obscurecontactus_suffix', ($request->variable('obscurecontactus_suffix', '', true)));

        trigger_error($user->lang('OBSCURECONTACTUS_CONFIG_SAVED') . adm_back_link($this->u_action));
        }
        $template->assign_vars(array(
        'CONTACT_ENABLED'              => $config['contact_admin_form_enable'],
        'OBSCURECONTACTUS_MOUSEOVER'   => (isset($config['obscurecontactus_mouseover'])) ? $config['obscurecontactus_mouseover'] : '',
        'OBSCURECONTACTUS_PREFIX'      => (isset($config['obscurecontactus_prefix'])) ? $config['obscurecontactus_prefix'] : '',
        'OBSCURECONTACTUS_SUBJECT'     => (isset($config['obscurecontactus_subject'])) ? $config['obscurecontactus_subject'] : '',
        'OBSCURECONTACTUS_SUFFIX'      => (isset($config['obscurecontactus_suffix'])) ? $config['obscurecontactus_suffix'] : '',
        'OBSCURECONTACTUS_VERSION'     => (isset($config['obscurecontactus_version'])) ? $config['obscurecontactus_version'] : '',
        'U_ACTION'                     => $this->u_action,
        ));
    }
}
