<?php
/**
*
* @package phpBB Extension - Obscure Contact Us
* @copyright (c) 2015 - HiFiKabin
* @license http://opensource.org/licenses/gpl-2.0.php GNU General Public License v2
*
*/

namespace hifikabin\obscurecontactus\event;

/**
* @ignore
*/
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
* Event listener
*/
class listener implements EventSubscriberInterface
{
    /** @var \phpbb\config\config */
    protected $config;

    static public function getSubscribedEvents()
    {
        return array(
        'core.page_header'   => 'add_page_header_link',
        );
    }

    protected $template;

    public function __construct(\phpbb\config\config $config, \phpbb\template\template $template)
    {
        $this->config = $config;
        $this->template = $template;
    }


    public function add_page_header_link($event)
    {
        $this->template->assign_vars(array(
        'OBSCURECONTACTUS_MOUSEOVER'  => (isset($this->config['obscurecontactus_mouseover'])) ? addslashes($this->config['obscurecontactus_mouseover']) : '',
        'OBSCURECONTACTUS_PREFIX'     => (isset($this->config['obscurecontactus_prefix'])) ? addslashes($this->config['obscurecontactus_prefix']) : '',
        'OBSCURECONTACTUS_SUBJECT'    => (isset($this->config['obscurecontactus_subject'])) ? addslashes($this->config['obscurecontactus_subject']) : '',
        'OBSCURECONTACTUS_SUFFIX'     => (isset($this->config['obscurecontactus_suffix'])) ? addslashes($this->config['obscurecontactus_suffix']) : '',
        ));
    }
}
