<?php

/**
*
* @package phpBB3 SEO Sitemap
* @copyright (c) 2014 www.phpbb-work.ru
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
*
*/

namespace shredder\sitemap\controller;

use Symfony\Component\HttpFoundation\Response;

class sitemap
{
	/**
	* Constructor
	* NOTE: The parameters of this method must match in order and type with
	* the dependencies defined in the services.yml file for this service.
	*

	/** @var \shredder\sitemap\core */
	protected $core;

	/** @var \phpbb\cache\service */
	protected $cache;

	/** @var \phpbb\config\config */
	protected $config;

	public function __construct(\shredder\sitemap\core $core, \phpbb\cache\service $cache, \phpbb\config\config $config)
	{
		$this->core = $core;
		$this->cache = $cache;
		$this->config = $config;
	}

	/**
	* Controller for route /sitemap/
	*
	* @param string		$name
	* @return \Symfony\Component\HttpFoundation\Response A Symfony Response object
	*/
	public function display_sitemap()
	{
		global $f_xml, $urls;

		$f_xml = '';
		$urls = 0;

		$driver = $this->cache->get_driver();

		if (($f_xml = $driver->get("_sitemap_seo_file")) === false)
		{
			$this->core->generate_sitemap();

			$this->config->set('sitemap_seo_url_count', $urls);

			if ($this->config['sitemap_seo_cache'])
			{
				$driver->put("_sitemap_seo_file", $f_xml, 3600*$this->config['sitemap_seo_cache']);
			}
		}

		header("Content-type: application/xml");
		return new Response($f_xml);
	}
}
