<?php
/**
 *
 * @package PhpBB Xmas extension
 * @copyright (c) 2016 Stoker
 * @license GNU General Public License, version 2 (GPL-2.0)
 *
 */

namespace stoker\xmas\acp;

/**
* @package acp
*/
class xmas_module
{
	/** @var \phpbb\config\config */
	protected $config;

	/** @var \phpbb\request\request */
	protected $request;

	/** @var \phpbb\template\template */
	protected $template;

	/** @var \phpbb\user */
	protected $user;

	/** @var string */
	public $u_action;

	public function main($id, $mode)
	{
		global $config, $request,  $template, $user;

		$this->config = $config;
		$this->request = $request;
		$this->template = $template;
		$this->user = $user;

		$this->user->add_lang('acp/common');
		$this->user->add_lang_ext('stoker/xmas', 'xmas_acp');

		$this->tpl_name = 'acp_xmas';
		$this->page_title = $this->user->lang('ACP_XMAS');

		$form_key = 'acp_xmas';
		add_form_key($form_key);

		if ($this->request->is_set_post('submit'))
		{
			if (!check_form_key($form_key))
			{
				trigger_error($user->lang('FORM_INVALID') . adm_back_link($this->u_action), E_USER_WARNING);
			}

			$enable_xmas = $this->request->variable('enable_xmas', 0);
			$this->config->set('enable_xmas', $enable_xmas);
			$enable_xmas_storm = $this->request->variable('enable_xmas_storm', 0);
			$this->config->set('enable_xmas_storm', $enable_xmas_storm);
			$this->config->set('xmas_storm_minsize', $request->variable('xmas_storm_minsize', 0));
			$this->config->set('xmas_storm_maxsize', $request->variable('xmas_storm_maxsize', 0));
			$this->config->set('xmas_storm_flakecount', $request->variable('xmas_storm_flakecount', 0));
			$this->config->set('xmas_testmode', $request->variable('xmas_testmode', 0));
			
			$enable_xmas_countdown = $this->request->variable('enable_xmas_countdown', 0);
			$this->config->set('enable_xmas_countdown', $request->variable('enable_xmas_countdown', 0));
			$this->config->set('xmas_countdown_testmode', $request->variable('xmas_countdown_testmode', 0));
			$this->config->set('xmas_countdown_direction', $request->variable('xmas_countdown_direction', 0));
			$this->config->set('xmas_countdown_date', $request->variable('xmas_countdown_date', ''));
			$this->config->set('xmas_countdown_offset_enable', $request->variable('xmas_countdown_offset_enable', 0));
			$this->config->set('xmas_countdown_offset', $request->variable('xmas_countdown_offset', ''));
			$this->config->set('xmas_countdown_yandm_enable', $request->variable('xmas_countdown_yandm_enable', 0));
			$this->config->set('xmas_countdown_week_enable', $request->variable('xmas_countdown_week_enable', 0));
			$this->config->set('xmas_countdown_leading_enable', $request->variable('xmas_countdown_leading_enable', 0));
			$this->config->set('xmas_countdown_year', $request->variable('xmas_countdown_year', 0));
			$this->config->set('xmas_countdown_month', $request->variable('xmas_countdown_month', 0));
			$this->config->set('xmas_countdown_text', utf8_normalize_nfc($request->variable('xmas_countdown_text', '', true)));
			$this->config->set('xmas_countdown_text_after', utf8_normalize_nfc($request->variable('xmas_countdown_text_after', '', true)));
			$this->config->set('xmas_countdown_complete', utf8_normalize_nfc($request->variable('xmas_countdown_complete', '', true)));

			trigger_error($this->user->lang('CONFIG_UPDATED') . adm_back_link($this->u_action));
		}

		$this->template->assign_vars(array(
			'ENABLE_XMAS'					=> isset($this->config['enable_xmas']) ? $this->config['enable_xmas'] : '',
			'ENABLE_XMAS_STORM'				=> isset($this->config['enable_xmas_storm']) ? $this->config['enable_xmas_storm'] : '',
			'XMAS_STORM_MINSIZE'			=> isset($this->config['xmas_storm_minsize']) ? $this->config['xmas_storm_minsize'] : '',
			'XMAS_STORM_MAXSIZE'			=> isset($this->config['xmas_storm_maxsize']) ? $this->config['xmas_storm_maxsize'] : '',
			'XMAS_STORM_FLAKECOUNT'			=> isset($this->config['xmas_storm_flakecount']) ? $this->config['xmas_storm_flakecount'] : '',
			'XMAS_TESTMODE'					=> (!empty($this->config['xmas_testmode'])) ? true : false,
			
			'ENABLE_XMAS_COUNTDOWN'			=> isset($this->config['enable_xmas_countdown']) ? $this->config['enable_xmas_countdown'] : '',
			'XMAS_COUNTDOWN_TESTMODE'		=> (!empty($this->config['xmas_countdown_testmode'])) ? true : false,
			'XMAS_COUNTDOWN_DIRECTION'		=> (!empty($this->config['xmas_countdown_direction'])) ? true : false,
			'XMAS_COUNTDOWN_DATE'			=> (isset($this->config['xmas_countdown_date'])) ? $this->config['xmas_countdown_date'] : '',
			'XMAS_COUNTDOWN_OFFSET_ENABLE'	=> (!empty($this->config['xmas_countdown_offset_enable'])) ? true : false,
			'XMAS_COUNTDOWN_OFFSET'			=> (isset($this->config['xmas_countdown_offset'])) ? $this->config['xmas_countdown_offset'] : '',
			'XMAS_COUNTDOWN_YANDM_ENABLE'	=> (!empty($this->config['xmas_countdown_yandm_enable'])) ? true : false,
			'XMAS_COUNTDOWN_WEEK_ENABLE'	=> (!empty($this->config['xmas_countdown_week_enable'])) ? true : false,
			'XMAS_COUNTDOWN_LEADING_ENABLE'	=> (!empty($this->config['xmas_countdown_leading_enable'])) ? true : false,
			'XMAS_COUNTDOWN_YEAR'			=> (!empty($this->config['xmas_countdown_year'])) ? true : false,
			'XMAS_COUNTDOWN_MONTH'			=> (!empty($this->config['xmas_countdown_month'])) ? true : false,
			'XMAS_COUNTDOWN_TEXT'			=> (isset($this->config['xmas_countdown_text'])) ? $this->config['xmas_countdown_text'] : '',
			'XMAS_COUNTDOWN_TEXT_AFTER'		=> (isset($this->config['xmas_countdown_text_after'])) ? $this->config['xmas_countdown_text_after'] : '',
			'XMAS_COUNTDOWN_COMPLETE'		=> (isset($this->config['xmas_countdown_complete'])) ? $this->config['xmas_countdown_complete'] : '',

			'U_ACTION'					=> $this->u_action,
		));
	}
}
