<?php
/**
 *
 * @package PhpBB Xmas extension
 * @copyright (c) 2016 Stoker
 * @license GNU General Public License, version 2 (GPL-2.0)
 *
 */

namespace stoker\xmas\event;

use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
* Event listener
*/
class listener implements EventSubscriberInterface
{
	/** @var \phpbb\config\config */
	protected $config;

	/** @var \phpbb\request\request */
	protected $request;

	/** @var \phpbb\template\template */
	protected $template;

	/** @var \phpbb\user */
	protected $user;

	/**
	* Constructor
	*
	* @param \phpbb\config\config $config
	* @param \phpbb\request\request $request
	* @param \phpbb\template\template $template
	* @param \phpbb\user $user
	* @return \stoker\xmas\event\listener
	* @access public
	*/
	public function __construct(\phpbb\config\config $config, \phpbb\request\request $request, \phpbb\template\template $template, \phpbb\user $user)
	{
		$this->config = $config;
		$this->request = $request;
		$this->template = $template;
		$this->user = $user;
	}

	/**
	* Assign functions defined in this class to event listeners in the core
	*
	* @return array
	* @static
	* @access public
	*/
	static public function getSubscribedEvents()
	{
		return array(
			'core.page_header'						=> 'main',
			'core.ucp_prefs_personal_data'			=> 'ucp_prefs_get_data',
			'core.ucp_prefs_personal_update_data'	=> 'ucp_prefs_set_data',
		);
	}

	/**
	* Get config var
	*
	* @return null
	* @access public
	*/
	public function main($event)
	{
		// add lang file
		$this->user->add_lang_ext('stoker/xmas', 'common');
		$this->template->assign_vars(array(
			'S_XMAS'		=>	!empty($this->user->data['user_xmas']) ? true : false,
			'S_XMAS_STORM'	=>	!empty($this->user->data['user_xmas_storm']) ? true : false,
		));
		// config settings
		$this->template->assign_var('ENABLE_XMAS', $this->config['enable_xmas']);
		$this->template->assign_var('ENABLE_XMAS_STORM', $this->config['enable_xmas_storm']);
		$this->template->assign_var('XMAS_STORM_MINSIZE', $this->config['xmas_storm_minsize']);
		$this->template->assign_var('XMAS_STORM_MAXSIZE', $this->config['xmas_storm_maxsize']);
		$this->template->assign_var('XMAS_STORM_FLAKECOUNT', $this->config['xmas_storm_flakecount']);
		$this->template->assign_var('XMAS_TESTMODE', $this->config['xmas_testmode']);
		
		$this->template->assign_var('ENABLE_XMAS_COUNTDOWN', $this->config['enable_xmas_countdown']);
		$this->template->assign_var('XMAS_COUNTDOWN_TESTMODE', $this->config['xmas_countdown_testmode']);
		$this->template->assign_var('XMAS_COUNTDOWN_DIRECTION', $this->config['xmas_countdown_direction']);
		$this->template->assign_var('XMAS_COUNTDOWN_DATE', $this->config['xmas_countdown_date']);
		$this->template->assign_var('XMAS_COUNTDOWN_OFFSET_ENABLE', $this->config['xmas_countdown_offset_enable']);
		$this->template->assign_var('XMAS_COUNTDOWN_OFFSET', $this->config['xmas_countdown_offset']);
		$this->template->assign_var('XMAS_COUNTDOWN_YEAR', $this->config['xmas_countdown_year']);
		$this->template->assign_var('XMAS_COUNTDOWN_MONTH', $this->config['xmas_countdown_month']);
		$this->template->assign_var('XMAS_COUNTDOWN_LEADING_ENABLE', $this->config['xmas_countdown_leading_enable']);
		$this->template->assign_var('XMAS_COUNTDOWN_YANDM_ENABLE', $this->config['xmas_countdown_yandm_enable']);
		$this->template->assign_var('XMAS_COUNTDOWN_WEEK_ENABLE', $this->config['xmas_countdown_week_enable']);
		$this->template->assign_var('XMAS_COUNTDOWN_TEXT', html_entity_decode($this->config['xmas_countdown_text']));
		$this->template->assign_var('XMAS_COUNTDOWN_TEXT_AFTER', html_entity_decode($this->config['xmas_countdown_text_after']));
		$this->template->assign_var('XMAS_COUNTDOWN_COMPLETE', html_entity_decode($this->config['xmas_countdown_complete']));
	}
	
	/**
	* Get user's option and display it in UCP Prefs View page
	*
	* @param object $event The event object
	* @return null
	* @access public
	*/
	public function ucp_prefs_get_data($event)
	{
		// Request the user option vars and add them to the data array
		$event['data'] = array_merge($event['data'], array(
			'xmas'			=> $this->request->variable('xmas', (int) $this->user->data['user_xmas']),
			'xmas_storm'	=> $this->request->variable('xmas_storm', (int) $this->user->data['user_xmas_storm']),
		));

		// Output the data vars to the template (except on form submit)
		if (!$event['submit'])
		{
			$this->user->add_lang_ext('stoker/xmas', 'xmas_ucp');
			$this->template->assign_vars(array(
				'S_UCP_XMAS'		=> $event['data']['xmas'],
				'S_UCP_XMAS_STORM'	=> $event['data']['xmas_storm'],
			));
		}
	}

	/**
	* Add user's xmas option state into the sql_array
	*
	* @param object $event The event object
	* @return null
	* @access public
	*/
	public function ucp_prefs_set_data($event)
	{
		$event['sql_ary'] = array_merge($event['sql_ary'], array(
			'user_xmas' => $event['data']['xmas'],
			'user_xmas_storm' => $event['data']['xmas_storm'],
		));
	}
}
