<?php
/**
*
 * @package PhpBB Xmas extension
 * @copyright (c) 2016 Stoker
 * @license GNU General Public License, version 2 (GPL-2.0
*
*/

namespace stoker\xmas\migrations\v1x;

class release_1_0_0_schema extends \phpbb\db\migration\migration
{
	public function effectively_installed()
	{
		return $this->db_tools->sql_column_exists($this->table_prefix . 'users', 'user_xmas');
	}

	public function update_schema()
	{
		return array(
			'add_columns'	=> array(
				$this->table_prefix . 'users'	=> array(
					'user_xmas'			=> array('BOOL', 1),
					'user_xmas_storm'	=> array('BOOL', 1),
				),
			),
		);
	}

	public function revert_schema()
	{
		return array(
			'drop_columns'	=> array(
				$this->table_prefix . 'users'	=> array(
					'user_xmas',
					'user_xmas_storm',
				),
			),
		);
	}
}
