<?php
/**
*
* @package phpBB Extension - Obscure Contact Us
* @copyright (c) 2015 - HiFiKabin
* @license http://opensource.org/licenses/gpl-2.0.php GNU General Public License v2
*
*/

namespace hifikabin\obscurecontactus\event;

/**
* @ignore
*/
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
* Event listener
*/
class listener implements EventSubscriberInterface
{
   /** @var \phpbb\config\config */
   protected $config;

   static public function getSubscribedEvents()
   {
      return array(
         'core.user_setup' => 'load_language_on_setup',
         'core.page_header'   => 'add_page_header_link',
      );
   }

   protected $helper;

   protected $template;

   public function __construct(\phpbb\controller\helper $helper, \phpbb\template\template $template, \phpbb\config\config $config)
   {
      $this->helper = $helper;
      $this->template = $template;
      $this->config = $config;
   }

   public function load_language_on_setup($event)
   {
      $lang_set_ext = $event['lang_set_ext'];
      $lang_set_ext[] = array(
         'ext_name' => 'hifikabin/obscurecontactus',
         'lang_set' => 'common',
      );
      $event['lang_set_ext'] = $lang_set_ext;
   }

   public function add_page_header_link($event)
   {
      $this->template->assign_vars(array(
      'OBSCURECONTACTUS_MOUSEOVER'  => (isset($this->config['obscurecontactus_mouseover'])) ? $this->config['obscurecontactus_mouseover'] : '',
      'OBSCURECONTACTUS_PREFIX'     => (isset($this->config['obscurecontactus_prefix'])) ? $this->config['obscurecontactus_prefix'] : '',
      'OBSCURECONTACTUS_SUBJECT'    => (isset($this->config['obscurecontactus_subject'])) ? $this->config['obscurecontactus_subject'] : '',
      'OBSCURECONTACTUS_SUFFIX'     => (isset($this->config['obscurecontactus_suffix'])) ? $this->config['obscurecontactus_suffix'] : '',
      ));
   }
}
