<?php
/**
 *
 * @package phpBB Extension - Timezone Clock
 * @copyright (c) 2015 - HiFiKabin
 * @license http://opensource.org/licenses/gpl-2.0.php GNU General Public License v2
 *
 */

namespace hifikabin\timezoneclock\event;

/**
 * @ignore
 */
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
 * Event listener
 */
class listener implements EventSubscriberInterface
{
	/** @var \phpbb\template\template */
	protected $template;

	/** @var \phpbb\db\driver\driver_interface */
	protected $db;

	/** @var \phpbb\request\request */
	protected $request;

	/** @var \timezoneclock_table */
	protected $timezoneclock_table;

	/** @var \phpbb\config\config */
	protected $config;

	/**
	 * Constructor
	 *
	 * @param \phpbb\template\template			$template
	 * @param \phpbb\db\driver\driver_interface	$db
	 * @param string							$timezoneclock_table
	 * @param \phpbb\config\config				$config
	 */

	public function __construct(\phpbb\template\template $template, \phpbb\user $user, \phpbb\db\driver\driver_interface $db, \phpbb\request\request $request, $timezoneclock_table, \phpbb\config\config $config)
	{
		$this->template = $template;
		$this->db = $db;
		$this->request = $request;
		$this->timezoneclock_table = $timezoneclock_table;
		$this->config = $config;
	}

	public static function getSubscribedEvents()
	{
		return array(
			'core.page_header' => 'timezoneclock'
		);
	}

	public function timezoneclock($event)
	{
		$this->template->assign_vars(array(
			'TZC_ENABLE' => $this->config['timezoneclock_enable']
		));

		if (isset($this->config['timezoneclock_enable']) && $this->config['timezoneclock_enable'])
		{
			$sql = 'SELECT* 
			FROM ' . $this->timezoneclock_table;
			$result = $this->db->sql_query($sql, 86400);

			while ($row = $this->db->sql_fetchrow($result))
			{
				if (!empty($row['tzc_city']))
				{
					$this->template->assign_block_vars('tzc_citys', array(
						'TZC_CITY'	=> $row['tzc_city'],
						'TZC_ZONE'	=> $row['tzc_zone'],
						'TZC_GMT'	=> $row['tzc_gmt']
					));
				}
			}
			$this->db->sql_freeresult($result);
		}
	}
}
