<?php
/**
*
* @package phpBB Extension - Timezone Clock
* @copyright (c) 2015 - HiFiKabin
* @license http://opensource.org/licenses/gpl-2.0.php GNU General Public License v2
*
*/

namespace hifikabin\timezoneclock\migrations;

class timezoneclock_data extends \phpbb\db\migration\migration
{

	public function update_schema()
	{
		return array(
			'add_tables'	=> array(
			// ADD NEW TABLE STRUCTURE
				$this->table_prefix . 'timezoneclock'	=> array(
					'COLUMNS' => array(
					'tzc_id'			=> array('UINT', null, 'auto_increment'),
					'tzc_zone'			=> array('TINT:2 (range, -128, 128)', null, ''),
					'tzc_gmt'			=> array('VCHAR', ''),
					'tzc_city'			=> array('VCHAR', ''),
					),
					'PRIMARY_KEY'	=> 'tzc_id',
				),
			),
		);
	}

	public function update_data()
	{
		// ADD CONFIG 
		return array(
			array('config.add', array('timezoneclock_enable', '0')),

		// Add ACP modules
			array('module.add', array('acp', 'ACP_CAT_DOT_MODS', 'ACP_TIMEZONECLOCK_TITLE')),
			array('module.add', array('acp', 'ACP_TIMEZONECLOCK_TITLE', array(
				'module_basename'	=> '\hifikabin\timezoneclock\acp\main_module',
				'module_langname'	=> 'ACP_TIMEZONECLOCK',
				'module_mode'		=> 'overview',
				'module_auth'		=> 'ext_hifikabin/timezoneclock && acl_a_board',
			))),
		);
	}

	/**
	* Drop the Timezone Clock table schema from the database
	*
	* @return array Array of table schema
	* @access public
	*/
	public function revert_schema()
	{
		return array(
			'drop_tables'	=> array(
				$this->table_prefix . 'timezoneclock',
			),
		);
	}
}
