<?php
/**
*
* @package phpBB Extension - Copyright
* @copyright (c) 2014 Stoker
* @license http://opensource.org/licenses/gpl-2.0.php GNU General Public License v2
*
*/

namespace stoker\copyright\event;

/**
* @ignore
*/
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
* Event listener
*/
class listener implements EventSubscriberInterface
{
	/* @var \stoker\copyright\core\functions_copyright */
	protected $tf_functions;

	public function __construct(\stoker\copyright\core\functions_copyright $functions)
	{
		$this->copyright_functions = $functions;
	}

	static public function getSubscribedEvents()
	{
		return array(
			'core.user_setup' => 'load_language_on_setup',
			'core.page_header'	=> 'main',
		);
	}

	public function main($event)
	{

		$this->copyright_functions->copyright();
	}

	public function load_language_on_setup($event)
	{
		$lang_set_ext = $event['lang_set_ext'];
		$lang_set_ext[] = array(
			'ext_name' => 'stoker/copyright',
			'lang_set' => 'copyright',
		);
		$event['lang_set_ext'] = $lang_set_ext;
	}
}
