<?php
/**
 *
 * @package phpBB Extension - Timezone Clock
 * @copyright (c) 2015 - HiFiKabin
 * @license http://opensource.org/licenses/gpl-2.0.php GNU General Public License v2
 *
 */

namespace hifikabin\timezoneclock\acp;

/**
 * @package acp
 */

class main_module
{
	var $u_action;

	function main($id, $mode)
	{
		global $db, $user, $template, $request, $phpbb_log, $phpbb_container, $cache, $config;
		
		$this->cache = $cache;
		$this->tpl_name = 'acp_timezoneclock';
		$this->page_title = $user->lang['ACP_TIMEZONECLOCK_TITLE'];
		$this->request = $request;
		$this->log = $phpbb_log;
		$this->config = $config;
		$timezoneclock_table = $phpbb_container->getParameter('tables.timezoneclock_table');

		$user->add_lang_ext('hifikabin/timezoneclock', 'common');

		add_form_key('timezoneclock/acp_timezoneclock');

		$sql = 'SELECT *
		FROM ' . $timezoneclock_table;
		$result = $db->sql_query($sql);
		
		while ($row = $db->sql_fetchrow($result))
		{
			if (!empty($row['tzc_city']))
			{
				$template->assign_block_vars('tzc_citys', array(
					'TZC_CITY'	=> $row['tzc_city'],
					'TZC_ZONE'	=> $row['tzc_zone'],
					'TZC_GMT'	=> $row['tzc_gmt']
				));
			}
		};

		if (empty($row['tzc_city']))
		{
			$template->assign_block_vars('tzc_citys', array(
				'TZC_CITY' => ''
			));
		};
		$db->sql_freeresult($result);

		$submit = $request->is_set_post('submit');
		if ($submit)
		{
			if (!check_form_key('timezoneclock/acp_timezoneclock'))
			{
				trigger_error('FORM_INVALID');
			}

			$sql = 'DELETE FROM ' . $timezoneclock_table;
			$db->sql_query($sql);

			$tzc_enable = $this->request->variable('tzc_enable', ' ');
			$this->config->set('timezoneclock_enable', $tzc_enable);

			$tzc_city = $this->request->variable('tzc_city', array(
				'' => ''
			), true);
			$tzc_zone = $this->request->variable('tzc_zone', array(
				'' => ''
			), true);
			$tzc_gmt  = $this->request->variable('tzc_gmt', array(
				'' => ''
			), true);
			
			$i = 0;
			while ($i < count($tzc_city))
			{
				$sql_ary1 = array(
					'tzc_city'	=> $tzc_city[$i],
					'tzc_zone'	=> $tzc_zone[$i],
					'tzc_gmt'	=> $tzc_gmt[$i]
				);
				$db->sql_query('INSERT INTO ' . $timezoneclock_table . ' ' . $db->sql_build_array('INSERT', $sql_ary1));
				$i++;
			}

			$cache->destroy('sql', $timezoneclock_table);
			
			$user_id = $user->data['user_id'];
			$user_ip = $user->ip;

			$phpbb_log->add('admin', $user_id, $user_ip, 'LOG_TIMEZONECLOCK_SAVE');
			trigger_error($user->lang['TIMEZONECLOCK_SAVED'] . adm_back_link($this->u_action));
		}

		$template->assign_vars(array(
			'TZC_ENABLE' => $this->config['timezoneclock_enable']
		));
	}
}
