<?php
/**
*
* @package phpBB Extension - Timezone Clock
* @copyright (c) 2015 - HiFiKabin
* @license http://opensource.org/licenses/gpl-2.0.php GNU General Public License v2
*
*/

namespace hifikabin\timezoneclock\migrations;

class timezoneclock_schema extends \phpbb\db\migration\migration
{
	static public function depends_on()
	{
		return array(
			'\hifikabin\timezoneclock\migrations\timezoneclock_data',
		);
	}

	public function update_data()
	{
		return array(
			array('custom', array(array($this, 'insert_sample_data'))),
		);
	}

	public function insert_sample_data()
	{
		global $user;

		$sample_data = array(
			array(
				'tzc_id' => '1', 'tzc_zone'	=> '-5', 'tzc_gmt'	=> 'NAmerica', 'tzc_city' => 'Washington DC',
			),
			array(
				'tzc_id' => '2', 'tzc_zone' => '0', 'tzc_gmt' => 'Europe',	'tzc_city' => 'London',
			),
			array(
				'tzc_id' => '3', 'tzc_zone' => '1', 'tzc_gmt' => 'Europe',	'tzc_city' => 'Berlin',
			),
			array(
				'tzc_id' => '4', 'tzc_zone' => '3', 'tzc_gmt' => 'GMT',	'tzc_city' => 'Moscow',
			),
			array(
				'tzc_id' => '5', 'tzc_zone' => '9', 'tzc_gmt' => 'GMT',	'tzc_city' => 'Tokyo',
			),
			array(
				'tzc_id' => '6', 'tzc_zone' => '10', 'tzc_gmt' => 'Australia', 'tzc_city' => 'Canberra',
			),
			array(
				'tzc_id' => '7', 'tzc_zone'	=> '-6', 'tzc_gmt'	=> 'SAmerica', 'tzc_city' => 'Brazilia',
			),
		);

		// Insert sample data
		$this->db->sql_multi_insert($this->table_prefix . 'timezoneclock', $sample_data);
	}
}
