<?php
/**
 *
 * Advanced Polls
 *
 * @copyright (c) 2015 Wolfsblvt ( www.pinkes-forum.de )
 * @license http://opensource.org/licenses/gpl-2.0.php GNU General Public License v2
 * @author Clemens Husung (Wolfsblvt)
 */

namespace wolfsblvt\advancedpolls;

class ext extends \phpbb\extension\base
{
	/**
	* Overwrite enable_step to enable advanced polls notifications
	* before any included migrations are installed.
	*
	* @param mixed $old_state State returned by previous call of this method
	* @return mixed Returns false after last step, otherwise temporary state
	*/
	function enable_step($old_state)
	{
		switch ($old_state)
		{
			case '': // Empty means nothing has run yet

				// Enable advanced polls notifications
				/* mo
				$phpbb_notifications = $this->container->get('notification_manager');
				$phpbb_notifications->enable_notifications('wolfsblvt.advancedpolls.notification.type.pollended');
				fin mo */
				return 'notifications';

			break;

			default:

				// Run parent enable step method
				return parent::enable_step($old_state);

			break;
		}
	}

	/**
	* Overwrite disable_step to disable advanced polls notifications
	* before the extension is disabled.
	*
	* @param mixed $old_state State returned by previous call of this method
	* @return mixed Returns false after last step, otherwise temporary state
	*/
	function disable_step($old_state)
	{
		switch ($old_state)
		{
			case '': // Empty means nothing has run yet

				// Disable board rules notifications
				/* mo
				$phpbb_notifications = $this->container->get('notification_manager');
				$phpbb_notifications->disable_notifications('wolfsblvt.advancedpolls.notification.type.pollended');
				fin mo */
				return 'notifications';

			break;

			default:

				// Run parent disable step method
				return parent::disable_step($old_state);

			break;
		}
	}

	/**
	* Overwrite purge_step to purge advanced polls notifications before
	* any included and installed migrations are reverted.
	*
	* @param mixed $old_state State returned by previous call of this method
	* @return mixed Returns false after last step, otherwise temporary state
	*/
	function purge_step($old_state)
	{
		switch ($old_state)
		{
			case '': // Empty means nothing has run yet

				// Purge board rules notifications
				/* mo
				$phpbb_notifications = $this->container->get('notification_manager');
				$phpbb_notifications->purge_notifications('wolfsblvt.advancedpolls.notification.type.pollended');
				fin mo */
				return 'notifications';

			break;

			default:

				// Run parent purge step method
				return parent::purge_step($old_state);

			break;
		}
	}
}
