<?php
/**
*
* @package hjw calendar Extension
* @copyright (c) 2023 hjw
* @license http://opensource.org/licenses/gpl-2.0.php GNU General Public License v2
*
*/

namespace hjw\calendar\acp;

class main_module
{
	var $u_action;
	public function main()
	{
		global $db, $user, $request, $template, $config, $phpbb_root_path, $phpbb_admin_path, $php_ext, $table_prefix, $phpbb_container, $language;

		$this->db = $db;
		$this->user = $user;
		$this->language = $language;
		$this->template = $template;
		$this->config = $config;
		$this->request = $request;
		$this->phpbb_root_path = $phpbb_root_path;
		$this->phpbb_admin_path = $phpbb_admin_path;
		$this->php_ext = $php_ext;
		$this->table_prefix = $table_prefix;
		$this->ext_root_path = $phpbb_root_path . 'ext/hjw/calendar/';
		$this->user->add_lang('acp/common');
		$this->page_title = $this->language->lang('ACP_CALENDAR_TITLE');
		$this->calendar_table = $phpbb_container->getParameter('tables.calendar');
		$this->calendar_participants_table = $phpbb_container->getParameter('tables.calendar_participants');
		$this->calendar_event_table = $phpbb_container->getParameter('tables.calendar_event');
		$this->calendar_event_list_table = $phpbb_container->getParameter('tables.calendar_event_list');
		$this->calendar_special_days_table = $phpbb_container->getParameter('tables.calendar_special_days');
		$this->calendar_forums_table = $phpbb_container->getParameter('tables.calendar_forums');
		$this->calendar_config_table = $phpbb_container->getParameter('tables.calendar_config');
		$this->lang_table = $phpbb_container->getParameter('tables.lang');

		$football = false;
		$sql = 'SELECT *
			FROM ' . EXT_TABLE . '
				WHERE ext_name ="football/football"';
		$result = $this->db->sql_query($sql);
		$row = $this->db->sql_fetchrow($result);

		if (!empty($row) && ($row['ext_active'] == 1))
		{
			$football = true;
			$this->template->assign_vars(array(
				'CALENDAR_FOOTBALL'	=> true,
			));
		}

		$multilanguage  = ($this->get_config('multilanguage') == true) ? true : false ;
		$this->template->assign_vars(array(
			'MULTILANGUAGE'		=> $multilanguage,
		));

		$day_name = array(
			0 => $this->language->lang(['datetime', 'Sunday']),
			1 => $this->language->lang(['datetime', 'Monday']),
			2 => $this->language->lang(['datetime', 'Tuesday']),
			3 => $this->language->lang(['datetime', 'Wednesday']),
			4 => $this->language->lang(['datetime', 'Thursday']),
			5 => $this->language->lang(['datetime', 'Friday']),
			6 => $this->language->lang(['datetime', 'Saturday']),
		);

		$month_name = array(
			1 => $this->language->lang(['datetime', 'January']),
			2 => $this->language->lang(['datetime', 'February']),
			3 => $this->language->lang(['datetime', 'March']),
			4 => $this->language->lang(['datetime', 'April']),
			5 => $this->language->lang(['datetime', 'May']),
			6 => $this->language->lang(['datetime', 'June']),
			7 => $this->language->lang(['datetime', 'July']),
			8 => $this->language->lang(['datetime', 'August']),
			9 => $this->language->lang(['datetime', 'September']),
		   10 => $this->language->lang(['datetime', 'October']),
		   11 => $this->language->lang(['datetime', 'November']),
		   12 => $this->language->lang(['datetime', 'December']),
		);

		$form_key = 'acp_calendar';
		add_form_key($form_key);

		$mode = $this->request->variable('mode', 'instructions');

		switch ($mode)
		{
			case 'instructions':
				$this->tpl_name = 'acp_calendar_instructions';
			break;

			case 'displayoptions':
				$jn = array();
				$this->set_config('tab', $this->request->variable('hjw_calendar_tab', $this->get_config('tab')));
				for ($i=0; $i<=1; $i++)
				{
					$s= ($this->get_config('tab') == $i) ? ' selected="selected"' : '';
					$this->template->assign_block_vars('tab', array(
						'SELECT' =>'<option' . $s . ' value="' . $i . '">' . $this->language->lang('ACP_CALENDAR_TAB_' . $i) . '</option>',
					));
				}

				$this->set_config('week_start', $this->request->variable('hjw_calendar_week_start', $this->get_config('week_start')));
				for ($i=0; $i<=6; $i++)
				{
					$s= ($this->get_config('week_start') == $i) ? ' selected="selected"' : '' ;
					$this->template->assign_block_vars('weekstart', array(
						'SELECT' =>'<option' . $s . ' value="' . $i . '">' . $day_name[$i] . '</option>',
					));
				}

				$this->set_config('week_display', $this->request->variable('hjw_calendar_week_display', $this->get_config('week_display')));
				$jn = ($this->get_config('week_display') == 0) ? 1: 0;
				$this->template->assign_vars(array(
					'WEEK_DISPLAY'	=> $this->u_action . '&hjw_calendar_week_display=' . $jn,
					'CWD'			=> ($jn == 0) ? 'fa-toggle-on': 'fa-toggle-off',
				));

				$this->set_config('legend_display', $this->request->variable('hjw_calendar_legend_display', $this->get_config('legend_display')));
				$jn = ($this->get_config('legend_display') == 0) ? 1: 0;
				$this->template->assign_vars(array(
					'LEGEND_DISPLAY'	=> $this->u_action . '&hjw_calendar_legend_display=' . $jn,
					'CLD'				=> ($jn == 0) ? 'fa-toggle-on': 'fa-toggle-off',
				));

				$this->set_config('calendar_for_guests', $this->request->variable('hjw_calendar_for_guests', $this->get_config('calendar_for_guests')));
				$jn = ($this->get_config('calendar_for_guests') == 0) ? 1: 0;
				$this->template->assign_vars(array(
					'CALENDAR_FOR_GUESTS'	=> $this->u_action . '&hjw_calendar_for_guests=' . $jn,
					'CFG'					=> ($jn == 0) ? 'fa-toggle-on': 'fa-toggle-off',
				));

				$this->set_config('birthday_on_calendar', $this->request->variable('hjw_calendar_birthday_on_calendar', $this->get_config('birthday_on_calendar')));
				$jn = ($this->get_config('birthday_on_calendar') == 0) ? 1: 0;
				$this->template->assign_vars(array(
					'BIRTHDAY_ON_CALENDAR'	=> $this->u_action . '&hjw_calendar_birthday_on_calendar=' . $jn,
					'BOC'					=> ($jn == 0) ? 'fa-toggle-on': 'fa-toggle-off',
				));

				$this->set_config('birthday_on_next', $this->request->variable('hjw_calendar_birthday_on_next', $this->get_config('birthday_on_next')));
				$jn = ($this->get_config('birthday_on_next') == 0) ? 1: 0;
				$this->template->assign_vars(array(
					'BIRTHDAY_ON_NEXT'	=> $this->u_action . '&hjw_calendar_birthday_on_next=' . $jn,
					'BON'				=> ($jn == 0) ? 'fa-toggle-on': 'fa-toggle-off',
				));

				$this->set_config('only_first_post', $this->request->variable('hjw_calendar_only_first_post', $this->get_config('only_first_post')));
				$jn = ($this->get_config('only_first_post') == 0) ? 1: 0;
				$this->template->assign_vars(array(
					'ONLY_FIRST_POST'	=> $this->u_action . '&hjw_calendar_only_first_post=' . $jn,
					'OFP'				=> ($jn == 0) ? 'fa-toggle-on': 'fa-toggle-off',
				));

				$this->set_config('week_or_next', $this->request->variable('hjw_calendar_week_or_next', $this->get_config('week_or_next')));
				for ($i=1; $i<=3; $i++)
				{
					$s= ($this->get_config('week_or_next') == $i) ? ' selected="selected"' : '';
					$this->template->assign_block_vars('weeknext', array(
						'SELECT' =>'<option' . $s . ' value="' . $i . '">' . $this->language->lang('ACP_WEEK_NEXT_' . $i) . '</option>',
					));
				}

				$this->set_config('week_on_index', $this->request->variable('hjw_calendar_week_on_index', $this->get_config('week_on_index')));
				for ($i=0; $i<=3; $i++)
				{
					$s= ($this->get_config('week_on_index') == $i) ? ' selected="selected"' : '';
					$this->template->assign_block_vars('weekblock', array(
						'SELECT' =>'<option' . $s . ' value="' . $i . '">' . $this->language->lang('ACP_WEEKBLOCK_TEMPLATE_' . $i) . '</option>',
					));
				}

				$this->set_config('number_of_weeks', $this->request->variable('hjw_calendar_number_of_weeks', $this->get_config('number_of_weeks')));
				if ($this->get_config('number_of_weeks') == 0)
				{
					$this->set_config('number_of_weeks', 1);
				}
				$this->template->assign_vars(array(
					'NUMBER_OF_WEEKS'	=> $this->get_config('number_of_weeks'),
				));

				$this->set_config('number_of_upcoming', $this->request->variable('hjw_calendar_number_of_upcoming', $this->get_config('number_of_upcoming')));
				for ($i = 1; $i <= 10; $i++)
				{
					$s= ($this->get_config('number_of_upcoming') == $i) ? ' selected="selected"' : '' ;
					$this->template->assign_block_vars('number_of_upcoming', array(
						'SELECT' =>'<option' . $s . ' value="' . $i . '">' . $i . '</option>',
					));
				}

				$this->set_config('calendar_on_index_off', $this->request->variable('hjw_calendar_on_index_off', $this->get_config('calendar_on_index_off')));
				$jn = ($this->get_config('calendar_on_index_off') == 0) ? 1: 0;
				$this->template->assign_vars(array(
					'CALENDAR_ON_INDEX_OFF'	=> $this->u_action . '&hjw_calendar_on_index_off=' . $jn,
					'COIO'					=> ($jn == 0) ? 'fa-toggle-on': 'fa-toggle-off',
				));

				$this->set_config('week_on_phone', $this->request->variable('hjw_calendar_week_on_phone', $this->get_config('week_on_phone')));
				$jn = ($this->get_config('week_on_phone') == 0) ? 1: 0;
				$this->template->assign_vars(array(
					'WEEK_ON_PHONE'	=> $this->u_action . '&hjw_calendar_week_on_phone=' . $jn,
					'WOP'			=> ($jn == 0) ? 'fa-toggle-on': 'fa-toggle-off',
				));

				$this->set_config('next_on_phone', $this->request->variable('hjw_calendar_next_on_phone', $this->get_config('next_on_phone')));
				$jn = ($this->get_config('next_on_phone') == 0) ? 1: 0;
				$this->template->assign_vars(array(
					'NEXT_ON_PHONE'	=> $this->u_action . '&hjw_calendar_next_on_phone=' . $jn,
					'NOP'			=> ($jn == 0) ? 'fa-toggle-on': 'fa-toggle-off',
				));

				$this->set_config('calendar_date_format', $this->request->variable('hjw_calendar_date_format', $this->get_config('calendar_date_format')));
				$jn = ($this->get_config('calendar_date_format') == 0) ? 1: 0;
				$this->template->assign_vars(array(
					'CALENDAR_DATE_FORMAT'	=> $this->u_action . '&hjw_calendar_date_format=' . $jn,
					'CDF'					=> ($jn == 0) ? 'fa-toggle-on': 'fa-toggle-off',
				));

				$this->set_config('display_time', $this->request->variable('hjw_calendar_display_time', $this->get_config('display_time')));
				$jn = ($this->get_config('display_time') == 0) ? 1: 0;
				$this->template->assign_vars(array(
					'DISPLAY_TIME'	=> $this->u_action . '&hjw_calendar_display_time=' . $jn,
					'CDT'			=> ($jn == 0) ? 'fa-toggle-on': 'fa-toggle-off',
				));

				$this->set_config('number_participating', $this->request->variable('hjw_calendar_number_participating', $this->get_config('number_participating')));
				$jn = ($this->get_config('number_participating') == 0) ? 1: 0;
				$this->template->assign_vars(array(
					'NUMBER_PARTICIPATING'	=> $this->u_action . '&hjw_calendar_number_participating=' . $jn,
					'CNP'					=> ($jn == 0) ? 'fa-toggle-on': 'fa-toggle-off',
				));

				$this->set_config('participants_name', $this->request->variable('hjw_calendar_participants_name', $this->get_config('participants_name')));
				$jn = ($this->get_config('participants_name') == 0) ? 1: 0;
				$this->template->assign_vars(array(
					'PARTICIPANTS_NAME'	=> $this->u_action . '&hjw_calendar_participants_name=' . $jn,
					'CPN'				=> ($jn == 0) ? 'fa-toggle-on': 'fa-toggle-off',
				));

				$this->set_config('notify', $this->request->variable('hjw_calendar_notify', $this->get_config('notify')));
				$jn = ($this->get_config('notify') == 0) ? 1: 0;
				$this->template->assign_vars(array(
					'NOTIFY'	=> $this->u_action . '&hjw_calendar_notify=' . $jn,
					'CN'		=> ($jn == 0) ? 'fa-toggle-on': 'fa-toggle-off',
				));

				$this->set_config('notify_participating', $this->request->variable('hjw_calendar_notify_participating', $this->get_config('notify_participating')));
				$jn = ($this->get_config('notify_participating') == 0) ? 1: 0;
				$this->template->assign_vars(array(
					'NOTIFY_PARTICIPATING'	=> $this->u_action . '&hjw_calendar_notify_participating=' . $jn,
					'CNPP'					=> ($jn == 0) ? 'fa-toggle-on': 'fa-toggle-off',
				));
				$this->set_config('notify_participating_adress', $this->request->variable('hjw_calendar_notify_participating_adress', $this->get_config('notify_participating_adress')));
				$jn = $this->get_config('notify_participating_adress');
				$this->template->assign_vars(array(
					'NOTIFY_PARTICIPATING_ADRESS1'	=> $this->u_action . '&hjw_calendar_notify_participating_adress=1',
					'NOTIFY_PARTICIPATING_ADRESS0'	=> $this->u_action . '&hjw_calendar_notify_participating_adress=0',
					'NOTIFY_PARTICIPATING_ADRESS2'	=> $this->u_action . '&hjw_calendar_notify_participating_adress=2',
					'CNPPA1'						=> ($jn == 1) ? 'fa-toggle-on': 'fa-toggle-off',
					'CNPPA0'						=> ($jn == 0) ? 'fa-toggle-on': 'fa-toggle-off',
					'CNPPA2'						=> ($jn == 2) ? 'fa-toggle-on': 'fa-toggle-off',
				));

				$this->set_config('multilanguage', $this->request->variable('hjw_calendar_multilanguage', $this->get_config('multilanguage')));
				$jn = ($this->get_config('multilanguage') == 0) ? 1: 0;
				$this->template->assign_vars(array(
					'MULTILANGUAGE'	=> $this->u_action . '&hjw_calendar_multilanguage=' . $jn,
					'CML'			=> ($jn == 0) ? 'fa-toggle-on': 'fa-toggle-off',
				));

				if ($football)
				{
					$this->set_config('football', $this->request->variable('hjw_calendar_football', $this->get_config('football')));
				$jn = ($this->get_config('football') == 0) ? 1: 0;
				$this->template->assign_vars(array(
					'FOOTBALL'	=> $this->u_action . '&hjw_calendar_football=' . $jn,
					'CFB'		=> ($jn == 0) ? 'fa-toggle-on': 'fa-toggle-off',
				));
				}

				$this->tpl_name = 'acp_calendar_displayoptions';
			break;

			case 'settings':
				$this->tpl_name = 'acp_calendar_event_settings';
				$action	= $this->request->variable('action', '');
				$id 	= $this->request->variable('id', 0);

				if ($multilanguage)
				{
					$sql = 'SHOW COLUMNS FROM ' . $this->calendar_event_table;
					$result = $this->db->sql_query($sql);
					$column = '/';
					while ($row = $this->db->sql_fetchrow($result))
					{
						$column .= $row['Field'] . '/';
					}
					$lang = array();
					$lang_name = array();
					$sql = 'SELECT *
							FROM ' . $this->lang_table;
					$lang_result = $this->db->sql_query($sql);
					while ($lang_row = $this->db->sql_fetchrow($lang_result))
					{
						$lang[] = $lang_row['lang_dir'];
						$lang_name[] = $lang_row['lang_english_name'];
						if (!strpos($column, '/' . $lang_row['lang_dir'] . '/'))
						{
							$sql = 'ALTER TABLE ' . $this->calendar_event_table . ' ADD COLUMN ' . $lang_row['lang_dir'] . ' VARCHAR(255)';
							$this->db->sql_query($sql);
						};
					}
				}

				switch ($action)
				{
					case 'add':
						$this->template->assign_vars(array(
							'ID' 					=> '',
							'EVENT' 				=> '',
							'COLOR' 				=> '',
							'PARTICIPANTS'			=> 0,
							'BIG'					=> 0,
							'BCOLOR' 				=> '',
							'ANNIVERSARY' 			=> false,
							'U_MODIFY'				=> $this->u_action . '&amp;action=create&amp;id=' . $id,
							'S_EDIT_CALENDAR_EVENT'	=> true,
						));
					break;

					case 'delete':
						$sql = 'DELETE
								FROM ' . $this->calendar_event_table . '
								WHERE id = "' . (int) $id . '"';
						$result = $this->db->sql_query($sql);
						$row = $this->db->sql_fetchrow($result);
						$this->db->sql_freeresult($result);
					break;

					case 'modify':
						$sql_ary = array(
							'EVENT'				=> utf8_normalize_nfc($this->request->variable('event', '', true)),
							'COLOR'				=> substr($this->request->variable('color', ''), -6),
							'BCOLOR'			=> (!$this->request->variable('bg', 0)) ? substr($this->request->variable('bcolor', ''), -6) : '',
							'PARTICIPANTS'		=> $this->request->variable('participants', 0),
							'BIG'				=> $this->request->variable('big', 0),
							'ANNIVERSARY' 		=> $this->request->variable('anniversary', false),
						);
						if ($multilanguage)
						{
							for ($i = 0, $count_lang = count($lang); $i < $count_lang; $i++)
							{
								$sql_ary[$lang[$i]]		= (utf8_normalize_nfc($this->request->variable($lang[$i], '', true))) ? utf8_normalize_nfc($this->request->variable($lang[$i], '', true)) : utf8_normalize_nfc($this->request->variable('event', '', true));
							}
						}
						$sql = 'UPDATE ' . $this->calendar_event_table . '
								SET ' . $this->db->sql_build_array('UPDATE', $sql_ary) . '
								WHERE id = "' . (int) $id . '"';
						$this->db->sql_query($sql);
					break;

					case 'create':
						$sql_ary = array(
							'EVENT'				=> utf8_normalize_nfc($this->request->variable('event', '', true)),
							'COLOR'				=> substr($this->request->variable('color', ''), -6),
							'BCOLOR'			=> (!$this->request->variable('bg', 0)) ? substr($this->request->variable('bcolor', ''), -6) : '',
							'PARTICIPANTS'		=> $this->request->variable('participants', 0),
							'BIG'				=> $this->request->variable('big', 0),
							'ANNIVERSARY' 		=> $this->request->variable('anniversary', false),
						);
						if ($multilanguage)
						{
							for ($i = 0, $count_lang = count($lang); $i < $count_lang; $i++)
							{
								$sql_ary[$lang[$i]]		= (utf8_normalize_nfc($this->request->variable($lang[$i], '', true))) ? utf8_normalize_nfc($this->request->variable($lang[$i], '', true)) : utf8_normalize_nfc($this->request->variable('event', '', true));
							}
						}
						$sql = 'INSERT INTO ' . $this->calendar_event_table . ' ' . $this->db->sql_build_array('INSERT', $sql_ary);
						$this->db->sql_query($sql);
						$sql = 'SELECT *
								FROM ' . $this->calendar_event_table . '
								WHERE sort ="0"';
						$result = $this->db->sql_query($sql);
						$row = $this->db->sql_fetchrow($result);
						$row['sort'] = $row['id'];
						$sql = 'UPDATE ' . $this->calendar_event_table . '
								SET sort = "' . $row['sort'] . '"
								WHERE id = "' . (int) $row['id'] . '"';
						$this->db->sql_query($sql);
					break;

					case 'up':
						$sort = $this->request->variable('sort', '');
						$sql = 'SELECT *
								FROM ' . $this->calendar_event_table . '
								WHERE sort = "' . ($sort - 1) . '"';
						$result = $this->db->sql_query($sql);
						$row = $this->db->sql_fetchrow($result);
						$sql = 'UPDATE
								' . $this->calendar_event_table . '
								SET sort = "' . $sort . '"
								WHERE id = "' . (int) $row['id'] . '"';
						$this->db->sql_query($sql);
						$sql = 'UPDATE
								' . $this->calendar_event_table . '
								SET sort = "' . ($sort - 1) . '"
								WHERE id = "' . (int) $id . '"';
						$this->db->sql_query($sql);
					break;

					case 'down':
						$sort = $this->request->variable('sort', '');
						$sql = 'SELECT *
								FROM ' . $this->calendar_event_table . '
								WHERE sort = "' . ($sort + 1) . '"';
						$result = $this->db->sql_query($sql);
						$row = $this->db->sql_fetchrow($result);
						$sql = 'UPDATE ' . $this->calendar_event_table . '
								SET sort = "' . $sort . '"
								WHERE id = "' . (int) $row['id'] . '"';
						$this->db->sql_query($sql);
						$sql = 'UPDATE ' . $this->calendar_event_table . '
								SET sort = "' . ($sort + 1) . '"
								WHERE id = "' . (int) $id . '"';
						$this->db->sql_query($sql);
					break;
				}

				if ($multilanguage)
				{
					for ($i = 0, $count_lang = count($lang); $i < $count_lang; $i++)
					{
						$this->template->assign_block_vars('lang', array(
							'LANG_NAME'	=> $lang_name[$i],
						));
					}
				}
			if ($action != 'add')
			{
				$sql = 'SELECT *
						FROM ' . $this->calendar_event_table;
				if ($action == 'edit')
				{
					$sql .= ' WHERE id = "' . (int) $id . '"';
					$this->template->assign_vars(array(
						'U_MODIFY'				=> $this->u_action . '&amp;action=modify&amp;id=' . (int) $id,
						'S_EDIT_CALENDAR_EVENT'	=> true,
					));
				}
				else
				{
					$sql .= ' ORDER by sort';
				}
				$result = $this->db->sql_query($sql);
				while ($row = $this->db->sql_fetchrow($result))
				{
					if ($multilanguage)
					{
						$lang_title = '';
						for ($i = 0, $count_lang = count($lang); $i < $count_lang; $i++)
						{
							$lang_title		.= $lang[$i] . ' - ' . $row[$lang[$i]] . chr(10);
						}
					}
					$this->template->assign_block_vars('calendar_events', array(
						'ID' 				=> $row['id'],
						'EVENT' 			=> ($action == 'add') ? '' : $row['event'],
						'LANG_TITLE'		=> ($multilanguage) ? $lang_title : '',
						'COLOR' 			=> $row['color'],
						'PARTICIPANTS'		=> $row['participants'],
						'PARTICIPANTS_TEXT'	=> $this->language->lang('ACP_CALENDAR_' . $row['participants']),
						'BIG'				=> $row['big'],
						'BCOLOR'			=> $row['bcolor'],
						'BG'				=> ($row['bcolor'] == '') ? 1 : 0,
						'ANNIVERSARY' 		=> $row['anniversary'],
						'ANNIVERSARY_TEXT' 	=> $this->language->lang('ACP_CALENDAR_' . $row['anniversary']),
						'U_EDIT'			=> $this->u_action . '&amp;action=edit&amp;id=' . $row['id'],
						'U_DELETE'			=> $this->u_action . '&amp;action=delete&amp;id=' . $row['id'],
						'U_MOVE_UP'			=> $this->u_action . '&amp;action=up&amp;id=' . $row['id'] . '&amp;sort=' . $row['sort'],
						'U_MOVE_DOWN'		=> $this->u_action . '&amp;action=down&amp;id=' . $row['id'] . '&amp;sort=' . $row['sort'],
					));
					if ($multilanguage)
					{
					for ($i = 0, $count_lang = count($lang); $i < $count_lang; $i++)
					{
						$this->template->assign_block_vars('calendar_events.lang', array(
							'EVENT'			=> ($action == 'add') ? '' : (($row[$lang[$i]]) ? $row[$lang[$i]] : $row['event']),
							'LANG'			=> $lang[$i],
							'LANG_NAME'		=> $lang_name[$i],
						));
					}
					}
				}
			}
			else
			{
				$this->template->assign_block_vars('calendar_events', array(
					'ID' 				=> '',
					'EVENT' 			=> '',
					'COLOR' 			=> '',
					'PARTICIPANTS'		=> 0,
					'BIG'				=> 0,
					'BCOLOR'			=> 0,
					'ANNIVERSARY' 		=> 0,
				));
					if ($multilanguage)
					{
				for ($i = 0, $count_lang = count($lang); $i < $count_lang; $i++)
				{
					$this->template->assign_block_vars('calendar_events.lang', array(
						'EVENT'		=> '',
						'LANG'		=> $lang[$i],
						'LANG_NAME'	=> $lang_name[$i],
						'U_MODIFY'				=> $this->u_action . '&amp;action=create&amp;id=' . $id,
						'S_EDIT_CALENDAR_EVENT'	=> true,
					));
				}
					}
			}
				$this->template->assign_vars(array(
					'U_ACTION'				=> $this->u_action . '&amp;action=add',
					'S_CALENDAR_VERSION'	=> $this->language->lang('ACP_CALENDAR_TITLE') . $this->language->lang('ACP_CALENDAR_VERSION') . $this->config['hjw_calendar_version'],
				));
			break;

			case 'forums_settings':
				$this->tpl_name = 'acp_calendar_forums_settings';
				$action	= $this->request->variable('action', '');
				$this->template->assign_vars(array(
					'U_CALENDAR_FORUM'		=> $this->u_action . '&amp;action=forum',
				));

				if ($action == 'forum')
				{
					$forum_id = intval ($this->request->variable('forum', 0));
					$sql = 'SELECT *
							FROM ' . $this->calendar_forums_table . '
							WHERE forum_id = "' . (int) $forum_id . '"';

					$result = $this->db->sql_query($sql);
					$row = $this->db->sql_fetchrow($result);

					$sql_ary = array(
						'ALLOWED' 		=> ($row['allowed'] == 0) ? 1 : 0,
					);

					$sql = 'UPDATE
							' . $this->calendar_forums_table . '
							SET ' . $this->db->sql_build_array('UPDATE', $sql_ary) . '
							WHERE forum_id = "' . (int) $forum_id . '"';
					$this->db->sql_query($sql);

				}

				$forum_list = make_forum_select(false, false, true, true, true, false, true);

				foreach ($forum_list as $list_row)
				{
					$sql = 'SELECT *
							FROM ' . $this->calendar_forums_table . '
							WHERE forum_id = "' . (int) $list_row['forum_id'] . '"';
					$result = $this->db->sql_query($sql);
					$row = $this->db->sql_fetchrow($result);
					$this->db->sql_freeresult($result);
					if (!$row)
					{
						$sql_ary = array(
							'FORUM_ID' 				=> $list_row['forum_id'],
							'ALLOWED' 				=> 0,
						);
						$sql = 'INSERT INTO ' . $this->calendar_forums_table . ' ' . $this->db->sql_build_array('INSERT', $sql_ary);
						$this->db->sql_query($sql);
						$color = 'red';
						$text = $this->language->lang('ACP_CALENDAR_ALLOWED_0') . '  &gt; ' . $this->language->lang('ACP_CALENDAR_CHANGE');
					}
					else
					{
						$color = ($row['allowed'] == 0) ? 'red' : 'green' ;
						$text = $this->language->lang('ACP_CALENDAR_ALLOWED_' . $row['allowed']) . '  &gt; ' . $this->language->lang('ACP_CALENDAR_CHANGE');
					}

					$this->template->assign_block_vars('forum', array(
						'FORUM'	=> $list_row['padding'] . $list_row['forum_name'],
						'COLOR'	=> ($list_row['forum_type'] == 1) ? $color : '#BBBBBB',
						'ID'	=> $this->u_action . '&amp;action=forum&amp;forum=' . $list_row['forum_id'],
						'TEXT'	=> $text,
						'TYPE'	=> $list_row['forum_type'],
					));

				}
			break;

			case 'event_list':
				$this->tpl_name = 'acp_calendar_event_list';

				$action		= $this->request->variable('action', '');
				$id 		= $this->request->variable('id', 0);
				$date_from	= ($this->request->variable('date_from', '')) ? $this->request->variable('date_from', '') : '0000-00-00';
				$date_to	= ($this->request->variable('date_to', '')) ? $this->request->variable('date_to', '') : '0000-00-00';

				if ($multilanguage)
				{
					$sql = 'SHOW COLUMNS FROM ' . $this->calendar_event_list_table;
					$result = $this->db->sql_query($sql);
					$column = '/';
					while ($row = $this->db->sql_fetchrow($result))
					{
						$column .= $row['Field'] . '/';
					}
					$lang = array();
					$lang_name = array();
					$sql = 'SELECT *
							FROM ' . $this->lang_table;
					$lang_result = $this->db->sql_query($sql);
					while ($lang_row = $this->db->sql_fetchrow($lang_result))
					{
						$lang[] = $lang_row['lang_dir'];
						$lang_name[] = $lang_row['lang_english_name'];
						if (!strpos($column, '/' . 'appointment_' . $lang_row['lang_dir'] . '/'))
						{
							$sql = 'ALTER TABLE ' . $this->calendar_event_list_table . ' ADD COLUMN ' . 'appointment_' . $lang_row['lang_dir'] . ' VARCHAR(255)';
							$this->db->sql_query($sql);
							$sql = 'ALTER TABLE ' . $this->calendar_event_list_table . ' ADD COLUMN ' . 'description_' . $lang_row['lang_dir'] . ' VARCHAR(255)';
							$this->db->sql_query($sql);
						};
					}
				}
				switch ($action)
				{
					case 'add':
						$this->template->assign_vars(array(
							'ID' 					=> '',
							'APPOINTMENT'			=> '',
							'DESCRIPTION'			=> '',
							'LINK'					=> '',
							'ANNIVERSARY'			=> '',
							'DATE_FROM'				=> '',
							'DATE_TO'				=> '',
							'NY'					=> 0,
							'COLOR'					=> '',
							'BIG'					=> 0,
							'BCOLOR'				=> '',
							'BG'					=> 0,
							'U_MODIFY'				=> $this->u_action . '&amp;action=create&amp;id=' . $id,
							'S_EDIT_CALENDAR_EVENT'	=> true,
						));
						if ($multilanguage)
						{
							for ($i = 0, $count_lang = count($lang); $i < $count_lang; $i++)
							{
								$this->template->assign_block_vars('lang', array(
									'APPOINTMENT'		=> '',
									'DESCRIPTION'		=> '',
									'LANG'		=> $lang[$i],
									'LANG_NAME'	=> $lang_name[$i],
								));
							}
						}
					break;

					case 'edit':
						$sql = 'SELECT *
								FROM ' . $this->calendar_event_list_table . '
								WHERE id = "' . (int) $id . '"';
						$result = $this->db->sql_query($sql);
						$row = $this->db->sql_fetchrow($result);
						$this->db->sql_freeresult($result);
						$ny = 0;
						$date_from = $row['date_from'];
						if (substr($row['date_from'], 0, 5) == '0000-')
						{
							$date_from = date("Y") . '-' . substr($row['date_from'], 5);
							$ny = 1;
						}
						$date_to = (substr($row['date_to'], 0, 5) == '0000-') ? date("Y") . '-' . substr($row['date_to'], 5) : $row['date_to'];
						$this->template->assign_vars(array(
							'ID'					=> $row['id'],
							'APPOINTMENT'			=> $row['appointment'],
							'DESCRIPTION'			=> $row['description'],
							'LINK'					=> $row['link'],
							'ANNIVERSARY'			=> $row['anniversary'],
							'DATE_FROM'				=> $date_from,
							'DATE_TO'				=> $date_to,
							'NY'					=> $ny,
							'COLOR'					=> '#' . $row['color'],
							'BIG'					=> $row['big'],
							'BCOLOR'				=> '#' . $row['bcolor'],
							'BG'					=> ($row['bcolor'] == '') ? 1 : 0,
							'U_MODIFY'				=> $this->u_action . '&amp;action=modify&amp;id=' . $row['id'],
							'S_EDIT_CALENDAR_EVENT'	=> true,
						));
						if ($multilanguage)
						{
							for ($i = 0, $count_lang = count($lang); $i < $count_lang; $i++)
							{
								$this->template->assign_block_vars('lang', array(
									'APPOINTMENT'		=> ($row['appointment_' . $lang[$i]]) ? $row['appointment_' . $lang[$i]] : $row['appointment'],
									'DESCRIPTION'		=> ($row['description_' . $lang[$i]]) ? $row['description_' . $lang[$i]] : $row['description'],
									'LANG'		=> $lang[$i],
									'LANG_NAME'	=> $lang_name[$i],
								));
							}
						}
					break;

					case 'delete':
						$sql = 'DELETE
								FROM ' . $this->calendar_event_list_table . '
								WHERE id = "' . (int) $id . '"';
						$result = $this->db->sql_query($sql);
						$row = $this->db->sql_fetchrow($result);
						$this->db->sql_freeresult($result);
					break;

					case 'modify':
						$sql_ary = array(
							'APPOINTMENT'			=> utf8_normalize_nfc($this->request->variable('appointment', '', true)),
							'DESCRIPTION' 			=> utf8_normalize_nfc($this->request->variable('description', '', true)),
							'LINK'					=> utf8_normalize_nfc($this->request->variable('link', '', true)),
							'ANNIVERSARY' 			=> $this->request->variable('anniversary', 0),
							'DATE_FROM' 			=> ($this->request->variable('ny', 0)) ? '0000-' . substr($date_from, 5) : $date_from,
							'DATE_TO' 				=>  ($this->request->variable('ny', 0)) ? '0000-' . substr($date_to, 5) : $date_to ,
							'COLOR'				=> substr($this->request->variable('color', ''), -6),
							'BIG'					=> $this->request->variable('big', 0),
							'BCOLOR'			=> (!$this->request->variable('bg', 0)) ? substr($this->request->variable('bcolor', ''), -6) : '',
						);
						if ($multilanguage)
						{
							for ($i = 0, $count_lang = count($lang); $i < $count_lang; $i++)
							{
								$sql_ary['appointment_' . $lang[$i]]	= (utf8_normalize_nfc($this->request->variable('appointment_' . $lang[$i], '', true))) ? utf8_normalize_nfc($this->request->variable('appointment_' . $lang[$i], '', true)) : utf8_normalize_nfc($this->request->variable('appointment', '', true));
								$sql_ary['description_' . $lang[$i]]	= (utf8_normalize_nfc($this->request->variable('description_' . $lang[$i], '', true))) ? utf8_normalize_nfc($this->request->variable('description_' . $lang[$i], '', true)) : utf8_normalize_nfc($this->request->variable('description', '', true));
							}
						}
						$sql = 'UPDATE ' . $this->calendar_event_list_table . '
								SET ' . $this->db->sql_build_array('UPDATE', $sql_ary) . '
								WHERE id = "' . (int) $id . '"';
						$this->db->sql_query($sql);
					break;

					case 'create':
						$sql_ary = array(
							'APPOINTMENT'			=> utf8_normalize_nfc($this->request->variable('appointment', '', true)),
							'DESCRIPTION' 			=> utf8_normalize_nfc($this->request->variable('description', '', true)),
							'LINK'					=> utf8_normalize_nfc($this->request->variable('link', '', true)),
							'ANNIVERSARY' 			=> $this->request->variable('anniversary', 0),
							'DATE_FROM' 			=> ($this->request->variable('ny', 0)) ? '0000-' . substr($date_from, 5) :  $date_from,
							'DATE_TO' 				=>  ($this->request->variable('ny', 0)) ? '0000-' . substr($date_to, 5) : $date_to,
							'COLOR'				=> substr($this->request->variable('color', ''), -6),
							'BIG'					=> $this->request->variable('big', 0),
							'BCOLOR'			=> (!$this->request->variable('bg', 0)) ? substr($this->request->variable('bcolor', ''), -6) : '',
						);
						if ($multilanguage)
						{
								for ($i = 0, $count_lang = count($lang); $i < $count_lang; $i++)
								{
									$sql_ary['appointment_' . $lang[$i]]	= (utf8_normalize_nfc($this->request->variable('appointment_' . $lang[$i], '', true))) ? utf8_normalize_nfc($this->request->variable('appointment_' . $lang[$i], '', true)) : utf8_normalize_nfc($this->request->variable('appointment', '', true));
									$sql_ary['description_' . $lang[$i]]	= (utf8_normalize_nfc($this->request->variable('description_' . $lang[$i], '', true))) ? utf8_normalize_nfc($this->request->variable('description_' . $lang[$i], '', true)) : utf8_normalize_nfc($this->request->variable('description', '', true));
								}
						}
						$sql = 'INSERT INTO ' . $this->calendar_event_list_table . ' ' . $this->db->sql_build_array('INSERT', $sql_ary);
								$this->db->sql_query($sql);
							break;
						}
						$sql = 'SELECT *
								FROM ' . $this->calendar_event_list_table . '
								ORDER by id';
						$result = $this->db->sql_query($sql);
						while ($row = $this->db->sql_fetchrow($result))
						{
							$r			= explode ('-',$row['date_from']);
							$from_year	= ($r[0] == '0000') ? '' : $r[0];
							$date_from  = $r[2] . '.' . $r[1] . '.';
							if ($from_year != '')
							{
								$date_from .= $from_year;
							}
							$r			= explode ('-', $row['date_to']);
							$to_day		= ($r[2] == '00')   ? '' : $r[2];
							$to_month	= ($r[1] == '00')   ? '' : $r[1];
							$to_year	= ($r[0] == '0000') ? '' : $r[0];
							$date_to	= '';
							if ($to_day)
							{
								$date_to = $to_day . '.' . $to_month . '.';
								if ($to_year != '')
								{
									$date_to .= $to_year;
								}
							}
							$b  = ($row['big'] == 1) ? '<strong>' : '';
							$nb = ($row['big'] == 1) ? '<strong>' : '';
							$lang_title = '';
						if ($multilanguage)
						{
							for ($i = 0, $count_lang = count($lang); $i < $count_lang; $i++)
							{
								$lang_title .= $lang[$i] . ': ' . $row['appointment_' . $lang[$i]] . ' - ' . $row['description_' . $lang[$i]] . chr(10);
							}
						}
							$this->template->assign_block_vars('calendar_appointment', array(
								'ID' 			=> $row['id'],
								'APPOINTMENT'	=> $b . $row['appointment'] . $nb,
								'DESCRIPTION' 	=> $b . $row['description'] . $nb,
								'LANG_TITLE'		=> ($multilanguage) ? $lang_title : '',
								'LINK'			=> $b . $row['link'] . $nb,
								'ANNIVERSARY' 	=> $b . $this->language->lang('ACP_CALENDAR_' . $row['anniversary']) . $nb,
								'DATE_FROM' 	=> $b . $date_from . $nb,
								'DATE_TO' 		=> $b . $date_to . $nb,
								'COLOR'			=> $row['color'],
								'BCOLOR'		=> $row['bcolor'],
								'U_EDIT'		=> $this->u_action . '&amp;action=edit&amp;id=' . $row['id'],
								'U_DELETE'		=> $this->u_action . '&amp;action=delete&amp;id=' . $row['id'],
							));
						}
						$this->template->assign_vars(array(
							'U_ACTION'				=> $this->u_action . '&amp;action=add',
							'S_CALENDAR_VERSION'	=> $this->language->lang('ACP_CALENDAR_TITLE') . $this->language->lang('ACP_CALENDAR_VERSION') . $this->config['hjw_calendar_version'],
						));
					break;

			case 'special_days':
				$this->tpl_name = 'acp_calendar_special_days';
				$action		= $this->request->variable('action', '');
				$id 		= $this->request->variable('id', 0);

				if ($multilanguage)
				{
					$sql = 'SHOW COLUMNS FROM ' . $this->calendar_special_days_table;
					$result = $this->db->sql_query($sql);
					$column = '/';
					while ($row = $this->db->sql_fetchrow($result))
					{
						$column .= $row['Field'] . '/';
					}
					$lang = array();
					$lang_name = array();
					$sql = 'SELECT *
							FROM ' . $this->lang_table;
					$lang_result = $this->db->sql_query($sql);
					while ($lang_row = $this->db->sql_fetchrow($lang_result))
					{
						$lang[] = $lang_row['lang_dir'];
						$lang_name[] = $lang_row['lang_english_name'];
						if (!strpos($column, '/' . $lang_row['lang_dir'] . '/'))
						{
							$sql = 'ALTER TABLE ' . $this->calendar_special_days_table . ' ADD COLUMN ' . $lang_row['lang_dir'] . ' VARCHAR(255)';
							$this->db->sql_query($sql);
						};
					}
				}
				switch ($action)
				{
					case 'add':
						$this->template->assign_block_vars('day', array(
							'SELECT' =>'<option></option>',
						));
						for ($i=1; $i<=31; $i++)
						{
							$this->template->assign_block_vars('day', array(
								'SELECT' =>'<option value="' . $i . '">' . $i . '</option>',
							));
						}
						$this->template->assign_block_vars('month', array(
							'SELECT' =>'<option></option>',
						));
						for ($i=1; $i<=12; $i++)
						{
							$this->template->assign_block_vars('month', array(
								'SELECT' =>'<option value="' . $i . '">' . $month_name[$i] . '</option>',
							));
						}
						$this->template->assign_vars(array(
							'ID' 					=> '',
							'NAME' 					=> '',
							'EASTERN'				=> '',
							'SHOW_ON' 				=> 0,
							'COLOR'					=> '',
							'BIG'					=> 0,
							'BCOLOR'				=> '',
							'BG'					=> 0,
							'U_MODIFY'				=> $this->u_action . '&amp;action=create&amp;id=' . $id,
							'S_EDIT_CALENDAR_EVENT'	=> true,
						));
						if ($multilanguage)
						{
							for ($i = 0, $count_lang = count($lang); $i < $count_lang; $i++)
							{
								$this->template->assign_block_vars('lang', array(
									'SPECIAL_DAY'	=> '',
									'LANG'			=> $lang[$i],
									'LANG_NAME'		=> $lang_name[$i],
								));
							}
						}
				break;

					case 'edit':
						$sql = 'SELECT *
								FROM ' . $this->calendar_special_days_table . '
								WHERE id = "' . (int) $id . '"';
						$result = $this->db->sql_query($sql);
						$row = $this->db->sql_fetchrow($result);
						$this->db->sql_freeresult($result);
						$eastern = intval ($row['eastern']);
						if ($row['date'] == '.')
						{
							$row['date'] = '';
						}
						if ($row['date'] || $row['name'] == 'Advent' || $row['name'] == 'Buß- und Bettag')
						{
							$eastern = '';
						}

						$this->template->assign_vars(array(
							'ID' 					=> $row['id'],
							'NAME'					=> $row['name'],
							'EASTERN' 				=> $eastern,
							'SHOW_ON' 				=> $row['show_on'],
							'COLOR'					=> '#' . $row['color'],
							'BIG'					=> $row['big'],
							'BCOLOR'				=> '#' . $row['bcolor'],
							'BG'					=> ($row['bcolor'] == '') ? 1 : 0,
							'U_MODIFY'				=> $this->u_action . '&amp;action=modify&amp;id=' . $row['id'],
							'S_EDIT_CALENDAR_EVENT'	=> true,
						));

						$r = explode ('.', $row['date'] . '.');

						$this->template->assign_block_vars('day', array(
							'SELECT' =>'<option></option>',
						));
						for ($i=1; $i<=31; $i++)
						{
							$s = ($i == $r[0]) ? ' selected="selected"' : '';
							$this->template->assign_block_vars('day', array(
								'SELECT' =>'<option' . $s . ' value="' . $i . '">' . $i . '</option>',
							));
						}
						$this->template->assign_block_vars('month', array(
							'SELECT' =>'<option></option>',
						));
						for ($i=1; $i<=12; $i++)
						{
							$s= ($i == $r[1]) ? ' selected="selected"' : '';
							$this->template->assign_block_vars('month', array(
								'SELECT' =>'<option' . $s . ' value="' . $i . '">' . $month_name[$i] . '</option>',
							));
						}
						if ($multilanguage)
						{
							for ($i = 0, $count_lang = count($lang); $i < $count_lang; $i++)
							{
								$this->template->assign_block_vars('lang', array(
									'SPECIAL_DAY'	=> ($row[$lang[$i]]) ? $row[$lang[$i]] : $row['name'],
									'LANG'			=> $lang[$i],
									'LANG_NAME'		=> $lang_name[$i],
								));
							}
						}
					break;

					case 'delete':
						$sql = 'DELETE
								FROM ' . $this->calendar_special_days_table . '
								WHERE id = "' . (int) $id . '"';
						$result = $this->db->sql_query($sql);
						$row = $this->db->sql_fetchrow($result);
						$this->db->sql_freeresult($result);
					break;

					case 'modify':
						$sql_ary = array(
							'NAME'			=> utf8_normalize_nfc($this->request->variable('name', '', true)),
							'EASTERN'		=> $this->request->variable('eastern', 0),
							'DATE'			=> $this->request->variable('from_day', '') . '.' . $this->request->variable('from_month', ''),
							'SHOW_ON'		=> $this->request->variable('show_on', 0),
							'COLOR'			=> substr($this->request->variable('color', ''), -6),
							'BCOLOR'		=> (!$this->request->variable('bg', 0)) ? substr($this->request->variable('bcolor', ''), -6) : '',
							'BIG'			=> $this->request->variable('big', 0),
						);
						if ($multilanguage)
						{
							for ($i = 0, $count_lang = count($lang); $i < $count_lang; $i++)
							{
								$sql_ary[$lang[$i]]		= (utf8_normalize_nfc($this->request->variable($lang[$i], '', true))) ? utf8_normalize_nfc($this->request->variable($lang[$i], '', true)) : utf8_normalize_nfc($this->request->variable('name', '', true));
							}
						}
						$sql = 'UPDATE ' . $this->calendar_special_days_table . '
								SET ' . $this->db->sql_build_array('UPDATE', $sql_ary) . '
								WHERE id = "' . (int) $id . '"';
						$this->db->sql_query($sql);
					break;

					case 'create':
						$sql_ary = array(
							'NAME'			=> utf8_normalize_nfc($this->request->variable('name', '', true)),
							'EASTERN'		=> $this->request->variable('eastern', 0),
							'DATE'			=> $this->request->variable('from_day', '') . '.' . $this->request->variable('from_month', ''),
							'SHOW_ON'		=> $this->request->variable('show_on', 0),
							'COLOR'				=> substr($this->request->variable('color', ''), -6),
							'BCOLOR'			=> (!$this->request->variable('bg', 0)) ? substr($this->request->variable('bcolor', ''), -6) : '',
							'BIG'			=> $this->request->variable('big', 0),
						);
						if ($multilanguage)
						{
							for ($i = 0, $count_lang = count($lang); $i < $count_lang; $i++)
							{
								$sql_ary[$lang[$i]]		= (utf8_normalize_nfc($this->request->variable($lang[$i], '', true))) ? utf8_normalize_nfc($this->request->variable($lang[$i], '', true)) : utf8_normalize_nfc($this->request->variable('name', '', true));
							}
						}
						$sql = 'INSERT INTO ' . $this->calendar_special_days_table . ' ' . $this->db->sql_build_array('INSERT', $sql_ary);
						$this->db->sql_query($sql);
					break;
				}
				$sql = 'SELECT *
						FROM ' . $this->calendar_special_days_table . '
						ORDER by id';
				$result = $this->db->sql_query($sql);
				while ($row = $this->db->sql_fetchrow($result))
				{
					if ($multilanguage)
					{
					$lang_title = '';
						for ($i = 0, $count_lang = count($lang); $i < $count_lang; $i++)
						{
							$lang_title .= $lang[$i] . ': ' . $row[$lang[$i]] . chr(10);
						}
					}
					$eastern = intval ($row['eastern']);
					if ($row['date'] == '.')
					{
						$row['date'] = '';
					}
					if ($row['date'] || $row['name'] == 'Advent' || $row['name'] == 'Buß- und Bettag')
					{
						$eastern = '';
					}
					$b  = ($row['big'] == 1) ? '<strong>' : '';
					$nb = ($row['big'] == 1) ? '</strong>' : '';

					$this->template->assign_block_vars('calendar_special_day', array(
						'ID' 			=> $row['id'],
						'NAME'			=> $b . $row['name'] . $nb,
						'LANG_TITLE'		=> ($multilanguage) ? $lang_title : '',
						'EASTERN' 		=> $b . $eastern . $nb,
						'DATE'			=> $b . $row['date'] . $nb,
						'SHOW_ON' 		=> $b . $this->language->lang('ACP_CALENDAR_' . $row['show_on']) . $nb,
						'COLOR'			=> $row['color'],
						'BCOLOR'		=> $row['bcolor'],
						'U_EDIT'		=> $this->u_action . '&amp;action=edit&amp;id=' . $row['id'],
						'U_DELETE'		=> $this->u_action . '&amp;action=delete&amp;id=' . $row['id'],
					));
				}
				$this->template->assign_vars(array(
					'U_ACTION'				=> $this->u_action . '&amp;action=add',
					'S_CALENDAR_VERSION'	=> $this->language->lang('ACP_CALENDAR_TITLE') . $this->language->lang('ACP_CALENDAR_VERSION') . $this->config['hjw_calendar_version'],
				));
			break;
		}
	}
	private function get_config ($config_name)
	{
		$sql = 'SELECT config_value
				FROM ' . $this->calendar_config_table . '
					WHERE config_name = "' . (string) $config_name . '"';
		$result = $this->db->sql_query($sql);
		$row = $this->db->sql_fetchrow($result);
		$config_value = ($row) ? $row['config_value'] : false;
		return $config_value;
	}
	private function set_config ($config_name, $config_value)
	{
		$sql_ary = array(
			'CONFIG_VALUE'		=> $config_value,
		);
		$sql = 'UPDATE ' . $this->calendar_config_table . '
				SET ' . $this->db->sql_build_array('UPDATE', $sql_ary) . '
					WHERE config_name = "' . (string) $config_name . '"';
		$this->db->sql_query($sql);
	}
}
