<?php
/**
*
* @package hjw calendar Extension
* @copyright (c) 2023 hjw
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
*
*/

namespace hjw\calendar\migrations;

class v_1_1_0 extends \phpbb\db\migration\migration
{
	public function effectively_installed()
	{
		return isset($this->config['hjw_calendar_version']) && version_compare($this->config['hjw_calendar_version'], '1.1.0', '>=');
	}

	public static function depends_on()
	{
			return array('\hjw\calendar\migrations\v_1_0_5');
	}
	public function update_data()
	{
		return array(
			array('custom', array(
				array($this, 'calendar_config')
			)),
			array('config.update', array('hjw_calendar_version', '1.1.0')),
		);
	}
	public function calendar_config()
	{
		$sql_ary = array(
			'CONFIG_NAME'		=>	'time_new',
			'CONFIG_VALUE'		=>	'0',
		);
		$sql = 'INSERT INTO ' . $this->table_prefix . 'calendar_config' . ' ' . $this->db->sql_build_array('INSERT', $sql_ary);
		$this->sql_query($sql);

		$sql_ary = array(
			'CONFIG_NAME'		=>	'multilanguage',
			'CONFIG_VALUE'		=>	'0',
		);
		$sql = 'INSERT INTO ' . $this->table_prefix . 'calendar_config' . ' ' . $this->db->sql_build_array('INSERT', $sql_ary);
		$this->sql_query($sql);

		$sql_ary = array(
			'CONFIG_NAME'		=>	'number_of_upcoming',
			'CONFIG_VALUE'		=>	'10',
		);
		$sql = 'INSERT INTO ' . $this->table_prefix . 'calendar_config' . ' ' . $this->db->sql_build_array('INSERT', $sql_ary);
		$this->sql_query($sql);

	}
}
