<?php
/**
 *
 * Tabs Menu in index. An extension for the phpBB Forum Software package.
 *
 * @copyright (c) 2017, Galandas, http://phpbb3world.altervista.org
 * @license GNU General Public License, version 2 (GPL-2.0)
 *
 */

namespace galandas\tabsmenu\migrations;

class update_config_value extends \phpbb\db\migration\migration
{
    /**
     * Specify dependencies to ensure this migration runs after install_acp_module.
     */
    public static function depends_on()
    {
        return array('\galandas\tabsmenu\migrations\install_acp_module');
    }

    /**
     * Update schema to change config_value column to TEXT type.
     */
    public function update_schema()
    {
        return array(
            'change_columns' => array(
                $this->table_prefix . 'config' => array(
                    'config_value' => ['TEXT', ''] // Aggiunta lunghezza massima
                ),
            ),
        );
    }

    /**
     * Revert schema changes (optional, but good practice).
     */
    public function revert_schema()
    {
        return array(
            'change_columns' => array(
                $this->table_prefix . 'config' => array(
                    'config_value' => ['VCHAR:255', '']
                ),
            ),
        );
    }

    /**
     * No data update needed for this migration.
     */
    public function update_data()
    {
        return array();
    }
}
